	subroutine CURSAV (ROW, COL)
c
c	Uses the VT-100 cursor position report to generate cursor
c	position variables which can be saved and reused.  Different
c	from SAVCUR and RESCUR because the values are saved in memory,
c	not in the terminal.
c	CAUTION!!!	If you are not careful, Fortran carriage controls
c	can cause you to get incorrect row and column values:
c	e.g.;	CALL CUP (10,20)
c		TYPE *, 'Here I am'
c		CALL CURSAV (ROW, COL)
c	will report the column as being 1, because of the Fortran carriage
c	control on the TYPE statement.
c
c		Written by:
c		R. W. Barnard
c		BIO/COMP Applications
c		P. O. Box 5342
c		Albuquerque, NM 87185
c		Version 1.2,	12-Feb-87.
c
	integer*2 INPCHR	!Necessary for ITTINR
	integer*2 ROW, COL
	byte CPR(5), CURPOS(10)
c
	data CPR /27, '[', '6', 'n', '200'O/
c
	do 10 K= 1, 10
	  CURPOS(K)= 0
10	continue
c
	call PRINT (CPR)		!Send position request to VT100.
	call IPOKE ("44,"10100 .or. IPEEK("44))	!Set for XM.
c
20	continue
	INPCHR= ITTINR ()	!INPCHR must be integer here!
	if (INPCHR.lt.0) go to 20	!Nothing yet.
c
	CURPOS(1)= INPCHR
	K= 2
30	continue
	ISTAT= ISLEEP (0,0,0,1)
	if (ISTAT.ne.0) stop 'CURSAV-F-Q-Element Failure'
	INPCHR= ITTINR ()	!Keep getting characters.
	if (INPCHR.ge.0) then
	  CURPOS(K)= INPCHR	!Keep accumulating them.
	  K= K+ 1
	  go to 30
	endif
c
	call IPOKE ("44,"10100 .xor. IPEEK("44))
	do 40 K= 1, 10		!Now check the string for
	  if (CURPOS(K).eq.'[') NR= K+ 1	!proper return.
	  if (CURPOS(K).eq.';') NC= K+ 1
	  if (CURPOS(K).eq.'R') NE= K
40	continue
	if (NE.ne.0) then
	  IERR= 1		!Don't report CVAI errors.
	  call CVAI (CURPOS(NR), ROW, NC-NR-1, IERR)
	  call CVAI (CURPOS(NC), COL, NE-NC, IERR)
	else
	  ROW= 0		!No success.
	  COL= 0
	endif
	return
c
	end
	subroutine TWOCOL (KOUNT, COL1, COL2, TYPE)
c
c	Positions the cursor at columns COL1 and COL2 for output
c	by the calling program.  The index KOUNT is updated after
c	every call, and is used to determine the output row.  The
c	initial value of KOUNT determines the offset (where the
c	two-column output starts).
c	The TYPE statement in the calling program must be of the
c	format ('+' "string").
c
c	The routine can be called in either absolute or relative mode;
c	the latter allows scrolling of the information within a scrolling
c	region.
c
	integer ROW, COL, COL1, COL2
	byte TYPE, ABS, REL
c
	parameter (ABS='A', REL='R')
c
	ROW= (KOUNT+ 1)/ 2		!Determine the row.
	IFLG= (-1)**KOUNT		!Alternate between +/- 1 as a flag.
c
	if (IFLG.lt.0) then		!First column.
	  if (TYPE.eq.ABS) then
	    COL= COL1
	  else
	    call NEL			!Go down a line (and scroll,
	    COL= COL1- 1		!if necessary).
	  endif
	else				!Second column.
	  if (TYPE.eq.ABS) then
	    COL= COL2
	  else
	    call CUB (80)	!Go back to the left margin to be sure.
	    COL= COL2- 1
	  endif
	endif
c
	if (TYPE.eq.ABS) then
	  call CUP (ROW, COL)			!Move there.
	else
	  call CUF (COL)
	endif
c
	KOUNT= KOUNT+ 1			!Bump counter.
	return
c
	end
	subroutine ONELIN (ROW, COL, NUM, ATTR)
c
c	Allows a sequence of numbers to be outputted following the
c	same prompt line.  It is currently set up to handle up to
c	five-digit numbers, but this could be changed by changing the
c	parameter NUMLEN.
c	The choice of ROW and COL must space the output beyond the
c	end of the prompt line.
c	COL should be the sum of the start column of the string and
c	the length of the string.
c	ATTR are VT-100 video attributes for the number, of the form
c	'1;5 ' (for bold and blink), or '0 ' for none.  Note the
c	required trailing blank.
c	The TYPE statement in the calling program must be of the
c	format ('+' "string", $).
c
	integer ROW, COL
c
	parameter (NUMLEN= 5)		!Number of spaces for output.
c
	call CUP (ROW, COL)	!Move to position specified for output, 
	call MSGPRT (0, '$', 0, NUM, NUMLEN, 0, ATTR, 0) !and type number.
	call CUB (NUMLEN)		!Then move back.
	return	
c
	end
	subroutine CENTER (ROW, NCHARS, SCRWID, CHRSIZ)
c
c	Locates a string of length NCHARS in the center of a screen
c	(either 80 or 132 columns).  The string can be either single-
c	or double-width characters.
c	ROW is row location where string will go.
c	SCRWID is screen size (either 80 or 132).
c	CHRSIZ is either 'S' for single or 'D' for double-width characters.
c
c	The TYPE statement in the calling program must be of the
c	format ('+' "string").
c
	integer*2 ROW, COL, SCRWID, FUGFAC
	byte CHRSIZ, CHRFLG
c
	if (CHRSIZ.eq.'D') then			!Must explicitly be 'D'
	  CHRFLG= .true.			!Double-Width Line
	  NWIDTH= 4
	  FUGFAC= 4
	else
	  CHRFLG= .false.			!Single-Width Line
	  NWIDTH= 2				!To calculate center.
	  FUGFAC= -2				!To exactly locate string.
	endif
c
	COL= (SCRWID- NCHARS- FUGFAC)/ NWIDTH	!Find the right column.
	call CUP (ROW, COL)
	if (CHRFLG) call DWL
	return
c
	end
                                                                                                                                                                                                