.; INCBUP.COM,  IND control file.
.;
.; Format is INCBUP P1 P2 P3 P4
.; P1 is SOURCE VOLUME
.; P2 is BACKUP VOLUME
.; P3 is DATE OF BACKUP
.; P4 is BACKUP DEVICE
.; Refer to INCBUP.DOC for instructions and definitions.
.;
.; Version 2 gives unique file names to subdevices used for
.; backups, so several can be put on one physical device.
.; Version 3 now checks disk size to be sure files will fit.
.; Version 4 includes cataloging by DSKLIB, and better MULTIVOLUME
.; verification.
.; Version 4.2, 22-May-85
.;
.; Written by: R. W. Barnard
.; Sandia National Laboratories, Division 7523
.; Albuquerque, NM 87185
.;
	.disable lowercase,octal
	.disable prefix
	.enable escape
	.enable quiet
SET TT QUIET
.;
.; Clear the screen.
;[H[2J
;
;	INCBUP - RT-11 Incremental file backup.
.;
.; Exiting instructions to the user.
;
; You may stop the command file by typing <ESC><CR>
;   in answer to any question.
;
.;
.; Change the assignment of your work device here.
ASSIGN VM WF
.; Change the name of the file to remember DSKLIB catalog numbers here.
	.sets DLBFIL "SY:INCBUP.DAT"
.; Change the volume initialization owner name here.
	.sets OWNAME "R W Barnard"
.; Change the default SOURCE VOLUME here.
	.sets SRV "WA"
.; Change the default BACKUP VOLUME here.
	.sets BKV "LD4"
.; Change the default BACKUP DEVICE here (used for backing up to LD's).
	.sets BKD "FW0"
.;
	.if P1 ne "" .goto 10
	.asks [0:4:"'SRV'"] A1 Enter the source volume
	.ift <ESCAPE> .goto quit
	.sets P1 A1
.10:	.parse P1 ":" P1 A2
ASSIGN 'P1' INP
	.sets SRCVOL P1+"  "	.;Fill out the device name to 3 characters.
	.sets SRCVOL SRCVOL[1:3]	.;Now trim to exactly 3 characters.
.;
	.sets LASDAT P3
	.if P3 ne "" .goto 20
	.disable suffix
.getdat:
	.asks LASDAT Enter the date (plus 1 day!) of the last backup
	.ift <ESCAPE> .goto quit
	.if LASDAT eq "" .goto getdat
	.enable suffix
.;
.20:	.parse <DATE> "-" DAY MON YR
	.gosub trnmon
DIR/BRI/OUT:WF:INCBUP/SINCE:'LASDAT'/EXCLUDE INP:*.(BAK,DSK)
	.openr WF:INCBUP.DIR
	.read DIRREC		.;Read the date line.
.loop:
	.read DIRREC	.;Read the remainder of the directory.
	.parse DIRREC "," FILES BLOCKS
	.if BLOCKS eq "" .goto 30
	.parse FILES " " A1 NUMFIL A2
	.parse BLOCKS " " A1 BLKSIZ A2
	.goto 40
.;
.30:	.iff <EOF> .goto loop
.40:	.close
	.if BLKSIZ eq "0" .goto nuttin
.;
;
; You have 'BLKSIZ' blocks, 'NUMFIL' files to be backed up.
;
	.setn SEGSIZ 'NUMFIL'/70+1
	.if P2 ne "" .goto 50
	.asks [0:4:"'BKV'"] BKVOL Enter the backup volume
	.ift <ESCAPE> .goto quit
	.sets P2 BKVOL
.; Get rid of any : that may have been typed.
.50:	.parse P2 ":" BKVOL A2
.;
ASSIGN 'BKVOL' OUP
.; Create the file to initialize the output volume.
	.testfile 'DLBFIL'
	.if <FILERR> ne <SUCCES> .gosub dsknum
 	.openr #2 'DLBFIL'
	.read #2 DSKNUM
	.close #2
	.enable lowercase
	.open WF:INITD.COM
	.enable data
DUP OUP:/Z/V/Y/N:'SEGSIZ'
'DSKNUM'Bak'SRCVOL''MO''DAY'
'OWNAME'
^C
	.disable data
	.close
	.disable lowercase
	.sets MULCOP ""
.;
	.sets DEVNAM BKVOL[1:2]	.;Get the 1st 2 chars of device name.
	.if DEVNAM ne "LD" .goto 100
.;
.;	***Backup to Logical Devices***
.;
	.if P4 ne "" .goto 60
	.asks [0:4:"'BKD'"] BKPDEV Enter the backup device for the logical disk
	.ift <ESCAPE> .goto quit
	.sets P4 BKPDEV
.60:	.parse P4 ":" BKPDEV A3
	.setn BKPSIZ 'BLKSIZ'.+6+(2*'SEGSIZ')
.;
	.disable suffix
.dsksiz:
	.gosub dskchk
	.if MAXSIZ ge BKPSIZ .goto 70
	.ask QQ Your files won''t fit on this disk.  Put in another and type <CR>
	.ift <ESCAPE> .goto quit
	.goto dsksiz
.;
.70:	.enable suffix
	.sets BKUFIL "'BKPDEV':BAK'P1'.'MO''DAY'"
	.testfile 'BKUFIL'
	.if <FILERR> ne <SUCCES> .goto 90
	.ask [<FALSE>] QQ File 'BKUFIL' exists... Delete it
	.iff QQ .goto 80
UNPROT 'BKUFIL'
DELETE/NOQUERY 'BKUFIL'
	.goto 90
.;
.80:	.disable suffix
	.ask QQ Put in another disk and type <CR>
	.ift <ESCAPE> .goto quit
	.enable suffix
	.goto dsksiz
.;
.90: CREATE 'BKUFIL'/ALL:'BKPSIZ'
MOUNT 'BKVOL' 'BKUFIL'
.;
.; Make the file to run the DSKLIB cataloguer.
	.open WF:DSKLIB.COM
	.data SET TT QUIET
	.data R DLBCOM
	.data OSY:INCBUP	UF'BKUFIL'	Q
	.close
;
; Initializing the backup volume ('BKVOL') now.
$@WF:INITD.COM
	.goto 130
.;
.; 	***Backup to a Physical device***
.;
.100:	.sets BKPDEV BKVOL
;
	.ask [<TRUE>] QQ Do you want to initialize the backup device
	.ift <ESCAPE> .goto quit
	.iff QQ .goto 110
$@WF:INITD.COM
.110:	.gosub dskchk
	.setn BLKN 'BLKSIZ'
	.if MAXSIZ ge BLKN .goto 120
	.sets MULCOP "/MULTIVOL"
; Need to do a multivolume backup.
.;
.; Make the file to run the DSKLIB cataloguer.
.120:	.open WF:DSKLIB.COM
	.data SET TT QUIET
	.data R DLBCOM
	.data OSY:INCBUP	UF'BKVOL':	Q
	.close
.;
.130: DELETE/NOQ WF:INCBUP.DIR
DELETE/NOQ WF:INITD.COM
;
; Copying the files to the backup volume now.
COPY/SINCE:'LASDAT'/INFORM/EXCLUDE/NOLOG'MULCOP' INP:*.(BAK,DSK) OUP:
	.setf SLON
	.ifloa SL .sett SLON
SET SL OFF
.;
.; Do different things depending on MULCOP.
	.if MULCOP ne "" .goto 140
;
; Verifying the files on the backup volume now.
COPY/SYSTEM/NOLOG OUP:*.* NL:
;
; Cataloging the backed-up files now.
$@WF:DSKLIB
DIRECTORY/PRINTER/VOLUME OUP:
	.if DEVNAM eq "LD" DISMOUNT 'BKVOL'
	.goto 160
.;
.140:	;
; Verifying the backup output volumes now.
; Start with the first disk in the sequence.
; Type <CR> with no disk in 'BKVOL' when all have been verified.
	.setn DSKCNT 1
	.disable suffix
.vfylp:
;
	.ask QQ Put disk 'DSKCNT' in drive 'BKVOL' and type <CR>
	.testdevice OUP
	.parse <EXSTRI> "," A1 A2 A3 A4 A5 A6 ONLINE MOUNT
	.if ONLINE ne "ONL" .goto 160
COPY/SYSTEM/NOLOG OUP:*.* NL:
	.if DSKCNT eq 1 .goto 150
.;
	.setn DN 'DSKNUM'	.;Need to give vol ID to second and later
	.inc DN			.;disks.
	.sets DSKN "'DN'"
	.gosub longnm
	.open WF:DSKLIB.COM
	.enable data
R DLBCOM
OSY:INCBUPVF'BKVOL':'DSKNUM'Bk'DSKCNT''SRCVOL'.'MO''DAY'/OWUF'BKVOL':Q
	.disable data
	.close
.150:	;
; Cataloging the backed-up files now.
$@WF:DSKLIB
DIRECTORY/PRINTER/VOLUME OUP:
	.inc DSKCNT
	.goto vfylp
.;
.160:	.ift SLON SET SL ON
.; Increment the number for DSLKIB.
	.setn DN 'DSKNUM'
	.inc DN
	.sets DSKN "'DN'"
	.gosub longnm
.; Write the latest DSKLIB disk number in a file for use next time.
	.open #2 'DLBFIL'
	.data #2 'DSKNUM'
	.close #2
DELETE/NOQ WF:DSKLIB.COM
DEASS INP
DEASS OUP
;
;	Backup of 'P1' completed.
;
	.exit
.;
.nuttin:
;
; Stoping because you have no new files...
; Rerun this command file when you have done some work!
;
	.exit
.;
.;	***Subroutines***
.;
.; Routine for creating a unique extension for a subdevice file
.; from the day and month.
.;
.trnmon:
	.sets MONTHS "JanFebMarAprMayJunJulAugSepOctNovDec"
	.setn COUNT 1
.mloop:
	.setn K 3*COUNT-2
	.sets MO MONTHS[K:K+2]
	.if MON eq MO .goto retn
	.setn COUNT COUNT+1
	.goto mloop
.;
.retn:	.sets MONTHS "123456789OND"
	.sets MO MONTHS[COUNT:COUNT]
	.return
.;
.; Routine for checking disk presence and free space.
.;
.dskchk:
.; See if the device is online (i.e., a disk in the drive).
	.testdevice 'BKPDEV'
	.parse <EXSTRI> "," A1 A2 A3 A4 A5 A6 ONLINE MOUNT
	.if ONLINE eq "ONL" .goto frespc	 .;Now check its free space.
	.disable suffix
	.ask QQ Put a disk in device 'BKPDEV'. Type <CR> to continue
	.enable suffix
	.ift <ESCAPE> .goto quit
	.goto dskchk
.;
.frespc: DIR/FRE/COL:1/OUT:WF:FRESPC 'BKPDEV':
.;
.; Find the largest free space on the disk.
.; Open the directory file.
	.openr WF:FRESPC.DIR
	.setn MAXSIZ 0	.;Initialize maximum size.
	.read DIRREC	.;Read the top line from the file.
.floop:
	.read DIRREC	.;Read another line from the file.
	.parse DIRREC ">" A1 SIZE
	.if SIZE eq "" .goto 200
	.setn SIZN 'SIZE'
	.if SIZN gt MAXSIZ .setn MAXSIZ SIZN
	.iff <EOF> .goto floop
.200:	.close
DELETE/NOQ WF:FRESPC.DIR
	.return
.;
.; Routine to establish the file to hold DSKLIB disk catalog numbers.
.; By using this file, subsequent backup volumes will have sequential numbers.
.;
.dsknum:
	.if <FILERR> ne 230. .goto quit
;
; File 'DLBFIL' not found.
; This file stores the next disk number for DSKLIB catalog.
	.asks [0:3:"001"] DSKNUM What disk number do you want to start with
	.ift <ESCAPE> .goto quit
	.sets DSKN DSKNUM
	.gosub longnm
	.open #2 'DLBFIL'
	.data #2 'DSKNUM'
	.close #2
	.return
.;
.; Routine to make sure that DSKLIB catalog numbers are always 3 characters.
.;
.longnm:
	.test DSKN
	.if <STRLEN> eq 3 .return
	.setn COUNT 3-<STRLEN>
	.sets ZEROS "00"
	.sets DSKNUM ZEROS[1:COUNT] 
	.sets DSKNUM DSKNUM+DSKN
	.return
.;
.quit:
;
; INCBUP aborted.
;
	.exit
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            