.;	DOWN.COM,  IND control file.
.;	Assigns default device to specified logical device.
.;
.;	This command file can support up to two levels of
.;	directory nesting.  It uses LD7 and LD6 for its operations.
.;	The first level is LD7, and the second is LD6.
.;	The file SY:CURDK.TMP holds the current default information.
.;
.;	When used in conjunction with UCL, you can type
.;	DO[WN] FILNAM and have that file become the default.
.;	The UCL entry is 
.;	DOWN == R IND\SY:DOWN ^ (assuming you are using UCL+).
.;
.;	Written by:
.;	R. W. Barnard
.;	Sandia National Laboratories, Division 7523
.;	Albuquerque, NM 87185
.;
.;	Version 1.5; 24-May-85
.;
	.enable quiet
	.disable lowercase
	.disable prefix,suffix
.;
	.if p1 ne "" .goto 10
	.asks P1 Down to which file
.;
.10:	.parse P1 ":" DEV FNAME 
	.if FNAME ne "" .goto 20	.;Device was entered.
	.sets FNAME DEV		.;Device not entered - use default.
	.sets DEV "DK"
.; See if the filespec has a null extension.
.20:	.test P1
	.sets EXTQ P1[<STRLEN>:<STRLEN>]
	.sett NULEXT		.;If null ext, last char of filespec will be .
	.if EXTQ ne "." .setf NULEXT
	.parse FNAME "." FNAME EXT
	.if EXT ne "" .goto 30		.;Extension was entered.
	.iff NULEXT .sets EXT "DSK"	.;Ext not entered - use default.
.;
.30:	.sets FILNAM "'FNAME'.'EXT'"	.;Build the complete file name.
	.testfile 'DEV':'FILNAM'
	.sets CURFIL <FILSPC>
	.if <FILERR> ne <SUCCES> .goto badnam
.;
ASS 'DEV' DK
	.testdevice DK
	.parse <EXSTRI> "," DEVNAM SIZE A1 A2 A3 LOAD ONL MOU NAT
	.sets CURLD "LD7"	.;See if we are already down one level.
	.if DEVNAM ne CURLD .goto mou
	.sets CURLD "LD6"
.;
.mou:
MOUNT 'CURLD' 'FILNAM' DK
.;	Show where we are.
	.open SY:CURDK.TMP
	.data E[10C[1m DK is 'CURFIL'[0m
	.close
.;	Message is printed in bold, and is positioned better on screen.
TYPE SY:CURDK.TMP
	.exit
.;
.badnam:
	.testdevice 'DEV'
	.parse <EXSTRI> "," DEVNAM SIZE 
	.if <FILERR> eq 346 ;      No such file 'DEVNAM':'FILNAM'
	.if <FILERR> eq 340 ;      'DEV' not mounted.
	.exit
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      