	SUBROUTINE TWOCOL (KOUNT, COL1, COL2, TYPE)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Positions the cursor at columns COL1 and COL2 for output
C	by the calling program.  The index KOUNT is updated after
C	every call, and is used to determine the output row.  The
C	initial value of KOUNT determines the offset (where the
C	two-column output starts).
C	The TYPE statement in the calling program must be of the
C	format ('+' "string").
C
C	The routine can be called in either absolute or relative mode;
C	the latter allows scrolling of the information within a scrolling
C	region.
C
	INTEGER ROW, COL, COL1, COL2
	BYTE TYPE, ABS, REL
C
	PARAMETER (ABS='A', REL='R')
C
	ROW= (KOUNT+ 1)/2			!Determine the row.
	IFLG= (-1)**KOUNT			!Alternate between +/- 1 as a flag.
C
	IF (IFLG.LT.0) THEN			!First column.
	  IF (TYPE.EQ.ABS) THEN
	    COL= COL1
	  ELSE
	    CALL NEL				!Go down a line (and scroll,
	    COL= COL1- 1			!if necessary).
	  ENDIF
	ELSE					!Second column.
	  IF (TYPE.EQ.ABS) THEN
	    COL= COL2
	  ELSE
	    CALL CUB (80)	!Go back to the left margin to be sure.
	    COL= COL2- 1
	  ENDIF
	ENDIF
C      
	IF (TYPE.EQ.ABS) THEN
	  CALL CUP (ROW, COL)			!Move there.
	ELSE
	  CALL CUF (COL)
	ENDIF
C
	KOUNT= KOUNT+ 1			!Bump counter.
	RETURN
C
	END
	SUBROUTINE ONELIN (ROW, COL, NUM)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Allows a sequence of numbers to be outputted following the
C	same prompt line.  It is currently set up to handle up to
C	four-digit numbers, but this could be changed by editing the
C	FORMAT statement and the call to CUB.
C	The choice of ROW and COL must space the output beyond the
C	end of the prompt line.
C	COL should be the sum of the start column of the string and
C	the length of the string.
C	The TYPE statement in the calling program must be of the
C	format ('+' "string", $).
C
	INTEGER ROW, COL
C
	CALL CUP (ROW, COL)			!Move to position specified
	TYPE 10, NUM			!for output, and type number.
	CALL CUB (4)			!Then move back.
	RETURN	
C
10	FORMAT ('+',I4, $)
	END
	SUBROUTINE CENTER (ROW, NCHARS, SCRWID, CHRSIZ)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Locates a string of length NCHARS in the center of a screen
C	(either 80 or 132 columns).  The string can be either single-
C	or double-width characters.
C	ROW is row loacation where string will go.
C	SCRWID is screen size (either 80 or 132).
C	CHRSIZ is either 'S' for single or 'D' for double-width characters.
C
C	The TYPE statement in the calling program must be of the
C	format ('+' "string").
C
	INTEGER ROW, COL, SCRWID, FUGFAC
	BYTE CHRSIZ, CHRFLG
C
	IF (CHRSIZ.EQ.'D') THEN			!Must explicitly be 'D'
	  CHRFLG= .TRUE.				!Double-Width Line
	  NWIDTH= 4
	  FUGFAC= 4
	ELSE
	  CHRFLG= .FALSE.				!Single-Width Line
	  NWIDTH= 2					!To calculate center.
	  FUGFAC= -2				!To exactly locate string.
	ENDIF
C
	COL= (SCRWID- NCHARS- FUGFAC)/NWIDTH	!Find the right column.
	CALL CUP (ROW, COL)
	IF (CHRFLG) CALL DWL
	RETURN
C
	END
                                                                                                                                                                                                                                                                                                                                                                                             