.; QMGREM.CMD
	.IF P1 NE "?" .GOTO BEGIN
; Remove Queue Manager tasks, stopping queues first if neccessary.
.; This works for both DCL & MCR
;
; SYNTAX:	@LB:[1,2]QMGREM [dev][/STOP]
;		@/LB:QMGREM	[dev][/STOP]	!from LB:[1,2] files
;	where "[dev]" is an optional spooled device (eg., "TT0:")
;
;	Queues must be in stopped state to remove - QMGREM will ask
;		before calling [1,2]QMGSTO if queues are not stopped.
;		Adding /STOP switch will avoid question.
;	QMGSTO (qv.) will usually remove the active despooler task
;		(eg., TT0 ). Additional tasks may be specified
;		in response to the QMGREM question
;
; Name of (additional) despooler task to remove (null=none) [S]:
;
;		to which the normal response is an immediate <RETURN>.
	.EXIT		! after @[1,2]QMGREM ?
.; MODIFIED:
.;	10-JAN-85 PJS	Add /STOP (actually /<anything>)
.BEGIN:	.ENABLE SUBSTITUTION
.000:
	.PARSE P1 "/" P1 SW1
	.IFINS QMG...	REM QMG...
	.IF <EXSTAT> = 1 .GOTO 0REST
	.IF SW1 NE "" .GOTO 010		! make more fancy if more switches ..
	.ASK Q Stop Queues
	.IFF Q .STOP
.010:	@/LB:QMGSTO 'P1'
	.GOTO 000
.0REST:	.IFINS ...QUE	REM ...QUE
	.IFINS ...PRI	REM ...PRI
	.IFINS PRT...	REM PRT...
	.IF P1 = "" .GOTO 0DS
	.IFINS 'P1'	REM 'P1'
.0DS:
	.ASKS P1 Name of (additional) despooler task to remove (null=none)
	.IF P1 = ""	.EXIT
	.PARSE P1 ":" P1 X
	REM 'P1'
	.GOTO 0DS
                                                                                                                                                              