.LIST
	.SBTTL	GKS Operating State Table

;;***********************************************************************
;;* GKS Operating State Table						*
;;***********************************************************************

	.PSECT	G$$OPS,RW,D,GBL,REL,OVR

GKCL	= 0			; GKS closed
GKOP	= 1			; GKS open
WSOP	= 2			; At least one workstation open
WSAC	= 4			; Workstation active
SGOP	= 10			; Segment open

G$OPST:	.WORD	GKCL		; Default state is closed

GKSDT:	.WORD	-1		; Pointer to the GKS description table.
GKSSL:	.WORD	GS.SOW		; Pointer to the GKS state list.
	.PAGE
	.SBTTL	GKS State List

;************************************************************************
;* GKS State List							*
;************************************************************************

GS.SOW:	.WORD	SOW	; Set of open workstations
GS.SAW:	.WORD	SAW	; Set of active workstations
GS.CL:	.WORD	1	; Current linetype
GS.CLS:	.WORD	1	; Current linewidth scale factor
GS.CPC:	.WORD	1	; Current polyline color index
GS.CMT:	.WORD	1	; Current marker type
GS.CNT:	.WORD	1	; Current normalization transformation number.
GS.LNT:	.WORD	LNT	; Pointer to a list of normalization transforms.
GS.CI:	.WORD	1	; Clipping indicator.
GS.CR:	.WORD	CR	; Pointer to the clipping rectangle.
GS.CTC:	.WORD	1	; Current Text Colour index.
GS.CCH:	.FLT2	0.0	; Current Character Height.
GS.CCW:	.FLT2	0.0	; Current Character Width.
GS.CCU:	.FLT2	0.0,1.0	; Current Character Up vector.
GS.CCB:	.FLT2	1.0,0.0	; Current Character Base vector.
GS.CTP:	.WORD	0	; Current Text Path.
GS.CTA:	.WORD	0,0	; Current Text Alignment.
GS.PCI:	.WORD	1	; Current Polymarker Colour Index.
GS.FAS:	.WORD	0	; Current fill area interior style.
GS.FCI:	.WORD	1	; Current fill area color index.
SOW:	.WORD	0	; Number of currently open workstations
	.BLKW	8.
SAW:	.WORD	0	; Number of currently active workstations
	.BLKW	8.
;
; List of Normalization Transformations.
;
LNT:	.WORD	0			; Transformation number.
	.FLT2	0.0,1.0,0.0,1.0		; World Coordinate Window.
CR:	.FLT2	0.0,1.0,0.0,1.0		; NDC Viewport (and initial clip
					;   rectangle).

	.WORD	1			; Transformation number.
	.FLT2	0.0,1.0,0.0,1.0		; World Coordinate Window.
	.FLT2	0.0,1.0,0.0,1.0		; NDC Viewport.

	.WORD	2			; Transformation number.
	.FLT2	0.0,1.0,0.0,1.0		; World Coordinate Window.
	.FLT2	0.0,1.0,0.0,1.0		; NDC Viewport.

	.WORD	3			; Transformation number.
	.FLT2	0.0,1.0,0.0,1.0		; World Coordinate Window.
	.FLT2	0.0,1.0,0.0,1.0		; NDC Viewport.

	.WORD	4			; Transformation number.
	.FLT2	0.0,1.0,0.0,1.0		; World Coordinate Window.
	.FLT2	0.0,1.0,0.0,1.0		; NDC Viewport.

WSSL:	.WORD	-1		; Pointers to the workstation state lists.
.REPT 7
	.WORD	-1
.ENDR

WSDT:	.WORD	-1		; Pointers to the workstation description 
				; tables
.REPT 7
	.WORD	-1
.ENDR

SGSL:	.WORD	-1		; Segment state list.
ERSL:	.WORD	-1		; Error state list.

$DEBUG	= 1			; Remove this to produce release version.
.NLIST
.IIF NDF G$ENUM	.INCLUDE /GKENUM.INC/
.IIF NDF G$DEFS .INCLUDE /GKSDEF.INC/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              