c
c
      subroutine axgrid (iseg)
c
c
c	PROG NAME:			AXGRID.rat
c
c	DATE OF FIRST VERSION:		 8-Feb-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL routine to plot axis grid lines.
c
c	USAGE:		call AXGRID (ISEG)
c
c			where ISEG = Axis segment number.  Values:
c					1 for X-axis
c					2 for Y-axis
c
c	Programmer:	E. Javel / M. Prucka
c
c*******************************************************************
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
c
c----------------------------------------------------------------------
c
c Establish the direction factors the plotting parameters
      if(.not.(iseg .eq. 1))goto 23000
         xdir = 1.
         ydir = 0.
         vmin = rxmin
         vmax = rxmax
         axlen = rxlen
         grdlen = rylen
         vint = xint
         cyc = xcycle
         pct = xpct/100.
         goto 23001
c     else
23000    continue
         xdir = 0.
         ydir = 1.
         vmin = rymin
         vmax = rymax
         axlen = rylen
         grdlen = rxlen
         vint = yint
         cyc = ycycle
         pct = ypct/100.
23001 continue
c Determine the number of major intervals
      slen = 0.
      n = 0
      if(.not.(cyc .eq. 0.))goto 23002
         nmajor = vint
         tlen = axlen * pct / nmajor
         goto 23003
c     else
23002    continue
         a = alog10 (vmax/vmin)
         nmajor = a
         if(.not.(a .gt. nmajor))goto 23004
            nmajor = nmajor + 1
23004    continue
         tlen = axlen * pct / a
         a = alog10 (vmin)
         a = a - aint(a)
         if(.not.(a .gt. 0.))goto 23006
            n = 1
            slen = tlen * (1.-a)
23006    continue
23003 continue
c Do a grid line at each major interval.  If the full axis length is used,
c don't do grid lines occurring at the edges.
      offs = (1.-pct)/2.*axlen + slen
      if(.not.(offs .eq. 0.))goto 23008
         nmajor = nmajor - 2
         xpos = rxllc + tlen*xdir
         ypos = ryllc + tlen*ydir
         goto 23009
c     else
23008    continue
         xpos = rxllc + offs*xdir
         ypos = ryllc + offs*ydir
23009 continue
c     for
      i=n
23010 if(.not.(i.le.nmajor))goto 23012
         xnew=xpos+grdlen*ydir
         ynew=ypos+grdlen*xdir
         dshlen=tiklen
         call dshlin(xpos,ypos,xnew,ynew,dshlen,dshlen,0)
         xpos = xpos + tlen*xdir
         ypos = ypos + tlen*ydir
          i=i+1
         goto 23010
c     endfor
23012 continue
      return
      end
                                                                                                                                                                                                                                                                                                                                                         