c
c
      subroutine msgloc (x,y,xs,ys)
c
c	PROGRAM NAME:			MSGLOC.rat
c
c	DATE OF  FIRST  VERSION:	14-DEC-81
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	To determine where messages are positioned
c			on the PLTFIL output page when the message
c			position is specified as a data point
c
c	USAGE:		call MSGLOC (X,Y,XS,YS)
c
c			WHERE	    X = X-axis position of message
c				    Y = Y-axis position of message
c				   XS = Scaled x-axis pos. of message
c				   YS = Scaled y-axis pos. of message
c
c	NOTES FOR PROGRAMMERS:	"Plot data as percentage of axis length"
c				is taken into account.
c
c	PROGRAMMER:		Mike Collins / Eric Javel / Matt Prucka
c
c**********************************************************************
c
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
c ... Process X-axis
c ... Compute scaling factors
      if(.not.(xcycle .le. 0.))goto 23000
c Linear axis
         a=(x-rxmin) / abs(rxmax-rxmin)
         goto 23001
c     else
23000    continue
c Log axis
         a=rxmax
         if(.not.(a .eq. 0.))goto 23002
            a=rxmin*(10.**xcycle)
23002    continue
         a=alog10(x/rxmin) / alog10(a/rxmin)
23001 continue
c ... Compute final scaled axis position, taking compressed
c      axis length into account and fudging if axis is reversed
      xs = a*rxlen*xpct/100. + (100.-xpct)*rxlen/200.
      if(.not.(rxmin .gt. rxmax))goto 23004
         xs = rxlen - xs
c ... Process Y-axis in same manner
23004 continue
      if(.not.(ycycle .le. 0.))goto 23006
c Linear axis
         a=(y-rymin)/abs(rymax-rymin)
         goto 23007
c     else
23006    continue
c Log axis
         a=rymax
         if(.not.(a .eq. 0.))goto 23008
            a=rymin*(10.**ycycle)
23008    continue
         a=alog10(y/rymin) / alog10(a/rymin)
23007 continue
      ys = a*rylen*ypct/100. + (100.-ypct)*rylen/200.
      if(.not.(rymin .gt. rymax))goto 23010
         ys = rylen - ys
23010 continue
      return
      end
                                                                                                                                                                                                                                                                                                                                                                                            