









	                         F L E C S



	    (FORTRAN Language with Extended Control Structures)
	     _       _             _        _       _



	                  U S E R'S   M A N U A L






	                   Versions 1 through 22
	                        Terry Beyer
	                    University of Oregon
	                      October 1, 1975


	                Civil Aeromedical Institute
	                      January 17, 1979


	                  Version 22H(126), RT-11
	                       Robert Carter
	                    Princeton Gamma Tech
	                     February 16, 1981


	               Version 22H(126), DECsystem-10
	                      Leland M. Bruns
	                     Johnson & Johnson
	                       March 2, 1981
	
	














	                 * * *  N O T I C E  * * *


	Disclaimer:
	__________

	None of the authors nor their employers shall  be  libel  in
	any way for any direct, indirect, incidental, consequential,
	or specific damages of any kind or from any cause whatsoever
	arising  out  of  or  in  any  way connected with the use or
	performance of this software.


	Permission:
	__________

	This software is in the public domain and may be  reproduced
	or altered without the explicit permission of the authors.
 
 
 
 
 
 
 
 
 
	                     TABLE OF CONTENTS
 
 
 
	1.  INTRODUCTION   . . . . . . . . . . . . . . . . .     1-1
 
	  1.1  RETENTION OF FORTRAN FEATURES   . . . . . . .     1-2
	  1.2  CORRELATION OF FLECS AND FORTRAN SOURCES    .     1-2
 
	2.  STRUCTURED STATEMENTS    . . . . . . . . . . . .     2-1
 
 
	3.  INDENTATION, LINES, AND THE LISTING FILE   . . .     3-1
 
	  3.1  PREPARATION OF FLECS SOURCE FILES   . . . . .     3-1
	  3.2  INDENTED SOURCE FILES   . . . . . . . . . . .     3-3
 
	4.  CONTROL STRUCTURES   . . . . . . . . . . . . . .     4-1
 
	  4.1  ALTERNATIVE STRUCTURES    . . . . . . . . . .     4-1
	    4.1.1  The IF Statement    . . . . . . . . . . .     4-1
	    4.1.2  The UNLESS Statement    . . . . . . . . .     4-2
	    4.1.3  The WHEN...ELSE Statement   . . . . . . .     4-2
	    4.1.4  The CONDITIONAL Statement   . . . . . . .     4-4
	    4.1.5  The SELECT Statement    . . . . . . . . .     4-5
	  4.2  REPETITIVE STRUCTURES   . . . . . . . . . . .     4-6
	    4.2.1  The DO Statement    . . . . . . . . . . .     4-6
	    4.2.2  The WHILE Statement   . . . . . . . . . .     4-6
	    4.2.3  The REPEAT WHILE Statement    . . . . . .     4-7
	    4.2.4  The UNTIL Statement   . . . . . . . . . .     4-7
	    4.2.5  The REPEAT UNTIL Statement    . . . . . .     4-8
	    4.2.6  The LOOP Statement    . . . . . . . . . .     4-8
	    4.2.7  The REPEAT LOOP Statement   . . . . . . .    4-10
	    4.2.8  "Infinite" LOOPs    . . . . . . . . . . .    4-11
	  4.3  BRANCH STATEMENTS   . . . . . . . . . . . . .    4-12
	    4.3.1  The NEXT Statement    . . . . . . . . . .    4-12
	    4.3.2  The BREAK Statement   . . . . . . . . . .    4-13
	  4.4  INTERNAL PROCEDURES   . . . . . . . . . . . .    4-14
	    4.4.1  The TO Statement    . . . . . . . . . . .    4-15
	    4.4.2  Internal Procedure References   . . . . .    4-15
 




	5.  PREPROCESSOR FEATURES:  DECsystem-10 & RT-11   .     5-1
 
	  5.1  EXTENDED STATEMENTS   . . . . . . . . . . . .     5-1
	    5.1.1  The RETURN Statement    . . . . . . . . .     5-1
	    5.1.2  The INCLUDE Statement   . . . . . . . . .     5-2
	    5.1.3  The STRING Statement    . . . . . . . . .     5-3
	      5.1.3.1  String Variables -    . . . . . . . .     5-3
	      5.1.3.2  String Constants -    . . . . . . . .     5-3
	  5.2  SYSTEM COMMANDS   . . . . . . . . . . . . . .     5-4
	    5.2.1  Conditional Translation   . . . . . . . .     5-5
	      5.2.1.1  The $TRUE & $FALSE Commands -   . . .     5-5
	      5.2.1.2  The $IF Command -   . . . . . . . . .     5-6
	      5.2.1.3  The $UNLESS Command -   . . . . . . .     5-6
	    5.2.2  Symbolic Substitution   . . . . . . . . .     5-7
	      5.2.2.1  The $DEFINE Command -   . . . . . . .     5-8
	      5.2.2.2  The Substitution Algorithm -    . . .     5-9
	    5.2.3  Listing Control   . . . . . . . . . . . .    5-10
	      5.2.3.1  The $PAGE Command -   . . . . . . . .    5-10
	      5.2.3.2  The $[NO]LIST Command -   . . . . . .    5-10
 
	6.  ERRORS   . . . . . . . . . . . . . . . . . . . .     6-1
 
	  6.1  SYNTAX ERRORS   . . . . . . . . . . . . . . .     6-1
	  6.2  CONTEXT ERRORS    . . . . . . . . . . . . . .     6-1
	  6.3  UNDETECTED ERRORS   . . . . . . . . . . . . .     6-2
	  6.4  OTHER ERRORS    . . . . . . . . . . . . . . .     6-3
 
	7.  OPERATING PROCEDURES:  DECsystem-10    . . . . .     7-1
 
	  7.1  SOURCE PREPARATION    . . . . . . . . . . . .     7-1
	  7.2  EXPLICIT INVOCATION   . . . . . . . . . . . .     7-1
	    7.2.1  The /INCLUDE Switch   . . . . . . . . . .     7-2
	    7.2.2  The /STANDARD Switch    . . . . . . . . .     7-2
	    7.2.3  The /NUMBER Switch    . . . . . . . . . .     7-2
	  7.3  COMPILE-CLASS COMMANDS    . . . . . . . . . .     7-3
 
	8.  OPERATING PROCEDURES:  PDP-11 with RT-11   . . .     8-1
 
	  8.1  DEFAULT EXTENSIONS    . . . . . . . . . . . .     8-2
	  8.2  SWITCHES    . . . . . . . . . . . . . . . . .     8-2
 
	9.  OPERATING PROCEDURES:  IBM S/360   . . . . . . .     9-1
 
	  9.1  FLECS VERSIONS FOR IBM SYSTEMS    . . . . . .     9-1
	  9.2  WATFLECS    . . . . . . . . . . . . . . . . .     9-1
	  9.3  STANDARD FORTRAN    . . . . . . . . . . . . .     9-2
	    9.3.1  Data Sets For The Translator    . . . . .     9-2
	    9.3.2  Using The Translator Stand-Alone    . . .     9-3
	    9.3.3  Using The Translator With FORTRAN(G)    .     9-4
 




	10.  RESTRICTIONS AND NOTES    . . . . . . . . . . .    10-1
 
 
	A.  FLECS KEYWORDS   . . . . . . . . . . . . . . . .     A-1
 
 
	B.  FLECS FLOWCHARTS   . . . . . . . . . . . . . . .     B-1
 
 
	C.  FLECS SAMPLE PROGRAM   . . . . . . . . . . . . .     C-1
 
 
	D.  FLECS DOCUMENTATION    . . . . . . . . . . . . .     D-1
 
 
	E.  INDEX    . . . . . . . . . . . . . . . . . . . .     E-1
 
	
	














	Acknowledgements:
	________________

	The author is indebted to many people for assistance of  one
	form  or  another  during  the course of this project.  Mike
	Dunlap, Kevin  McCoy,  and  Peter  Moulton  deserve  special
	thanks   for   many   helpful   and   fruitful  discussions,
	suggestions, and encouragements.  I am grateful to my  wife,
	Kathleen,  who  assisted in many ways including shielding me
	from the harsh reality of JCL and  360  Assembler  Language.
	Text   preparation   was   adroitly  accomplished  by  Marva
	VanNatta, Allyene Tom, Diane Lane, and Kathleen Beyer.

	This project was initiated  while  the  author  was  working
	under  a  grant  provided  by  the  Office of Scientific and
	Scholarly Research of the Graduate School at the  University
	of  Oregon.   Work on the project has also been supported in
	part by the  Department  of  Computer  Science  and  by  the
	Computing Center of the University of Oregon.

	                                             Terry Beyer
	                                             October 1, 1975












	                         CHAPTER 1

	                        INTRODUCTION



	FORTRAN  contains  four  basic  mechanisms  for  controlling
	program flow:  CALL/RETURN, IF, DO, and various forms of the
	GO TO.

	FLECS, a  language  extension  to  FORTRAN,  has  additional
	control  mechanisms  that make it easier to write FORTRAN by
	eliminating much of  the  clerical  detail  associated  with
	constructing FORTRAN programs.  FLECS is also easier to read
	and comprehend.

	This manual is a brief but complete introduction  to  FLECS.
	It  is not a primer on FLECS or structured programming.  The
	reader is assumed to be a knowledgeable FORTRAN programmer.

	Programmers to whom transportability of their programs is  a
	concern should note than the FLECS translator source code is
	in the public domain and  is  made  freely  available.   The
	translator  was  written  with  transportability in mind and
	requires little effort to move from one machine to  another.
	Those  interested  in  moving  FLECS  to  another machine or
	having their own copy of FLECS should contact the University
	of Oregon Computing Center.

	At Oregon, FLECS is implemented on both the DECsystem-10 and
	the  IBM  S/360.   The manner of implementation is that of a
	preprocessor that translates  FLECS  programs  into  FORTRAN
	programs.   The  resulting FORTRAN program is then processed
	in the usual way.  The translator  also  produces  a  nicely
	formatted  listing  of  the  FLECS  program that graphically
	presents the control structures used.
	INTRODUCTION                                        Page 1-2
	


	The following diagram illustrates the translating process.


	    /-------/   +----------+       /----------/   +--------+
	   /FLECS  /    |  FLECS   |      /Translated/    |FORTRAN |
	  /Source /---->|Translator|---->/ FORTRAN  /---->|Compiler|
	 /Program/      |          |    /  Source  /      |        |
	/-------/       +----------+   /----------/       +--------+
	                     |
	                     |
	                     V
	                  /---------/
	                 / FLECS   /
	                / Indented/
	               /  Listing/
	              /---------/



	1.1  RETENTION OF FORTRAN FEATURES

	The FLECS translator examines each statement  in  the  FLECS
	program  to  see if it is an extended statement (a statement
	                             ________ _________
	valid in FLECS but not in FORTRAN).  If it is recognized  as
	an   extended   statement,   the  translator  generates  the
	corresponding  FORTRAN   statements.    If,   however,   the
	statement  is  not  recognized as an extended statement, the
	translator assumes it must be a FORTRAN statement and passes
	it  through  unaltered.   Thus  the  FLECS  system  does not
	                                ___  _____  ______  ____ ___
	restrict the use of FORTRAN statements, it  simply  provides
	________ ___ ___ __ _______ __________
	additional  statements which may be used.  In particular, GO
	TOs, arithmetic IFs, CALLs, arithmetic statement  functions,
	and  any  other  FORTRAN  statements,  compiler dependent or
	otherwise, may be used in a FLECS program.



	1.2  CORRELATION OF FLECS AND FORTRAN SOURCES


	One difficulty of preprocessor systems like  FLECS  is  that
	error  messages  that come from the FORTRAN compiler must be
	related back to the original  FLECS  source  program.   This
	difficulty  is  reduced  by  allowing  the placement of line
	                                                        ____
	numbers (not to be confused with FORTRAN statement  numbers)
	_______
	on  FLECS source statements.  These line numbers then appear
	on the listing and in the FORTRAN  source.   When  an  error
	message  is  produced  by either the FLECS translator or the
	FORTRAN compiler, it will include the  line  number  of  the
	offending  FLECS  source statement, making it easy to locate
	on the listing.

	If the programmer chooses not to supply  line  numbers,  the
	translator  will assign sequential numbers and place them on
	INTRODUCTION                                        Page 1-3
	CORRELATION OF FLECS AND FORTRAN SOURCES


	the listing and in the FORTRAN source.   Thus,  errors  from
	the compiler may still be related to the FLECS listing.

	Details of line numbering are machine  dependent.   On  most
	card-oriented  systems,  the  line  numbers may be placed in
	columns 76-80 of each card.  Other systems may have  special
	provisions for line numbers.

	On the DECsystem-10 SOS line sequence numbers  are  used  by
	FLECS  for  line  numbering whenever they are present on the
	input file.   The  line  sequence  increment  between  lines
	should  be  no  less  than  10  to  assure  that  FLECS  has
	sufficient "space"  to  generate  the  FORTRAN  statement(s)
	corresponding   to   each  FLECS  statement.   If  there  is
	insufficient room for the generated statements,  or  if  the
	statement  numbers  from the input file are not in sequence,
	FLECS will renumber the FORTRAN output file from that  point
	by  00001  until it is back in step with the input code (the
	line numbers on the listing  file  will  remain  unchanged).
	There  are  two  exceptions to the sequence checking done by
	FLECS:  line numbering may be  restarted  from  any  initial
	value  at 1) the beginning of a routine and 2) the beginning
	of a page.

	Under RT-11 (PDP-11 & LSI-11) it  is  inconvenient  for  the
	user  to  create  a line numbered file.  Therefore the FLECS
	listing contains both sequential FLECS listing line  numbers
	and  computed  FORTRAN  line numbers which should correspond
	with the FORTRAN  listing  line  numbers.   (See  the  RT-11
	implementation  notes on how to optionally include numbering
	in the generated FORTRAN source code.)

	The beginning FLECS  programmer  should  discover  and  make
	special  note  of  the  details  of  the  mechanism by which
	FORTRAN compiler error messages may be traced  back  to  the
	FLECS listing on the system being used.












	                         CHAPTER 2

	                   STRUCTURED STATEMENTS



	A basic notion of FLECS is that of the structured  statement
	                                       __________  _________
	which  consists  of a control phrase and its scope.  FORTRAN
	                      _______ ______
	has two structured statements, the logical IF  and  the  DO.
	The following example illustrates this terminology:


	           Structured Statement
	                    /\
	    /---------------  ----------------\
	        Control Phrase          Scope
	              /\                 /\
	    /---------  ---------\    /--  ---\
	    Keyword  Specification
	      /\          /\
	    /-  --\  /----  -----\
	    IF       (X.EQ.Y)         U = V + W


	    Keyword  Specification
	      /\          /\
	    /-  --\  /----  -----\
	    DO       30  I = 1, N    > Control Phrase \
	    A(I) = B(I) + C         \                  \ Structured
	    L(I) = I - K(I)          > Scope           / Statement
	30  CONTINUE                /                 /


	Note that each structured statement consists  of  a  control
	phrase  that  controls the execution of a set of one or more
	statements called its scope.  Also note  that  each  control
	phrase   consists   of   a   keyword  plus  some  additional
	                             _______
	information called the specification.  A statement that does
	                       _____________
	not  consist of a control phrase and a scope is said to be a
	simple  statement.   Examples  of  simple   statements   are
	______  _________
	assignment statements, subroutine CALLs, arithmetic IFs, and
	GO TOs.

	The problem with the FORTRAN logical IF  statement  is  that
	its  scope may contain only a single simple statement.  This
	restriction is eliminated in the case of the DO, but at  the
	STRUCTURED STATEMENTS                               Page 2-2
	


	cost  of  clerical detail (having to stop thinking about the
	problem while a statement number is  invented).   Note  also
	that  the  IF specification is enclosed in parentheses while
	the DO specification is not.

	In FLECS there is a uniform convention for  writing  control
	phrases   and   indicating   their  scopes.   In  writing  a
	structured statement,  the  keyword  is  placed  on  a  line
	beginning in column 7 followed by its specification enclosed
	in parentheses.  The remainder of the line  is  left  blank.
	The  statements composing the scope are placed on successive
	lines.   The  end  of  the  scope  is  indicated  by  a  FIN
	statement.   This creates a multi-line structured statement.
	                            __________ __________ _________
	Examples of multi-line structured statements:

	        IF (X.EQ.Y)
	        .  U = V+W
	        .  R = S+T
	        ...FIN

	        DO (I=1,N)
	        .  A(I) = B(I)+C
	        .  C = C*2.14-3.14
	        ...FIN


	        Note:   The  statement   number   has   been
	        eliminated  from  the DO specification since
	        it is no longer necessary, the  end  of  the
	        loop being specified by the FIN.


	Nesting of structured statements is permitted to any depth.

	Example of nested structured statements:

	        IF (X.EQ.Y)
	        .  U = V+W
	        .  DO (I = 1,N)
	        .  .  A(I) = B(I)+C
	        .  .  C = C*2.14-3.14
	        .  ...FIN
	        .  R = S+T
	        ...FIN


	When the scope of a control  phrase  consists  of  a  single
	simple  statement,  it may be placed on the same line as the
	______
	control phrase and the FIN  may  be  dispensed  with.   This
	creates a one-line structured statement.
	          ________ __________ _________

	STRUCTURED STATEMENTS                               Page 2-3
	


	Examples of one-line structured statements:

	        IF (X.EQ.Y) U=V+W

	        DO (I=1,N)  A(I) = B(I)+C

	Since each control phrase must begin on a new  line,  it  is
	not  possible  to have a one-line structured statement whose
	scope consists of a structured statement.

	Example of invalid construction:

	        IF (X.EQ.Y) DO (I=1,N) A(I) = B(I)+C

	To achieve the effect desired above, the IF must be  written
	in a multi-line form.

	Example of valid construction:

	        IF (X.EQ.Y)
	        .  DO (I=1,N) A(I) = B(I)+C
	        ...FIN

	FLECS provides, in addition to IF  and  DO,  several  useful
	structured  statements  not  available  in FORTRAN.  After a
	brief excursion into the subject  of  indentation,  we  will
	present these additional structures.












	                         CHAPTER 3

	          INDENTATION, LINES, AND THE LISTING FILE



	In the examples of  multi-line  structured  statements,  the
	statements  in  the scope were indented and an L-shaped line
	was drawn (in dots) connecting the keyword  of  the  control
	phrase  to  the  matching FIN.  The resulting graphic effect
	helps to reveal the structure of the program.  The rules for
	using  indentation  and  FINs  are quite simple and uniform.
	The control phrase  of  a  multi-line  structured  statement
	always  causes  indentation  of  the statements that follow.
	Nothing else causes indentation.   A  level  of  indentation
	(i.e.  a scope) is always terminated by a FIN.  Nothing else
	terminates a level of indentation.



	3.1  PREPARATION OF FLECS SOURCE FILES

	When writing a FLECS program on paper, the programmer should
	adopt  the indentation and line-drawing conventions shown in
	FLECS listings.  When preparing a FLECS  source  program  in
	machine-readable  form, however, each statement should begin
	in column 7.  (The FLECS implementations on the DECsystem-10
	and  under RT-11 will also accept FLECS statements beginning
	immediately after any tab character in columns 1  through  6
	in the same manner as is valid for the FORTRAN compilers for
	those systems.)  When  the  FLECS  translator  produces  the
	listing,  it  will  reintroduce  the correct indentation and
	produce corresponding lines.  If the programmer attempts  to
	introduce  his  own  indentation  with  the  use  of leading
	blanks, the program will be  translated  correctly  but  the
	resulting listing will be improperly indented.

	INDENTATION, LINES, AND THE LISTING FILE            Page 3-2
	PREPARATION OF FLECS SOURCE FILES


	Example of indentation:

	        1. Program as entered into computer.

	          IF (X.EQ.Y)
	          U = V+W
	          DO (I = 1,N)
	          A(I) = B(I)+C
	          C = C*2.14-3.14
	          FIN
	          R = S+T
	          FIN

	        2. Program as listed by FLECS translator.

	          IF (X.EQ.Y)
	          .  U = V+W
	          .  DO (I = 1,N)
	          .  .  A(I) = B(I)+C
	          .  .  C = C*2.14-3.14
	          .  ...FIN
	          .  R = S+T
	          ...FIN

	The correctly  indented  listing  is  a  tremendous  aid  in
	reading  and working with programs.  Except for the dots and
	spaces used for indentation, the lines are listed exactly as
	they  appear  in  the source program;  that is, the internal
	spacing of columns 7-72 is preserved (with the exception for
	indented  source files detailed below).  There is seldom any
	need to refer to the  straight  listing  of  the  unindented
	source.

	Comment lines are  treated  in  the  following  way  on  the
	listing   to   prevent  interruption  of  the  dotted  lines
	indicating scope:  A comment line that contains only  blanks
	(or  a tab in the DECsystem-10 or RT-11 versions) in columns
	2 through 6  will  be  listed  with  columns  7  through  72
	indented  at the then-current level of indentation as if the
	line were an executable statement.  If, however, one or more
	nonblank  characters  appear  in  columns  2  through 6 of a
	comment card, the card will be listed  without  indentation.
	Blank  lines  may  be  inserted  in  the  source and will be
	treated as empty comments.

	In  current  DECsystem-10  and  RT-11  versions  of   FLECS,
	"intra-line"  comments  may  also appear.  The text of these
	comments should  be  placed  to  the  right  of  each  FLECS
	statement  and  preceeded  by  an  exclamation  point ("!"),
	following the conventions for FORTRAN statements accepted by
	the compilers for those machines:

	INDENTATION, LINES, AND THE LISTING FILE            Page 3-3
	PREPARATION OF FLECS SOURCE FILES


	        keyword (specification)  scope     !comment

	        keyword (specification)            !comment
	        .  scope                           !comment
	        ...FIN                             !comment




	3.2  INDENTED SOURCE FILES

	It has been suggested in the preceeding paragraphs that  the
	user  not try to indent the original source file and instead
	let FLECS do  the  proper  indention  automatically  in  the
	listing  file.   On  a batch-oriented system this works well
	since the programmer will usually have such a source listing
	available  during editing and debugging.  But on timesharing
	systems, where  the  programmers  view  of  the  listing  is
	restricted  by the limitations of terminals (especially true
	for CRT terminals), indenting the SOURCE file  itself  would
	prove  valuable  in the input and editing of FLECS programs.
	Similarly, it is pedagogically unreasonable to tell a novice
	FLECS  programmer  that  the listing is indented to make the
	program more understandable, just don't  put  any  indention
	into  your  source!   In programming courses where FLECS was
	the language vehicle,  frequently  students  were  found  to
	"forget" and include the indention in the source file.

	For these reasons, several FLECS implementations  have  been
	extended  to  allow  for the input of indented source files.
	In particular, the DECsystem-10 and RT-11 FLECS  translators
	will  accept indented FLECS source files as input.  On these
	systems, tab characters (^I) may be used to  indent  program
	statements as desired, provided that such tabs are the first
	characters in the text field of the statement.   Here  "text
	field" may be understood to mean either 1) columns 7 through
	72 or 2) from after a tab occuring between columns 1 through
	6  up  to  the  end  of  the  line.   Any such "leading tab"
	character will  be  completely  ignored  by  FLECS  and  the
	remainder  of  the statement will be processed and listed as
	usual according to its syntax.  Thus, the  FLECS  programmer
	may  use indentation to aid in the comprehension of the file
	being edited, but FLECS will not be confused  in  the  event
	that  the  indention is wrong since it will be stripped away
	entirely  before  translation  begins.   Following  is   the
	indented source corresponding to the program above:

	INDENTATION, LINES, AND THE LISTING FILE            Page 3-4
	INDENTED SOURCE FILES


	          IF (X.EQ.Y)
	          <tab>U = V+W
	          <tab>DO (I = 1,N)
	          <tab><tab>A(I) = B(I)+C
	          <tab><tab>C = C*2.14-3.14
	          <tab><tab>FIN
	          <tab>R = S+T
	          <tab>FIN

	But the  maintenance  of  an  indented  source  file  itself
	becomes  a  problem:  suppose the programmer makes a mistake
	in the FLECS syntax or in the indention itself.  In order to
	maintain  a  current  source  file,  it will be necessary to
	constantly  update  the  source  file   with   the   correct
	indention.  This problem is dramatically compounded when the
	programmer chooses to add, delete,  or  change  any  control
	structures  whose  scope  include  a  large  number of other
	statements.

	To aid the FLECS programmer in  this  dilemma,  these  FLECS
	translators  also  provide  the  means  of  producing  a new
	indented source file with the proper tabbing for the control
	structures  present.   (See the subsequent chapters on using
	the DECsystem-10 and  PDP-11  translators  for  the  command
	syntax to do this.) With the exception of indention, the new
	file will be identical in content to the original.   So  the
	FLECS  user  may  re-create a new, up to date source file at
	any point:  either each time the file  is  edited,  or  only
	when needed.


	        Note:   The  DECsystem-10  and  RT-11  FLECS
	        translators  strip  away all leading tabs in
	        the statement text field of each  line.   To
	        preserve  such  tab  characters  it  is only
	        necessary to insert a space in front of  the
	        first  tab.   It will no longer be a leading
	        tab and thus will be preserved  through  the
	        translation process.












	                         CHAPTER 4

	                     CONTROL STRUCTURES



	A complete description  of  each  of  the  extended  control
	structures  provided  by  FLECS is given below together with
	its general syntax (flowcharts for all structures appear  in
	Appendix  B).   The symbol [L] is used to indicate a logical
	expression.  The symbol $ is used to indicate a scope of one
	or more statements.  Some statements, as indicated below, do
	not have a one-line construction.

	A convenient summary of the information in this chapter  may
	be found in Appendices A through C.



	4.1  ALTERNATIVE STRUCTURES

	Alternative  (or   Decision)   structures   are   structured
	statements  that  control  the  execution  of  one  or  more
	alternative scopes on the basis of a logical  expression  or
	test.



	4.1.1  The IF Statement

	Description:  The IF statement causes a  logical  expression
	to  be  evaluated.   If  the  value  is  true,  the scope is
	executed once and control passes to the next statement.   If
	the  value  is  false,  control  passes directly to the next
	statement without execution of the scope.

	General Form:

	        IF ( [L] ) $

	Examples:

	        IF (X.EQ.Y) U = V+W

	CONTROL STRUCTURES                                  Page 4-2
	ALTERNATIVE STRUCTURES


	        IF (T.GT.0.AND.S.LT.R)
	        .  I = I+1
	        .  Z = 0.1
	        ...FIN




	4.1.2  The UNLESS Statement

	Description:  "UNLESS ( [L] )" is functionally equivalent to
	"IF (.NOT.( [L] ))" but is more convenient in some contexts.

	General Form:

	        UNLESS ( [L] ) $

	Examples:

	        UNLESS (X.NE.Y) U = V+W

	        UNLESS (T.LE.0.OR.S.GE.R)
	        .  I = I+1
	        .  Z = 0.1
	        ...FIN




	4.1.3  The WHEN...ELSE Statement

	Description:  The WHEN...ELSE statements correspond  to  the
	IF...THEN...ELSE  statement of Algol, PL/I, Pascal, etc.  In
	FLECS,  both  the  WHEN  and  the  ELSE  act  as  structured
	statements  although only the WHEN has a specification.  The
	ELSE statement must immediately  follow  the  scope  of  the
	WHEN.   The  specifier  of the WHEN is evaluated and exactly
	one of the two scopes is executed.  The scope of the WHEN is
	executed if the expression is true and the scope of the ELSE
	statement is executed if the expression is false.  In either
	case,  control  passes  to  the next statement following the
	ELSE statement.

	General Form:

	        WHEN ( [L] ) $1
	        ELSE $2

	Examples:

	        WHEN (X.EQ.Y) U = V+W
	        ELSE U = V-W

	CONTROL STRUCTURES                                  Page 4-3
	ALTERNATIVE STRUCTURES


	        WHEN (X.EQ.Y)
	        .  U = V+W
	        .  T = T+1.5
	        ...FIN
	        ELSE U = V-W

	        WHEN (X.EQ.Y) U = V+W
	        ELSE
	        .  U = V-W
	        .  T = T+1.5
	        ...FIN

	        WHEN (X.EQ.Y)
	        .  U = V+W
	        .  T = T-1.5
	        ...FIN
	        ELSE
	        .  U = V-W
	        .  T = T+1.5
	        ...FIN


	        Note:  WHEN and ELSE always come as  a  pair
	        of statements, never separately.  Either the
	        WHEN or the ELSE  or  both  may  assume  the
	        multi-line form.  ELSE is considered to be a
	        control phrase, hence it cannot be placed on
	        the     same    line    as    WHEN.     Thus
	        "WHEN ( [L]) $1 ELSE $2" is not valid.
	                                    ___


	        Note:  In   the   DECsystem-10   and   RT-11
	        versions,   the  following  syntax  for  the
	        WHEN...ELSE statement is also accepted:

	                IF ( [L] ) THEN $1
	                ELSE $2

	        The semantics for this statement is  exactly
	        the  same  as for the WHEN...ELSE statement:
	        statement(s)  $1   are   executed   if   the
	        condition   [L]   is   true;   alternatively
	        statement(s)  $2   are   executed   if   the
	        condition  [L]  is  false.  The keyword THEN
	        must appear immediately after the  condition
	        and  on the same line, even if $1 is a group
	        of  several  statements  on  the   following
	        lines.   Throughout  the  remainder  of this
	        manual,  use  of   the   term   "WHEN...ELSE
	        statement"  may be understood to include the
	        additional    equivalent    IF...THEN...ELSE
	        syntax.
	CONTROL STRUCTURES                                  Page 4-4
	ALTERNATIVE STRUCTURES


	4.1.4  The CONDITIONAL Statement

	Description:  The CONDITIONAL statement is based on the LISP
	conditional.   Logical  expressions are evaluated one by one
	until the first true expression is encountered.   The  scope
	corresponding  to  that  expression is executed, and control
	then  passes  to   the   first   statement   following   the
	CONDITIONAL.   If  all  expressions  are  false, no scope is
	executed.  (See, however, the note about OTHERWISE below.)

	General Form:

	        CONDITIONAL
	        .  ( [L1] ) $1
	        .  ( [L2] ) $2
	        .     .     .
	        .     .     .
	        .  ( [Ln] ) $n
	        ...FIN

	Examples:

	        CONDITIONAL
	        .  (X.LT.-5.0)  U = U+W
	        .  (X.LE. 1.0)  U = U+W+Z
	        .  (X.LE.10.5)  U = U-Z
	        ...FIN

	        CONDITIONAL
	        .  (A.EQ.B)  Z = 1.0
	        .  (A.LE.C)
	        .  .  Y = 2.0
	        .  .  Z = 3.4
	        .  ...FIN
	        .  (A.GT.C.AND.A.LT.B)  Z=6.2
	        .  (OTHERWISE)  Z = 0.0
	        ...FIN


	        Note:  The CONDITIONAL itself does not  have
	        a     one-line    form.     However,    each
	        "( [Li] ) $i" is  treated  as  a  structured
	        statement   and   may   be  in  one-line  or
	        multi-line form.


	        Note:    The   reserved    word    OTHERWISE
	        represents  a  catchall condition.  That is,
	        "(OTHERWISE) $i"    is     equivalent     to
	        "(.TRUE.) $i" in a CONDITIONAL statement.
	CONTROL STRUCTURES                                  Page 4-5
	ALTERNATIVE STRUCTURES


	4.1.5  The SELECT Statement

	Description:   The  SELECT  statement  is  similar  to   the
	CONDITIONAL   but   is   more  specialized.   It  allows  an
	expression to be tested for equality to each expression in a
	list  of expressions.  When the first matching expression is
	encountered, a  corresponding  scope  is  executed  and  the
	SELECT  statement  terminates.   In  the  description below,
	[E1], [E2],...,  [E3]  represent  arbitrary  but  compatible
	expressions.    Any   type  of  expression  (integer,  real,
	complex, ...) is allowed as long as the  underlying  FORTRAN
	system  allows  such expressions to be compared with an .EQ.
	or .NE.  operator.  

	General Form:

	        SELECT ( [E] )
	        .  ( [E1] ) $1
	        .  ( [E2] ) $2
	        .     .     .
	        .     .     .
	        .  ( [En] ) $n
	        ...FIN

	Examples:

	        SELECT (OPCODE(PC))
	        .  (JUMP) PC = AD
	        .  (ADD)
	        .  .  A = A+B
	        .  .  PC = PC+1
	        .  ...FIN
	        .  (SKIP) PC = PC+2
	        .  (STOP) CALL STOPCD
	        ...FIN


	        Note:  As in the  case  of  CONDITIONAL,  at
	        most one of the $i will be executed.


	        Note:  The catchall OTHERWISE  may  also  be
	        used    in   a   SELECT   statement.    Thus
	        "(OTHERWISE) $n" is equivalent to "([E]) $n"
	        within a "SELECT ([E])" statement.


	        Note:  The expression [E] is reevaluated for
	        each  comparison in the list.  Thus lengthy,
	        time    consuming,     or     irreproducable
	        expressions  should be precomputed, assigned
	        to a variable, and the variable used in  the
	        specification    portion   of   the   SELECT
	        statement.
	CONTROL STRUCTURES                                  Page 4-6
	REPETITIVE STRUCTURES


	4.2  REPETITIVE STRUCTURES

	The structured statements described below all have  a  scope
	that  is  repeated  a  variable number of times depending on
	specified conditions.

	Of the many loops presented, the novice FLECS user will find
	the DO, WHILE, and REPEAT UNTIL loops most useful.  To avoid
	confusion, the UNTIL, REPEAT WHILE,  LOOP,  and  REPEAT LOOP
	loops  may  be  initially  ignored until the user has gained
	some experience at programming in FLECS.



	4.2.1  The DO Statement

	Description:  The FLECS DO loop is functionally identical to
	the  FORTRAN  DO  loop;  the only differences are syntactic.
	In the FLECS DO loop, the statement number is  omitted  from
	the  DO  statement, the iteration parameters are enclosed in
	parentheses, and  the  scope  is  indicated  by  either  the
	one-line  or  multi-line convention.  Since the semantics of
	the FORTRAN DO statement vary from one FORTRAN  compiler  to
	another,  a  flowchart  cannot  be  given.   The  symbol [I]
	represents any legal iteration specification.

	General Form:                   Equivalent FORTRAN:

	        DO ( [I] ) $                    DO 30 [I]
	                                        $
	                                30      CONTINUE

	Examples:

	        DO (I=1,N) A(I) = 0.0

	        DO (J=3,K,3)
	        .  B(J) = B(J-1)*B(J-2)
	        .  C(J) = SIN(B(J))
	        ...FIN



	4.2.2  The WHILE Statement

	Description:   The  WHILE  loop  causes  its  scope  to   be
	repeatedly  executed  while  a  specified condition is true.
	The condition is checked prior to the first execution of the
	loop.   Thus, if the condition is initially false, the scope
	will not be executed at all.

	General Form:

	        WHILE ( [L] ) $
	CONTROL STRUCTURES                                  Page 4-7
	REPETITIVE STRUCTURES


	Examples:

	        WHILE (X.LT.A(I)) I=I+1

	        WHILE (P.NE.0)
	        .  VAL(P) = VAL(P)+1
	        .  P = LINK(P)
	        ...FIN



	4.2.3  The REPEAT WHILE Statement

	Description:  By using the REPEAT  verb,  the  test  can  be
	logically  moved  to  the end of the loop.  The REPEAT WHILE
	loop causes its scope to  be  repeatedly  executed  while  a
	specified  condition  remains  true.   The  condition is not
	checked until after the first execution of the  loop.   Thus
	the  scope  will  always  be  executed at least once and the
	condition indicates under what conditions the scope is to be
	repeated.    Note:   "REPEAT WHILE( [L] )"  is  functionally
	________
	equivalent to "REPEAT UNTIL(.NOT.( [L] ))".

	General Form:

	        REPEAT WHILE ( [L] ) $

	Examples:

	        REPEAT WHILE (N.EQ.M(I)) I = I+1

	        REPEAT WHILE (LINK(Q).NE.0)
	        .  R = LINK(Q)
	        .  LINK(Q) = P
	        .  P = Q
	        .  Q = R
	        ...FIN



	4.2.4  The UNTIL Statement

	Description:   The  UNTIL  loop  causes  its  scope  to   be
	repeatedly  executed  until  a  specified  condition becomes
	true.  The condition is checked prior to the first execution
	of  the scope.  Thus if the condition is initially true, the
	scope will not be executed at all.   Note:   "UNTIL ( [L] )"
	is functionally equivalent to "WHILE (.NOT.( [L] ))".

	General Form:

	        UNTIL ( [L] ) $

	CONTROL STRUCTURES                                  Page 4-8
	REPETITIVE STRUCTURES


	Examples:

	        UNTIL (X.EQ.A(I)) I = I+1

	        UNTIL (P.EQ.0)
	        .  VAL(P) = VAL(P)+1
	        .  P = LINK(P)
	        ...FIN



	4.2.5  The REPEAT UNTIL Statement

	Description:  By using the REPEAT  verb,  the  test  can  be
	logically  moved  to  the end of the loop.  The REPEAT UNTIL
	loop causes its scope to  be  repeatedly  executed  until  a
	specified  condition  becomes  true.   The  condition is not
	checked until after the first execution of the scope.   Thus
	the  scope  will  always  be  executed at least once and the
	condition indicates under what conditions the repetition  of
	                                              __________
	the scope is to be terminated.

	General Form:

	        REPEAT UNTIL ( [L] ) $

	Examples:

	        REPEAT UNTIL (N.EQ.M(I)) I = I+1

	        REPEAT UNTIL (LINK(Q).EQ.0)
	        .  R = LINK(Q)
	        .  LINK(Q) = P
	        .  P = Q
	        .  Q = R
	        ...FIN



	4.2.6  The LOOP Statement

	The  LOOP  statement  is  the  most  general  FLECS  control
	structure  for  iterative execution.  This statement has two
	formats--its "general loop" form is describe here, while its
	"infinite loop" form is discussed separately below.

	When used in the "general loop"  form,  the  LOOP  statement
	provides a means of specifying the four essential components
	of  any  "well-formed"  loop:   1) initialization,  2) test,
	3) increment,  and  4) body.   In  order  to allow for these
	components to be given, the syntax of the  LOOP  statement's
	specification   clause  differs  from  that  of  most  FLECS
	statements.  Where a logical expression for the  test  would
	normally   be   given  enclosed  by  parentheses,  the  LOOP
	CONTROL STRUCTURES                                  Page 4-9
	REPETITIVE STRUCTURES


	statement has the loop initialization, test,  and  increment
	steps,   all   within   the  parentheses  and  separated  by
	semicolons.  The test component  is,  as  usual,  a  logical
	expression.   But the initialization and increment portions,
	on the other hand, may be either of:   1) a  single  FORTRAN
	statement  (such  as  I = 0  or  I = I + 1)  or  2) a  FLECS
	internal      procedure       reference       (such       as
	INITIALIZE-TO-HEAD-OF-LIST  or GET-NEXT-LINK).  Thus, use of
	the LOOP statement in this form provides the unique  ability
	(aside  from  the DO statement) to indicate in one statement
	all the essential information about the control of execution
	of  the  loop, and closely models similar control structures
	from other structured languages such as RATFOR and C.

	Execution of the loop statement proceeds  as  follows:   The
	initialization step is performed, either by the execution of
	the statement specified or by invocation  of  the  indicated
	internal procedure.  Then, the logical expression is tested,
	and, if the result is .TRUE., then the loop body (which  may
	be  in  single- or multi-line forms, as usual) is performed.
	(Note that the scope of the statement may not  be  performed
	at  all  if the test is initially .FALSE.;  in this respect,
	the LOOP statement is  like  the  WHILE  loop.)  After  each
	successful   execution  of  the  LOOP  body,  the  increment
	statement or procedure is  performed  and  control  is  then
	returned to the beginning of the loop for the next test.

	General Form:

	        LOOP ( <init> ; [L] ; <incr> ) $

	            ...where <init> and <incr> may be...
	                1) a single FORTRAN statement
	                2) a FLECS internal procedure reference

	Examples:

	        LOOP ( I=1 ; I.LE.N ; I=I+1)
	        .  TYPE *,I
	        ...FIN

	        N = 0
	        LOOP ( LNK=HEAD ; LNK.NE.NULL ; LNK=NODLNK(LNK) )
	        .  N = N + 1
	        ...FIN

	CONTROL STRUCTURES                                 Page 4-10
	REPETITIVE STRUCTURES


	        LOOP ( INIT-X ; X.GE.XMIN ; DECR-X ) ADD-TO-SUM
	           ~ ~ ~
	        TO INIT-X
	        .  IF (X.EQ.0)
	        .  .  TYPE 1
	1       .  .  FORMAT (' Enter X:  ',$)
	        .  .  ACCEPT 2,X
	2       .  .  FORMAT (I)
	        .  ...FIN
	        ...FIN
	        TO DECR-X
	        .  CONDITIONAL
	        .  .  (X.GT.10.0)   X = X - 1.0
	        .  .  (X.GT.100.0)  X = X - 10.0
	        .  .  (OTHERWISE)   X = X - 100.0
	        .  ...FIN
	        ...FIN
	        TO ADD-TO-SUM
	        .  UNLESS (FUNCT(X).EQ.-1)  CALL SUM (X)
	        ...FIN

	Any or all of the components specified in the control phrase
	may  be  omitted,  so  long  as the two semicolon separators
	remain.  The initialization and increment components default
	to  "do  nothing",  while  the  test  component  defaults to
	"always succeed".  So, the following two statements are both
	valid and equivalent:

	        LOOP ( ; ; ) $

	        LOOP ( CONTINUE ; .TRUE. ; CONTINUE ) $




	4.2.7  The REPEAT LOOP Statement

	As with the WHILE and UNTIL loops discussed above, there  is
	a  form of the LOOP statement which performs the test at the
	end of each iteration, rather than at the  beginning.   And,
	as  before,  this  form is indicated by the word "REPEAT" in
	the syntax.  The general form of the REPEAT LOOP  statement,
	like   the  LOOP  statement,  allows  the  specification  of
	initialization, test, and  increment  clauses  separated  by
	commas  in the control phrase.  Execution of the REPEAT LOOP
	statement is identical to that of the LOOP statement  except
	that  the  test  is  done  after  the  body  of  the loop is
	                           _____
	executed.

	        REPEAT LOOP ( <init> ; [L] ; <incr> ) $

	            ...where <init> and <incr> may be...
	                1) a single FORTRAN statement
	                2) a FLECS internal procedure reference
	CONTROL STRUCTURES                                 Page 4-11
	REPETITIVE STRUCTURES


	Examples:

	        REPEAT LOOP ( N=1 ; K.GT.0 ; N=N+1 )  READ (1) K

	        F0 = FUNC(1.0)
	        REPEAT LOOP ( X=0.1 ; DIF.LT.1.0E-5 ; X=X/10.0 )
	        .  F1 = FUNC(X)
	        .  DIF = ABS(F1-F2)
	        .  F0 = F1
	        ...FIN




	4.2.8  "Infinite" LOOPs

	The second form of the LOOP and  REPEAT LOOP  statements  is
	simply  the  degenerate  form of the first form:  the entire
	specification portion of the statement may  be  omitted,  in
	which  case  the loop is assumed to be infinite.  Obviously,
	infinite  loops  must  be   used   with   some   degree   of
	caution(!!!),  but  there  are  numerous occasions where the
	exact number of iterations for a loop cannot  be  calculated
	in  any  deterministic way.  Examples might be "loop through
	all input lines in a file" or "process one command from  the
	terminal"  or  "continue  an iterative calculation until the
	result is 'good enough'".  In such instances, an  "infinite"
	loop  may  be  the most straightforward control structure to
	use.  (The BREAK statement, described later in this chapter,
	may  be  used  to  allow  an  exit  route from such infinite
	loops--see the second example below.)

	General Form:

	        [ REPEAT ]  LOOP $

	Examples:

	        REPEAT LOOP  PROCESS-USER-COMMAND-UNTIL-EXIT

	        LOOP  !Standard input loop follows...
	        .  READ (5,12,END=99)  A,B,C
	12      .  FORMAT (3F10.2)
	        .  WHEN (.TRUE.)  CONTINUE
	99      v--ELSE           BREAK
	        .  UNLESS (A.EQ.0. .OR. B.EQ.0. .OR. C.EQ.0.)
	        .  .  X = A/B + B/C + C/A
	        ^--.--IF (X.LT.0.0)  NEXT
	        .  .  WRITE (6,13) A,B,C,X
	13      .  .  FORMAT (4F12.2)
	        .  ...FIN
	        ...FIN
	CONTROL STRUCTURES                                 Page 4-12
	REPETITIVE STRUCTURES


	        Note:  The second  form  for  the  LOOP  and
	        REPEAT LOOP  statements may be considered to
	        be the special case of the first format with
	        all  of  the specification clause defaulted,
	        that is,

	        LOOP ( CONTINUE ; .TRUE. ; CONTINUE ) $


	        Note:  In the event its specification phrase
	        is  found to be in error, an invalid LOOP or
	        REPEAT LOOP statement will be repaired  with
	        a dummy specification which assures that the
	        loop body will never be executed, as in  the
	        following example:

	        LOOP ( CONTINUE ; .FALSE. ; CONTINUE ) $


	        Note:  At present, the two  LOOP  statements
	        have    only   been   implemented   in   the
	        DECsystem-10 and RT-11 versions of FLECS.




	4.3  BRANCH STATEMENTS

	FLECS allows the use of two  forms  of  "structured"  branch
	statements  as  described  below.  These statements may only
	appear within the body of one of the FLECS  loops  described
	above, but not within standard FORTRAN (non-FLECS) DO loops!
	           ___



	4.3.1  The NEXT Statement

	Description:  In its simplest form, execution  of  the  NEXT
	statement causes the remainder of the current iteration of a
	loop to be skipped.  Execution then continues at the control
	statement for the loop, either exiting or not, as conditions
	dictate.   The  NEXT  statement  may  also  appear  with  an
	optional  number  (the  default  is  1)  which specifies the
	nesting level of the loop for which the "next" iteration  is
	to  be  forced.  Specifying 1 indicates that the immediately
	enclosing loop is to begin its next iteration.  Specifying 2
	indicates that the inner loop is to be exited completely and
	execution is to resume with the next iteration of  the  next
	outer  loop.  Specifying 3 indicates that 2 levels are to be
	exited and  the  next  outer  loop  is  to  begin  its  next
	iteration,  and  so  on.   In  the  listing file, FLECS will
	indicate the loop associated with each  NEXT  by  a  row  of
	dashes  and  a  pointer  to  the  loop  control statement in
	addition to the usual indentation.
	CONTROL STRUCTURES                                 Page 4-13
	BRANCH STATEMENTS


	General Form:

	        NEXT [ [#] ]    ...where [#] is the nesting level

	Example:

	        DO (I = 1, 10)
	        ^--IF (D(I).EQ.0.0)  NEXT
	        .  X(I) = N(I)/D(I)
	        .  IF (I.NE.1)
	        .  .  DO (J = 1, I-1)
	        .  .  .  IF (X(I).EQ.X(J))
	        .  .  .  .  X(I) = 0.0
	        ^--.--.--.--NEXT 2
	        .  .  .  ...FIN
	        .  .  ...FIN
	        .  ...FIN
	        .  TYPE 1,I,X(I)
	1       .  FORMAT (1X,I2,1X,F6.2)
	        ...FIN

	In this example, each time D(I) is found  to  be  zero,  the
	outer loop is forced to its next iteration without executing
	the TYPE statement.  If, in the inner loop, X(I) is the same
	as  X(J),  then the inner loop is exited and execution again
	continues with I getting its next value in the outermost  DO
	loop.


	        Note:  Execution of a NEXT  statement  which
	        forces  the  next  iteration  of  a  LOOP or
	        REPEAT LOOP structure will cause a branch to
	        the statement(s) generated for the increment
	        clause specified for that  structure,  after
	                                               _____
	        which  control  is  passed  to the loop exit
	        _____
	        test.



	4.3.2  The BREAK Statement

	Description:  The BREAK statement is quite similar in format
	and  use  to  the  NEXT  statement.   It differs in that the
	specified  loop  is  not  forced  to  its  next   iteration;
	instead,  the  loop is immediately exited.  Execution always
	continues, in this  case,  with  the  statement  immediately
	following  the  end of the loop specified.  As with the NEXT
	statement, if the loop level is not specified, it is assumed
	to  be 1 and the immediately enclosing loop is exited.  And,
	as in the case of the NEXT statement, the listing file  will
	show  the loop associated with each BREAK statement by a row
	of dashes and a pointer to the end of the loop in  place  of
	the usual indentation conventions.
	CONTROL STRUCTURES                                 Page 4-14
	BRANCH STATEMENTS


	General Form:

	        BREAK [ [#] ]    ...where [#] is the nesting level

	Example:

	        TOTAL = 0.0
	        N = 0
	        LOOP  !...thru all input grades
	        .  READ (20,5,END=9) GRADE
	5       .  FORMAT (F5.2)
	        .  WHEN (.TRUE.)  CONTINUE
	9       v--ELSE           BREAK
	        .  TOTAL = TOTAL + GRADE
	        .  N = N + 1
	        ...FIN
	        AVG = TOTAL / N

	Here, the infinite-looking LOOP statement is executed  until
	the  data  from FORTRAN logical unit number 20 is exhausted.
	At that time the BREAK statement at  statement  label  9  is
	executed,  forcing  immediate  termination  of the enclosing
	LOOP statement.  Execution then resumes with the calculation
	of AVG from TOTAL and N.


	        Note:    At   present,   the   two    BRANCH
	        statements,  NEXT  and BREAK, have only been
	        implemented in the  DECsystem-10  and  RT-11
	        versions of FLECS.




	4.4  INTERNAL PROCEDURES

	In FLECS a sequence of statements may be declared to  be  an
	internal procedure and given a name.  The procedure may then
	________ _________
	be invoked from any point in the program  by  simply  giving
	its name.

	Procedure names may be any string of  letters,  digits,  and
	_________ _____
	hyphens  (i.e.   minus  signs)  beginning  with a letter and
	containing at least one hyphen.   Internal  blanks  are  not
	allowed.   The  only  restriction on the length of a name is
	that is may not be continued onto a second line.

	Examples of valid internal procedure names:

	        INITIALIZE-ARRAYS
	        GIVE-WARNING
	        SORT-INTO-DESCENDING-ORDER
	        INITIATE-PHASE-3
	CONTROL STRUCTURES                                 Page 4-15
	INTERNAL PROCEDURES


	4.4.1  The TO Statement

	A  procedure  declaration  consists  of  the  keyword   "TO"
	   _________  ___________
	followed  by  the  procedure name and its scope.  The set of
	statements composing the procedure is called its scope.   If
	the  scope  consists of a single simple statement, it may be
	placed on the same line as  the  "TO"  and  procedure  name.
	Otherwise,  the  statements  of  the scope are placed on the
	following lines and terminated with a FIN statement.   These
	rules  are analogous with the rules for forming the scope of
	a structured statement.

	General form of procedure declarations:

	        TO procedure-name  $

	Examples of procedure declarations:

	        TO RESET-POINTER P = 0

	        TO DO-NOTHING CONTINUE

	        TO SUMMARIZE-FILE
	        .  INITIALIZE-SUMMARY
	        .  OPEN-FILE
	        .  REPEAT UNTIL (EOF)
	        .  .  ATTEMPT-TO-READ-RECORD
	        .  .  WHEN (EOF) CLOSE-FILE
	        .  .  ELSE UPDATE-SUMMARY
	        .  ...FIN
	        .  OUTPUT-SUMMARY
	        ...FIN



	4.4.2  Internal Procedure References

	An  internal  procedure  reference  is  a   procedure   name
	    ________  _________  _________
	appearing  where  an executable statement would be expected.
	In fact, an internal procedure reference  is  an  executable
	simple  statement  and  thus  may  be used in the scope of a
	structured statement as in the  last  example  above.   When
	control  reaches a procedure reference during execution of a
	FLECS program, a return address  is  saved  and  control  is
	transferred  to  the  first  statement  in  the scope of the
	procedure.  When control  reaches  the  end  of  the  scope,
	control  is  transferred  back  to  the  statement logically
	following the procedure reference.

	A typical FLECS program or subprogram consists of  a  series
	of  FORTRAN  declarations (INTEGER, DIMENSION, COMMON, etc.)
	followed by a series of executable statements (the  body  of
	the  program),  followed  by  any  FLECS  internal procedure
	declarations, followed by the END statement.
	CONTROL STRUCTURES                                 Page 4-16
	INTERNAL PROCEDURES


	Here is a complete (but uninteresting)  FLECS  program  that
	illustrates the placement of the procedure declarations.



	        ----------------------------------------

	00010  C  PROGRAM FOR DECsystem-10 TO COMPUTE X**2.
	00020  C  ZERO IS USED TO TERMINATE EXECUTION.
	00030
	00040           REAL X,XSQ
	00050           REPEAT UNTIL (X.EQ.0)
	00060           .  GET-A-VALUE-OF-X
	00070           .  IF (X.NE.0)
	00080           .  .  COMPUTE-RESULT
	00090           .  .  TYPE-RESULT
	00100           .  ...FIN
	00110           ...FIN
	00120           CALL EXIT

	        ----------------------------------------

	00130           TO GET-A-VALUE-OF-X
	00140           .  TYPE 10
	00150   10      .  FORMAT (' X = ',$)
	00160           .  ACCEPT 20,X
	00170   20      .  FORMAT(F)
	00180           ...FIN

	        ----------------------------------------

	00190           TO COMPUTE-RESULT XSQ = X*X

	        ----------------------------------------

	00200           TO TYPE-RESULT
	00210           .  TYPE 30, XSQ
	00220   30      .  FORMAT(' X-SQUARED = ',F7.2)
	00230           ...FIN

	        ----------------------------------------

	00240           END
	CONTROL STRUCTURES                                 Page 4-17
	INTERNAL PROCEDURES


	Notes concerning internal procedures:

	     1.  All internal procedure declarations must be
	         placed at the end of the program just prior
	         to the END statement.   The  appearance  of
	         the  first  "TO"  statement  terminates the
	         body  of  the  program.    The   translator
	         expects   to   see  nothing  but  procedure
	         declarations from that point on.

	     2.  The  order  of  the  declarations  is   not
	         important.   Alphabetical  by  name  is  an
	         excellent order for programs with  a  large
	         number of procedures.

	     3.  Procedure declarations may not  be  nested.
	         In  other  words,  the scope of a procedure
	         may not contain  a  procedure  declaration.
	         It   may,  of  course,  contain  executable
	         procedure references.

	     4.  Any procedure may contain references to any
	         other procedures (excluding itself).

	     5.  Dynamic recursion of procedure  referencing
	         is not permitted.

	     6.  All program  variables  within  a  main  or
	         subprogram are global and are accessible to
	         the statements in all  procedures  declared
	         within    that   same   main   program   or
	         subprogram.

	     7.  There is no formal mechanism  for  defining
	         or   passing   parameters  to  an  internal
	         procedure.   When  parameter   passing   is
	         needed,  the FORTRAN function or subroutine
	         subprogram mechanism may  be  used  or  the
	         programmer  may  invent  his  own parameter
	         passing methods using the global nature  of
	         variables over internal procedures.

	     8.  The FLECS  translator  separates  procedure
	         declarations on the listing by dashed lines
	         as shown in the preceding example.













	                         CHAPTER 5

	       PREPROCESSOR FEATURES:  DECsystem-10 & RT-11



	In addition to its facilities  for  structured  programming,
	the FLECS translator can provide several capabilities due to
	its role as a preprocessor of FORTRAN source code.  In  this
	chapter  several  of  these  features, as implemented on the
	DECsystem-10 and RT-11 versions of FLECS, are discussed.



	5.1  EXTENDED STATEMENTS

	In addition to the  extensions  to  the  control  structures
	provided  by FORTRAN, the FLECS preprocessor also provides a
	number of  convenient  additions  to  the  language.   These
	changes  are  implemented  either  by extensions to existing
	statements or by completely new statement types as described
	below.



	5.1.1  The RETURN Statement

	Description:   the  usual  FORTRAN  syntax  for  the  RETURN
	statement has been extended in FLECS for the case of RETURNs
	from function subprograms.  The usual FORTRAN convention  of
	using  the  function  name as a variable as well is somewhat
	confusing  to  novice  programmers  and  is  replaced  by  a
	(hopefully) more elegant syntax.

	General Form:

	        RETURN ( [E] )

	Example:

	        REAL FUNCTION ABSVAL (X)
	        WHEN (X.GE.0) RETURN (X)
	        ELSE          RETURN (-X)
	        END

	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-2
	EXTENDED STATEMENTS


	FLECS will cause the appropriate statements to be  generated
	to  return  the parenthesized expression as the value of the
	function.  In the example above, either the value  of  X  or
	the  value  of the expression -X is returned as the value of
	the function ABSVAL.



	5.1.2  The INCLUDE Statement

	Description:  the INCLUDE statement specifies the name of  a
	file  to  be  included  at  this  point in the input stream.
	FLECS will take its input from the specified file  until  it
	reaches  the  end  of the included file, at which time input
	from the original  file  is  resumed.   Included  files  may
	contain any type of FORTRAN and FLECS statements, even other
	INCLUDE statements.  (INCLUDEs may be nested to a maximum of
	5   levels   deep   in   current   DECsystem-10   and  RT-11
	implementations.)

	General Form:

	        INCLUDE "file specification"

	...where the default extension for the file is .FLX  in  the
	versions  of  FLECS  for the DECsystem-10 and RT-11 systems.
	The text of the included file will  appear  in  the  listing
	file, if any, and the translated FORTRAN statements from the
	included input will be placed in the FORTRAN output file.

	The FLECS  INCLUDE  statement  is  particularly  useful  for
	FORTRAN  users  of  any  system  where  the "native" FORTRAN
	compiler does not have an "include" feature.  Even where the
	host  FORTRAN supports this feature, there will still be the
	need to include source statements which must  be  translated
	by FLECS.

	Note that the syntax for the FLECS INCLUDE statement is very
	similar to that of FORTRAN-10's INCLUDE statement, differing
	only in the type of quotes used--FLECS  uses  double  quotes
	(") around the file name while FORTRAN-10 uses single quotes
	(').  Use the FLECS INCLUDE statement when  code  is  to  be
	included  which  requires  preprocessing  by FLECS, that is,
	when FLECS control structures are used.  When no translation
	is  needed  in the included file, the FORTRAN-10 form may be
	used (it is ignored by  FLECS)  to  avoid  the  overhead  of
	preprocessing source code which is entirely FORTRAN.
	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-3
	EXTENDED STATEMENTS


	5.1.3  The STRING Statement

	Description:  the STRING statement  may  be  used  in  FLECS
	programs  to  facilitate  the use of "FLECS-format" strings.
	This format uses an integer array to store strings with  the
	current  length  of  the  string  in characters in the first
	word.  The text of the  string  is  packed  in  "An"  format
	(where  "n" is the number of characters per word on the host
	machine...4 for the IBM S/360, 5 for the DECsystem-10, 2 for
	the  PDP-11,  etc.)  in  the  remainder  of  the  array.  In
	addition,  in  the  RT-11  implementation,  one   additional
	character  space  is  allocated  at the end of the string to
	allow room for the user to null terminate the string if  the
	conventions  of  RT-11's  SYSLIB library are to be followed.
	The STRING statement has two forms, one for the  declaration
	of string variables and one for the initialization of string
	constants.



	5.1.3.1  String Variables - 

	To set up a FLECS-format string to contain a given number of
	characters the first form of the STRING statement is used.

	General Form:

	        STRING variable (#-chars)

	Examples:

	        STRING LNAME(25)
	        STRING CODE(3000), ALPHA(26), DIGITS(10)

	The syntax is quite similar to  that  of  the  DIMENSION  or
	INTEGER  statements,  and  basically  FLECS  calculates  the
	number of words in an integer array required  to  store  the
	specified   number  of  characters  plus  their  length  and
	dimensions the variable accordingly.



	5.1.3.2  String Constants - 

	To create strings  with  constant  or  initial  values,  the
	second form of the STRING statement is used.

	General Form:

	        STRING variable 'text'

	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-4
	EXTENDED STATEMENTS


	Examples:

	        STRING ALPHA 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	        STRING NULL '', DO 'DON''T'

	This form uses the length  of  the  text  specified  as  the
	length  of  the  string  and will both dimension the integer
	array and initialize the string to the specified text.   The
	text  string  is  a  standard  FORTRAN  literal and embedded
	single quotes (') may be represented as usual by two  single
	quotes ('').

	STRING statements are limited, like other FLECS  statements,
	to  one  line of code each thus limiting string constants to
	roughly 60 characters or so.  In the event a  longer  string
	is  desired, it will be necessary to use the form for string
	variables described above to create the array space and then
	to  use  the FORTRAN DATA statement to initialize the string
	manually (or  split  the  string  into  2  or  more  smaller
	strings).   On  the  other  hand,  each STRING statement may
	consist of any number of either type of string  declarations
	separated by commas as in the following example:

	        STRING DIG'0123456789', LINE(80), WORD'AIN''T'


	Note that use of the STRING statement in FLECS programs will
	usually  result in mixing INTEGER and DATA statements in the
	resulting FORTRAN code.  While most modern FORTRAN compilers
	(including  FORTRAN-10) can deal with such occurrences, most
	also  insist  on  producing  a  warning  message  for   each
	statement  which  appears  out  of  order  according  to the
	"traditional" rules for statement  ordering.   To  turn  off
	this  message  from FORTRAN-10 (which inherited this archaic
	trait!) use the /NOWARN switch when  compiling  FLECS  files
	using the STRING statement as follows:

	        .COMPIL file.FLX(NOWARN)
	         _______________________


	The file FOR:STRLIB.REL contains a  library  of  subroutines
	for  use  with  "FLECS-format"  strings,  many of which were
	taken from the sources for the FLECS translator itself.  For
	a  complete  description of these routines, consult the file
	FOR:STRLIB.PLM.



	5.2  SYSTEM COMMANDS

	Description:  Any line in a FLECS source file which contains
	a  dollar  sign  ("$")  in  column  one will be treated as a
	command to the preprocessing system itself.   Such  commands
	will (usually) not be included in either the listing file or
	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-5
	SYSTEM COMMANDS


	the  file  of  generated  FORTRAN  statements  (they   will,
	however,  be  output to indented source files).  In general,
	these commands have the following syntax:

	General Form:  $<keyword>  [ <argument(s)> ]

	...where <keyword> may be reduced  to  its  shortest  unique
	abbreviation  (except  where  noted),  and <argument(s)> are
	optional and may take several forms.  Also,  any  number  of
	spaces  (and/or tabs--^I's) may appear on either side of the
	keyword for readability.



	5.2.1  Conditional Translation

	This class of system commands may be used  to  conditionally
	control  translation  of  lines  from  the input file.  Each
	<keyword> must be followed by an <argument> which  qualifies
	the   command.    The  argument  format  is  any  string  of
	alphanumeric characters, of which, only  the  first  "n"  of
	which  are  significant--where  "n"  is  the  number of "A1"
	format  characters  per  word  on  the  host  machine.   The
	arguments  represent  variables  which  are used as "logical
	flags" or "feature test  switches"  in  determining  whether
	each  line in the source file is to be processed or ignored.
	The current implementation allows for up to 10 variables  to
	be defined during each translation.



	5.2.1.1  The $TRUE & $FALSE Commands - 

	The $TRUE and $FALSE  commands  may  be  used  to  define  a
	variable  and  set  its  initial  value.   At any subsequent
	point,  these  commands  may  also  be  used  to  change   a
	variable's  value, although this change will not take effect
	until the next $IF, $UNLESS, or $FIN command is  encountered
	(see below).

	General Form:  $TRUE  variable
	               $FALSE variable

	Examples:

	        $TRUE DEC10

	        $FALSE SINGLEPRECISION

	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-6
	SYSTEM COMMANDS


	5.2.1.2  The $IF Command - 

	The $IF command will turn on processing of subsequent  lines
	from  the source file if the value of the specified variable
	is  currently  TRUE;   if  the  variable  is   FALSE,   then
	subsequent  lines  will  be  completely  ignored, except for
	subsequent conditional translation commands of course!  When
	translation  is disabled in this manner, regular input lines
	are completely ignored and  are  suppressed  from  both  the
	listing and FORTRAN output files but will appear in indented
	source output.  $IF statements  may  be  nested,  and  their
	scope  is  controlled by $FIN statements in exactly the same
	manner as in any regular FLECS multi-line  statement.   Note
	that   $IF   commands  (and  matching  $FIN's)  may  not  be
	abbreviated, just as regular FLECS  statement  keywords  may
	not.

	General Form:  $IF variable

	Example:

	        $TRUE ANSI
	           ~ ~ ~
	        $IF ANSI
	          |
	          |  (source translated only if ANSI = .TRUE.)
	          v
	        $FIN




	5.2.1.3  The $UNLESS Command - 

	The  $UNLESS  system  command   bears   exactly   the   same
	relationship to the $IF command as does the UNLESS statement
	to  the  IF  statement.   $UNLESS  may  be  thought  of   as
	"$IF NOT variable",  although  this  syntax  itself  is  not
	supported.  As with the $IF  command,  $UNLESS  may  not  be
	abbreviated.

	General Form:  $UNLESS variable

	Example:

	        $TRUE ANSI
	           ~ ~ ~
	        $UNLESS ANSI
	          |
	          |  (source translated only if ANSI = .FALSE.)
	          v
	        $FIN

	The conditional translation capabilities of FLECS allow  for
	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-7
	SYSTEM COMMANDS


	several variants of the same source program to be maintained
	in  one  file,  thus  eliminating  "skew"  problems  due  to
	alterations  to  one  version  differing from others when in
	fact they should be applied globally.  The following example
	illustrates  the  use of conditional translation commands to
	implement a floating point absolute value function  in  both
	REAL and DOUBLE PRECISION forms.

	Example of a source file using conditional translation:

	$TRUE DP  (...or...  $FALSE DP)
	C       Absolute Value Function...
	$IF DP
	C       ...Double Precision Version
	        DOUBLE PRECISION FUNCTION ABSVAL (X)
	        DOUBLE PRECISION X, TEMP, ZERO, MINUS1
	        DATA ZERO/0.0D0/, MINUS1/-1.0D0/
	$   FIN
	$UNLESS DP
	C       ...Single Precision Version
	        REAL FUNCTION ABSVAL (X)
	        REAL X, TEMP, ZERO, MINUS1
	        DATA ZERO/0.0E0/, MINUS1/-1.0E0/
	$   FIN
	        WHEN (X.GE.ZERO)  TEMP = X
	        ELSE              TEMP = X * MINUS1
	        RETURN (TEMP)
	        END

	Note that the translated source statements  will  appear  in
	the  listing  file  while  those  which  are ignored will be
	omitted;  all system commands will be  suppressed  from  the
	listing  as  well.  All input lines which are not translated
	will, however, be output to  indented  source  files;   such
	lines  will  not  be  indented  since  the context for their
	indentation is unknown.



	5.2.2  Symbolic Substitution

	Because FLECS must scan each line in the FLECS input file to
	determine  when  preprocessing  is necessary, it can also be
	used to make symbolic  substitutions  in  the  source  text.
	This  feature  may  be used to parameterize computations and
	thereby reduce  the  chance  of  error  due  to  incorrectly
	changing  array sizes, etc.  String substitution may also be
	used to define characters such as "&" and "|"  to  represent
	the  usual  FORTRAN  operators  .AND.  and .OR., providing a
	means for extensibility and a more  readable  listing  file.
	This   feature   is   currently   available   only   on  the
	DECsystem-10.
	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-8
	SYSTEM COMMANDS


	5.2.2.1  The $DEFINE Command - 

	The $DEFINE system command is used to define the symbols  to
	be  removed from the input stream and the strings with which
	they are to replaced in the format shown here:

	General Form:  $DEFINE  <string1>  [ <string2> ]

	...where <string1> is the input symbol and <string2> is  its
	replacement string.  <string1> may be either 1) an arbitrary
	string of alphanumeric characters, or  2) any  other  single
	non-blank  character.  <string2> is optional and may consist
	of  any  string  of  non-blank  characters;    if   omitted,
	<string2>  defaults  to the null (empty) string.  (As usual,
	"non-blank" is assumed to mean "non-tab"  also.)  Notice  in
	the  example below that $DEFINE commands, unlike most system
	commands, will be output to the listing file (the  $[NO]LIST
	commands described later may be used to avoid this).

	Example of a source file using symbolic substitution:

	$DEFINE {
	$DEFINE } FIN
	$DEFINE & .AND.
	$DEFINE NCELLS 10
	           ~ ~ ~
	        DIMENSION CELL(NCHARS)
	           ~ ~ ~
	        IF (ANS.EQ.'Y' & K.EQ.1)  {
	        TYPE 12,CELL
	12      FORMAT (1X,NCELLS(A1))
	        }
	           ~ ~ ~


	Example listing file from the source listed above:

	$DEFINE {
	$DEFINE } FIN
	$DEFINE & .AND.
	$DEFINE NCELLS 10
	           ~ ~ ~
	        DIMENSION CELL(NCELLS)
	           ~ ~ ~
	        IF (ANS.EQ.'Y' & K.EQ.1)  {
	        .  TYPE 12,CELL
	12      .  FORMAT (1X,NCELLS(A1))
	        ...}
	           ~ ~ ~


	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11       Page 5-9
	SYSTEM COMMANDS


	Example object file from the source listed above:

	           ~ ~ ~
	        DIMENSION CELL(10)
	           ~ ~ ~
	        IF (.NOT.(ANS.EQ.'Y' .AND. K.EQ.1)) GO TO 99999
	        TYPE 12,CELL
	12      FORMAT (1X,10(A1))
	99999   CONTINUE
	           ~ ~ ~




	5.2.2.2  The Substitution Algorithm - 

	FLECS uses  the  following  algorithm  to  perform  symbolic
	substitutions:   At  the  begining  of  each  routine  (main
	program,  subroutine,  function,  etc.)  FLECS  clears   all
	previously   defined   symbols.    Until   a  definition  is
	encountered (i.e., a $DEFINE command), translation  proceeds
	as  usual.  Once any definitions have been made, FLECS makes
	an extra  pass  over  each  non-comment,  non-system-command
	input  line  before beginning the usual translation.  During
	this  extra  pass,  the  line  is  scanned  left  to  right,
	beginning  in  column  7  in the statement text field of the
	line.  Any currently defined symbol found in this field will
	be  replaced,  and the scan continues from immediately after
	the replacement string.  Symbols which  will  be  considered
	for   replacement   are:    1) any  string  of  alphanumeric
	characters delimited by non-alphanumerics, or  2) any  other
	non-blank,  non-alphanumeric  character.   For  alphanumeric
	strings, substitution is performed without regard  to  case;
	that is, defined symbols and their substitutions are shifted
	to  upper  case  automatically.   Also,  substitutions   are
	performed without regard to the possible existence of quoted
	strings, Hollerith constants, or intra-line comments.  Then,
	after  all  substitutions have been made, the resulting line
	is then checked for FLECS statements and processed or passed
	directly to the FORTRAN output file as usual.

	        Note:    Because    symbolic    substitution
	        requires FLECS to perform an additional pass
	        over each input line, translation times will
	        increase  significantly  whenever any symbol
	        definitions are present.  This  increase  is
	        roughly 20% on the DECsystem-10.  FLECS will
	        make  the  extra  pass  only  after  it  has
	        encountered   the   first  $DEFINE  command;
	        therefore, definitions should be  placed  as
	        far  down  in the source file as possible to
	        reduce execution time.
	PREPROCESSOR FEATURES:  DECsystem-10 & RT-11      Page 5-10
	SYSTEM COMMANDS


	5.2.3  Listing Control

	There  are  presently  two  commands  for  controlling   the
	contents of the desired contents of the output listing file,
	as described in the following paragraphs.



	5.2.3.1  The $PAGE Command - 

	The  $PAGE  command  (or  any  abbreviation  thereof)   will
	generate  a  new page in the listing file at the point where
	it is encountered and subsequent lines output to the listing
	will  be  printed on the next page.  The command itself will
	not be output to  the  listing,  but  will  be  included  in
	indented source output files.

	General Form:  $PAGE




	5.2.3.2  The $[NO]LIST Command - 

	The $NOLIST command may be used  to  suppress  any  and  all
	subsequent  output to the listing file.  To restore listing,
	the $LIST command may be given.  These commands will have no
	effect  if  no  listing  file  is being output.  As with the
	$PAGE command described above, $NOLIST  and  $LIST  commands
	may  be  abbreviated and will not appear in any output files
	except for indented source files.

	General Form:  $NOLIST
	               $LIST

	One useful application of the $NOLIST and $LIST commands  is
	to  suppress  INCLUDEd  files  containing COMMON definitions
	from  the  source  listing  when  they  are  lengthy  and/or
	repeated.


	        Note:  Errors encountered with  the  listing
	        suppressed  will  not  appear  in the output
	        file but will be  typed  out  on  the  users
	        terminal.   But,  if the output listing file
	        is specified as "TTY:" then no  errors  will
	        appear  while  $NOLIST is in effect.  In any
	        event, FLECS' summary  of  major  and  minor
	        errors will always be displayed.












	                         CHAPTER 6

	                           ERRORS



	This section provides  a  framework  for  understanding  the
	error-handling  mechanisms  of Version 22 (and later) of the
	FLECS Translator.  The system described below is at an early
	point in evolution, but it has proved to be quite workable.

	The FLECS translator examines a FLECS program line by  line.
	As  each  line is encountered, the translator first subjects
	it to a limited syntax analysis and then a context analysis.
	                ______                     _______
	Errors  may be detected during either of these analyses.  It
	is  also  possible  for  errors  to  go  undetected  by  the
	                                         __________
	translator.



	6.1  SYNTAX ERRORS

	When the translator detects a syntax error, it  ignores  the
	                                            __  _______  ___
	statement.   On  the  FLECS  listing  the line number of the
	_________
	statement is overprinted with "-"'s  to  indicate  that  the
	statement  has been ignored.  The nature of the syntax error
	is given in a message on the following line.

	The fact that a statement has been ignored may,  of  course,
	cause some context errors in later statements.  For example,
	the control phrase "WHEN (X(I).LT.(3+4)" has a missing right
	parenthesis.   This statement will be ignored, causing, as a
	minimum, the following ELSE  to  be  out  of  context.   The
	programmer  should of course be aware of such effects.  More
	will be said about these effects.



	6.2  CONTEXT ERRORS

	If a statement successfully passes the syntax  analysis,  it
	is checked to see if it is in the appropriate context within
	the program.  For example, an ELSE must appear after a  WHEN
	and  nowhere  else.   If  an  ELSE  does  not  appear at the
	appropriate point or if it appears at some other point, then
	a  context error has occurred.  A frequent source of context
	ERRORS                                              Page 6-2
	CONTEXT ERRORS


	errors in the initial stages of  development  of  a  program
	comes  from  miscounting  the  number of FINs needed at some
	point in the program.

	With the exception of excess FINs  that  do  not  match  any
	preceding  control  phrase  and are ignored (as indicated by
	overprinting  the  line  number),  all  context  errors  are
	treated  with  a  uniform  strategy.  When an out-of-context
	source statement is encountered, the translator generates  a
	"STATEMENT(S)   NEEDED"   message.    It  then  invents  and
	processes  a  sequence  of  statements  that,  had  it  been
	included at that point in the program, would have placed the
	original source statement in a correct context.   A  message
	is  given  for  each  such statement invented.  The original
	source statement is then  processed  in  the  newly  created
	context.

	By inventing statements the  translator  is  not  trying  to
	patch  up  the program so that it will run correctly;  it is
	simply trying to  adjust  the  local  context  so  that  the
	original  source  statement  and  the statements that follow
	will be acceptable on a context basis.  As in  the  case  of
	context   errors   generated  by  ignoring  a  syntactically
	incorrect  statement,  such   an   adjustment   of   context
	frequently  causes further context errors later on.  This is
	called propagation of context errors.
	       ___________ __ _______ ______

	One nice feature of the context adjustment strategy is  that
	context   errors   cannot   propagate  past  a  recognizable
	procedure declaration.  This is because the "TO" declaration
	is  in  context only at indentation level 0.  Thus, to place
	the "TO" in  context,  the  translator  must  invent  enough
	statements  to  terminate  all open control structures which
	precede the "TO." The programmer who modularizes his program
	into  a  collection  of relatively short internal procedures
	limits the potential for propagation of context errors.



	6.3  UNDETECTED ERRORS

	The FLECS translator is ignorant of most details of  FORTRAN
	syntax.   Thus,  most FORTRAN syntax errors will be detected
	by the FORTRAN compiler rather than by the FLECS translator.
	In  addition,  there  are  two major classes of FLECS errors
	that  will  be  caught  by  the  compiler  and  not  by  the
	translator.

	The first class of  undetected  errors  involves  misspelled
	FLECS keywords.  A misspelled keyword will not be recognized
	by the translator.  It will assume the  line  on  which  the
	word occurs to be a FORTRAN statement and will pass the line
	unaltered to the compiler, which will no doubt object to it.
	For  example, a common error is spelling UNTIL with two L's.
	ERRORS                                              Page 6-3
	UNDETECTED ERRORS


	Such statements are  passed  to  the  compiler,  which  then
	produces  an  error  message.   The  fact  that  an intended
	control phrase was not recognized frequently causes a  later
	context  error,  since  a  level  of indentation will not be
	triggered.

	The second class of undetected  errors  involves  unbalanced
	parentheses (See also Note 8 in chapter 6).  When scanning a
	parenthesized specification, the translator looks for a left
	parenthesis  to  match  the  initial  right parenthesis that
	begins the specification.  As  soon  as  it  finds  one,  it
	assumes  that  the remainder of the line is a simple FORTRAN
	statement, which it passes to the compiler.  Of course, this
	assumption may be wrong.  Thus the statement

	        WHEN (X.LT.A(I)+Z)) X = 0

	is broken into

	        keyword                 "WHEN"
	        specification           "(X.LT.A(I)+Z)"
	        FORTRAN statement       ") X = 0"

	Needless to say, the compiler will object to ") X = 0" as  a
	statement.

	Programmers on batch-oriented systems have  less  difficulty
	with  undetected  errors  due to the practice of running the
	program through both the translator and  the  compiler  each
	time  a run is submitted.  The compiler errors usually point
	out any errors undetected by the translator.

	Programmers on interactive systems tend to have a  bit  more
	difficulty,  since  an  undetected  error  in  one  line may
	trigger a context error in a much later line.  Noticing  the
	context   error,   the  programmer  does  not  proceed  with
	compilation and hence is not warned by the compiler  of  the
	genuine  cause  of  the  error.   One indication of the true
	source of the error may be an  indentation  failure  at  the
	corresponding point in the listing.



	6.4  OTHER ERRORS

	The translator detects a variety of other  errors,  such  as
	multiple  defined  or  undefined  procedure references.  The
	error messages are self-explanatory.  (Really and truly!)












	                         CHAPTER 7

	            OPERATING PROCEDURES:  DECsystem-10



	7.1  SOURCE PREPARATION

	FLECS source files on the DECsystem-10 may be  created  with
	any file name and extension at all, but the standard default
	extension  is  .FLX.   The  translator  will  accept  either
	line-numbered  files  (e.g.,  from SOS) or non-line-numbered
	files (e.g., from TECO).  The  advantage  of  line  numbered
	files is that the translator and compiler error messages may
	be related directly to the source file without reference  to
	a  listing.   As  with  FORTRAN-10,  the  "tab  to column 7"
	convention may be used.



	7.2  EXPLICIT INVOCATION

	On the DECsystem-10, FLECS may be executed  in  one  of  two
	ways:  by explicitly running the translator or by evoking it
	through one of the various  COMPILe-class  commands.   FLECS
	may be invoked explicitly by the command...

	        .R FLECS
	         _______

	FLECS will begin execution by typing out its current version
	number  and  prompting for a command string with a star (*).
	The general format for commands to FLECS is as follows...

	        *[file.FOR,file.LST,file.FIN=]file.FLX[/switches]
	         ________________________________________________

	...where everything except the name of  the  input  file  is
	optional.

	This command format is roughly the  same  as  that  for  the
	FORTRAN-10  compiler  itself,  with  the  file  name  on the
	right-hand side of the equal sign specifying the input  file
	(in  this  case a FLECS file) and the first two files on the
	left-hand side specifying the FORTRAN output  file  (here  a
	file  of pure FORTRAN code) and the listing file.  The third
	output file specification is for the FLECS  indented  source
	file  (see  the description of this file in Chapter 3).  Any
	OPERATING PROCEDURES:  DECsystem-10                 Page 7-2
	EXPLICIT INVOCATION


	or all of these three file names may  be  omitted;   in  the
	event that none are specified, the input file is checked for
	syntax (errors are reported  to  the  user's  terminal)  and
	nothing  else  is  done.  If the equal sign is omitted also,
	then  both  the  FORTRAN  and  listing  output   files   are
	automatically  generated  with  the same filename as that of
	the input file.  The defaults for extensions are .FOR, .LST,
	.FIN,  and  .FLX  for the FORTRAN, listing, indented source,
	and FLECS files, respectively.  All file specifications  may
	include  optional  device and path specifications (including
	SFD's).

	The list of switches is optional;  currently there are three
	valid  switches  (any others will simply be ignored);  these
	switches are described below.



	7.2.1  The /INCLUDE Switch

	The switch /INCLUDE serves the same function in FLECS as  it
	does  in  FORTRAN-10,  informing  the  translator that lines
	beginning with the character "D"  in  column  1  are  to  be
	treated  as  debugging  lines  and  should  be translated as
	normal FLECS statements--without the /INCLUDE  switch,  such
	lines  are  completely  ignored and appear in neither output
	file.



	7.2.2  The /STANDARD Switch

	The /STANDARD  switch  may  be  used  to  request  that  the
	indented  source file be formatted according to the rules of
	the FORTRAN language standard, namely,  that  the  statement
	begins in column 7 and that the line number and continuation
	fields occupy the  first  6  columns.   If  this  option  is
	negated  by  the  inclusion  of  the  prefix  "NO", then the
	formatting convention used by  most  FORTRAN-10  programmers
	will  be  used:   statement  numbers  (if  any) will be left
	justified to column 1, followed by a tab character (^I)  and
	the   statement  text.   The  default  for  this  switch  is
	/NOSTANDARD.



	7.2.3  The /NUMBER Switch

	To output a new .FIN indented  source  file  with  SOS  line
	sequence  numbers,  the /NUMBER switch must be used.  In the
	default case, i.e.,  /NONUMBER,  no  line  numbers  will  be
	output, although page marks--form feed characters (^L)--will
	be preserved.  If the switch /NUMBER is  given,  then  FLECS
	will use the line numbers found on the original input source
	OPERATING PROCEDURES:  DECsystem-10                 Page 7-3
	EXPLICIT INVOCATION


	file if present;  if the original file is unsequenced, FLECS
	will  use  the  line  numbers  generated for the FORTRAN and
	listing files.

	        Note:  The presence of either the  /STANDARD
	        switch  or  the  /NUMBER  switch  in a FLECS
	        command line implies the  generation  of  an
	        indented  source  output file, regardless of
	        the specification of a .FIN file name in the
	        command.   If  no  such  name appears, FLECS
	        will use the usual defaults in creating one.




	7.3  COMPILE-CLASS COMMANDS

	The  usual  DECsystem-10  COMPILe-class  commands  such   as
	.COMPILE,  .LOAD,  .EXECUTE, and .DEBUG will recognize files
	with .FLX extensions as FLECS source files and will take the
	necessary  steps  to first translate the FLECS statements to
	FORTRAN using the FLECS translator  and  then  to  pass  the
	translated code to the FORTRAN compiler for translation into
	object code.  In the event that a FLECS source file does not
	have  the  usual  .FLX extension, to compile it will require
	use of the /FLECS switch to COMPIL as follows:

	        .EXEC file.ext/FLECS
	         ___________________

	The standard COMPILe-class switch /LIST may also be appended
	to  request  that  FLECS  produce a listing file;  /CREF may
	also be used, but it will simply be taken as a  synonym  for
	/LIST.   When the /LIST switch is used, only a FLECS listing
	is produced, and the FORTRAN listing file is suppressed.  In
	order to produce the FORTRAN listing, it is necessary to run
	the FORTRAN compiler directly.

	COMPIL will also allow the user  to  pass  switches  to  the
	FLECS  and  FORTRAN  compilers  (all  switches are passed to
	both--FLECS ignores any that it does not use).   The  format
	for  passing  switches in this case is to inclose the entire
	list--except for the initial slash--in parentheses after the
	file name as in the following example:

	        .DEBUG file.ext(switch1/switch2.../switchN)/LIST
	         _______________________________________________

	Note that the /STANDARD and /NUMBER  switches  must  not  be
	passed  to  the  FORTRAN compiler:  they may only be used if
	the .COMPIL command  is  used  together  with  the  standard
	COMPIL  switch /NOBINARY.  The following example illustrates
	the creation of an indented source file and a  listing  file
	from a FLECS source file:

	        .COMPIL file.ext(NONUMBER/NOSTANDARD)/LIST/NOBIN
	         _______________________________________________
	OPERATING PROCEDURES:  DECsystem-10                 Page 7-4
	COMPILE-CLASS COMMANDS


	The new indented source will have no line  sequence  numbers
	and   will   be   formated  according  to  usual  FORTRAN-10
	(non-standard) rules, and the FORTRAN compiler will  not  be
	run since no object (i.e., .FOR) file will have been created
	by FLECS.


	        Note:  Uninvoked internal procedures and too
	        many  or  too few "FIN"'s preceeding a TO or
	        END statement are considered minor errors by
	        FLECS.  All others are considered major.  If
	        any  major  errors  are  detected   by   the
	        translator,  it  will  abort  any  following
	        compilation, loading, and execution.


	        Note:  COMPIL invokes the  FLECS  translator
	        whenever  the  .FOR file is missing or older
	        than  the  .FLX  file,  regardless  of   the
	        existence  or  timestamp of a .REL file.  If
	        you wish to save disk space by deleting  the
	        .FOR  file,  you  must  then use the command
	        ".EXEC file.REL" to avoid retranslation  and
	        recompilation.


	        Note:  If COMPIL finds an .FOR file which is
	        newer   than   the  .FLX  file,  it  assumes
	        (without looking)  that  the  matching  .REL
	        file  also exists.  LINK, of course, will be
	        unhappy if this is not true.   To  create  a
	        new .REL file without retranslation, use the
	        command ".EXEC file.FOR".












	                         CHAPTER 8

	          OPERATING PROCEDURES:  PDP-11 with RT-11



	Under the RT-11  operating  system  FLECS  must  be  invoked
	directly  by  running FLECS using the standard RT-11 command
	format:

	           .R FLECS
	   or
	           .RUN [DEV:]FLECS

	FLECS will begin execution by typing out its current version
	number  and  prompting for a command string with a star (*).
	At this point the user may either  type  a  command  in  the
	following format (standard RT-11 format)...

	           *O,L,I=S<switches>

	           Where:
	               O = Fortran Output file spec
	               L = Flecs Listing file spec
	               I = Indented source file spec
	               S = Flecs Source file spec

	..or type an abbreviated command of the form...

	           *S<switches>

	..in which case a generated FORTRAN file and a FLECS listing
	file  are  created  with the same file name as the source on
	the same RT-11 device as the source.   Note  that  all  file
	specifications are in standard RT-11 format, and that in the
	first type of command  each  output  file  specification  is
	optional.
	OPERATING PROCEDURES:  PDP-11 with RT-11            Page 8-2
	DEFAULT EXTENSIONS


	8.1  DEFAULT EXTENSIONS

	The following file extensions apply as defaults to any  file
	specification in which an extension is missing:

	           File                    Extension
	           ____                    _________

	      O -  FORTRAN            .FTX (FORTRAN from FLEX)
	                                    _  _            _
	      L -  listing            .FLL (FLECS listing)
	                                    __    _
	      I -  indented source    .FIN (FLECS indented source)
	                                    _     __
	      S -  FLECS SOURCE       .FLX (FLEX)
	                                    __ _



	8.2  SWITCHES

	The  following  switches  are  currently  implemented  under
	RT-11:

	    /C  include comment lines in  generated  FORTRAN
	                _
	        file
	    /D  include  lines  with  a  'D'  in  column   1
	        (debugging lines)
	         _
	    /L  place the corresponding FLECS  listing  line
	                                                _
	        numbers  in  columns  75-80 of the generated
	        FORTRAN file (see note below)
	    /N  produce a new INDENTED source file
	                  _

	        Note:   The  /L  switch  may  be  useful  in
	        debugging  with  FDT  but  its  general  use
	        should be avoided  as  it  produces  a  MUCH
	        BIGGER file!












	                         CHAPTER 9

	              OPERATING PROCEDURES:  IBM S/360



	9.1  FLECS VERSIONS FOR IBM SYSTEMS

	On the IBM S/360 there are two ways of accessing FLECS which
	have  come  to  be  known  as  WATFLECS  and Standard FLECS.
	WATFLECS  is  a  specially  adapted  version  of  the  FLECS
	translator  which  processes batches of short jobs using the
	WATFIV compiler and is used primarily  in  conjunction  with
	Computer  Science  classes.  Standard FLECS is a stand alone
	FLECS  translator  used  for  larger  production   programs,
	usually  in  conjunction  with the level G FORTRAN compiler.
	Cataloged  procedures  which  are  analogous  to  those  for
	FORTRAN(G)  exist  for  using  Standard  FLECS.  WATFLECS is
	accessed through a special  submission  process.   The  same
	FLECS  translation  logic  is  used for both systems, so the
	only   language   differences   are   those   due   to   the
	incompatibilities of the corresponding FORTRANs.



	9.2  WATFLECS

	The procedure for preparing and submitting a  program  under
	WATFLECS is almost identical to the procedure for submitting
	a job under WATFIV.  The deck set up is shown below:

	        $JOB  ...WATFIV parameters
	          .
	          .
	          FLECS source program
	          .
	          .
	        $ENTRY
	          .
	          .
	          data cards (if any)
	          .
	          .

	OPERATING PROCEDURES:  IBM S/360                    Page 9-2
	WATFLECS


	Notes on preparing a WATFLECS program:

	     1.  An 029 keypunch must be used.
	         __ ___ ________ ____ __ ____

	     2.  WATFIV  does  not  follow  the  ANSI  standard  for
	         FORTRAN in that it does not allow a FORTRAN program
	         to jump out of the scope of a  DO  loop  and  later
	         jump back in.  Since FLECS internal procedure calls
	         are implemented by GO TO's, it is not  possible  to
	                                     __ __ ___  ________  __
	         reference an internal procedure within the scope of
	         _________ __ ________ _________ ______ ___ _____ __
	         a DO loop when using WATFLECS.  Any  of  the  other
	         _ __ ____ ____ _____ ________
	         loop  structures may be used to simulate a DO loop,
	         however.

	     3.  Terminate a WATFLECS main program by placing a STOP
	         _________ _ ________ ____ _______ __ _______ _ ____
	         statement  ahead  of  the  first internal procedure
	         _________  _____  __  ___  _____ ________ _________
	         declaration.
	         ___________

	     4.  The  following  unit  numbers  are   available   in
	         WATFLECS:

	                Unit    Physical Device
	                ____    _______________
	                 1      card input (from $ENTRY cards)
	                 2      undefined
	                 3      printed output
	                4-7     scratch disk (READ/WRITE)
	                8-10    class input data sets (READ only)


	     5.  The various "$" cards which control the listing  of
	         a WATFIV program may be included in the program but
	         will be ignored by the WATFLECS system.

	     6.  The user may wish to employ the NOWARN and  NOEXTEN
	         WATFIV  parameters  since  FLECS-generated  FORTRAN
	         triggers many warnings and extensions.




	9.3  STANDARD FORTRAN

	A  cataloged  JCL  procedure  exist  for  using  the   FLECS
	translator as a stand-alone program.  In addition, cataloged
	procedures exist for running FLECS followed by FORTRAN(G).



	9.3.1  Data Sets For The Translator

	The translator requires three data sets with  the  following
	names:

	        SYSIN   is the input data set containing the
	OPERATING PROCEDURES:  IBM S/360                    Page 9-3
	STANDARD FORTRAN


	                FLECS source.

	        LIST    is the output  data  set  containing
	                the FLECS listing.

	        FORTOUT is the output  data  set  containing
	                the  FORTRAN  source produced by the
	                translator.

	The DCB information for these data sets is given below.   It
	is  fixed and contained in the program, hence it need not be
	specified in the JCL.

	        SYSIN   DCB=(RECFM=F,BLKSIZE=80)

	        LIST    DCB=(RECFM=FA,BLKSIZE=133)

	        FORTOUT DCB=(RECFM=F,BLKSIZE=80)




	9.3.2  Using The Translator Stand-Alone

	The cataloged procedure FLECS is a one step procedure  which
	runs  the  FLECS translator.  The user must supply the SYSIN
	data set.  Default DD statements in the procedure send  LIST
	to the printer and FORTOUT to a dummy data set.  If desired,
	these DD statements may be overridden as illustrated in  the
	examples below:

	Example:  Obtaining a printed FLECS listing and ignoring the
	FORTRAN source produced.

	        //jobname   JOB   accounting information
	        //stepname  EXEC  FLECS
	        //SYSIN     DD    *
	           .
	           .
	           FLECS source program
	           .
	           .
	        /*

	Example:  Obtaining a printed  version  of  both  the  FLECS
	listing and the FORTRAN source files.

	OPERATING PROCEDURES:  IBM S/360                    Page 9-4
	STANDARD FORTRAN


	        //jobname   JOB   accounting information
	        //stepname  EXEC  FLECS
	        //FORTOUT   DD    SYSOUT=A
	        //SYSIN     DD    *
	           .
	           .
	           FLECS source program
	           .
	           .
	        /*

	Example:  Obtaining a printed version of the  FLECS  listing
	and  passing  the  FORTRAN source to the FORTRAN(H) compiler
	for compilation only.  (This example illustrates the general
	method  of  passing  the FORTRAN source file to a subsequent
	job step and suppressing the FORTRAN listing.)

	        //jobname   JOB   accounting information
	        //stepname1 EXEC  FLECS
	        //FORTOUT   DD    DSNAME=&TEMP,DISP=(NEW,PASS),
	        //                UNIT=SYSDA,SPACE=(CYL,(1,1))
	        //SYSIN     DD    *
	           .
	           .
	           FLECS source program
	           .
	           .
	        /*
	        //stepname2 EXEC  FORTHC,PARM.FORT='NOSOURCE'
	        //SYSIN     DD    DSNAME=&TEMP,DISP=(OLD,DELETE)




	9.3.3  Using The Translator With FORTRAN(G)

	Several cataloged procedures  have  been  established  which
	simplify   the   process   of   using  FLECS  together  with
	FORTRAN(G).  The procedure names are  given  below  together
	with the FORTRAN procedures to which they correspond.

	        FLECSC          FORTGC
	        FLECSCL         FORTGCL
	        FLECSCLG        FORTGCLG
	        FLECSGO         FORTGO

	The reader is  assumed  to  be  familiar  with  the  "FORTG"
	procedures.  The FLECS procedures have been derived from the
	FORTG procedures by adding an initial procstep  named  FLECS
	which runs the FLECS translator and which passes the FORTOUT
	data set to the following step.  Since  error  message  from
	the  FORTRAN  compiler  will  contain the line number of the
	original FLECS source statement, the  programmer  will  have
	little  occasion  to  use the source listing produced by the
	OPERATING PROCEDURES:  IBM S/360                    Page 9-5
	STANDARD FORTRAN


	FORTRAN compiler.  For this reason, the source listing  from
	FORTRAN  has  been  suppressed  by  including  a  'NOSOURCE'
	parameter for the compiler.

	Example:   Translating,  compiling,  linkage  editing,   and
	executing  a  FLECS  program with previously compiled object
	decks and data.

	        //jobname      JOB   accounting information
	        //stepname     EXEC  FLECSCLG
	        //FLECS.SYSIN  DD    *
	           .
	           .
	           FLECS source program
	           .
	           .
	        /*
	        //LKED.SYSIN   DD    *
	           .
	           .
	           required object decks
	           .
	           .
	        /*
	        //GO.SYSIN     DD    *
	           .
	           .
	           input data
	           .
	           .
	        /*


	        Note:  To obtain the source listing from the
	        FORTRAN  compiler,  replace  the "EXEC" card
	        above with the following:

	        //stepname     EXEC  FLECSCLG


	In general, a FLECS run using one of the FLECS procedures is
	identical  to a FORTRAN(G) run using the corresponding FORTG
	procedures with the following changes:

	     1.  Change the procedure name from FORTGxxx to FLECSxxx
	         (exception:  FORTGO becomes FLECSGO).

	     2.  Change  the  SYSIN  DD  card  from  FORT.SYSIN   to
	         FLECS.SYSIN.

	     3.  If desired, override the suppression of the  source
	         listing by including PARM.FORT='SOURCE' on the EXEC
	         card as described above.













	                         CHAPTER 10

	                   RESTRICTIONS AND NOTES



	If FLECS were implemented by a  nice,  intelligent  compiler
	this  section  would  be  much shorter.  Currently, however,
	FLECS is implemented by a sturdy but naive translator.  Thus
	the    FLECS   programmer   must   observe   the   following
	restrictions:

	     1.  FLECS must invent many statement numbers in
	         creating  the  FORTRAN program.  It does so
	         by beginning with a large  number  (usually
	         99999)  and generating successively smaller
	         numbers as it needs them.   Do  not  use  a
	         number   that  will  be  generated  by  the
	         translator.  A good rule  of  thumb  is  to
	         avoid using 5-digit statement numbers.
	         _____ _____ _______ _________ _______

	     2.  The FLECS translator must generate  integer
	         variable  names.  It does so by using names
	         of the  form  "Innnnn"  where  nnnnn  is  a
	         5-digit   number  related  to  a  generated
	         statement number.  Do not use variables  of
	                            __ ___ ___ _________  __
	         the  form  Innnnn and avoid causing them to
	         ___  ____  ______ ___ _____ _______ ____ __
	         be  declared  other  than   INTEGER.    For
	         __  ________  _____  ____   _______
	         example,           the          declaration
	         "IMPLICIT REAL (A-Z)"  leads  to   trouble.
	         Use "IMPLICIT REAL (A-H,J-Z)" instead.

	     3.  The   translator   does    not    recognize
	         continuation  lines  in  the  source  file.
	         Thus FORTRAN statements may  be  continued,
	         since  the  statement and its continuations
	         will  be  passed  through  the   translator
	         without   alteration   (See  section  1.1).
	         However, an extended FLECS statement  which
	                  __ ________ _____ _________  _____
	         requires  translation may not be continued.
	         ________  ___________ ___ ___ __ _________
	         The reasons one might wish  to  continue  a
	         FLECS   statement   are:    (1)   it  is  a
	         structured    statement    or     procedure
	         declaration  with a one-statement scope too
	         long to fit on a line, or (2)  it  contains
	         an  excessively long specification portion,
	RESTRICTIONS AND NOTES                             Page 10-2
	


	         or (3) both the above.  Problem (1) can  be
	         avoided  by  going  to the multi-line form.
	         Frequently, problem (2) can be avoided when
	         the specification is an expression (logical
	         or otherwise) by assigning  the  expression
	         to  a variable in a preceding statement and
	         then   using   the    variable    as    the
	         specification.

	     4.  Blanks are meaningless separators in  FLECS
	         ______ ___ ___________ __________ __  _____
	         statements;  don't put them in dumb places,
	         ___________  _____ ___ ____ __ ____ ______
	         like the  middle  of  identifiers,  or  key
	         words, and do use them to separate distinct
	                    __
	         words, like REPEAT and UNTIL.

	     5.  Let FLECS indent the  listing.   Start  all
	                                          _____  ___
	         statements in column 7 and the listing will
	         __________ __ ______ _
	         always reveal the  true  structure  of  the
	         program  (as  understood by the translator,
	         of   course).    Alternatively,   on    the
	         DECsystem-10  or  PDP-11, use a tab--^I--as
	         the first character of each  line  followed
	         by the statement text for correct indention
	         by the FLECS translator.  NOTE:  after such
	         a  leading tab character, FLECS will accept
	         any non-alphabetic (and non-"(")  character
	         as  a valid continuation character, placing
	         it correctly in column 6 of  the  resulting
	         FORTRAN source file.

	     6.  As far  as  the  translator  is  concerned,
	         FORMAT  statements  are  executable FORTRAN
	         statements, since it doesn't recognize them
	         as  extended FLECS statements.  Thus, place
	                                               _____
	         FORMAT statements only where an  executable
	         ______ __________ ____ _____ __  __________
	         FORTRAN   statement  would  be  acceptable.
	         _______   _________  _____  __  __________
	         Don't put them between the end  of  a  WHEN
	         statement  and  the  beginning  of  an ELSE
	         statement.    Don't   put   them    between
	         procedure declarations.

	         Incorrect Examples:      Corrected Examples:

	           WHEN (FLAG) WRITE(3,3)   WHEN (FLAG)
	         3 FORMAT(1H1)              .  WRITE(3,3)
	           ELSE LINE=LINE+1       3 .  FORMAT(1H1)
	                                    ...FIN
	                                    ELSE LINE=LINE+1

	           TO WRITE-HEADER          TO WRITE-HEADER
	           .  PAG=PAG+1             .  PAG=PAG+1
	           .  WRITE(3,4) PAG        .  WRITE(3,4) PAG
	           ...FIN                 4 .  FORMAT(1X,I3)
	         4 FORMAT(1X,I3)            ...FIN
	RESTRICTIONS AND NOTES                             Page 10-3
	


	     7.  The  translator,   being   simple   minded,
	         recognizes extended FLECS statements by the
	         process of scanning the first identifier on
	         the  line.  If the identifier is one of the
	         FLECS keywords IF, WHEN, UNLESS, FIN, etc.,
	         the line is assumed to be a FLECS statement
	         and is treated as such.   Thus,  The  FLECS
	                                          ___  _____
	         keywords  are reserved;  do not use them as
	         ________  ___ _________  __ ___ ___ ____ __
	         variable names.  In case  of  necessity,  a
	         ________ _____
	         variable  name  --  say,  WHEN  --  may  be
	         slipped past the translator by embedding  a
	         blank  within  it.  Thus, "WH EN" will look
	         like  "WH"  followed   by   "EN"   to   the
	         translator  which  is  blank sensitive, but
	         like "WHEN" to the compiler, which  ignores
	         blanks.

	     8.  In scanning a parenthesized  specification,
	         the  translator scans from left to right to
	         find  the  parenthesis  that  matches   the
	         initial    left    parenthesis    of    the
	         specification.  The translator, however, is
	         ignorant  of  FORTRAN  syntax including the
	         concept of  Hollerith  constants  and  will
	         treat  Hollerith  parentheses  as syntactic
	         parentheses.  Thus, avoid placing Hollerith
	                             _____ _______ _________
	         constants containing unbalanced parentheses
	         _________ __________ __________ ___________
	         within   specifications.    If   necessary,
	         ______   ______________
	         assign  such  constants  to  a  variable by
	         using DATA or  assignment  statements,  and
	         place  the  variable  in the specification.
	         Alternatively,   FLECS   is   capable    of
	         recognizing FORTRAN quoted literal strings;
	         parentheses embedded within literals may be
	         used safely in all cases.

	         Incorrect Example:     Corrected Examples:

	         IF (J.EQ.1H()          LP = '('
	                                IF (J.EQ.LP)
	                                   or
	                                IF (J.EQ.'(')

	         Note that this restriction also applies  to
	         Hollerith  constants  containing semicolons
	         within specifications for LOOP  statements,
	         when implemented.

	     9.  The FLECS translator will  not  supply  the
	         statements  necessary  to cause appropriate
	         termination   of    main    programs    and
	         subprograms.    Thus,  always  include  the
	                                ______  _______  ___
	         appropriate  RETURN,  STOP,  or  CALL  EXIT
	         ___________  _______  _____  __  ____  ____
	         statement   prior  to  the  first  internal
	         _________   _____  __  ___  _____  ________
	RESTRICTIONS AND NOTES                             Page 10-4
	


	         procedure declaration.  Failure  to  do  so
	         _________ ___________
	         will  result  in control entering the scope
	         of the first procedure  after  leaving  the
	         body  of  the  program.   Do not place such
	         statements    between     the     procedure
	         declarations and the END statement.













	                        APPENDIX A

	                       FLECS KEYWORDS



	        Note:  The following keywords  are  reserved
	        for  FLECS.  Translation errors may occur if
	        these words appear in any context other than
	        those  defined  in  the FLECS syntax.  Their
	        use as  FORTRAN  variable  names  should  be
	        avoided and is strongly discouraged.




	                        BREAK
	                        CONDITIONAL
	                        DEFINE
	                        DO
	                        ELSE
	                        END
	                        FALSE
	                        FIN
	                        IF
	                        INCLUDE
	                        LIST
	                        LOOP
	                        NEXT
	                        NOLIST
	                        OTHERWISE
	                        PAGE
	                        REPEAT
	                        RETURN
	                        SELECT
	                        STRING
	                        THEN
	                        TO
	                        TRUE
	                        UNLESS
	                        UNTIL
	                        WHEN
	                        WHILE












	                        APPENDIX B

	                      FLECS FLOWCHARTS



	Legend:
	______

	    [L] = Logical expression
	    [E] = Expression (any type)
	    [I] = DO iteration specification
	    [#] = Loop nesting level
	     $  = Scope, 1 or more statements




	Alternative Structures:
	___________ __________



	                                        WHEN ( [L] ) $1
	                                        ELSE $2
	  IF ( [L] ) $     UNLESS ( [L] ) $        or
	                                        IF ( [L] ) THEN $1
	                                        ELSE $2
	 --------------   ------------------   --------------------
	      |                |                       |
	      v                v                       v
	     /-\  T           /-\  F               T  /-\  F
	    <[L]>---+        <[L]>---+           +---<[L]>---+
	     \-/    |         \-/    |           |    \-/    |
	      |     v          |     v           v           v
	    F |     $        T |     $           $1          $2
	      |     |          |     |           |           |
	      |<----+          |<----+           +---->+<----+
	      |                |                       |
	      v                v                       v
	FLECS FLOWCHARTS                                    Page B-2
	


	Alternative Structures  (continued):
	___________ __________  ___________



	     CONDITIONAL                    SELECT ( [E] )
	     .  ( [L1] ) $1                 .  ( [E1] ) $1
	     .  ( [L2] ) $2                 .  ( [E2] ) $2
	     .     .     .                  .     .     .
	     .  ( [Ln] ) $n                 .  ( [En] ) $n
	     ...FIN                         ...FIN
	   --------------------           --------------------
	        |                              |
	        v                              v
	       /-\                            /-\
	      /   \  T                       /[E]\  T 
	     <[L1] >--->$1-->+              < .EQ.>--->$1-->+
	      \   /          |               \[E1]/         |
	       \-/           |                \-/           |
	        |            |                 |            |
	      F |            |               F |            |
	        v            |                 v            |
	       /-\           |                /-\           |
	      /   \  T       |               /[E]\  T       |
	     <[L2] >--->$2-->+              < .EQ.>--->$2-->+
	      \   /          |               \[E2]/         |
	       \-/           |                \-/           |
	        |            |                 |            |
	      F |            |               F |            |
	        ~            ~                 ~            ~
	        :            :                 :            :
	        ~            ~                 ~            ~
	        |            |                 |            |
	        v            |                 v            |
	       /-\           |                /-\           |
	      /   \  T       |               /[E]\  T       |
	     <[Ln] >--->$n-->+              < .EQ.>--->$n-->+
	      \   /          |               \[En]/         |
	       \-/           |                \-/           |
	        |            |                 |            |
	      F |            |               F |            |
	        |<-----------+                 |<-----------+
	        |                              |
	        v                              v


	        Note:  OTHERWISE may be used in  CONDITIONAL
	        and  SELECT  statements as a final condition
	        which is "always .TRUE.".
	FLECS FLOWCHARTS                                    Page B-3
	


	Repetitive Structures:
	__________ __________



	     WHILE ( [L] ) $           REPEAT WHILE ( [L] ) $
	    ------------------        -------------------------
	            |                            |
	            |                            +-----+
	            v                                  |
	        F  /-\  T                    F  /-\  T |
	      +---<[L]>---+                +---<[L]>-->|
	      |    \-/    |                |    \-/    |
	      |     ^     |                |     ^     |
	      |     |     v                |     |     v
	      |     |     $                |     |     $
	      |     |     |                |     |     |
	      |     +-----+                |     +-----+
	      |                            |
	      +-----+                      +-----+
	            |                            |
	            v                            v



	     UNTIL ( [L] ) $           REPEAT UNTIL ( [L] ) $
	    ------------------        -------------------------
	            |                            |
	            |                            +-----+
	            v                                  |
	        T  /-\  F                    T  /-\  F |
	      +---<[L]>---+                +---<[L]>-->|
	      |    \-/    |                |    \-/    |
	      |     ^     |                |     ^     |
	      |     |     v                |     |     v
	      |     |     $                |     |     $
	      |     |     |                |     |     |
	      |     +-----+                |     +-----+
	      |                            |
	      +-----+                      +-----+
	            |                            |
	            v                            v
	FLECS FLOWCHARTS                                    Page B-4
	


	Repetitive Structures  (continued):
	__________ __________  ___________



	  LOOP (init;[L];incr) $    REPEAT LOOP (init;[L];incr) $
	 ------------------------  -------------------------------
	            |                            |
	            |                            +-----+
	            v                                  |
	           init                                v
	            |                                 init
	            v                                  |
	        F  /-\  T                    F  /-\  T |
	      +---<[L]>---+                +---<[L]>-->|
	      |    \-/    |                |    \-/    |
	      |     ^     |                |     ^     |
	      |     |     v                |     |     v
	      |    incr   $                |    incr   $
	      |     ^     |                |     ^     |
	      |     |     |                |     |     |
	      |     +-----+                |     +-----+
	      |                            |
	      +-----+                      +-----+
	            |                            |
	            v                            v



	     [ REPEAT ]  LOOP              DO ( [I] ) $
	    ------------------        -------------------------
	            |                            |
	            |                            +-----+
	            |                                  |
	            v                       Fail/-\Suc |
	            +-----+                +---<[I]>-->|
	            ^     |                |    \-/    |
	            |     |                |     ^     |
	            |     v                |     |     v
	            |     $                |     |     $
	            |     |                |     |     |
	            +-----+                |     +-----+
	                                   |
	                                   +-----+
	                                         |
	                                         v
	FLECS FLOWCHARTS                                    Page B-5
	


	Branch Statements:
	______ __________



	       NEXT [ [#] ]                BREAK [ [#] ]
	    ------------------          ---------------------  
	            |                            |
	            v                            v
	           /-\                          /-\
	      +---<   >----+               +---<   >----+
	      |    \-/     |               |    \-/     |
	      |     ^      |               |     ^      |
	      |     |      |               |     |      |
	      |     | NEXT v               |   BREAK    v
	      |     |<=====$               |<===========$
	      |     |      |               |     |      |
	      |     +------+               |     +------+
	      |                            |
	      +-----+                      +-----+
	            |                            |
	            v                            v




	Internal Procedures:
	________ __________



	      procedure-name            TO procedure-name $
	     ----------------          ---------------------
	            |
	            |                      +-----+
	            |                      |     |
	            v                   ---+     v
	       procedure-name                    $
	            |                   <--+     |
	            |                      |     |
	            |                      +-----+
	            v


	        Note:  Place a RETURN, STOP,  or  CALL  EXIT
	        statement ahead of the first TO statement.












	                        APPENDIX C

	                    FLECS SAMPLE PROGRAM







	        Note:  The following pages show the  listing
	        and FORTRAN output files for a "generalized"
	        FLECS sample program.  This program  is  not
	                                                 ___
	        intended  to  be  compiled  with any FORTRAN
	        compiler,  but  rather  it  illustrates   an
	        example  of each FLECS control structure and
	        the   corresponding   FORTRAN   statement(s)
	        generated.




	Legend:
	______

	    [L] = Logical Expression
	    [E] = Expression (any type)
	    [I] = DO iteration specification
	    $nn = Scope, 1 or more statements
	FLECS SAMPLE PROGRAM                                Page C-2
	


	      ----------------------------------------
	       
	00100 C       
	00200 C Sample FLECS Control Structures
	00300 C       
	00400 C   Alternative Structures
	00500 C       
	00600 C     "IF" - 1 alternative, do on .TRUE.
	00700 C       
	00800       IF ( [L] )  $01
	00900 C       
	01000       IF ( [L] )
	01100       .  $02
	01200       ...FIN
	01300 C       
	01400 C     "UNLESS" - 1 alternative, do on .FALSE.
	01500 C       
	01600       UNLESS ( [L] )  $03
	01700 C       
	01800       UNLESS ( [L] )
	01900       .  $04
	02000       ...FIN
	02100 C       
	02200 C     "WHEN" - 2 alternatives
	02300 C       
	02400       WHEN ( [L] )  $05
	02500       ELSE $06
	02600 C       
	02700       WHEN ( [L] )
	02800       .  $07
	02900       ...FIN
	03000       ELSE
	03100       .  $08
	03200       ...FIN
	03300 C       
	03400 C     "CONDITIONAL" - N alternatives
	03500 C       
	03600       CONDITIONAL
	03700       .  ( [L1] )  $09
	03800       .  ( [L2] )
	03900       .  .  $10
	04000       .  ...FIN
	04100       .  (OTHERWISE)  $11
	04200       ...FIN
	04300 C       
	04400 C     "SELECT" - N alternatives
	04500 C       
	04600       SELECT ( [E] )
	04700       .  ( [E1] )  $12
	04800       .  ( [E2] )
	04900       .  .  $13
	05000       .  ...FIN
	05100       .  (OTHERWISE)  $14
	05200       ...FIN
	FLECS SAMPLE PROGRAM                                Page C-3
	


	05400 C       
	05500 C   Repetitive Structures
	05600 C       
	05700 C     "DO" - FORTRAN iterative loop
	05800 C       
	05900       DO ( [I] )  $15
	06000 C       
	06100       DO ( [I] )
	06200       .  $16
	06300       ...FIN
	06400 C       
	06500 C     "WHILE" - test before, do if .TRUE.
	06600 C       
	06700       WHILE ( [L] )  $17
	06800 C       
	06900       WHILE ( [L] )
	07000       .  $18
	07100       ...FIN
	07200 C       
	07300 C     "REPEAT WHILE" - test after, do if .TRUE.
	07400 C       
	07500       REPEAT WHILE ( [L] )  $19
	07600 C       
	07700       REPEAT WHILE ( [L] )
	07800       .  $20
	07900       ...FIN
	08000 C       
	08100 C     "UNTIL" - test before, do if .FALSE.
	08200 C       
	08300       UNTIL ( [L] )  $21
	08400 C       
	08500       UNTIL ( [L] )
	08600       .  $22
	08700       ...FIN
	08800 C       
	08900 C     "REPEAT UNTIL" - test after, do if .FALSE.
	09000 C       
	09100       REPEAT UNTIL ( [L] )  $23
	09200 C       
	09300       REPEAT UNTIL ( [L] )
	09400       .  $24
	09500       ...FIN
	FLECS SAMPLE PROGRAM                                Page C-4
	


	09700 C       
	09800 C     "LOOP" - test before, do if .TRUE.
	09900 C       
	10000       LOOP ($25;[L];$26)  $27
	10100 C       
	10200       LOOP ($28;[L];$29)
	10300       .  $30
	10400       ...FIN
	10500 C       
	10600 C     "LOOP" - infinite form
	10700 C       
	10800       LOOP  $31
	10900 C       
	11000       LOOP
	11100       .  $32
	11200       ...FIN
	11300 C       
	11400 C     "REPEAT LOOP" - test after, do if .TRUE.
	11500 C       
	11600       REPEAT LOOP ($33;[L];$34)  $35
	11700 C       
	11800       REPEAT LOOP ($36;[L];$37)
	11900       .  $38
	12000       ...FIN
	12100 C       
	12200 C     "REPEAT LOOP" - infinite form
	12300 C       
	12400       REPEAT LOOP  $39
	12500 C       
	12600       REPEAT LOOP
	12700       .  $40
	12800       ...FIN
	12900 C       
	13000 C   Branch Statements
	13100 C       
	13200 C     "NEXT" - start next iteration of Nth loop
	13300 C       
	13400       DO ( [I] )
	13500       .  DO ( [I] )
	13600       .  ^--NEXT 1
	13700       ^--.--NEXT 2
	13800       .  ...FIN
	13900       ...FIN
	14000 C       
	14100 C     "BREAK" - exit the Nth loop
	14200 C       
	14300       DO ( [I] )
	14400       .  DO ( [I] )
	14500       .  v--BREAK 1
	14600       v--.--BREAK 2
	14700       .  ...FIN
	14800       ...FIN
	FLECS SAMPLE PROGRAM                                Page C-5
	


	14900 C       
	15000 C   Internal Procedures
	15100 C       
	15200 C     Internal Procedure references
	15300 C       
	15400       procedure-name-1
	15500       procedure-name-2
	15600       STOP
	15700 C       
	15800 C     "TO" - Internal Procedure definitions
	15900 C       
	       
	      ----------------------------------------
	       
	16000       TO procedure-name-1  $41
	       
	      ----------------------------------------
	       
	16100       TO procedure-name-2
	16200       .  $42
	16300       ...FIN
	       
	      ----------------------------------------
	       
	16400       END
	       
	      ----------------------------------------
	       
	            Procedure Cross-Reference Table
	       
	      16000 PROCEDURE-NAME-1
	            15400
	       
	      16100 PROCEDURE-NAME-2
	            15500
	       
	       
	      (FLECS  Version 22H(126))
	       
	      ----------------------------------------
	       
	FLECS SAMPLE PROGRAM                                Page C-6
	


	00800         IF ( [L] )  $01
	01000         IF(.NOT.( [L] )) GO TO 99999
	01100         $02
	01600   99999 IF(.NOT.( [L] )) $03
	01800         IF( [L] ) GO TO 99998
	01900         $04
	02400   99998 IF(.NOT.( [L] )) GO TO 99996
	02401         $05
	02402         GO TO 99997
	02500   99996 $06
	02700   99997 IF(.NOT.( [L] )) GO TO 99994
	02800         $07
	02900         GO TO 99995
	03100   99994 $08
	03700   99995 IF(.NOT.( [L1] )) GO TO 99992
	03701         $09
	03800         GO TO 99993
	03801   99992 IF(.NOT.( [L2] )) GO TO 99991
	03900         $10
	04100         GO TO 99993
	04101   99991 $11
	04700   99993 IF(( [E1] ).NE.( [E] )) GO TO 99989
	04701         $12
	04800         GO TO 99990
	04801   99989 IF(( [E2] ).NE.( [E] )) GO TO 99988
	04900         $13
	05100         GO TO 99990
	05101   99988 $14
	05900   99990 DO 99986  [I] 
	05901         $15
	05902   99986 CONTINUE
	06100   99987 DO 99984  [I] 
	06200         $16
	06300   99984 CONTINUE
	06700   99985 IF(.NOT.( [L] )) GO TO 99983
	06701         $17
	06702         GO TO 99985
	06900   99983 IF(.NOT.( [L] )) GO TO 99982
	07000         $18
	07100         GO TO 99983
	07500   99982 GO TO 99980
	07501   99981 IF(.NOT.( [L] )) GO TO 99979
	07502   99980 $19
	07503         GO TO 99981
	07700   99979 GO TO 99977
	07701   99978 IF(.NOT.( [L] )) GO TO 99976
	07800   99977 $20
	07900         GO TO 99978
	08300   99976 IF( [L] ) GO TO 99975
	08301         $21
	08302         GO TO 99976
	08500   99975 IF( [L] ) GO TO 99974
	08600         $22
	08700         GO TO 99975
	FLECS SAMPLE PROGRAM                                Page C-7
	


	09100   99974 GO TO 99972
	09101   99973 IF( [L] ) GO TO 99971
	09102   99972 $23
	09103         GO TO 99973
	09300   99971 GO TO 99969
	09301   99970 IF( [L] ) GO TO 99968
	09400   99969 $24
	09500         GO TO 99970
	10000   99968 $25
	10001         GO TO 99966
	10002   99967 $26
	10003   99966 IF(.NOT.([L])) GO TO 99965
	10004         $27
	10005         GO TO 99967
	10200   99965 $28
	10201         GO TO 99963
	10202   99964 $29
	10203   99963 IF(.NOT.([L])) GO TO 99962
	10300         $30
	10400         GO TO 99964
	10800   99962 $31
	10801         GO TO 99962
	11100   99959 $32
	11200         GO TO 99959
	11600   99956 $33
	11601         GO TO 99954
	11602   99955 $34
	11603         IF(.NOT.([L])) GO TO 99953
	11604   99954 $35
	11605         GO TO 99955
	11800   99953 $36
	11801         GO TO 99951
	11802   99952 $37
	11803         IF(.NOT.([L])) GO TO 99950
	11900   99951 $38
	12000         GO TO 99952
	12400   99950 $39
	12401         GO TO 99950
	12700   99947 $40
	12800         GO TO 99947
	13400   99944 DO 99942  [I] 
	13500         DO 99940  [I] 
	13600         GO TO 99940
	13700         GO TO 99942
	13800   99940 CONTINUE
	13900   99941 CONTINUE
	13901   99942 CONTINUE
	14300   99943 DO 99938  [I] 
	14400         DO 99936  [I] 
	14500         GO TO 99937
	14600         GO TO 99939
	14700   99936 CONTINUE
	14800   99937 CONTINUE
	14801   99938 CONTINUE
	FLECS SAMPLE PROGRAM                                Page C-8
	


	15400   99939 ASSIGN 99934 TO I99935
	15401         GO TO 99935
	15500   99934 ASSIGN 99932 TO I99933
	15501         GO TO 99933
	15600   99932 STOP
	16000   99935 CONTINUE
	16001         $41
	16002         GO TO I99935
	16100   99933 CONTINUE
	16200         $42
	16300         GO TO I99933
	16400         END












	                        APPENDIX D

	                    FLECS DOCUMENTATION



	                   (As of December, 1974)


	Beyer, T.:  FLECS Users Manual (University of Oregon)

	    Contains a concise description of the FLECS extension of
	    FORTRAN  and of the details necessary to running a FLECS
	    program on the DECsystem-10 or the IBM S/360 at Oregon.


	Beyer, T.:  FLECS System Modification Guide

	    Contains information of interest to anyone who wishes to
	    install  or  adapt  the FLECS system to a new machine or
	    operating system.  Also of interest to those who wish to
	    improve  the  efficiency  of  the  system  by  rewriting
	    portions of the system in assembly language.












	                        APPENDIX E

	                           INDEX




	            $ commands . . . . . . . 5-4
	            $DEFINE command  . . . . 5-8
	            $FALSE command . . . . . 5-5
	            $FIN command . . . . . . 5-6
	            $IF command  . . . . . . 5-6
	            $LIST command  . . . . . 5-10
	            $NOLIST command  . . . . 5-10
	            $PAGE command  . . . . . 5-10
	            $TRUE command  . . . . . 5-5
	            $UNLESS command  . . . . 5-6

	            Algol (language) . . . . 4-2
	            Alternative structures . 4-1, B-1 to B-2

	            Blanks . . . . . . . . . 10-2
	            Body, loop . . . . . . . 4-8, 4-10
	            Branch statements  . . . 4-12, B-5
	            BREAK statement  . . . . 4-13, B-5

	            C (language) . . . . . . 4-9
	            Cataloged procedures . . 9-1 to 9-2, 9-4
	            Command format . . . . . 7-1
	            Commands
	              $  . . . . . . . . . . 5-4
	              COMPILe-class  . . . . 7-3
	              conditional  . . . . . 5-5
	              listing control  . . . 5-10
	              system . . . . . . . . 5-4
	            Comment lines  . . . . . 3-2
	            Comments, intra-line . . 3-2, 5-9
	            COMPILe-class commands . 7-3
	            COMPILe-class switch . . 7-3
	            Conditional commands . . 5-5
	            CONDITIONAL statement  . 4-4, B-2
	            Conditional translation  5-5, 5-7
	            Context errors . . . . . 6-1
	            Continuation lines . . . 10-1 to 10-2
	            Control phrase . . . . . 2-1
	            Control structures . . . 4-1
	            CREF switch  . . . . . . 7-3

	            Debugging lines  . . . . 7-2
	            DEC RT-11  . . . . . . . 1-3, 3-1 to 3-3,
	                                     4-3, 4-12, 4-14,
	                                     5-1 to 5-3, 8-1,
	                                     10-2
	            Decision structures  . . 4-1
	            DECsystem-10 . . . . . . 1-1, 1-3, 3-1 to 3-3,
	                                     4-3, 4-12, 4-14,
	                                     5-1 to 5-3, 5-7,
	                                     5-9, 7-1, 10-2,
	                                     D-1
	            Default extension  . . . 5-2, 7-1 to 7-2,
	                                     8-2
	            DO statement . . . . . . 2-1, 4-6, B-4

	            Errors . . . . . . . . . 6-1
	            Exclamation points . . . 3-2
	            Extended statement . . . 1-2
	            Extension
	              default  . . . . . . . 5-2, 7-1 to 7-2,
	                                     8-2

	            Filename . . . . . . . . 7-1 to 7-2
	            FIN statement  . . . . . 2-2
	            FLECS switch . . . . . . 7-3
	            FLECS-format strings . . 5-3 to 5-4
	            Form feeds . . . . . . . 7-2
	            FORTRAN features . . . . 1-2
	            FORTRAN(G) . . . . . . . 9-1 to 9-2, 9-4
	            FORTRAN(H) . . . . . . . 9-4
	            FORTRAN-10 . . . . . . . 3-1 to 3-2, 5-2,
	                                     5-4, 7-1 to 7-2
	            Function subprograms . . 5-1

	            General LOOP . . . . . . 4-8, B-4
	            General REPEAT LOOP  . . 4-10

	            Hollerith  . . . . . . . 5-9, 10-3

	            IBM S/360  . . . . . . . 1-1, 5-3, 9-1, D-1
	            IF statement . . . . . . 2-1, 4-1, B-1
	            IF...THEN...ELSE statement  4-2 to 4-3, B-1
	            INCLUDE statement  . . . 5-2
	            INCLUDE switch . . . . . 7-2
	            Increment, loop  . . . . 4-8, 4-10
	            Indentation  . . . . . . 3-1, 10-2
	            Indented source file . . 3-3, 5-7, 7-1
	            Infinite LOOP  . . . . . 4-11, B-4
	            Infinite REPEAT LOOP . . 4-11
	            Initialization, loop . . 4-8, 4-10
	            Integer variable . . . . 10-1
	            Internal procedures  . . 4-14, B-5
	            Intra-line comments  . . 3-2, 5-9

	            JCL  . . . . . . . . . . 9-2

	            Keywords . . . . . . . . 2-1, 6-2, 10-3, A-1

	            Library
	              STRLIB (DECsystem-10)  5-4
	              SYSLIB (RT-11) . . . . 5-3
	            Line numbers . . . . . . 1-2
	            Line sequence numbers
	              SOS  . . . . . . . . . 1-3, 7-1 to 7-2
	            LISP (language)  . . . . 4-4
	            LIST switch  . . . . . . 7-3
	            Listing  . . . . . . . . 3-1, 7-1
	            Listing control commands  5-10
	            Literals . . . . . . . . 10-3
	            Logical expression . . . 4-1
	            Loop
	              body . . . . . . . . . 4-8, 4-10
	              increment  . . . . . . 4-8, 4-10
	              initialization . . . . 4-8, 4-10
	              test . . . . . . . . . 4-8, 4-10
	            LOOP statement . . . . . 4-8, 10-3, B-4
	              "general" form . . . . 4-8
	              "infinite" form  . . . 4-11
	            Loop structures  . . . . 4-6

	            Multi-line structured statement  2-2

	            Nesting  . . . . . . . . 2-2
	            NEXT statement . . . . . 4-12, B-5
	            NOWARN switch  . . . . . 5-4
	            NUMBER switch  . . . . . 7-2

	            One-line structured statement  2-2
	            OTHERWISE statement  . . 4-4 to 4-5

	            Page marks . . . . . . . 7-2
	            Parentheses  . . . . . . 4-9, 6-3, 10-3
	            PASCAL (language)  . . . 4-2
	            PL/I (language)  . . . . 4-2
	            Procedure name . . . . . 4-14

	            Quotes
	              double . . . . . . . . 5-2
	              single . . . . . . . . 5-2, 5-4

	            RATFOR . . . . . . . . . 4-9
	            REPEAT LOOP statement  . 4-10, B-4
	              "general" form . . . . 4-10
	              "infinite" form  . . . 4-11
	            REPEAT UNTIL statement . B-3
	            REPEAT WHILE statement . 4-7 to 4-8, B-3
	            Repetitive structures  . 4-6, B-3
	            Restrictions . . . . . . 10-1
	            RETURN statement . . . . 5-1

	            Scope  . . . . . . . . . 2-1
	            SELECT statement . . . . 4-5, B-2
	            Semicolons . . . . . . . 4-9, 10-3
	            Simple statement . . . . 2-1
	            SOS
	              line sequence numbers  1-3, 7-1 to 7-2
	            Source preparation . . . 3-1, 7-1
	            Specification  . . . . . 2-1
	            STANDARD switch  . . . . 7-2
	            Statement number . . . . 10-1
	            String
	              "FLECS"-format . . . . 5-3 to 5-4
	              constant . . . . . . . 5-3
	              variable . . . . . . . 5-3
	            String library . . . . . 5-3 to 5-4
	            STRING statement . . . . 5-3
	            STRLIB library (DECsystem-10)  5-4
	            Structured statement . . 2-1
	            Subroutines  . . . . . . 5-1
	            Substitution, symbolic . 5-7
	            Switch
	              /CREF  . . . . . . . . 7-3
	              /FLECS . . . . . . . . 7-3
	              /INCLUDE . . . . . . . 7-2
	              /LIST  . . . . . . . . 7-3
	              /NOBINARY  . . . . . . 7-3
	              /NOWARN  . . . . . . . 5-4
	              /NUMBER  . . . . . . . 7-2
	              /STANDARD  . . . . . . 7-2
	              COMPILe-class  . . . . 7-3
	              RT-11  . . . . . . . . 8-2
	            Symbolic substitution  . 5-7
	            Syntax errors  . . . . . 6-1
	            SYSLIB library (RT-11) . 5-3
	            System commands  . . . . 5-4

	            Tabs . . . . . . . . . . 3-1 to 3-3, 5-5,
	                                     7-2, 10-2
	            TECO . . . . . . . . . . 7-1
	            Test, loop . . . . . . . 4-8, 4-10
	            TO procedure-name statement  4-14
	            Translation
	              conditional  . . . . . 5-5, 5-7
	            Transportability . . . . 1-1

	            Undetected errors  . . . 6-2
	            UNLESS statement . . . . 4-2, B-1
	            UNTIL statement  . . . . 4-7, B-3

	            WATFIV . . . . . . . . . 9-1
	            WATFLECS . . . . . . . . 9-1
	            WHEN...ELSE statement  . 4-2, B-1
	            WHILE statement  . . . . 4-6, B-3

 . . . . 4-8, 4-10
	            TO procedure-name statement  4-14
	            Translation
	              conditional  . . . . . 5-5, 5-7
	            Transportability . . . . 1-1

	            Undetected errors  . . . 6-2
	            UNLESS statement . 