	PROGRAM VTEST1

C-----------------------------------------------------------------------------
C
C	This program writes four arrays, one of each data type,
C	then reads them back and compares with what was written.
C	Next, it does a real array of square roots and then a
C	double precision array of squares.
C
C	The accesses and faults are printed at the end of each
C	group.  Finally, the hit ration for the entire program is
C	printed.  The hit ration will always be high because of
C	the sequential nation of this particular program.
C
C-----------------------------------------------------------------------------

	PARAMETER (NSIZE = 4000)
	BYTE      BYTE, B
	INTEGER*2 INTGER
	INTEGER*4 ACCESSES, FAULTS
	REAL*4    REAL, R
	REAL*8    DOUBLE, D

	VIRTUAL	BYTE(NSIZE), INTGER(NSIZE), REAL(NSIZE), DOUBLE(NSIZE)

	COMMON /VCOUNT/ ACCESSES, FAULTS

C...... Initialize statistics

	ACCESSES = 0
	FAULTS   = 0

C...... Print message

	WRITE (5,*) ' '
	WRITE (5,*) 'VIRTUAL DISK ARRAY TEST'
	WRITE (5,*)

C...... Load data

	DO 10 I=1,NSIZE
	   B=I
	   BYTE(I)=B
   10	CONTINUE

	DO 20 I=1,NSIZE
	   INTGER(I)=I
   20	CONTINUE

	DO 30 I=1,NSIZE
	   R=I
	   REAL(I)=R
   30	CONTINUE

	DO 40 I=1,NSIZE
	   D=I
	   DOUBLE(I)=D
   40	CONTINUE

	TYPE 200, ACCESSES, FAULTS

C...... Check values

	DO 110 I=1,NSIZE
	   B=I
	   IF (BYTE(I) .NE. B) WRITE (5,*) 'BYTE test ',B,BYTE(I)
  110	CONTINUE

	DO 120 I=1,NSIZE
	   IF (INTGER(I) .NE. I)  WRITE (5,*) 'INTEGER test ',I,INTGER(I)
  120	CONTINUE

	DO 130 I=1,NSIZE
	   R=I
	   IF (REAL(I) .NE. R)  WRITE (5,*) 'REAL test ',R,REAL(I)
  130	CONTINUE

	DO 140 I=1,NSIZE
	   D=DOUBLE(I)
	   IF (DOUBLE(I) .NE. D) WRITE (5,*) 'DOUBLE test',D,DOUBLE(I)
  140	CONTINUE

	TYPE 200, ACCESSES, FAULTS

C...... Do square-root and square loading

	DO 150 I=1,NSIZE
	   R=I
	   REAL(I)=SQRT(R)
  150	CONTINUE

	DO 160 I=1,NSIZE
	   D=I
	   DOUBLE(I)=D*D
  160	CONTINUE

	TYPE 200, ACCESSES, FAULTS

C...... Check results

	DO 170 I=1,NSIZE
	   R=I
	   IF (REAL(I) .NE. SQRT(R))
     1	      WRITE (5,*) 'SQRT test ',I,SQRT(R),REAL(I)
  170	CONTINUE

	DO 180 I=1,NSIZE
	   D=I
	   IF (DOUBLE(I) .NE. D*D)
     1	      WRITE (5,*) 'SQUARE test ',I,D*D,DOUBLE(I)
  180	CONTINUE

	TYPE 200, ACCESSES, FAULTS

C...... Print statistics

	HITS = 100.0 * ( 1.0-(FLOAT(FAULTS)/FLOAT(ACCESSES)) )
	TYPE 205, HITS

C-----------------------------------------------------------------------------

  200	FORMAT(' ACCESSES  =',I10,'  FAULTS    =',I10/)
  205	FORMAT(' Hit ratio = ',F8.2,'%'/)

	END
                                                                                                                                                                                                                                                                                                                                                                                                                                               