	FUNCTION TAN(X)
	COSX=COS(X)
	IF (COSX.EQ.0.) GOTO 1
	TAN=SIN(X)/COSX
	RETURN
1	TAN=0.
	CALL ERRGON('TAN(X)')
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DTAN(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X
	DCOSX=DCOS(X)
	IF (DCOSX.EQ.0.) GOTO 1
	DTAN=DSIN(X)/DCOSX
	RETURN
1	DTAN=0.
	CALL ERRGON('DTAN(X)')
	RETURN
	END
C
	COMPLEX FUNCTION CTAN(Z)
	IMPLICIT COMPLEX (C)
	COMPLEX Z
	CCOSZ=CCOS(Z)
	IF (CCOSZ.EQ.(0.,0.)) GOTO 1
	CTAN=CSIN(Z)/CCOSZ
	RETURN
1	CTAN=(0.,0.)
	CALL ERRGON('CTAN(X)')
	RETURN
	END
C
	FUNCTION ASIN(X)
	IF (X.EQ.1..OR.X.EQ.-1.) GOTO 1
	IF (X.GT.1..OR.X.LT.-1.) GOTO 2
	ASIN=ATAN(X/SQRT(1-X**2))
	RETURN
1	ASIN=X*PI()/2.
	RETURN
2	ASIN=0.
	CALL ERRGON('ASIN(X)')
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DASIN(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X,PI
	IF (X.EQ.1..OR.X.EQ.-1.) GOTO 1
	IF (X.GT.1..OR.X.LT.-1.) GOTO 2
	DASIN=DATAN(X/DSQRT(1-X**2))
	RETURN
1	DASIN=X*PI()/2.
	RETURN
2	DASIN=0.
	CALL ERRGON('DASIN(X)')
	RETURN
	END
C
	FUNCTION ACOS(X)
	ACOS=PI()/2.
	IF (X.EQ.0.) RETURN
	IF (X.EQ.1..OR.X.EQ.-1.) GOTO 1
	IF (X.GT.1..OR.X.LT.-1.) GOTO 2
	AC=ATAN(SQRT(1-X**2)/X)
	ACOS=AC
	IF (X.LT.0) ACOS=AC+PI()
	RETURN
1	ACOS=((1-X)/2)*PI()
	RETURN
2	ACOS=0.
	CALL ERRGON('ACOS(X)')
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DACOS(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X,PI
	DACOS=PI()/2.
	IF (X.EQ.0.) RETURN
	IF (X.EQ.1..OR.X.EQ.-1.) GOTO 1
	IF (X.GT.1..OR.X.LT.-1.) GOTO 2
	DAC=DATAN(DSQRT(1-X**2)/X)
	DACOS=DAC
	IF (X.LT.0.) DACOS=DAC+PI()
	RETURN
1	DACOS=((1-X)/2)*PI()
	RETURN
2	DACOS=0.
	CALL ERRGON('DACOS(X)')
	RETURN
	END
C
	FUNCTION SINH(X)
	SINH=(EXP(X)-EXP(-X))/2.
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DSINH(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X
	DSINH=(DEXP(X)-DEXP(-X))/2.
	RETURN
	END
C
	COMPLEX FUNCTION CSINH(Z)
	IMPLICIT COMPLEX (C)
	COMPLEX Z
	CSINH=(CEXP(Z)-CEXP(-Z))/(2.,0.)
	RETURN
	END
C
	FUNCTION COSH(X)
	COSH=(EXP(X)+EXP(-X))/2.
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DCOSH(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X
	DCOSH=(DEXP(X)+DEXP(-X))/2.
	RETURN
	END
C
	COMPLEX FUNCTION CCOSH(Z)
	IMPLICIT COMPLEX (C)
	COMPLEX Z
	CCOSH=(CEXP(Z)+CEXP(-Z))/(2.,0.)
	RETURN
	END
C
	DOUBLE PRECISION FUNCTION DTANH(X)
	IMPLICIT DOUBLE PRECISION (D)
	DOUBLE PRECISION X
	DTANH=DSIN(X)/DCOSH(X)
	RETURN
	END
C
	COMPLEX FUNCTION CTANH(Z)
	IMPLICIT COMPLEX (C)
	COMPLEX Z
	CTANH=CSINH(Z)/CCOSH(Z)
	RETURN
	END
C
	SUBROUTINE ERRGON(STRING)
	BYTE STRING(1),ERRSTR(34)
	DATA ERRSTR /13,13,10,'?','G','O','N','L','I','B','-',
	* 'F','-','I','n','v','a','l','i','d',' ','a','r','g',
	* 'u','m','e','n','t',' ','o','f',' ',0/
	L=0
	DO 1, I=1,10
	IF (STRING(I).EQ.0) GOTO 2
1	L=L+1
2	DO 4, I=1,33
3	IF (ITTOUR(ERRSTR(I))) GOTO 3
4	CONTINUE
	DO 6, I=1,L
5	IF (ITTOUR(STRING(I))) GOTO 5
6	CONTINUE
7	IF (ITTOUR(13)) GOTO 7
8	IF (ITTOUR(10)) GOTO 8
9	IF (ITTOUR(10)) GOTO 9
	RETURN
	END
                      