/*
 *				b u i l d 1 . c
 *
 * Op sys strings and things
 */

#include	<stdio.h>
#include	"build.h"

/*
 * Default model strings
 *
 * Note the following:
 *	SRC and COPYINCLUDE must be such that, if neither is changed,
 *	the copy may be omitted.
 */

char		*comm_model =
/*
 *	comm_model is common to all operating systems.
 *
 * Note: several of the following are rewritten on various operating systems.
 * Others are specified here so they are defined during processing.
 */
"\
$(SRC)		= {}\n\
$(BIN)		= {}\n\
$(FIRST)	= {}\n\
$(LAST)		= {}\n\
$(COPYCOMMENT)	= {}\n\
$(DELCOMMENT)	= {}\n\
$(ALLOWEXECUTE)	= {}\n\
$(ALLOWREAD)	= {}\n\
$(POSTFIX)	= {}\n\
$(TERMINATE)	= {}\n\
$(INCLUDE)	= {}\n\
$(FILES)	= {}\n\
$(MPINSTALL)	= {}\n\
$(MP)		= {}\n\
$(CPP)		= {}\n\
$(DIFFINSTALL)	= {}\n\
$(UTLIB)	= {}\n\
$(EOF)		= {^Z}\n\
$(EXIT)		= {^Z}\n\
$(SOURCE)	= {$(SRC)$?}\n\
$(VXLINK)	= { link/nomap/exe=$(BIN)$(PROGRAM) $(VXOBJS)\n}\n\
$(RXLINK)	= { tkb $(LINK1)$(BIN)$(PROGRAM)=$(RXOBJS)$(RXARGS)\n}\n\
$(RTLINK)	= { LINK\n$(BIN)$(PROGRAM)=$(LINK1)$(RTOBJS)$(LINK2)\n}\n\
$(RXODL)	= { $(PROGRAM).TMP/MP}\n\
$(RXARGS)	= {}\n\
$(STACK)	= 2000\n\
$(TKBOPTIONS)	= {}\n\
$(OBJS)		= {}\n\
$(DTOA)		= {}\n\
$(ATOF)		= {}\n\
$(LIBS)		= {}\n\
$(OVR)		= {}\n\
$(ODL)		= {}\n\
$(LINK1)	= {}\n\
$(LINK2)	= {}\n\
$(LBR.1)	= $(LBR)\n\
$(VXLIBR.1)	= {$$ library/insert/object $? }\n\
$(VXLIBR)	= { library/create/object $? $(VXOBJS)\n}\n\
$(RXLIBR)	= { $(LBR) $?/CR=$(RXOBJS)\n}\n\
$(RTLIBR)	= { LIBR\n$?=$(LINK1)$(RTOBJS)$(LINK2)\n}\n\
";

char		*op_base[] = {
/*
 *	op_base contains operating system specific strings, such
 *	as those needed to copy files.
 */

/*
 * NONE		Undefined
 */
"",

/*
 * VAX
 */
"\
$(INITIALIZE)	= { $$! Vax $(MODE) command file built on $(DATE)\n\
$$ was_verify = 'f$$verify(1)'\n}\n\
$(VXLIB)	= { SYS$$LIBRARY:VAXCRTL/LIB}\n\
$(RXLIB)	= { C:C/LB}\n\
$(BIN)		= BIN:\n\
$(MCR)		= { $ mcr }\n\
$(PREFIX)	= { $$!\n$$! ** Compile $(PROGRAM)\n$$!\n}\n\
$(COPYINCLUDE)	= { $$ $(COPYCOMMENT)copy $(SOURCE) $?\n}\n\
$(COPYODL)	= { $$ create $(PROGRAM).TMP\n$(ODL)\n$$EOD\n}\n\
$(DELETEODL)	= { $$ delete $(PROGRAM).TMP;\n}\n\
$(COMMENT)	= {!! }\n\
$(LBR)		= { mcr lbr}\n\
$(EOF)		= { $$EOD\n}\
$(CLEANUP)	= { $$ $(DELCOMMENT)delete $*.OBJ;\n}\n\
$(EXECUTABLE)	= { $$ set protection=(world=re) $(BIN)$(PROGRAM).EXE;\n}\n\
$(READABLE)	= { $$ set protection=(world=r) $?\n}\n\
$(POSTFIX)	= { $$ $(PROGRAM) :== $$$(BIN)$(PROGRAM)\n}\n\
$(TERMINATE)	= { $$ if .not. 'was_verify' then set noverify\n}\n\
",
/*
 * RSX
 */
"\
$(MCR)		= {}\n\
$(PREFIX)	= { ;\n; Compile $(PROGRAM)\n;\n}\n\
$(COPYINCLUDE)	= { $(COPYCOMMENT)pip $?=$(SOURCE)\n}\n\
$(COPYODL)	= {\
.OPEN $(PROGRAM).TMP\n\
.ENABLE DATA\n\
$(ODL)\n\
.DISABLE DATA\n\
.CLOSE\n\}\n\
$(DELETEODL)	= { pip $(PROGRAM).TMP;/de\n}\n\
$(EXECUTABLE)	= { pip $(BIN)$(PROGRAM).TSK;/pr/wo:r\n}\n\
$(READABLE)	= { pip $?/pr/wo:r\n}\n\
$(COMMENT)	= {;; }\n\
$(LBR)		= lbr\n\
$(CLEANUP)	= { $(DELCOMMENT)pip $*.OBJ;/de\n}\n\
",
/*
 * RSTS
 */
"\
$(INITIALIZE)	= {\n\
SWITCH BASIC\n\
! RSTS $(MODE) command file built on $(DATE)\n\
}\n\
$(MCR)		= {}\n\
$(PREFIX)	= { !\n! ** Compile $(PROGRAM)\n!\n}\n\
$(COPYINCLUDE)	= { $(COPYCOMMENT)pip $?=$(SOURCE)\n}\n\
$(COPYODL)	= { pip $(PROGRAM).TMP=_kb:\n$(ODL)\n$(EOF)\n}\n\
$(DELETEODL)	= { pip $(PROGRAM).TMP/de\n}\n\
$(READABLE)	= { pip $?<40>/re\n}\n\
$(COMMENT)	= {!! }\n\
$(LBR)		= lbr\n\
$(CLEANUP)	= { $(DELCOMMENT)pip $*.OBJ/de\n}\n\
",
/*
 * RT11
 */
"\
$(PREFIX)	= { !\n! ** Compile $(PROGRAM)\n!\n}\n\
$(COPYINCLUDE)	= {\
SET ERROR NONE\n\
$(COPYCOMMENT)COPY $(SOURCE) $?\n\
SET ERROR ERROR\n}\n\
$(COMMENT)	= {!! }\n\
$(CLEANUP)	= { $(DELCOMMENT)DELETE/NOQ $*.OBJ\n}\n\
$(EXECUTABLE)	= {}\n\
$(READABLE)	= {}\n\
$(EXIT)		= {^C}\n\
",
/*
 * UNIXNATIVE
 */
"\
$(INITIALIZE)	= { # Unix makefile built on $(DATE)\n\
CFLAGS = -O\n\}\n\
$(PREFIX)	= {#\n# ** compile $(PROGRAM)\n#\n}\n\
$(COPYINCLUDE)	= {}\n\
$(COMMENT)	= {#}\n\
$(UXMAKE)	= {\
OBJECTS.$(PROGRAM) = $(UXFILES)\n\
$(PROGRAM): $$(OBJECTS.$(PROGRAM))\n\
\tcc $$(CFLAGS) $$(OBJECTS.$(PROGRAM)) -o $(PROGRAM)\n}\n\
$(UXINCLUDE)	= {$$(OBJECTS.$(PROGRAM)): $(SOURCE)\n}\n\
",
};
char		*op_model[] = {
/*
 *	op_model contains strings needed to compile and link C
 *	programs.
 */

/*
 * NONE		Undefined
 */
"",

/*
 * VNATIVE	Vax native
 */
"\
$(MODE)		= native\n\
$(CC)		= { $$ cc/nolist $(SOURCE)\n}\n\
$(CCMP)		= $(CC)\n\
$(LINK)		= { $$ $(VXLINK)}\n\
$(LIBRARY)	= { $$ $(VXLIBR)}\n\
$(DECUS_LIB)	= { C:VAXLIB/LIB}\n\
$(DTOA.OBJ)	= {}\n\
$(ATOF.OBJ)	= {}\n\
",
/*
 * VRSX		Vax Rsx
 */
"\
$(MODE)		= compatibility\n\
$(RSXP)		= {}\n\
$(DTOA.OBJ)	= { C:DTOA}\n\
$(ATOF.OBJ)	= { C:ATOF}\n\
$(CC)		= {\
$$ xcc $(SOURCE) $(RSXP)\n\
$$ xas $*.S -d\n}\n\
$(CCMP)		= {\
$$ cpp $(SOURCE) $*.TM2\n\
$$ xcc $*.TM2 $(RSXP)\n\
$$ xas $*.S -d\n\
$$ delete $*.TM2;\n}\n\
$(LINK)		= { $$ mcr $(RXLINK)}\
$(LIBRARY)	= { $$ $(RXLIBR)}\n\
$(LBR.1)	= { $$ mcr lbr}\n\
",
/*
 * RSXNATIVE
 */
"\
$(INITIALIZE)	= { ; RSX native command file built on $(DATE)\n\
.IFNINS XCC INS $$CC\n\
.IFNINS XAS INS $$AS\n}\n\
$(RXLIB)	= { LB:[1,1]C/LB}\n\
$(DTOA.OBJ)	= { C:DTOA}\n\
$(ATOF.OBJ)	= { C:ATOF}\n\
$(RSXP)		= {}\n\
$(MPINSTALL)	= {.IFNINS CPP INS $$CPP\n}\n\
$(CC)		= {\n\
xcc $(SOURCE) -a $(RSXP)\n\
.IF <EXSTAT> NE 1 .EXIT\n\
}\n\
$(CCMP)		= {\
cpp $(SOURCE) $*.TM2\n\
.IF <EXSTAT> NE 1 .EXIT\n\
xcc $*.TM2 -a $(RSXP)\n\
.IF <EXSTAT> NE 1 .EXIT\n\
pip $*.TM2;/de\n}\n\
$(LINK)		= {\
.OPEN $(PROGRAM).TKB\n\
.ENABLE DATA\n\
$(BIN)$(PROGRAM)/CP=$(RXOBJS)$(RXARGS)\n\
.DISABLE DATA\n\
.CLOSE\n\
tkb @$(PROGRAM).TKB\n\
.IF <EXSTAT> NE 1 .EXIT\n\
pip $(PROGRAM).TKB;/de\n}\n\
$(LIBRARY)	= $(RXLIBR)\n\
",
/*
 * RSTSRSX	RSTS RSX mode
 */
"\
$(MODE)		= RSX\n\
$(RXLIB)	= { C:C/LB}\n\
$(DTOA.OBJ)	= { C:RXDTOA}\n\
$(ATOF.OBJ)	= { C:RXATOF}\n\
$(RSXP)		= {}\n\
$(CC)		= {\
xcc $(SOURCE) $(RSXP)\n\
xas $*.S -d\n}\n\
$(CCMP)		= {\
cpp $(SOURCE) $*.TM2\n\
xcc $*.TM2 $(RSXP)\n\
xas $*.S -d\n\
pip $*.TM2/de\n}\n\
$(LINK)		= { $(RXLINK)}\n\
$(LIBRARY)	= { $(RXLIBR)}\n\
$(EXECUTABLE)	= { pip $(BIN)$(PROGRAM).TSK<104>/re\n}\n\
",
/*
 * RSTSRT	RSTS RT11 mode
 */
"\
$(MODE)		= RT11\n\
$(SUPORT)	= { c:suport}\n\
$(RTLIB)	= { c:clib}\n\
$(DTOA.OBJ)	= { c:rtdtoa}\n\
$(ATOF.OBJ)	= { c:rtatof}\n\
$(RT11P)	= {}\n\
$(CC)		= {\
cc $(SOURCE)$(RT11P)\n\
as $*.S/d\n}\n\
$(CCMP)		= {\
cpp $(SOURCE) $*.TM2\n\
cc $*.TM2$(RT11P)\n\
as $*.S/d\n\
pip $*.TM2/de\n}\n\
$(LINK)		= { RUN $$$(RTLINK)}\n\
$(LIBRARY)	= { RUN $$$(RTLIBR)}\n\
$(EXECUTABLE)	= { pip $(BIN)$(PROGRAM).SAV<104>/re\n}\n\
",
/*
 * RT11NATIVE
 */
"\
$(INITIALIZE)	= { ! RT11 native command file built on $(DATE)\n}\n\
$(SUPORT)	= { c:suport}\n\
$(RTLIB)	= { c:clib}\n\
$(DTOA.OBJ)	= { c:dtoa}\n\
$(ATOF.OBJ)	= { c:atof}\n\
$(RT11P)	= {}\n\
$(CC)		= {\
RUN C:CC\n$(SOURCE)$(RT11P)\n\
RUN C:AS\n$*.S/d\n}\n\
$(CCMP)		= {\
RUN C:CPP\n$(SOURCE) $*.TM2\n\
RUN C:CC\n$*.TM2$(RT11P)\n\
RUN C:AS\n$*.S/d\n\
DELETE/NOQ $*.TM2\n}\n\
$(LINK)		= { R $(RTLINK)}\n\
$(LIBRARY)	= { R $(RTLIBR)}\n\
",

/*
 * UNIX		Unix
 */
"\
$(DTOA.OBJ)	= {}\n\
$(ATOF.OBJ)	= {}\n\
",
};
                                                                                                                                                                                                                                                                                                                                       