/*)BUILD	$(PROGRAM)	=	ftest2
		$(INCLUDE)	=	pml.h
		$(DTOA)		=	1
		$(UTLIB)	=	C:PML
		$(TKBOPTIONS)	= {
			STACK	=	2000
			TASK	=	...FT2
		}
*/

#include <stdio.h>
#include "c:pmluse.h"
#include "pml.h"

#define cabs_table cabst
#define csqrt_table csrtb
#define csin_table csntb
#define ccos_table ccstb
#define cln_table clntb
#define cexp_table cxptb
#define ctan_table ctntb
#define csinh_table cshtb
#define ccosh_table ccsht
#define ctanh_table cthtb
#define casin_table casht
#define cacos_table cacst
#define catan_table cattb
#define crcp_table crcpt
double crcp_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     1.999999992549419403e-01, -3.999999985098838806e-01,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00, -5.000000000000000000e-01,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.000000000000000000e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -2.500000000000000000e-01, -2.500000000000000000e-01,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -1.999999992549419403e-01,  3.999999985098838806e-01,
     1.000000000000000000e00, -2.000000000000000000e00,
     1.999999992549419403e-01,  3.999999985098838806e-01
};
double catan_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     1.338972523808479309e00,  4.023594781756401062e-01,
     0.000000000000000000e00,  2.000000000000000000e00,
     1.570796325802803039e00,  5.493061468005180358e-01,  /* -real part */
     1.000000000000000000e00,  0.000000000000000000e00,
     7.853981629014015197e-01,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -1.311223268508911132e00,  2.388778626918792724e-01,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -1.338972523808479309e00, -4.023594819009304046e-01,
     1.000000000000000000e00, -2.000000000000000000e00,
     1.338972523808479309e00, -4.023594819009304046e-01
};
double cacos_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     1.143717750906944274e00, -1.528570920228958129e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     1.570796325802803039e00, -1.443635478615760803e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     0.000000000000000000e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
     2.325045466423034668e00, -1.734324529767036438e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
     1.997874900698661804e00,  1.528570890426635742e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     1.143717750906944274e00,  1.528570890426635742e00
};
double casin_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     4.270785786211490631e-01,  1.528570890426635742e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00,  1.443635478615760803e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.570796325802803039e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -7.542491331696510314e-01,  1.734324455261230468e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -4.270785823464393615e-01, -1.528570920228958129e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     4.270785823464393615e-01, -1.528570920228958129e00
};
double ctanh_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     1.166736245155334472e00, -2.434581927955150604e-01,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00, -2.185039848089218139e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     7.615941539406776428e-01,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -1.023835599422454834e00, -2.839295566082000732e-02,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -1.166736245155334472e00,  2.434581927955150604e-01,
     1.000000000000000000e00, -2.000000000000000000e00,
     1.166736245155334472e00,  2.434581927955150604e-01
};
double ccosh_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
    -6.421481221914291381e-01,  1.068607419729232788e00,
     0.000000000000000000e00,  2.000000000000000000e00,
    -4.161468371748924255e-01,  0.000000000000000000e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.543080642819404602e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -1.565625831484794616e00, -3.297894805669784545e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -6.421481221914291381e-01,  1.068607419729232788e00,
     1.000000000000000000e00, -2.000000000000000000e00,
    -6.421481221914291381e-01, -1.068607419729232788e00
};
double csinh_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
    -4.890562593936920166e-01,  1.403119236230850219e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00,  9.092974215745925903e-01,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.175201192498207092e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
     1.509306475520133972e00,  3.420954853296279907e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
     4.890562593936920166e-01, -1.403119236230850219e00,
     1.000000000000000000e00, -2.000000000000000000e00,
    -4.890562593936920166e-01, -1.403119236230850219e00
};
double ctan_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     3.381283208727836608e-02,  1.014793619513511657e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00,  9.640275761485099792e-01,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.557407721877098083e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
     2.839295566082000732e-02,  1.023835599422454834e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -3.381283208727836608e-02, -1.014793619513511657e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     3.381283208727836608e-02, -1.014793619513511657e00
};
double cexp_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
    -1.131204381585121154e00,  2.471726655960083007e00,
     0.000000000000000000e00,  2.000000000000000000e00,
    -4.161468371748924255e-01,  9.092974215745925903e-01,
     1.000000000000000000e00,  0.000000000000000000e00,
     2.718281835317611694e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -5.631934991106390953e-02,  1.230600243434309959e-01,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -1.530918665230274200e-01, -3.345118276774883270e-01,
     1.000000000000000000e00, -2.000000000000000000e00,
    -1.131204381585121154e00, -2.471726655960083007e00
};
double cln_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     8.047189563512802124e-01,  1.107148721814155578e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     6.931471824645996093e-01,  1.570796325802803039e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     0.000000000000000000e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
     1.039720773696899414e00,  2.356194496154785156e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
     8.047189563512802124e-01, -2.034443944692611694e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     8.047189563512802124e-01, -1.107148721814155578e00
};
double ccos_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     2.032723009586334228e00, -3.051897794008255004e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     3.762195706367492675e00,  0.000000000000000000e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     5.403023064136505127e-01,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -1.565625846385955810e00,  3.297894805669784545e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
     2.032723009586334228e00, -3.051897794008255004e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     2.032723009586334228e00,  3.051897794008255004e00
};

double csin_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     3.165778547525405883e00,  1.959601044654846191e00,
     0.000000000000000000e00,  2.000000000000000000e00,
     0.000000000000000000e00,  3.626860409975051879e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     8.414709866046905517e-01,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
    -3.420954853296279907e00, -1.509306490421295166e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
    -3.165778547525405883e00, -1.959601044654846191e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     3.165778547525405883e00, -1.959601044654846191e00
};
double csqrt_table[] = {
     1.000000000000000000e00,  2.000000000000000000e00,
     1.272019654512405395e00,  7.861513718962669372e-01,
     0.000000000000000000e00,  2.000000000000000000e00,
     1.000000000000000000e00,  1.000000000000000000e00,
     1.000000000000000000e00,  0.000000000000000000e00,
     1.000000000000000000e00,  0.000000000000000000e00,
    -2.000000000000000000e00,  2.000000000000000000e00,
     6.435942575335502624e-01,  1.553773969411849975e00,
    -1.000000000000000000e00, -2.000000000000000000e00,
     7.861513718962669372e-01, -1.272019654512405395e00,
     1.000000000000000000e00, -2.000000000000000000e00,
     1.272019654512405395e00, -7.861513718962669372e-01
};
double cabs_table[] = {
    1.000000000000e00, 2.000000000000e00, 2.23606798052788e00,
    0.000000000000e00, 2.000000000000e00, 2.00000000000000e00,
    1.000000000000e00, 0.000000000000e00, 1.00000000000000e00,
   -2.000000000000e00, 2.000000000000e00, 2.82842713594437e00,
   -1.000000000000e00,-2.000000000000e00, 2.23606798052788e00,
    1.000000000000e00,-2.000000000000e00, 2.23606798052788e00
};

struct test {
    double (*func)();
    double *table;
    int entries;
    char *name;
};
eval(fpntr)
register struct test *fpntr;
{
    double dabs();
    COMPLEX val, ref, err, aerr, amax, v;
    register double *tblpntr;
    register int idx;

    amax.real = amax.imag = 0.0;
    tblpntr = fpntr->table;
    for (idx = 0; idx < fpntr->entries; idx++ ) {
	val.real = *tblpntr++;
	val.imag = *tblpntr++;
	ref.real = *tblpntr++;
	ref.imag = *tblpntr++;
	v.real = val.real;
	v.imag = val.imag;
	(*fpntr->func)(&val);
	err.real = (val.real-ref.real)/ref.real;
	err.imag = (val.imag-ref.imag)/ref.imag;
	aerr.real = dabs(err.real);
	aerr.imag = dabs(err.imag);
	if (aerr.real > 1.0e-4 || aerr.imag > 1.0e-4) {
#ifdef PDP10
	    printf ("%s error for %f + j %f\n",fpntr->name,v.real,v.imag);
	    printf ("\tComputed value = %f + j %f\n",val.real,val.imag);
	    printf ("\tReference value = %f + j %f\n",ref.real,ref.imag);
	    printf ("\tRelative error = %f + j %f\n",err.real,err.imag);
#else
	    printf ("%s error for %le + j %le\n",fpntr->name,v.real,v.imag);
	    printf ("\tComputed value = %le + j %le\n",val.real,val.imag);
	    printf ("\tReference value = %le + j %le\n",ref.real,ref.imag);
	    printf ("\tRelative error = %le + j %le\n",err.real,err.imag);
#endif
	}
	if (aerr.real > amax.real) {
	    amax.real = aerr.real;
	}
	if (aerr.imag > amax.imag) {
	    amax.imag = aerr.imag;
	}
    }
#ifdef PDP10
    printf ("\t%s:\terrmax = %f real %f imag\n",fpntr->name,amax.real,amax.imag);
#else
    printf ("\t%s:\terrmax = %le real %le imag\n",fpntr->name,amax.real,amax.imag);
#endif
}
struct test tests[] = {
    &csin,&csin_table,6,"CSIN",
    &ccos,&ccos_table,6,"CCOS",
    &ctan,&ctan_table,6,"CTAN",
    &csinh,&csinh_table,6,"CSINH",
    &ccosh,&ccosh_table,6,"CCOSH",
    &ctanh,&ctanh_table,6,"CTANH",
    &casin,&casin_table,6,"CASIN",
    &cacos,&cacos_table,6,"CACOS",
    &catan,&catan_table,6,"CATAN",
    &csqrt,&csqrt_table,6,"CSQRT",
    &cexp,&cexp_table,6,"CEXP",
    &cln,&cln_table,6,"CLN",
    &crcp,&crcp_table,6,"CRCP",
    0,0,0,0
};

main()
{
    register struct test *tp;

    tp = &tests[0];
    while (tp->func) {
	eval(tp);
	tp++;
    }
    do_cabs();
}

do_cabs()
{
    COMPLEX x;
    double  r, cabs();
    register double *tblpntr;
    double rref, err, kerr, errmax, dabs();
    register int idx;

    errmax = 0.0;
    tblpntr = cabs_table;
    for (idx = 0; idx < 6; idx++ ) {
	x.real = *tblpntr++;
	x.imag = *tblpntr++;
	r = cabs(&x);
	rref = *tblpntr++;
	err = (r-rref)/rref;
	kerr = dabs(err);
	if (kerr > 1.0e-4) {
#ifdef PDP10
	    printf ("%s error for %f %f\n","CABS",x.real,x.imag);
	    printf ("\tComputed value = %f\n",r);
	    printf ("\tReference value = %f\n",rref);
	    printf ("\tRelative error = %f\n\n",err);
#else
	    printf ("%s error for %le %le\n","CABS",x.real,x.imag);
	    printf ("\tComputed value = %le\n",r);
	    printf ("\tReference value = %le\n",rref);
	    printf ("\tRelative error = %le\n\n",err);
#endif
	}
	if (kerr > errmax) {
	    errmax = kerr;
	}
    }
#ifdef PDP10
    printf ("\t%s:\terrmax = %f\n","CABS",errmax);
#else
    printf ("\t%s:\terrmax = %le\n","CABS",errmax);
#endif
}
                                                                                                                                                                      