          .MACRO $ALVIN
          .MCALL $ALV51
$ALV51
          .ENDM
;;************** Updated 2-Oct-85 for CL-Controlled devices, V5.1c.
        .MACRO $ALV51
EOL1=215         ;Carriage Return Character (NORMAL END-OF-LINE)
EOL2=215         ;CARRIAGE RETURN CHARACTER (ALTERNATE END-OF-LINE)
CAN1=204         ;CONTROL "D" CHARACTER (CANCEL CURRENT INPUT LINE)
CAN2=225         ;Control "U" Character (ALTERNATE CANCEL LINE)
CTLAT=200        ;CONTROL "@" CHARACTER (GENERATE A BREAK)
ECHOTOG=206      ;CONTROL "F" CHARACTER (KEYBOARD ECHO CONTROL)
TRUNC=226        ;CONTROL "V" CHARACTER (TRUNCATE CURRENT LISTING)
ALTMODE=375      ;ALT MODE CHARACTER
RUBOUT=377       ;RUBOUT CHARACTER (ALTERNATE ALTMODE CHARACTER)
                 ;WYLBUR RESPONDS WITH EVEN PARITY
XON=021          ;CONTROL "Q" CHARACTER (WYLBUR RESPONSE COMPLETE)
XOFF=023	 ;Control "S" Character - Flow control, turn off
;;
NUL=0            ;CONTROL "@" CHARACTER - NULL
EOT=004          ;CONTROL "D" CHARACTER - END-OF-TRANSMISSION
BELL=007         ;CONTROL "G" CHARACTER - AUDIO ALARM
BS=010           ;CONTROL "H" CHARACTER - BACK SPACE
HT=011           ;CONTROL "I" CHARACTER - HORIZONTAL TAB
LF=012           ;CONTROL "J" CHARACTER - LINE FEED
VT=013           ;CONTROL "K" CHARACTER - VERTICAL TAB
FF=014           ;CONTROL "L" CHARACTER - FORM FEED
CR=015           ;CONTROL "M" CHARACTER - CARRIAGE RETURN
CAN=030          ;CONTROL "X" CHARACTER - ALTERNATE BACK SPACE
BLANK=040        ;THE SPACE CHARACTER
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;        BUFFER DESCRIPTOR OFFSETS:
BIN=0     ;INPUT POINTER
BOUT=2    ;OUTPUT POINTER
BSTART=4  ;STARTING ADDRESS OF THE BUFFER
BEND=6    ;ENDING ADDRESS OF THE BUFFER
BStatus=10 ;Buffer status
;;;;;;;;;;;;;;;;;;
;;        UNIT LOGICAL STATUS DEFINITIONS
COMPLETE=100000  ;OPERATION COMPLETE
DISABLE=040000   ;UNIT DISABLED
SEIZED=020000    ;UNIT SEIZED
IGNORE=010000    ;UNIT IS IN THE IGNORE STATE
REQUEST=004000   ;REQUEST PENDING FOR UNIT
ERROR=002000     ;ERROR DETECTED
BUFULL=001000    ;UNIT'S DATA BUFFER IS FULL (INPUT DEVICES ONLY)
AUTONL=001000    ;AUTO-NEW-LINE IN PROGRESS (STREAM OUTPUT DEVICES ONLY)
RESPONSE=000400  ;RESPONSE DETECTED
CANCEL=000200    ;CANCEL REQUEST DETECTED
NOECHO=000100    ;UNIT ECHO DISABLED (INPUT DEVICES ONLY)
PAGING=000100    ;PAGE EJECT IN PROGRESS (PAGE OUTPUT DEVICES ONLY)
SETPARITY=000040 ;FORCE PARITY BIT ON
BRKREQ=000020    ;BREAK REQUEST DETECTED
CLRPARITY=000010 ;FORCE PARITY BIT OFF
OFFLINE=000004   ;Printer Offline 
DOECHO=000004    ;CHAR NEEDS TO BE ECHOED YET (RT INPUT DEVICES ONLY)
ASYNCH=000002    ;Asynchronous processing request (i.e, Break detect, IN only)
EXTRA=000001     ;Flow control marker - input=xoff sent, output=send NEXTOUT
STALLD=00001     ;Alias for EXTRA - indicates input device needs reactivation.
;;;;;;;;;;;;;;;;;;
;;        UNIT LOGICAL CONTROL WORD BIT DEFINITIONS
ATACHD=100000    ;UNIT IS ATTACHED (not used - but reserved)
SNDBRK=010000    ;Unit is allowed to send breaks (OUTPUT only)
SILENT=010000    ;Initiate receive with NOECHO enabled (INPUT only)
PARON= 004000    ;PARITY IS BY DEFAULT TO BE FORCED ON (OUTPUT ONLY)
PAROFF=002000    ;PARITY IS BY DEFAULT TO BE FORCED OFF (OUTPUT ONLY)
  ;(Someday ...  SETTING BOTH PARON & PAROFF WILL RESULT IN EVEN PARITY)
STREAM=000001    ;UNIT HAS STREAM LIST ENABLED (PRINTED OUTPUT ONLY)
PAGE=  000002    ;UNIT HAS PAGE FORMATING ENABLED (PRINTED OUTPUT ONLY)
OUTPUT=000004    ;Unit is enabled for output - absence indicates input.
RTCTL= 000010    ;UNIT IS AN RT-11 CONTROLLED DEVICE (CONSOLE ONLY)
ECHO=  000020    ;Unit is to echo chars thru ASOCDEVICE (INPUT only)
FLOWCTL=00040    ;Unit enabled for flow control (ie,Xon/Xoff Input stream)
CLCTL= 000100    ;Unit is a pseudo-device using TSX-Plus CL support.
NoAbort=00200	; Enable soft error reporting & no control-C abort (console).
;;        ADDITIONAL SEND & RECEIVE CONTROL BIT DEFINITIONS
RESET= 001000    ;RECIEVE FUNCTION FOR RESETTING BUFFER POINTERS
STRING=020000    ;SEND FUNCTION INDICATING STRING DESCRIPTOR PROVIDED
UseDB=  40000    ;Function indicating the Default Buffer is to be used.
;;       (Bit 400 is reserved as a control word continuation indicator
;;        for Send/Receive calls.)
;;       (All high-byte control word bits can be also be used as 
;;       Send/Receive functions at the time of the call.
;;**********************************************************************
;;        DEVICE DESCRIPTORS
;;
;;   OFFSET DEFINITIONS
;;
LSTAT=0          ;LOGICAL STATUS OFFSET (MUST BE THE 1ST WORD)
DEVADR=2         ;DEVICE STATUS ADDRESS OFFSET
BDADR=4          ;CURRENT BUFFER DESCRIPTOR ADDRESS
VECTOR=6         ;ADDRESS OF INTERRUPT VECTOR
INTRPT=10        ;ADDRESS OF INTERRUPT HANDLER
HNDLER=INTRPT    ;Address of Pseudo-device handler (for RT-Ctl'ed)
IOSTAT=12        ;ACTUAL DEVICE STATUS AT TIME OF LAST INTERRUPT
PDSTAT=14        ;PREVIOUS DEVICE STATUS WHEN ENABLED
PENTRY=16        ;PREVIOUS ENTRY ADDRESS IN INTERRUPT VECTOR
PENTPS=20        ;PREVIOUS PROCESSOR STATUS IN INTERRUPT VECTOR
PDBadr=22	; Previous Default Buffer descriptor address.
LCTL=24          ;LOGICAL CONTROL WORD
LUNIT=26         ;LOGICAL UNIT NUMBER (1 BYTE)
REDIRECT=LUNIT+1 ;Redirect logical unit number, if zero then does not exit.
BDefault=30      ;Default buffer descriptor address.
LWORK0=32        ;CONTEXT DEPENDENT DEVICE DYNAMIC STORAGE
CharSV=LWork0    ;Character save location for RT-Controled defered echo.
CARLEN=LWORK0    ;LENGTH IN CHARS OF A CARRIAGE (STREAM OUTPUT)
BRKREG=LWORK0    ;COUNT REGISTER FOR BREAK TIMING (LINEOUT ONLY)
BRKLEN=LWORK0+1  ;LENGTH IN CHAR TIMES OF A BREAK (LINEOUT ONLY)
LWORK1=LWork0+2  ;CONTEXT DEPENDENT DEVICE DYNAMIC STORAGE WORD 1
ERRCNT=LWORK1    ;COUNT OF CHARACTER ERRORS (INPUT ONLY)
LWORK2=LWORK0+4
ERRCHAR=LWORK2   ;Override character for input chars detected in error.
PAGLEN=LWORK2    ;ONE BYTE LENGTH IN LINES OF A PRINT PAGE (PAGE OUTPUT)
LINMAX=LWORK2+1  ;PAGE EJECT LINE #; A BYTE FOR LINES/PAGE (PAGE OUTPUT)
LWORK3=LWORK0+6
ASOCDEVICE=LWORK3 ;Associated device descriptor, flow control in & out.
LWORK4=LWORK0+10
FLOWOFF=LWORK4   ;Output character which will stop the input flow
FLOWON=LWORK4+1  ;Output character which will re-start the input flow
LWORK5=LWORK0+12
NEXTOUT=LWORK5   ;When EXTRA raised, this is the next character to go.
LWORK6=LWORK0+14
BUFMARGIN=LWORK6 ;Count of buffer at which flow will stop/resume.
LWORK7=LWORK0+16
CTLSTR=LWORK7    ;Pointer to control string to compare to (console input).
LINCNT=LWORK7    ;CURRENT LINE COUNT WITHIN PAGE; A BYTE (PAGE OUTPUT)
CARPOS=LWORK7+1  ;CURRENT CARRIAGE COLUMN POSITION (STREAM OUTPUT)
CLUNIT=LWORK0+20  ; Unit number of the TSX CL driver to be used.
TSXLINE=LWORK0+21 ; TSX terminal number to be taken over for the CL I/O.
TSXJob=Lwork0+22  ; TSX job number.
AllocJob=Lwork0+23 ; The job which owns the CL allocation.
BDESC0=LWORK0+24  ; BUFFER DESCRIPTOR WORK
BDESC1=BDESC0+2   ; BUFFER DESCRIPTOR WORK
BDESC2=BDESC0+4   ; BUFFER DESCRIPTOR WORK
BDESC3=BDESC0+6   ; BUFFER DESCRIPTOR WORK
R2SAVE=LWORK0+34  ; For direct interrupt entry, this stores interrupted Reg 2.
DevDend=LWORK0+36 ; Size of a device descriptor in bytes.
;;*************************************************************
	; Device Table Descriptor offsets:
DTDbegin=0	; Beginning address of device table (a vector of pointers).
DTDend=2	; End address of the device table.
DTDmax=4	; Maximum number of devices (this is now an arbitrary limit).
DTDItable=6	; RT direct interrupt table address (zero = not defined).
DTDDsize=10	; Size of a device descriptor in bytes.
	; Direct Interrupt Table Descriptor offsets:
DITbegin=0	; Beginning address of the interrupt entry table.
DITend=2	; Ending address of the interrupt entry table.
DITsize=4	; Size of an interrupt entry element.
DDAstore=4  ; Offset of Device Desc Adr in a direct interrupt entry element.
DITDin=6	; Default input interrupt handler address.
DITDout=10	; Default output interrupt handler address.
;;*********************************************************************
;; Typical logical device numbers of the console:
;;
KEYB=0     ;Logical device number of the console keyboard.
LIST=1     ;Logical device number of the console display.
      .ENDM
;;*********************************************************************
        .MACRO $ALV50
EOL1=215         ;Carriage Return Character (NORMAL END-OF-LINE)
EOL2=215         ;CARRIAGE RETURN CHARACTER (ALTERNATE END-OF-LINE)
CAN1=204         ;CONTROL "D" CHARACTER (CANCEL CURRENT INPUT LINE)
CAN2=225         ;Control "U" Character (ALTERNATE CANCEL LINE)
CTLAT=200        ;CONTROL "@" CHARACTER (GENERATE A BREAK)
ECHOTOG=206      ;CONTROL "F" CHARACTER (KEYBOARD ECHO CONTROL)
TRUNC=226        ;CONTROL "V" CHARACTER (TRUNCATE CURRENT LISTING)
ALTMODE=375      ;ALT MODE CHARACTER
RUBOUT=377       ;RUBOUT CHARACTER (ALTERNATE ALTMODE CHARACTER)
                 ;WYLBUR RESPONDS WITH EVEN PARITY
XON=021          ;CONTROL "Q" CHARACTER (WYLBUR RESPONSE COMPLETE)
XOFF=023	 ;Control "S" Character - Flow control, turn off
;;
NUL=0            ;CONTROL "@" CHARACTER - NULL
EOT=004          ;CONTROL "D" CHARACTER - END-OF-TRANSMISSION
BELL=007         ;CONTROL "G" CHARACTER - AUDIO ALARM
BS=010           ;CONTROL "H" CHARACTER - BACK SPACE
HT=011           ;CONTROL "I" CHARACTER - HORIZONTAL TAB
LF=012           ;CONTROL "J" CHARACTER - LINE FEED
VT=013           ;CONTROL "K" CHARACTER - VERTICAL TAB
FF=014           ;CONTROL "L" CHARACTER - FORM FEED
CR=015           ;CONTROL "M" CHARACTER - CARRIAGE RETURN
CAN=030          ;CONTROL "X" CHARACTER - ALTERNATE BACK SPACE
BLANK=040        ;THE SPACE CHARACTER
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;        BUFFER DESCRIPTOR OFFSETS
BIN=0     ;INPUT POINTER
BOUT=2    ;OUTPUT POINTER
BSTART=4  ;STARTING ADDRESS OF THE BUFFER
BEND=6    ;ENDING ADDRESS OF THE BUFFER
;;;;;;;;;;;;;;;;;;
;;        UNIT LOGICAL STATUS DEFINITIONS
COMPLETE=100000  ;OPERATION COMPLETE
DISABLE=040000   ;UNIT DISABLED
SEIZED=020000    ;UNIT SEIZED
IGNORE=010000    ;UNIT IS IN THE IGNORE STATE
REQUEST=004000   ;REQUEST PENDING FOR UNIT
ERROR=002000     ;ERROR DETECTED
BUFULL=001000    ;UNIT'S DATA BUFFER IS FULL (INPUT DEVICES ONLY)
AUTONL=001000    ;AUTO-NEW-LINE IN PROGRESS (STREAM OUTPUT DEVICES ONLY)
RESPONSE=000400  ;RESPONSE DETECTED
CANCEL=000200    ;CANCEL REQUEST DETECTED
NOECHO=000100    ;UNIT ECHO DISABLED (INPUT DEVICES ONLY)
PAGING=000100    ;PAGE EJECT IN PROGRESS (PAGE OUTPUT DEVICES ONLY)
SETPARITY=000040 ;FORCE PARITY BIT ON
BRKREQ=000020    ;BREAK REQUEST DETECTED
CLRPARITY=000010 ;FORCE PARITY BIT OFF
OFFLINE=000004   ;Printer Offline 
DOECHO=000004    ;CHAR NEEDS TO BE ECHOED YET (RT INPUT DEVICES ONLY)
ASYNCH=000002    ;Asynchronous processing request (i.e, Break detect, IN only)
EXTRA=000001     ;Flow control marker - input=xoff sent, output=send NEXTOUT
;;;;;;;;;;;;;;;;;;
;;        UNIT LOGICAL CONTROL WORD BIT DEFINITIONS
ATACHD=100000    ;UNIT IS ATTACHED
SNDBRK=010000    ;Unit is allowed to send breaks (OUTPUT only)
SILENT=010000    ;Initiate receive with NOECHO enabled (INPUT only)
PARON= 004000    ;PARITY IS BY DEFAULT TO BE FORCED ON (OUTPUT ONLY)
PAROFF=002000    ;PARITY IS BY DEFAULT TO BE FORCED OFF (OUTPUT ONLY)
  ;(Someday ...  SETTING BOTH PARON & PAROFF WILL RESULT IN EVEN PARITY)
STREAM=000001    ;UNIT HAS STREAM LIST ENABLED (PRINTED OUTPUT ONLY)
PAGE=  000002    ;UNIT HAS PAGE FORMATING ENABLED (PRINTED OUTPUT ONLY)
OUTPUT=000004    ;Unit is enabled for output - absence indicates input.
RTCTL= 000010    ;UNIT IS AN RT-11 CONTROLLED DEVICE (CONSOLE ONLY)
ECHO=  000020    ;Unit is to echo chars thru ASOCDEVICE (INPUT only)
FLOWCTL=00040    ;Unit enabled for flow control (ie,Xon/Xoff Input stream)
;;        ADDITIONAL SEND & RECEIVE CONTROL BIT DEFINITIONS
RESET= 001000    ;RECIEVE FUNCTION FOR RESETTING BUFFER POINTERS
STRING=020000    ;SEND FUNCTION INDICATING STRING DESCRIPTOR PROVIDED
;;       (BIT 400 IS RESERVED AS A CONTROL WORD CONTINUATION INDICATOR
;;        FOR SEND/RECEIVE CALLS.)
;;       (All high-byte control bits can be used at send/receive time
;;       as functions presumming they are used in the proper context.)
;;**********************************************************************
;;        DEVICE DESCRIPTORS
;;
;;   OFFSET DEFINITIONS
;;
LSTAT=0          ;LOGICAL STATUS OFFSET (MUST BE THE 1ST WORD)
DEVADR=2         ;DEVICE STATUS ADDRESS OFFSET
BDADR=4          ;CURRENT BUFFER DESCRIPTOR ADDRESS
VECTOR=6         ;ADDRESS OF INTERRUPT VECTOR
INTRPT=10        ;ADDRESS OF INTERRUPT HANDLER
HNDLER=INTRPT    ;Address of Pseudo-device handler (for RT-Ctl'ed)
IOSTAT=12        ;ACTUAL DEVICE STATUS AT TIME OF LAST INTERRUPT
PDSTAT=14        ;PREVIOUS DEVICE STATUS WHEN ENABLED
PENTRY=16        ;PREVIOUS ENTRY ADDRESS IN INTERRUPT VECTOR
PENTPS=20        ;PREVIOUS PROCESSOR STATUS IN INTERRUPT VECTOR
PDDADR=22        ;PREVIOUS DEVICE DESCRIPTOR ADDRESS FOR UNIT ENABLED
LCTL=24          ;LOGICAL CONTROL WORD
LUNIT=26         ;LOGICAL UNIT NUMBER (1 BYTE)
REDIRECT=LUNIT+1 ;Redirect logical unit number, if zero then does not exit.
LWORK0=30        ;CONTEXT DEPENDENT DEVICE DYNAMIC STORAGE
CharSV=LWork0    ;Character save location for RT-Controled defered echo.
CARLEN=LWORK0    ;LENGTH IN CHARS OF A CARRIAGE (STREAM OUTPUT)
BRKREG=LWORK0    ;COUNT REGISTER FOR BREAK TIMING (LINEOUT ONLY)
BRKLEN=LWORK0+1  ;LENGTH IN CHAR TIMES OF A BREAK (LINEOUT ONLY)
LWORK1=32        ;CONTEXT DEPENDENT DEVICE DYNAMIC STORAGE WORD 1
ERRCNT=LWORK1    ;COUNT OF CHARACTER ERRORS (INPUT ONLY)
LWORK2=LWORK0+4
ERRCHAR=LWORK2   ;Override character for input chars detected in error.
PAGLEN=LWORK2    ;ONE BYTE LENGTH IN LINES OF A PRINT PAGE (PAGE OUTPUT)
LINMAX=LWORK2+1  ;PAGE EJECT LINE #; A BYTE FOR LINES/PAGE (PAGE OUTPUT)
LWORK3=LWORK0+6
ASOCDEVICE=LWORK3 ;Associated device descriptor, flow control in & out.
LWORK4=LWORK0+10
FLOWOFF=LWORK4   ;Output character which will stop the input flow
FLOWON=LWORK4+1  ;Output character which will re-start the input flow
LWORK5=LWORK0+12
NEXTOUT=LWORK5   ;When EXTRA raised, this is the next character to go.
LWORK6=LWORK0+14
BUFMARGIN=LWORK6 ;Count of buffer at which flow will stop/resume.
LWORK7=LWORK0+16
CTLSTR=LWORK7    ;Pointer to control string to compare to
LINCNT=LWORK7    ;CURRENT LINE COUNT WITHIN PAGE; A BYTE (PAGE OUTPUT)
CARPOS=LWORK7+1  ;CURRENT CARRIAGE COLUMN POSITION (STREAM OUTPUT)
SDESC0=LWORK0+20 ;STRING DESCRIPTOR WORK WORD FOR MULTI-SEQUENCES
SDESC1=SDESC0+2  ;STRING DESCRIPTOR WORK WORD FOR MULTI-SEQUENCES
BDESC0=SDESC0+4  ;BUFFER DESCRIPTOR WORK
BDESC1=BDESC0+2  ;BUFFER DESCRIPTOR WORK
BDESC2=BDESC0+4  ;BUFFER DESCRIPTOR WORK
BDESC3=BDESC0+6  ;BUFFER DESCRIPTOR WORK
;;**************************************
;; Typical logical device numbers of the console:
;;
KEYB=0     ;Logical device number of the console keyboard.
LIST=1     ;Logical device number of the console printer.
      .ENDM
;;*********************************************************************
;;*********
        .MACRO  $GETYN  PROMPT,YES,NO,BREAK,DESC,?BLABL,?CLABL

.IF NB <PROMPT>  ;Process inline string and descriptor.
        .NLIST
        .GLOBL  GETYN
        .LIST
        JSR     %5,GETYN
        .WORD   .+10	;Inline string descriptor address.
  .IF NB BREAK             
        BR      BREAK	;User specified BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - Assume BREAK.is.NO.
  .EndC
  .IF NB NO
        BR      NO	;User specified a NO.exit branch.
  .IFF
        BR      BLABL	;Assume the fall-through case is NO.
  .ENDC
  .IF NB YES
        BR      YES	;User specified a YES.exit branch.
  .IFF
        BR      BLABL	;Assume the fall-through case is YES.
    .IF B NO
        .ERROR ; $GETYN - Neither a YES.nor.NO exit specified.
    .endc
  .endc
        .WORD   .+4	;Start address of the string.
        .WORD   CLABL-1	;End address of the string.
        .ASCII  \PROMPT\
CLABL:
        .EVEN
BLABL:
.Mexit
.IFF            ;Process user specified string descriptor.
  .IF B DESC
        .ERROR ; $GETYN - No_Prompt String nor DESCriptor provided.
  .Mexit
  .Endc
        .NLIST
        .GLOBL  GETYN
        .LIST
        JSR     %5,GETYN
        .WORD   DESC	;User specified string descriptor.
  .IF NB BREAK  
        BR      BREAK	;User specified a BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - Assume BREAK.is.NO.
  .EndC
  .IF NB NO
        BR      NO	;User specified a NO.exit branch.
  .IFF
        BR      .+4	;Assume the fall-through case is NO.
  .ENDC
  .IF NB YES
        BR      YES	;User specified a YES.exit branch.
  .IFF
    .IF B NO
        NOP		;(Filler)
        .ERROR ; $GETYN - Neither a YES.exit nor a NO.exit specified.
    .endc
  .endc
.ENDC
        .ENDM
;;*********
        .MACRO  $LIST   MSG,DESC,?BLABL,?CLABL
 
.IF NB <MSG>       ;Process inline string and descriptor.
        .NLIST
        .GLOBL  PUTLIST
        .LIST
        JSR     %5,PUTLIST
        .WORD   .+4	;String descriptor address.
        BR      BLABL	;Branch around the message.
        .WORD   .+4	;Start address of the string.
        .WORD   CLABL-1	;End address of the string.
        .ASCII  \MSG\
CLABL:
        .EVEN
BLABL:
.MEXIT
.IFF            ;Process user provided string descriptor.
  .IF B DESC
        .ERROR ; $LIST invoked with no argument.
  .Mexit
  .IFF
        .NLIST
        .GLOBL  PUTLIST
        .LIST
        JSR     %5,PUTLIST
        .WORD   DESC	;User provided string descriptor.
  .MEXIT
  .Endc
.ENDC
        .ENDM
;;*********
        .MACRO  $GETLIST  PROMPT,ANSWR,BREAK,DESC,?BLABL,?CLABL

.IF NB <PROMPT>  ;Process inline string and descriptor.
        .NLIST
        .GLOBL  GETLIST
        .LIST
        JSR     %5,GETLIST
        .WORD   .+10	;Inline PROMPT.string descriptor address.
  .IF NB ANSWR
        .WORD	ANSWR	;User specified INPUT STRING descriptor.
  .IFF
        .WORD	0	;(Filler - nowhere for input to go.)
        .ERROR ; $GETLIST - No input string descriptor provided.
  .endc
  .IF NB BREAK
        BR      BREAK	;User specified BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - BREAK.is.IGNORED; R0=Count=0.
  .EndC
	BR	BLABL	;Branch around the inline string.
        .WORD   .+4	;Start address of the Prompt.string.
        .WORD   CLABL-1	;End address of the Prompt.string.
        .ASCII  \PROMPT\
CLABL:
        .EVEN
BLABL:
.Mexit
.IFF            ;Process user specified string descriptor.
  .IF B DESC
        .ERROR ; $GETLIST - No_Prompt String provided.
  .Mexit
  .Endc
        .NLIST
        .GLOBL  GETLIST
        .LIST
        JSR     %5,GETLIST
        .WORD   DESC	;User provided prompt.descriptor.
  .IF NB ANSWR
        .WORD	ANSWR	;User specified INPUT STRING descriptor.
  .IFF
        .WORD	0	;(Filler - nowhere for input to go.)
        .ERROR ; $GETLIST - No input string descriptor provided.
  .endc
  .IF NB BREAK  
        BR      BREAK	;User specified a BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - BREAK.is.IGNORED; R0=Count=0.
  .EndC

.ENDC
        .ENDM		; $GETLIST macro end.
;;*********
        .MACRO  $GETSTRING PROMPT,ANSWR,BREAK,DESC,?BLABL,?CLABL

.IF NB <PROMPT>  ;Process inline string and descriptor.
        .NLIST
        .GLOBL  GETLIST
        .LIST
        JSR     %5,GETLIST
        .WORD   .+10	;Inline PROMPT.string descriptor address.
  .IF NB ANSWR
        .WORD	ANSWR	;User specified INPUT STRING descriptor.
  .IFF
        .WORD	0	;(Filler - nowhere for input to go.)
        .ERROR ; $GETLIST - No input string descriptor provided.
  .endc
  .IF NB BREAK
        BR      BREAK	;User specified BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - BREAK.is.IGNORED; R0=Count=0.
  .EndC
	BR	BLABL	;Branch around the inline string.
        .WORD   .+4	;Start address of the Prompt.string.
        .WORD   CLABL-1	;End address of the Prompt.string.
        .ASCII  \PROMPT\
CLABL:
        .EVEN
BLABL:
.Mexit
.IFF            ;Process user specified string descriptor.
  .IF B DESC
        .ERROR ; $GETLIST - No_Prompt String provided.
  .Mexit
  .Endc
        .NLIST
        .GLOBL  GETLIST
        .LIST
        JSR     %5,GETLIST
        .WORD   DESC	;User provided prompt.descriptor.
  .IF NB ANSWR
        .WORD	ANSWR	;User specified INPUT STRING descriptor.
  .IFF
        .WORD	0	;(Filler - nowhere for input to go.)
        .ERROR ; $GETLIST - No input string descriptor provided.
  .endc
  .IF NB BREAK  
        BR      BREAK	;User specified a BREAK.exit.
  .IFF
        NOP		;No.BREAK.exit - BREAK.is.IGNORED; R0=Count=0.
  .EndC

.ENDC
        .ENDM		; $GETSTring macro end.
;;*********
        .MACRO  $LIST1  MSG,DESC,?BLABL,?CLABL
 
.IF NB <MSG>       ;Process inline string and descriptor.
        .NLIST
        .GLOBL  PUTLIST
        .LIST
        JSR     %5,PUTLIST
        .WORD   .+4	;String descriptor address.
        BR      BLABL	;Branch around the message.
        .WORD   .+4	;Start address of the string.
        .WORD   CLABL-1	;End address of the string.
        .BYTE   15,12	;$LIST1 begins on new line - CR,LF.
        .ASCII  \MSG\
CLABL:
        .EVEN
BLABL:
.MEXIT
.IFF            ;Process user provided string descriptor.
  .IF B DESC
        .ERROR ; $LIST1 invoked with no argument.
  .Mexit
  .IFF
        .NLIST
        .GLOBL  PUTLIST,CRLF
        .LIST
        JSR     %7,CRLF
        JSR     %5,PUTLIST
        .WORD   DESC	;User provided string descriptor.
  .Mexit
  .Endc
.Endc
        .ENDM
;;**************
        .MACRO  $SKIPLIST  MSG,DESC,?BLABL,?CLABL
 
.IF NB <MSG>       ;Process inline string and descriptor.
        .NLIST
        .GLOBL  PUTLIST
        .LIST
        JSR     %5,PUTLIST
        .WORD   .+4	;String descriptor address.
        BR      BLABL	;Branch around the message.
        .WORD   .+4	;Start address of the string.
        .WORD   CLABL-1	;End address of the string.
        .BYTE   15,12	;$SkipList begins on a new line: CR,LF.
        .ASCII  \MSG\
CLABL:
        .EVEN
BLABL:
.MEXIT
.IFF            ;Process user provided string descriptor.
  .IF B DESC
        .ERROR ; $SKIPLIST invoked with no argument.
  .Mexit
  .IFF
        .NLIST
        .GLOBL  PUTLIST,CRLF
        .LIST
        JSR     %7,CRLF
        JSR     %5,PUTLIST
        .WORD   DESC	;User provided string descriptor.
  .Mexit
  .Endc
.Endc
        .ENDM
;;**************
	.MACRO	$SKIP
        .NLIST
        .GLOBL  CRLF
        .LIST
        JSR     %7,CRLF
	.ENDM
;;**************
	.MACRO	$SKIP2
        .NLIST
        .GLOBL  CRLF2
        .LIST
        JSR     %7,CRLF2
	.ENDM
;;**************
         .MACRO $RTDEF
RTJSW=44         ;ADDRESS OF RT JOB STATUS WORD
TTNOWAIT=100     ;RTJSW BIT TO INHIBIT TT WAIT FOR .TTINR AND .TTOUTR
TTSPECIAL=10000  ;RTJSW BIT TO ALLOW PASSING OF CHARS AS AVAILABLE .TTIN
TTUPLOW=40000    ;RTJSW BIT TO ALLOW INPUT OF UPPER AND LOWER CASE
;;
ERRBYT  =52     ;SYSTEM CALLS RETURN ERROR NUMBERS TO THIS BYTE.
O.KCSR  =304    ;OFFSET INTO RMON FOR KEYBOARD COMMAND/STATUS ADDRESS.
SRCHAN  =0      ;SAVE/RESTORE DATA I/O CHANNEL.
CHAINLENTH=510  ;ADR OF LENGTH OF STRING RETURNED TO RT FOR CHAIN EXIT.
CHAINSTRING=512 ;START ADR OF COMMANDS TO BE EXECUTED AFTER CHAIN EXIT.
;;
RTsysgen=372	; RMON offset of the sysgen features word:
TSXgen=100000	;  Sysgen configuration bit indicating TSX+v5.0 or later.
          .ENDM
;;**************
          .MACRO $REGS
          R0=%0  ;GENERAL REGISTER DEFINITION
          R1=%1
          R2=%2
          R3=%3
          R4=%4
          R5=%5
          R6=%6
          R7=%7
          SP=R6
          PC=R7
          .ENDM
;;**************
          .MACRO $CONSL
TKS=177560       ;CONSOLE KEYBOARD STATUS
TKB=177562       ;CONSOLE KEYBOARD BUFFER
TPS=177564       ;CONSOLE PRINTER STATUS
TPB=177566       ;CONSOLE PRINTER BUFFER
TKIAD=60         ;VECTOR ADDRESS OF CONSOLE KEYBOARD INTERRUPT
TPIAD=64         ;VECTOR ADDRESS OF CONSOLE PRINTER INTERRUPT
          .ENDM
;;**************
          .MACRO $LINE2
DLRS=176510      ;DL-11 RECEIVER STATUS
DLRB=176512      ;DL-11 RECEIVER BUFFER
DLXS=176514      ;DL-11 TRANSMITTER STATUS
DLXB=176516      ;DL-11 TRANSMITTER BUFFER
DLRIAD=310       ;VECTOR ADDRESS OF DL-11 RECEIVER INTERRUPT
DLXIAD=314       ;VECTOR ADDRESS OF DL-11 TRANSMITTER INTERRUPT
          .ENDM
;;**************
          .MACRO $LINE1
DLRS=176500      ;DL-11 RECEIVER STATUS
DLRB=176502      ;DL-11 RECEIVER BUFFER
DLXS=176504      ;DL-11 TRANSMITTER STATUS
DLXB=176506      ;DL-11 TRANSMITTER BUFFER
DLRIAD=270       ;VECTOR ADDRESS OF DL-11 RECEIVER INTERRUPT
DLXIAD=274       ;VECTOR ADDRESS OF DL-11 TRANSMITTER INTERRUPT
          .ENDM
;;**************
          .MACRO $RESTORE
          MOV    (SP)+,R0    ;RESTORE REGISTERS R0-R5 FROM THE STACK
          MOV    (SP)+,R1
          MOV    (SP)+,R2
          MOV    (SP)+,R3
          MOV    (SP)+,R4
          MOV    (SP)+,R5
          .ENDM
;;**************
          .MACRO $SAVE
          MOV    R5,-(SP)    ;SAVE REGISTERS R5-R0 ON THE STACK
          MOV    R4,-(SP)
          MOV    R3,-(SP)
          MOV    R2,-(SP)
          MOV    R1,-(SP)
          MOV    R0,-(SP)
          .ENDM
;;**************
          .MACRO $SPAN   DESC,FUNCTN,NOTFND
	  .GLOBL SPAN
;;               ;Alvin SPAN control function bits (updated 10-Jul-84):
NOT=100000	 ;Function for not skipping specified control character.
ONLY=40000	 ;Function for only skipping specified character.
UNTIL=20000	 ;Function for skipping until the specified character.
RETURN=10000	 ;Function for returning new pointer in register 0.
NOUPDATE=4000	 ;Function for not updating descriptor with new pointer.
SSTR=2000        ;Specifies a Static String, implies RETURN & NOUPDATE.
CSTR=1000        ;Specifies a Command String.  Command String is also detected
                 ; if the descriptor static START & END values indicate such:
;
; A Buffer Descriptor:  Input ptr       A Command Desc:  Dynamic Begin ptr
;                       Output ptr                       Dynamic End ptr
;                       Start ptr (static)               End ptr (static)
;                       End ptr (static)                 Start ptr (static)
;
; A Static String: Begin ptr (address of first character in the string)
;                  End ptr (address of last character in the string)

.IF NB DESC  	; Process request to call SPAN.  Otherwise only define.
        JSR     %5,SPAN
	.WORD	DESC	; Descriptor of Buf/String to be searched.

  .IF NB FUNCTN
	.WORD	FUNCTN	; Define the user-provided span function.
  .IFF
	.WORD	0	; Define a default span function.
  .ENDC

  .IF NB NOTFND
	BR	NOTFND	; If specified Span function fails, take this exit.
  .IFF
	NOP		; Fall through if Span function fails.
  .ENDC
.ENDC
           .ENDM	; $Span
;;***********************
          .MACRO $RMT01
          .GLOBL REMOTE      ;CONTROL WORD FOR REMOTE PROCESSOR #1
DISCONNECT=100000            ;CONTROL BIT=ON=REMOTE NOT CONNECTED
NOCARRIER=20000              ;CONTROL BIT=ON=LINE CARRIER NOT PRESENT
CARRIER=10000                ;DL-11 RECEIVER STATUS BIT - CARRIER DETECT
                             ;ALSO CONTROL BIT=ON=ASSUME CARRIER PRESENT
          .ENDM
;;**************
        .MACRO  $CMND   NAME,NMB,START,END,ENTRYP
        .WORD   NMB     ;'NAME' characters which must match.
        .WORD   START   ;String begin.
        .WORD   END     ;String ends here.
        .WORD   ENTRYP  ;'NAME' entry point.
        .ENDM
;;*******************************
.MACRO	$TWAIT	TimVal		; Use this sort of like RT-11 TWAIT.
        .Globl  TWait
	JSR	R5,TWAIT	; Call twait routine.
	.WORD	TimVal		; Single word time value.
.ENDM
;;*******************************
;;****** Macro to Lock a TSX-Plus job in low memory:
          .MACRO  $LOCKLO  OK,NOREALTIME
          JSR     R0,.+6
          .BYTE   7,140    ;TSX-Plus Lock Task in Low Memory
          EMT     ^O 375
          MOV     (SP)+,R0
.IIF NB <NOREALTIME> BCS NOREALTIME ;Error - No Realtime or No OPER Priv.
.IIF NB <OK> BCC  OK       ;Request satisfied - no error.
          .ENDM
;;******* Macro for TSX-Plus to Map the I/O Page:
          .MACRO  $MAPIO  OK,NOREALTIME
          JSR     R0,.+6
          .BYTE   5,140   ;TSX-Plus Map the I/O Page for User
          EMT     ^O 375
          MOV     (SP)+,R0
.IIF NB <OK> BCC  OK
.IIF NB <NOREALTIME> BCS NOREALTIME
          .ENDM
;;**********************
	.MACRO $IFTSX JMPTRUE,JMPFALSE ;Take a Jump depending upon tsx-ness.
	.Mcall	.Gval
	JSR	R0,.+8.		; Set R0 to point to inline arg blk, save R0.
	.Byte	0,^O 34		; It's a Gval.
	.Word	^O 372		; System generation configuration Rmon offset.
	.Gval
	Rol	R0		; Rotate the negative bit (TSXv5+) into carry.
	MOV	(SP)+,R0	; Restore R0 without disrupting Carry.
.IIF NB <JMPTRUE>         BCS     JMPTRUE	; Yes, this is TSX-Plus.
.IIF NB <JMPFALSE>        BCC     JMPFALSE	; No, this is not TSX-Plus.
          .ENDM
;;**********************
	.MACRO	$TSXJOB DEST,JMPTRUE,JMPFALSE ; Store the TSX job number.
	JSR	R0,.+6		; Get the EMT Arg block to R0 and save R0.
	.BYTE	0,^O110		; It's the TSX get job/line number EMT.
	EMT	^O 375		; May need .Serr set; for RT this is invalid.
.IF NB <DEST>
 .IF DIF <DEST>,R0
	MOV	R0,DEST		; Store this job's line number.
	MOV	(SP)+,R0	; Restore R0 to original condition.
 .IFF
	INC	(SP)+		; Job # in R0, pop former R0, retain Carry.
 .ENDC
.IFF
	INC	(SP)+		; Job # in R0, pop former R0, retain Carry.
.ENDC
.IIF NB <JMPTRUE>         BCC     JMPTRUE	; Yes, it is TSX-Plus.
.IIF NB <JMPFALSE>        BCS     JMPFALSE	; No, it is not TSX-Plus.
          .ENDM

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        