/*
 *				c s m e m b . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	csmember	Test For Membership in a Cset
index			Test for membership in a cset

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 int
	 csmember(cs,c);
	 CSET *cs;
	 int c;

description

	csmember() returns TRUE if c is a member of the cset cs, FALSE
	otherwise.  Note that c is typically a char.

	Note:  c is not validated; c<0 or c>=cssize will return nonsense.
	However, csmask is used to control unwanted sign extension - see
	cset().

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=07
 * Edit history
 * 0.0 13-Jul-82 JSL	Invention
 * 0.1 16-Jul-82 JSL	Reverse order of arguments for consistency
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif

csmember(cs,c)
register CSET *cs;
register int c;
{
	c &= csmask;

	if ((int)cs & 1)			/* A complemented cset	*/
	{	cs = cscomp(cs);		/* Get base cset	*/
		return ((cs->table[c] & cs->mask) == 0);
						/* Test if NOT there	*/
	}
	else
		return ((cs->table[c] & cs->mask) != 0);
						/* Test if there	*/
}
                                                                                                                                                                                                                                                                                                                                                                                         