/*
 *			a t o i . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	atoi	Convert Ascii to integer
index		Convert string to integer

synopsis
	.s.nf
	int
	atoi(p)
	char		*p;
	.s.f
Description

	Convert string to integer.  No data checking is performed.
	The conversion stops at the first non-integer.  Leading
	spaces, tabs, plus-signs and/or newlines are ignored.  
	The integer may be preceeded by a minus sign.

Bugs

#endif

#define	EOS	0

int
atoi(string)
register char	*string;
/*
 * Convert string to integer.
 */
{
	register int	value;
	register int	c;
	int		signflag;

	value = 0;
	signflag = 0;
	while ((c = *string++) != EOS) {
	    switch (c) {
	    case '-':			/* Set sign flag and skip	*/
		signflag++;
	    case '\n':
	    case '\t':
	    case ' ':
	    case '+':
		break;			/* Skip over these		*/

	    default:
		goto breakout;		/* Exit while loop on others	*/
	    }
	}
breakout:
	while ((c -= '0') >= 0 && c <= 9) {
	    value *= 10;
	    value += c;
	    c = *string++;
	}
	return ((signflag) ? (-value) : value);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                   