#include <stdio.h>
#include <ctype.h>
#define	L_sun			3
#define	L_fri			4
#define	L_sunday		6
#define	L_friday		7
#define	L_saturday		8
#define	L_sat			9
#define	L_tues			10
#define	L_thurs			11
#define	L_mon			12
#define	L_tuesday		13
#define	L_thursday		14
#define	L_monday		15
#define	L_wednesday		16
#define	L_wed			17
#define FIRST	'd'
#define LAST	'y'
static char px_assoc[] = {
	7,	/* 'd' */
	-1,	/* 'e' */
	1,	/* 'f' */
	-1,	/* 'g' */
	-1,	/* 'h' */
	0,	/* 'i' */
	-1,	/* 'j' */
	-1,	/* 'k' */
	-1,	/* 'l' */
	9,	/* 'm' */
	0,	/* 'n' */
	-1,	/* 'o' */
	-1,	/* 'p' */
	-1,	/* 'q' */
	-1,	/* 'r' */
	0,	/* 's' */
	6,	/* 't' */
	-1,	/* 'u' */
	-1,	/* 'v' */
	7,	/* 'w' */
	-1,	/* 'x' */
	0,	/* 'y' */
};
static char *px_table[] = {
	NULL,			/*  0	*/
	NULL,			/*  1	*/
	NULL,			/*  2	*/
	"sun",			/*  3	*/
	"fri",			/*  4	*/
	NULL,			/*  5	*/
	"sunday",		/*  6	*/
	"friday",		/*  7	*/
	"saturday",		/*  8	*/
	"sat",			/*  9	*/
	"tues",			/* 10	*/
	"thurs",		/* 11	*/
	"mon",			/* 12	*/
	"tuesday",		/* 13	*/
	"thursday",		/* 14	*/
	"monday",		/* 15	*/
	"wednesday",		/* 16	*/
	"wed",			/* 17	*/
};

int
keyword(text)
register char	*text;
/*
 * Look for keyword (string of alpha) in the perfect hash table
 * Return the index (L_xxx value) or 0 if not found
 */
{
	register char	*tp;
	register int	hash;

	if (*text < FIRST || *text > LAST)
	    return (0);
	for (tp = text; isalpha(*tp); tp++)
	    ;
	hash = (tp - text);
	if (*--tp < FIRST || *tp > LAST)
	    return (0);
	hash += (px_assoc - FIRST)[*text] + (px_assoc - FIRST)[*tp];
	if (px_table[hash] == NULL)
	    return (0);
	if (strncmp(text, px_table[hash], (tp - text + 1)) != 0)
	    return (0);
	return(hash);
}

                                                                                                                                                                                                                                                                                         