/*
 *			r t i m e . h
 */

#ifdef	DOCUMENTATION

title	rtime	Define time buffer structure for $$rtime()
index		Define time buffer structure for $$rtime()

synopsis

	#include <rtime.h>
	   ...
	struct TIME buffer;

description

	This header file defines the structure of the time buffer used by
	the standard library $$rtime() function (which is unique to
	Decus C).  It is defined as follows:
	.s.nf
	struct TIME {
		int	year;		G.TIYR  year - 1900
		int	month;		G.TIMO  Jan. = 1
		int	day;		G.TIDA
		int	hour;		G.TIHR  00 .. 23
		int	minute;		G.TIMI  00 .. 59
		int	second;		G.TISC  00 .. 59
		int	tick;		G.TICT  00 .. tsec-1
		int	tsec;		G.TICP  tick/second
	};
	.s.f
Bugs

	Oboslete, use time() and localtime() instead.

#endif

/*
 * )EDITLEVEL=01
 * Edit history
 * 0.0 21-May-81 JSL	Extracted from ctime.mac
 */

#ifndef _TIME_			/* Don't do this twice */
#define _TIME_

struct TIME {
	int	year;	/* G.TIYR  year - 1900	*/
	int	month;	/* G.TIMO  Jan. = 1	*/
	int	day;	/* G.TIDA		*/
	int	hour;	/* G.TIHR  00 .. 23	*/
	int	minute;	/* G.TIMI  00 .. 59	*/
	int	second;	/* G.TISC  00 .. 59	*/
	int	tick;	/* G.TICT  00 .. tsec-1	*/
	int	tsec;	/* G.TICP  tick/second	*/
} ;

#endif
                                                                                                                                                                                                                                                                                                        