/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * Region Definition Block  ( RDBDF$ )
 *
 * Used with 'crrg', 'atrg', and 'dtrg' functions.
 *
 * Bob Denny
 * 12-May-80
 *
 */

struct	rdb	{
		ADDR	r_gid;		/* Region ID */
		int	r_gsiz;		/* Size of region */
		struct rad50 r_gnam;	/* Name of region */
		struct rad50 r_gpar;	/* Region part. name */
		int	r_gsts;		/* Region status word */
		int	r_gpro;		/* Region prot. code */
		};

/* Region status word codes */

#define	RS_CRR	0100000		/* Reg. successfully created */
#define	RS_UNM	0040000		/* Windows unmapped on detach */
#define	RS_MDL	0000200		/* Mark delete on last detach */
#define	RS_NDL	0000100		/* Not marked for delete */
#define	RS_ATT	0000040		/* Attach to created region */
#define	RS_NEX	0000020		/* Region not extendable */
#define	RS_DEL	0000010		/* Delete access desired */
#define	RS_EXY	0000004		/* Extend   "      "     */
#define	RS_WRT	0000002		/* Write    "      "     */
#define	RS_RED	0000001		/* Read     "      "     */
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              