	SUBROUTINE SPLINP (ICHAR, ESC)
C
C	Version 1.2, 16-Sep-84
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	This routine uses the TTY special mode to allow single-
C	character and escape sequence inputs to be processed
C	without the need of a carriage return.
C
C	The arguments are:
C	ICHAR (Integer*2) - the character obtained from the input.
C			    If a byte is desired, ICHAR can be
C			    equivalenced or assigned in the calling
C			    program.
C			  - ICHAR is an ASCII value for printable
C			    characters, except that it is a true
C			    number (0-9) for the digits 0-9.  It is
C			    -1 if a <CR> is typed, and a -2 if any
C			    other unprintable charater is typed.
C	ESC (Byte)	  - Logical flag to indicate whether an
C			    escape sequence was inputted.
C			    If ESC is true, ICHAR contains the
C			    last character of the escape sequence.
C
	BYTE ESC, ICHARB
	EQUIVALENCE (INPCHR, ICHARB)
C
	CALL IPOKE ("44,"10000.OR.IPEEK("44))	!Set TTY Special Mode
C
10	INPCHR= ITTINR ()		!Get the character, if there is
	IF (INPCHR.LT.0) GO TO 10	!one.
C
	IF (ICHARB.GE.32) THEN		!Printable character processing.
	    ESC= .FALSE.
	    ISTAT= ITTOUR (ICHARB)		!Echo it
	    ICHAR= INPCHR
C	In the case of numbers, make the output character a real number.
	    IF (ICHARB.GE.'0' .AND. ICHARB.LE.'9') ICHAR= INPCHR- "60
C
C	Unprintable character processing.
	ELSE IF (ICHARB.EQ.27) THEN	!Escape sequence.
	    ESC= .TRUE.
20	    ICHAR= INPCHR
	    ISTAT= ISLEEP (0,0,0,1)!We need to wait bec ESC SEQ's come too fast.
	    IF (ISTAT.NE.0) STOP 'SPLINP-F-Q-Element Failure'
	    INPCHR= ITTINR ()		!Get the next characters.
	    IF (INPCHR.GE.0) GO TO 20	!Loop until done.
C
C	Non-escape unprintable characters return as negative numbers.
	ELSE IF (ICHARB.EQ.13) THEN	!A CR was typed.
	  ISTAT= ISLEEP (0,0,0,1)
	  IF (ISTAT.NE.0) STOP 'SPLINP-F-Q-Element Failure'
	  INPCHR= ITTINR ()		!Get the LF
	  ESC= .FALSE.
	  ICHAR= -1
	ELSE				!Other unprintable was typed.
	  ESC= .FALSE.
	  ICHAR= -2
	ENDIF
C
	CALL IPOKE ("44,"10000.XOR.IPEEK("44))	!Back to normal input.
	RETURN
C
	END
                                                                                                                                                                                                                                                                                                                                                                         