	SUBROUTINE CVAI (INSTR, NUM, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Converted to Fortran-77, 2-Mar-84
C
C	Converts an ASCII string into an integer.
C	Input is string, output is num, number of characters
C	to be converted is N1.
C	Specify starting position in string in call (i.e.,
C	call CVAI with STRING(3)).
C	If the string has trailing blanks, the number gets properly
C	right-justified.
C
	REAL*4 RN(5), MAXNUM
	INTEGER*2 BLNCTR
	BYTE INSTR(1), STRING(20)
C
	PARAMETER (MAXNUM=32786.)
C
	IF (N1.EQ.0) THEN		!No number of digits specified
	  TYPE 60, 7
	  RETURN
	ENDIF
C
	NUM= 0				!Integer answer
	RNUM= 0.				!Intermediate answer
	BLNCTR= 1			!Trailing blank counter
C
	DO 15 K= N1,1,-1		!Right-justify the string
	STRING(K)= "40
	IF (INSTR(K).EQ."40) BLNCTR= BLNCTR+ 1
15	CONTINUE
	DO 16 K= N1,BLNCTR,-1
16	STRING(K)= INSTR(K-BLNCTR+1)
C
	DO 10 K= 1,N1
	RN(K)= STRING(K)- "60		!Convert ASCII to number
10	IF (RN(K).LT.0.) RN(K)= 0.		!Convert blanks to zeros
C
	DO 20 K= 1,N1
	L= N1- K				!Power of 10
20	RNUM= RNUM+ RN(K)*10**L		!Build a number
	IF (RNUM.GT.MAXNUM) THEN
	  TYPE 50, 7, RNUM
	  RETURN
	ENDIF
C
	NUM= RNUM
	RETURN
C
50	FORMAT (' CVAI-F-Integer Overflow:' A1, F10.0)
60	FORMAT (' CVAI-F-No Specification of Digits' A1)
	END
	SUBROUTINE CVIA (INUM, STRING, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	This routine converts an integer into an ASCII string
C	(left-justified).
C	The number can be up to 32767 (10).
C	The position in the string where the digits are placed is
C	controlled by the call, (e.g., STRING(3)).
C	The number of digits in the string converted is returned in N1.
C	If the routine is entered with N1 = 0, leading zeros are not copied.
C	If N1 >0, N1 digits (including possibly leading zeros) are
C	copied over.
C
	DIMENSION N(5)
	BYTE STRING(1)
C
	PARAMETER (NPWR=5)			!Max number of digits
C
	NUM= INUM				!Save the original number
	NDIGIT= N1			!Save the number of digits desired
	N1= 0				!Initialize
C
	DO 10 K= 1,NPWR
	L= NPWR- K				!Power of 10
	N(K)= NUM/10**L			!Split up the digits
C	Find the number of digits after the leading zeros.
	IF (N(K).NE.0 .AND. N1.EQ.0) N1= L+ 1
10	NUM= NUM- N(K)*10**L		!Subtract off digit found
C
	IF (NDIGIT.GT.N1) N1= NDIGIT	!Copy over either nonzero digits
	DO 20 K= 1,N1			!Or the specified number of digits.
	L= NPWR- N1+ K			!Start at non-zero values in N(K)
20	STRING(K)= N(L)+ "60		!Make ASCII
	RETURN
C
	END
	SUBROUTINE CVAJ (INSTR, NUM, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Converts an ASCII string into a double-precision integer.
C	Input is string, output is num, number of characters
C	to be converted is N1.
C	Specify starting position in string in call (i.e.,
C	call CVAI with STRING(3)).
C	If the string has trailing blanks, the number gets properly
C	right-justified.
C
	REAL*4 RN(10)
	REAL*8 RNUM, MAXNUM
	INTEGER*2 BLNCTR
	INTEGER*4 NUM, TEN
	BYTE INSTR(1), STRING(30)
C
	PARAMETER (MAXNUM=2147385345., TEN=10)
C
	IF (N1.EQ.0) THEN		!No number of digits specified
	  TYPE 60, 7
	  RETURN
	ENDIF
C
	NUM= 0				!Integer answer
	RNUM= 0.				!Intermediate answer
	BLNCTR= 1			!Trailing blank counter
C
	DO 15 K= N1,1,-1		!Right-justify the string
	STRING(K)= "40
	IF (INSTR(K).EQ."40) BLNCTR= BLNCTR+ 1
15	CONTINUE
	DO 16 K= N1,BLNCTR,-1
16	STRING(K)= INSTR(K-BLNCTR+1)
C
	DO 10 K= 1,N1
	RN(K)= STRING(K)- "60		!Convert ASCII to number
10	IF (RN(K).LT.0.) RN(K)= 0.		!Convert blanks to zeros
C
	DO 20 K= 1,N1
	L= N1- K				!Power of 10
20	RNUM= RNUM+ RN(K)*TEN**L		!Build a number
	IF (RNUM.GT.MAXNUM) THEN
	  TYPE 50, 7, RNUM
	  RETURN
	ENDIF
C
	NUM= RNUM
	RETURN
C
50	FORMAT (' CVAJ-F-Integer Overflow:' A1, F12.0)
60	FORMAT (' CVAJ-F-No Specification of Digits' A1)
	END
	SUBROUTINE CVJA (INUM, STRING, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	This routine converts a double-precision integer into an 
C	ASCII string (left-justified).
C	The number can be up to 32767 (10).
C	The position in the string where the digits are placed is
C	controlled by the call, (e.g., STRING(3)).
C	The number of digits in the string converted is returned in N1.
C	If the routine is entered with N1 = 0, leading zeros are not copied.
C	If N1 >0, N1 digits (including possibly leading zeros) are
C	copied over.
C
	DIMENSION N(10)
	INTEGER*4 INUM, NUM, TEN
	BYTE STRING(1)
C
	PARAMETER (NPWR=10, TEN=10)			!Max number of digits
C
	NUM= INUM				!Save the original number
	NDIGIT= N1			!Save the number of digits desired
	N1= 0				!Initialize
C
	DO 10 K= 1,NPWR
	L= NPWR- K				!Power of 10
	N(K)= NUM/TEN**L			!Split up the digits
C	Find the number of digits after the leading zeros.
	IF (N(K).NE.0 .AND. N1.EQ.0) N1= L+ 1
10	NUM= NUM- N(K)*TEN**L		!Subtract off digit found
C
	IF (NDIGIT.GT.N1) N1= NDIGIT	!Copy over either nonzero digits
	DO 20 K= 1,N1			!Or the specified number of digits.
	L= NPWR- N1+ K			!Start at non-zero values in N(K)
20	STRING(K)= N(L)+ "60		!Make ASCII
	RETURN
C
	END
                                                                                                                                                                                                                                                                                                                                                            