      SUBROUTINE CNVDAT

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90k27a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Convert the HDR1 date (year and day-of-year) to standard RT-11
C	format (dd-mmm-yy).
C
C	Convert the year and the day of the year from ASCII strings to
C	integers.  Using IF-THEN-ELSE structures test the day of the
C	year to determine the month and day of the month.  Test the year
C	for leap year.  Convert the integer year and day of the month
C	values to ASCII strings.  If a conversion error occurs, set the
C	error flag, display an error message, and exit this subroutine.
C
C
C Edit Record:
C
C	27-Nov-90:  Original creation started.
C	27-Nov-90:  Original creation completed.
C
C
C Calling sequence:
C
C	LblRcd = <string>
C	CALL CNVDAT
C
C
C Returns:
C
C	DaMoC
C	Error
C	MonthC
C	YearC
C
C
C Called By:
C
C	DOHDR1
C
C***********************************************************************

      INCLUDE 'TAPEDR.DAT'		!Common & variables declarations

      READ (LblRcd(43:44),'(I2)') YearI
      READ (LblRcd(45:47),'(I3)') DaYrI

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'Jan'
          GOTO 900
      END IF

      IF (MOD(YearI,4) .EQ. 0) THEN
          IF (DaYrI .GT. 29) THEN
              DaYrI = DaYrI - 29
          ELSE
              DaMoI = DaYrI
              MonthC = 'Feb'
              GOTO 900
          END IF
      ELSE
          IF (DaYrI .GT. 28) THEN
              DaYrI = DaYrI - 28
          ELSE
              DaMoI = DaYrI
              MonthC = 'Feb'
              GOTO 900
          END IF
      END IF

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'Mar'
          GOTO 900
      END IF

      IF (DaYrI .GT. 30) THEN
          DaYrI = DaYrI - 30
      ELSE
          DaMoI = DaYrI
          MonthC = 'Apr'
          GOTO 900
      END IF

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'May'
          GOTO 900
      END IF

      IF (DaYrI .GT. 30) THEN
          DaYrI = DaYrI - 30
      ELSE
          DaMoI = DaYrI
          MonthC = 'Jun'
          GOTO 900
      END IF

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'Jul'
          GOTO 900
      ENDIF

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'Aug'
          GOTO 900
      END IF

      IF (DaYrI .GT. 30) THEN
          DaYrI = DaYrI - 30
      ELSE
          DaMoI = DaYrI
          MonthC = 'Sep'
          GOTO 900
      END IF

      IF (DaYrI .GT. 31) THEN
          DaYrI = DaYrI - 31
      ELSE
          DaMoI = DaYrI
          MonthC = 'Oct'
          GOTO 900
      END IF

      IF (DaYrI .GT. 30) THEN
          DaYrI = DaYrI - 30
      ELSE
          DaMoI = DaYrI
          MonthC = 'Nov'
          GOTO 900
      END IF

      IF (DaYrI .GT. 31) THEN
          Error = .TRUE.
          TYPE *, 'CNVDAT:  date conversion error'
      ELSE
          DaMoI = DaYrI
          MonthC = 'Dec'
      END IF

900   CONTINUE
      WRITE (DaMoC,'(I2)') DaMoI
      WRITE (YearC,'(I2)') YearI

      RETURN
      END				!CNVDAT.FOR.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               