c short cycle memory test, compile with F77 and run under rt-11
c from DECUS US Chapter Newsletter, March, 1987, Hardware Micro SIG, page 4
c by Scott Taylor, Douglas Engineering, Santa Monica, California
c
c Note:  The following applies only to the LSI-11/73, not to the 11/23,
c and then only when a floating-point chip is installed.
c
c The LSI-11/73 floating-point accelerator chip can cause problems with some
c memory boards, particularly the faster ones.  When there is a floating-point
c exception (division by zero is the most common example), a "short cycle"
c occurs.  In simple terms, what happens is the cpu requests a memory fetch,
c then changes its mind.  The SYNCH signal is asserted for a short period and
c then removed.  Some memory boards can handle this, but others become
c corrupted.  New releases of the floating point chip in 1987 may or may not
c solve the problem.
c
c Several memory manufacturers are aware of the short SYNCH cycle problem and
c have devised fixes, others have not.  Early versions of some boards may fail
c while current versions function properly.  Older memories (the slower ones)
c that do not start their memory cycle until DIN or DOUT occur do not exhibit
c the problem.
c
c The following FORTRAN-77 program can be run to determine if a particular
c memory board, flaoting-point chip and cpu are compatible when short SYNCH
c cycles occur.  The program should be run once with the cache enabled and
c once with the cache disabled.  (Un)commenting the cache control register
c lines ("ccc") before compiling will accomplish this.
c
c Accompanying this are: FPTON .SAV - built with cache enabled.
c 			 FPTOFF.SAV - built with cache disabled.
c
c Memory boards which fail this test crash the monitor during or after the
c test (usually immediately), or produce unrelated error messages and abort
c the program.  A few may fail on the first occurance one time and complete
c several thousand another.  Therefore, 100,000 iterations are performed to
c give the memory every chance to fail.  A particular memory board may finish
c all 100k iterations but corrupt other parts of memory, and cause a crash
c shortly after this test is completed, when other operations are performed.
c Because of this, running the program a few times may be safer than
c increasing the iteration count.
c
	program	FPTest
c
	Logical	F,T
c
ccc	call ipoke("177746,"1000)	!this turns cache memory off
c
	F = .false.
	T = .true.
c
	Call ErrSet(73,T,F,F,F,15)	! intercept divide by zero error
					! prevent program from aborting
c
	itimes = 0
	icount = 0
c
100	continue	! a real do loop doing this sort of thing would be
c			! optimized out of existance so we'll simulate one
	a = 1234./0.		! divide any real*4 number by zero
c
	icount = icount + 1
	if(icount .lt. 1000) go to 100
	icount = 0
	itimes = itimes + 1
	type 872,itimes		! put periodic progress reports on the screen
	if(itimes .le. 100) go to 100
c
	type 666
666	format(' Memory/Floating Point chip compatibility test'
	1      ' complete')
c
872	format('+',i4)		! optional lines, type 872 ... and this one
c
ccc	call ipoke("177746,"0)	! this turns cache back on
c
	call exit
	end
                                                                                                                                                                                                                                                                                                                                                      