      SUBROUTINE GETXOR

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91a21a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Get the saveset record length and the XOR grouping factor.
C
C	Go into a loop.  Call a routine to get the data field length.
C	If the field length returned is zero, exit the loop.  Call a
C	routine to get the data field itentification.  If the length
C	equals 256 and the identification equals 3, exit the loop.  Call
C	a routine to get the data field information.  If the field is
C	the saveset record length, save it.  If the field is the XOR
C	grouping factor, save it.  Loop back for another pass.
C
C	If any of the called routines returns an error condition, exit
C	this subroutine.
C
C
C Edit Record:
C
C	16-Nov-90:  Original creation started.
C	05-Dec-90:  Original creation completed.
C	21-Jan-91:  Module taken from the SVSTDR suite.
C
C
C Calling sequence:
C
C	ByteBF() = <bytes>
C	CALL GETXOR
C
C
C Returns:
C
C	BytPtr
C	Error
C	SSRcLn
C	XORFct
C
C
C Called By:
C
C	EFWORK
C
C
C Routines Called:
C
C	GETFLD
C	GETID
C	GETLEN
C
C***********************************************************************

      INCLUDE 'EXTFLS.DAT'		!Common & variables declarations

      BytPtr = 275
100   CONTINUE

          CALL GETLEN
          IF (Error) GOTO 900

          IF (FldLnI .EQ. 0) GOTO 900

          CALL GETID

          IF ((FldLnI .EQ. 256) .AND. (FldIdI .EQ. 3)) GOTO 900

          CALL GETFLD

          IF (FldIdI .EQ. 13) THEN
              SSRcLn = FieldI(1)	!Save the record length.
          END IF

          IF (FldIdI .EQ. 14) THEN
              XORFct = FieldI(1)	!Save the XOR factor.
          END IF

      GOTO 100

900   CONTINUE
      RETURN
      END				!GETXOR.FOR.
                                                                                                                        