      SUBROUTINE EFWORK

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91c20b
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Control the process of extracting selected files from a saveset.
C
C	Enter a loop and call a routine to read a data record from the
C	tape.  If a tape mark is encountered, exit the loop.  If the
C	data record is the first one, call a routine to get the XOR
C	grouping factor.  If the record is an XOR one, skip over it.
C	If the record is the last one, exit the loop.  Call a routine to
C	scan and display any file directory information that may be
C	present.  Call a routine to control selection of the file.  If
C	file is selected, call a routine to control its transfer.  Loop
C	back for another pass.
C
C	If an error condition is returned by any of the called routines,
C	exit this subroutine.
C
C
C Edit Record:
C
C	16-Jan-91:  Original creation started.
C	20-Mar-91:  Original creation completed.
C
C
C Calling sequence:
C
C	BtBfLn = <integer>
C	MtDvNm = <string>
C	Read = <integer>
C	CALL EFWORK
C
C
C Called By:
C
C	EXTFLS
C
C
C Routines Called:
C
C	GETXOR
C	GETDIR
C	GETFIL
C	MTFOR
C	SELFIL
C
C***********************************************************************

      INCLUDE 'EXTFLS.DAT'		!Common & variables declarations

100   CONTINUE

          CALL MTFOR (MtDvNm,Read,BtBfLn,ByteBf,Iret)
          IF (Iret .EQ. 0) GOTO 900	!End of saveset, exit loop.
          BytPtr = 0

          IF (SSRcNm .EQ. 1) THEN	!First record, get XOR factor.
              CALL GETXOR
              IF (Error) GOTO 900
          END IF

          IF (MOD(SSRcNm,XORFct+1) .EQ. 0) THEN
              GOTO 100			!Skip over the XOR records.
          END IF

          IF (LRFlg .EQ. 2) GOTO 900	!Skip last record.

          BytPtr = BytPtr + (16 - MOD(BytPtr,16) + 1)
200       CONTINUE
              IF ((ByteBf(BytPtr) .EQ. 0) .AND.
     *            (ByteBf(BytPtr+1) .EQ. 1) .AND.
     *            (ByteBf(BytPtr+2) .EQ. 3) .AND.
     *            (ByteBf(BytPtr+3) .EQ. 0)) THEN
                  CALL GETDIR		!Extract directory data.
                  BytPtr = BytPtr + (16 - MOD(BytPtr,16)) + 1
                  CALL SELFIL
                  IF (SelFlg) THEN
                      CALL GETFIL
                      IF (Error) GOTO 900
                  END IF
              ELSE
                  BytPtr = BytPtr + 16	!Bump the pointer.
                  IF (BytPtr .GT. SSRcLn) GOTO 300
              END IF
          GOTO 200
300       CONTINUE

      GOTO 100

900   CONTINUE
      RETURN
      END				!EFWORK.FOR.
                                                                                                                                                                                                                                                                                                                 