      PROGRAM SVSTDR

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90l06a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Make a directory of the contents of a selected saveset on a VMS
C	backup magnetic tape listing the names of the several files
C	along with other pertinent data.
C
C	Call a routine to clear the screen.  Then identify the program
C	and its version.  Call a routine to control the initialization
C	process.  Call a routine to control the making of the saveset
C	directory.  Call a routine to shut things down, neat and clean.
C	Finally, terminate the program with a parting message.
C
C	If the initialization routine returns an error condition, skip
C	directly to the termination routine call.
C
C
C Edit Record:
C
C	13-Nov-90:  Original creation started.
C	06-Dec-90:  Original creation completed.
C
C
C Building Requirements:
C
C	The following files are required for building this program:
C
C	Filename	Version		Remarks
C
C	SVSTDR.COM	90L05a	Command file to build SVSTDR.SAV.
C
C	SVSTDR.DAT	90l06a	COMMON and variables declarations.
C
C	CLRSCR.FOR	90k13a	Clear the screen.
C	GETDIR.FOR	90l04a	Get a file's directory information.
C	GETFLD.FOR	90l05a	Extract a directory data field.
C	GETID.FOR	90l03a	Extract a directory data field
C				 identification number.
C	GETLEN.FOR	90l03a	Extract a directory data field length.
C	GETXOR.FOR	90l05a	Get the XOR grouping factor.
C	GTSSNM.FOR	90l04a	Get the saveset name.
C	MNTTAP.FOR	90k13a	Mount the magnetic tape.
C	OPNFIL.FOR	90l05a	Open the output file.
C	POSTAP.FOR	90l04a	Position the tape.
C	RDVOL1.FOR	90k13a	Read the VOL1 label record.
C	SDINIT.FOR	90l04a	Initialization control module.
C	SDQUIT.FOR	90l05a	Termination control module.
C	SDWORK.FOR	90l06a	Work control module.
C	SLSVST.FOR	90l05a	Select the save set.
C	SVSTDR.FOR	90l06a	This main control module.
C	WRTDIR.FOR	90l04a	Write the directory data.
C
C	F77OTS.OBJ		FORTRAN 77 library.
C	MTLIB.OBJ		Magnetic tape subroutine library.
C	SYSLIB.OBJ		System subroutine library.
C
C	F77.SAV			FORTRAN 77 compiler.
C	LINK.SAV		RT-11 linker.
C
C	Copy the files from the distribution media as follows:
C
C		COPY	dev:SVSTDR.DSK	dev:SVSTDR.TMP
C
C	Then unpack the logical device as follows:
C
C		MOUNT	LDx	SVSTDR.TMP
C		CREATE/ALL:yyy	SVSTDR.DSK	      !Where yyy => 988.
C		MOUNT	LDz	SVSTDR.DSK	DK
C		COPY	LDx:	DK:
C		DISMOUNT	LDx
C		DELETE	SVSTDR.TMP
C
C	Build the program SVSTDR.SAV by executing the command file,
C	SVSTDR.COM as follows:
C
C		DISPLAY	:==	TIME		      !For RT-11 only.
C		@SVSTDR.COM
C
C
C Executing Instructions.
C
C	Under RT-11, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		LOAD	<mag tape handler>
C		SET	USR	NOSWAP		      !RT11SJ only.
C		RUN	<dev:>SVSTDR
C
C	Under TSX-Plus, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		RUN	<dev:>SVSTDR
C
C
C Hiearchical Diagram:
C
C	An asterisk following a module name indicates that there are
C	multiple calls made to the module.  Library routines are
C	identified with comments.
C
C	SVSTDR
C	    CLRSCR
C	    SDINIT
C		MNTTAP
C		    MTFOR		MTLIB routine.
C		OPNFIL
C		    GTLIN		SYSLIB routine.
C		    DATE		SYSLIB routine.
C		    TIME		SYSLIB routine.
C		RDVOL1
C		    MTFOR	*	MTLIB routine.
C		SLSVST
C		    GTSSNM
C			GTLIN		SYSLIB routine.
C		    POSTAP
C			MTFOR	*	MTLIB routine.
C	    SDWORK
C		MTFOR			MTLIB routine.
C		GETXOR
C		    GETLEN
C		    GETID
C		    GETFLD
C		GETDIR
C		    GETLEN
C		    GETID
C		    GETFLD
C		    WRTDIR
C	    SDQUIT
C		MTFOR			MTLIB routine.
C
C
C Routines Called:
C
C	CLRSCR
C	SDINIT
C	SDQUIT
C	SDWORK
C
C***********************************************************************

      INCLUDE 'SVSTDR.DAT'		!Common & variables declarations

      CALL CLRSCR			!Clear the screen.
      TYPE *, ProgID			!Program identification and
      TYPE *				! version.

      CALL SDINIT			!Initialization.
      IF (Error) GOTO 900

      CALL SDWORK			!Perform the task at hand.

900   CONTINUE
      CALL SDQUIT			!Neat and clean.

      TYPE *, Endmsg			!Say we're done.
      TYPE *

      END				!SVSTDR.FOR.
                                                                                                                                                                                                    