      SUBROUTINE XFRFIL

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  9f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Transfer the selected file from the saveset to the RT-11 device.
C
C	Enter a loop and test for the start of a file directory segment.
C	If one is encountered, exit this subroutine immediately.  If one
C	is not encountered, transfer sixteen bytes to the output file
C	and bump the data pointer.  If the pointer passes the end of the
C	data record, call a routine to read the next record from the
C	tape.  If the end of the saveset is reached, set the error flag
C	and exit this subroutine.  If the data record is an XOR record,
C	skip over it by reading another data record.  Initialize the
C	data pointer and loop back for another pass.
C
C	If any error conditions are encountered, set the error flag and
C	exit this subroutine.
C
C
C Edit Record:
C
C	20-Mar-91:  Original creation started.
C	21-Mar-91:  Original creation completed.
C	04-Jun-91:  Removed some leftover diagnostic statements.
C
C
C Calling sequence:
C
C	BtBfLn = <integer>
C	ByteBf() = <bytes>
C	BytPtr = <integer>
C	MtDvNm = <string>
C	Read = <integer>
C	SSRcLn = <integer>
C	XORFct = <integer>
C	CALL XFRFIL
C
C
C Returns:
C
C	ByteBf()
C	BytPtr
C	Error
C
C
C Called By:
C
C	GETFIL
C
C
C Routines Called:
C
C	MTFOR
C
C***********************************************************************

      INCLUDE 'EXTFLS.DAT'		!Common & variables declarations

      INTEGER*2 I			!Loop index.

100   CONTINUE

          IF ((ByteBf(BytPtr) .EQ. 0) .AND.
     *        (ByteBf(BytPtr+1) .EQ. 1) .AND.
     *        (ByteBf(BytPtr+2) .EQ. 3) .AND.
     *        (ByteBf(BytPtr+3) .EQ. 0)) GOTO 900
                  
          DO 150 I = 1,16
              OutBfB(I) = ByteBf(BytPtr+I-1)
150       CONTINUE
151       FORMAT (A16)
          WRITE (UNIT=OutLun,FMT=151,ERR=850) OutBfC
          BytPtr = BytPtr + 16

          IF (BytPtr .GT. SSRcLn) THEN
200           CONTINUE
                  CALL MTFOR (MtDvNm,Read,BtBfLn,ByteBf,Iret)
                  IF (Iret .EQ. 0) THEN
                      Error = .TRUE.
                      GOTO 900
                  END IF
                  IF (MOD(SSRcNm,XORFct+1) .EQ. 0) GOTO 200
                  BytPtr = 273
          ENDIF

      GOTO 100

850   CONTINUE
      Error = .TRUE.
      TYPE *, 'XFRFIL:  WRITE error'
      TYPE *

900   CONTINUE
      RETURN
      END				!XFRFIL.FOR.
                                                                                                                                                                                                                                                                                                                                                                                                                                                 