/* sktl28.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  sksendwait
 *
 *  Invalid socket		- return(-2)
 *  Connection dropped		- return(-1)
 *  Data sent			- return( 0)
 *  Timeout			- return( 1)
 */
int sksendwait(sknum,wt)
int sknum;
long wt;
{
	register struct socket *skt;
	long time;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-2);

	/*
	 * Wait until connection dropped, data sent, or timeout
	 */
	time = cticks(NULL);
	while(1) {
		ntsleep(0);
		if(!skleft(sknum))
			return(0);
		if(sktest(sknum))
			return(-1);
		if(elapsed(time) >= wt)
			return(1);
		suspnd(0);
	}
}
                                                                                        