/* makskt.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <malloc.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "cticks.h"

/*
 * makesocket
 *
 * This is the initialization for TCP based communication.  When a
 * socket needs to be created, this routine is called to do as much
 * pre-initialization as possible to save overhead during operation.
 *
 * This structure is created upon opening of a socket,
 * either listening or wanting to send.
 *
 * A TCP socket, in this implementation, includes all of the state
 * data for the socket connection, a complete packet for the
 * TCP transmission, and two queues, one each for sending and receiving.
 * The data associated with the queues is in struct window.
 */

int makesocket()
{
	register int i,j;
	int nn,retval,sknum,seqnum;
	register struct socket *skt;

	skt = -1;
	sknum = 0;

	/*  
	 * Get a new socket
	 */
	while(sknum<LSCKTS && sktlist[sknum].region) {
		sknum++;
	}
	if(sknum<LSCKTS) {
		skt = (struct socket *) mapskt(sknum);
		retval = sknum;
	}

	/*
	 * Check to see if any other connection is done with its socket
	 * buffer space.  All connection states other than STWAIT,
	 * SLAST, SCLOSED or SEST are forcibly closed.
	 */
	sknum = 0;
	while(skt==-1 && sknum<LSCKTS && sktlist[sknum].region) {
		skt = (struct socket *) mapskt(sknum);
		switch(skt->state) {
		case SLISTEN:
		case SSYNR:
		case SSYNS:
		case SFW1:
		case SFW2:
		case SCLOSING:
		case SCWAIT:
			skt->tcpout.t.flags = TFIN|TACK;
			tcpsend(skt,0);

		case STWAIT:
		case SLAST:
		case SCLOSED:
		default:
			break;

		case SEST:
			skt = -1;
			break;
		}
		/*
		 * socket # to return
		 */
		retval = sknum++;
	}
	if(skt==-1) {
		skposterr(503);
		return(-1);
	}
	/*
	 * initialize sktlist parameters
	 */
	sktlist[retval].region = 1;
	sktlist[retval].inport =
	sktlist[retval].outport = 0;
	for(i=0; i<4; i++)
		sktlist[retval].remoteip[i] = '\0';
	/*
	 * clear the whole socket
	 */
	clrskt(skt);
	/*
	 * queuing parameters
	 */
	setupwindow(&skt->in,QUEUESIZE);
	setupwindow(&skt->out,QUEUESIZE);
	/*
	 * create a unique random port number
	 */
	seqnum  = (int) (skt->out.lasttime & 0x3FFFL);
	seqnum += 0x800;
	do {
		if(++seqnum > 0x47FF)
			seqnum = 0x0800;
		for(i=0; i<LSCKTS && seqnum!=sktlist[i].inport; i++);
	} while(i<LSCKTS);
	/*
	 * static initialization of non-zero socket elements
	 */
	skt->in.port = sktlist[retval].inport = seqnum;

	skt->credit = nnwin;
	skt->sendsize = nnmtu;
	skt->rto = MINRTO;

	movebytes(&skt->tcpout,&ipblank,sizeof(DLAYER)+sizeof(IPLAYER));
	skt->tcpout.i.tlen = 0;
	skt->tcpout.i.protocol = PROTTCP;
	skt->tcpout.t.source = intswap(seqnum);
	skt->tcpout.t.seq = longswap(skt->out.nxt);

	skt->tcps.proto = PROTTCP;
	movebytes(skt->tcps.source,nnipnum,4);

	/*
	 *  install default maximum segment size which will be
	 *  sent out in the first ACK-SYN packet
	 */
	skt->tcpout.x.options[0] = 2;
	skt->tcpout.x.options[1] = 4;
	nn = intswap(nnseg);
	movebytes((char *)&skt->tcpout.x.options[2],(char *)&nn,2);
	skt->tcpout.t.hlen = 24<<2;

	/*
	 *  This socket is allocated for WAITTIME
	 */
	skt->state = STWAIT;
	return(retval);
}

/*
 * setupwindow
 *
 * Configure information about a window *w*
 */

VOID setupwindow(w,wsize)
register struct window *w;
register unsigned int wsize;
{
	w->rdptr = w->wtptr = w->queue = w->where;
	/*
	 * nothing here yet
	 */
	w->lasttime = cticks(NULL);
	w->ack = w->nxt = ((w->lasttime<<12) & 0x0FFFF000L);
	w->size = wsize - 1;
}

/*
 * clrskt()
 *
 * Clear a Socket Structure
 */
VOID clrskt(p)
register char *p;
{
	register int i;

	for (i=0; i<sizeof(struct socket); i++) {
		*p++ = 0;
	}
}
                                                                                                                                                                                                        