/* ftppi1.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

VOID ftppi1(cmdno,command)
register int cmdno;
register char *command;
{
	int i,j;
	char cmndline[82];
	char word[50];

	/*
	 * process commands
	 */
	switch(cmdno) {
	case QMARK:
	case HELP:
		if(!command[0]) {
			kb_puts(
			"These valid commands may be abbreviated:\r\n");
			/*
			 * display command list
			 */
			cmndline[0] = '\0';
			for(i=0,j=0; i<NCMDS; i++) {
				/*
				 * skip if a blank entry
				 */
				if (ftp_cmdlst[i] == NULL)
					continue;
				/*
				 * get word from list
				 */
				if(j%5 != 4) {
					sprintf(word,"%-16s",ftp_cmdlist[i]);
					strcat(cmndline,word);
				} else {
					sprintf(word,"%s\r\n",ftp_cmdlist[i]);
					strcat(cmndline,word);
					kb_puts(cmndline);
					cmndline[0] = '\0';
				}
				j++;
			}
			/*
			 * last line
			 */
			if(cmndline[0] != '\0') {
				kb_puts(cmndline);
				kb_nline();
			}
		} else {
			kb_puts("Specific help not available\r\n");
		}
		return;

	case BELL:
		return(	toggle(command,word,&bell,
			"Bell mode on.\r\n",
			"Bell mode off.\r\n")
			);

	case BYE:
	case QUIT:
		if(linked) {
			ftpdo("QUIT");
			linked = 0;
		}
		/*
		 * exit FTP
		 */
		ftpexit(0);

#ifdef	DEBUGOPTION
	case DEBUG:	/* turn on/off debugging, optional level */
		if(sscanf(command,"%d",&i)>0) {
			debug = i;
		} else {
			toggle(command,word,&debug,
			"Debugging on.\r\n",
			"Debugging off.\r\n");
			if(debug)
				debug = DBUGTRUE;
		}
		if(debug)
			kbprintf("Debugging on (debug == %d).\r\n",debug);
		return;
#else
	case DEBUG:	/* no debugging */
		kb_puts("Debugging not available.\r\n");
		return;
#endif

#ifdef	DEBUGOPTION
	case NDEBUG:	/* turn on/off network debugging, optional level */
		if(sscanf(command,"%d",&i)>0) {
			ndebug = i;
		} else {
			toggle(command,word,&ndebug,
			"Net Debugging on.\r\n",
			"Net Debugging off.\r\n");
			if(ndebug)
				ndebug = DBUGTRUE;
		}
		if(ndebug)
			kbprintf("Net Debugging on (ndebug == %d).\r\n",ndebug);
		return;
#else
	case NDEBUG:	/* no debugging */
		kb_puts("Net Debugging not available.\r\n");
		return;
#endif

	default:
		return;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                