/* cnctsb.c */

#define	CNCTSBMASTER

/*
 *  Includes
 */
#include <string.h>
#include <stdio.h>

#include "vrsion.h"
#include "vcntsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "confgs.h"
#include "kbkeys.h"
#include "kbdutl.h"
#include "sktlib.h"
#include "inierr.h"
#include "suspnd.h"

/*
 * Internal/External Routines routines
 */

extern	VOID	cncti();	/* Overlayable Initialization Section */
extern	int	dosess();	/* process loop */
extern	int	inprocess();	/* (sknum) process incoming data */
extern	int	newkey();	/* (tw) filter for command sequences */
extern	int	dokey();	/* (tw,c) process keyboard keys */
extern	int	keygets();	/* (str,lim,echo) get line from keyboard */
extern	char	*stptok();	/* (p,to,len,dlm) stop on token */
extern	VOID	strlwr();	/* (st) convert string to lower case */

/*
 * debug -
 */
#define DBUGTRUE	-1	/* all debuggers */

char	*hlptxt[] = {
"",
"Keyboard usage for CNCTSB-11",
"-------- ----- --- ---------",
"",
"The metacharacter 'M->' is ^A",
"M->C    open capture file             M->O    abort output",
"M->D    close capture file            M->Q    are you there?",
"M->F    FTP [internet address]        M->S    skip to end of buffer",
"M->H    this help screen              M->X    close connection",
"M->I    type my internet address      M->Y    interrupt process",
"",
" ^?     abort CNCTSB session",
"",
0
};


int	viewmode = 1;

int	cnctopen = 0;			/* connection open flag */
int	cnctskt = -1;			/* socket number */
struct socket *cskt = -1;		/* socket */
struct twin  session;			/* session */
struct twin *tw = NULL;			/* *session */

char	parsedat[80];			/* parsing data */


#define	ABORT	(-3)


main(argc,argv)
int argc;
char *argv[];
{
	register int i;
	register int ev;

	/*
	 * Initialization
	 */
	cncti(argc,argv);

	/*
	 *  Open a connection to the machine named.
	 *  Start up all of the configuration on the connection.
	 */
	cnctskt = opensess(parsedat,HCNCT);
	if(cnctskt<0) {
		printf("\r\nEscaping from CNCT\r\n");
		return(0);
	}

	cskt = (struct socket *) mapskt(cnctskt);
	tw = &session;

	do {
		ev = dosess();
		if(ev==0)
			suspnd(0);
	} while (ev != -1);

	suspnd(0);
	errhandle();

	/*
	 * close all network connections
	 */
	for(i=0; i<LSCKTS; i++)
		ntclose(i);

	/*
	 * terminate network stuff
	 */
	ntshut();

	kb_puts("\r\nEscaping from CNCTSB\r\n");
	exit(0);
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving two sources
 *  of external input in order of precedence:
 *   - keyboard strokes
 *   - message events
 */
int dosess()
{
	register struct socket *skt;
	register struct machinfo *mp;
	register int c;
	int cl,ev,dat;
	char st[82];

	/*
	 * do all key translations
	 */
	switch(viewmode) {
	  default:
	    /*
	     * This gives precedence to the
	     * keyboard over the network.
	     */
	    while(0<=(c=newkey())) {
	      if(c==A_BRK)
		return(-1);
	    }
	    break;

	  case 1:
	    if(fndbrk)
		return(-1);

	    c = kb_char();
	    if(c == A_X) {
		return(-1);
	    } else
	    if(c != -1) {
	      kb_puts("\r\nOther commands require an open session.");
	      kb_puts("\r\n^A X - Escape from CNCTSB\r\n");
	    }
	    break;
	}

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev =  Sgetevent(USERCLASS  | CONCLASS  | SCKTCLASS |
			TCPCLASS   | MSGCLASS  | ERRCLASS  |
			ABORTCLASS | SCKTABORT | SRVCCLASS |
			SRVCATTACH | SRVCABORT | TASKCLASS,
			&cl, &dat);
	if(ev!=0 && dat==cnctskt) {
	  switch(cl) {
	    case CONCLASS:
	      switch(ev) {
		case CONOPEN:	/* a connection has just opened */
		  cnctopen = 1;
		  viewmode = 0;
		  break;

		case CONCLOSE:	/* connection is closing */
		  if(0<skqlen(dat))
		    skptuev(CONCLASS,CONCLOSE,dat);  /* call me again */
		  viewmode = 1;
		  /* drop through, process any data */

		case CONDATA:
		  break;

		case CONFAIL:	/* can't open connection */
		  kb_puts("\r\nCan't open connection\r\n");
		  skclose(dat);	    /* close out attempt */
		  skrelease(dat,1);
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    case USERCLASS:		/* domain class */
	      skt = (struct socket *) skvalid(dat);
	      if(skt==-1)
		break;
	      switch(ev) {
		  case DOMFAIL:
		    skptevent(ERRCLASS,16,dat);
		    skptevent(CONCLASS,CONFAIL,dat);
		    break;

		  case DOMOK:
		    mp = skt->mpp;
		    if(mp) {
		      skptevent(MSGCLASS,17,dat);
		      if(mp->sname) {
			if(mp->port!=skt->sktport) {
			  sprintf(st,"%s #%u",mp->sname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,st);
			} else {
			  addsess(dat,mp->sname);
			}
		      } else {
			if(mp->port!=skt->sktport) {
			  sprintf(st,"%s #%u",mp->hname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,st);
			} else {
			  addsess(dat,mp->hname);
			}
		      }
		    } else {
		      skptevent(ERRCLASS,16,dat);
		      skptevent(CONCLASS,CONFAIL,dat);
		    }
		    break;

		  default:
		    break;
	      }
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      if( ev<100 || errmsg ) {
		kb_puts(skerrstring(ev));
		kb_nline();
	      }
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    skptuev(CONCLASS,CONDATA,dat);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		default:
		  break;
	      }
	      break;

	    /*
	     * Unused Classes
	     */
	    default:
	      break;
	  }
	}

	/*
	 * Connection Processing
	 */
	if(cnctopen) {
	  c = inprocess();
	  if(c) {
	    if(c == A_BRK) {
	      return(-1);
	    }
	    return(c);
	  }
	}
	return(ev);
}

/* 
 *  inprocess
 *
 *  take incoming data and process it.  Close the connection if it
 *  is the end of the connection.
 */
int inprocess()
{
	register int cnt;
	char s[82];

	cnt = skread(cnctskt,s,80);	/* get some from incoming queue */
	if(cnt<0) {			/* close this session, if over */
	  cnctopen = 0;
	  skclose(cnctskt);
	  skrelease(cnctskt,1);

	  if(tw->capon) {
	    fclose(tw->capfp);		/* close the capture file */
	    tw->capon = 0;
	  }

	  kb_puts("\r\nConnection closed.\r\n");
	  return(A_BRK);
	}

	if(cnt) {
	  skdeque(cnctskt);		/* dequeue the data */
	  /*
	   *  send the string where it belongs
	   *  1. Check for a capture file.
	   *  2. send to screen
	   */
	  if(tw->capon)
	    fwrite(s,cnt,1,tw->capfp);

	  s[cnt] = '\0';
	  kb_puts(s);
	  return(1);
	}

	return(0);
}

/*  newkey
 *
 *  filter for command key sequences
 */
int newkey()
{
	register int c;

	if(fndbrk) {
		fndbrk = 0;
		c = A_BRK;
	} else {
		c = kb_char();
	}

	if(c>0)
		c = dokey(c);
	if(pushsk)
		skenque(cnctskt,1);
	return(c);
}

/*
 *  dokey
 *
 *  Translates,
 *  filters for command keys,
 *  and sends keys.
 */
int dokey(c)
register int c;
{
	register char *xxip;
	register int i;
	char s[82];

	switch (c) {
	  case A_C:		/* open capture file */
	    if(!tw->capon) {
	      kb_puts("\r\nEnter capture file name, ESC to abort: ");
	      s[0] = 0;
	      while(0>=(i = kb_gets(s,sizeof(s),1)))
		suspnd(0);
	      if(i!=27 && s[0]!=0) {
		kb_nline();
		if((tw->capfp = fopen(s,"wn")) != NULL) {
		  tw->capon = 1;
		  stptok(tw->capfp->io_name, tw->capfil, 15, "[");
		  strlwr(tw->capfil);
		}
	      }
	    }
	    if(tw->capon) {
	      kbprintf("\r\nCapture file %s is open.", tw->capfil);
	    }
	    kb_nline();
	    c = 0;
	    break;

	  case A_D:		/* close capture file */
	    if(tw->capon) {
	      fclose(tw->capfp);
	      tw->capon = 0;
	      kbprintf("\r\nCapture file %s is closed.\r\n", tw->capfil);
	    } else {
	      kb_puts("\r\nCapture file not open.\r\n");
	    }
	    c = 0;
	    break;

	  case A_F:		/* an ftp command */
	    xxip = cskt->tcpout.i.ipsource;
	    sprintf(s,"ftp %d.%d.%d.%d\r\n",
	      *(xxip+0)&0xFF, *(xxip+1)&0xFF,
	      *(xxip+2)&0xFF, *(xxip+3)&0xFF);
	    skwrite(cnctskt,s,strlen(s));
	    c=0;
	    break;

	  case A_H:		/* help display */
	    printtxt(hlptxt);
	    c = 0;
	    break;

	  case A_I:		/* my internet address */
	  case A_J:		/* their internet address */
	    if(c==A_I) {
	      xxip = cskt->tcpout.i.ipsource;
	    } else {
	      xxip = cskt->tcpout.i.ipdest;
	    }
	    sprintf(s,"%d.%d.%d.%d",
		*(xxip+0)&0xFF, *(xxip+1)&0xFF,
		*(xxip+2)&0xFF, *(xxip+3)&0xFF);
	    skwrite(cnctskt,s,strlen(s));
	    c = 0;
	    break;

	  case A_O:		/* abort output */
	    skwrite(cnctskt,"\377\365",2);
	    skempty(cnctskt);
	    c = 0;
	    break;
	      
	  case A_Q:		/* are you there? */
	    skwrite(cnctskt,"\377\366",2);
	    c = 0;
	    break;

	  case A_S:		/* skip to end */
	    skempty(cnctskt);
	    c = 0;
	    break;

	  case A_X:		/* close the connection */
	    kb_puts("\r\nClose the connection? (Y/N)  ");
	    kb_out(c = kb_gchar());
	    if(tolower(c)=='y') {
	      kb_puts("\r\n Attempting to close . . .");
	      skptuev(ABORTCLASS,USERABORT,cnctskt);
	    }
	    kb_nline();
	    c = 0;
	    break;

	  case A_Y:		/* interrupt */
	    skwrite(cnctskt,"\377\364",2);
	    skempty(cnctskt);
	    c = 0;
	    break;
	      
	  case A_BRK:		/* abort Telnet */
	    kb_puts("\r\nAbort the connection? (Y/N)  ");
	    kb_out(c = kb_gchar());
	    kb_nline();
	    if(tolower(c)=='y') {
	      if(tw->capon) {
		fclose(tw->capfp);	/* close the capture file */
		tw->capon = 0;
	      }
	      skclose(cnctskt);
	      skrelease(cnctskt,1);
	      return(A_BRK);
	    }
	    c = 0;
	    break;

	  default:
	    break;
	}

	if(c>0)
	  skwchar(cnctskt,c);

	return(c);
}

/*
 * keygets
 *
 * read a line from the keyboard
 * returns ABORT if keyboard input aborted
 * or non-zero on success
 */

int keygets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';

	if(fndbrk) {
		fndbrk = 0;
		kb_puts("^C\r\n");
		return(ABORT);
	}
	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(fndbrk) {
			fndbrk = 0;
			*save = '\0';
			kb_puts("^C\r\n");
			return(ABORT);	
		}
		suspnd(0);
	}
}

static char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
static VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  printout text
 */
VOID printtxt(txt)
register char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}
                                                                                                                                                                                                        