/* scrnPT.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"

#include "fmtdat.h"
#include "vt1xx.h"

extern	char *cstate[];
extern	char filstr[];

scrnP(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register DLAYER *dl;
	int row;
	char *ea;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #P)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	sprintf(s,
	"__PKT");
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	dl = &tl->d;
	row++;

	sprintf(s,
	"	DLAYER	d");
	fmtplc(s,row++);

	sprintf(s,
	"	iostat . . . . . . . . = 0x%04.4X", dl->iostat);
	fmtplc(s,row++);

	sprintf(s,
	"	iolen  . . . . . . . . = 0x%04.4X", dl->iolen);
	fmtplc(s,row++);

	sprintf(s,
	"	type . . . . . . . . . = 0x%04.4X", dl->type);
	fmtplc(s,row++);

	ea = &dl->dest;
	row++;
	sprintf(s,
	"	dest = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);

	ea = &dl->me;
	row++;
	sprintf(s,
	"	me   = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);
}

scrnQ(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register IPLAYER *il;
	int row;
	char *ea;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #Q)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	sprintf(s,
	"__PKT");
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	size = %4.4d bytes", sizeof(struct iph));
	fmtplc(s,row++);

	il = &tl->i;
	row++;
	sprintf(s,
	"	IPLAYER	i");
	fmtplc(s,row++);

	sprintf(s,
	"	versionandhdrlen . . . = 0x__%02.2X",
		il->versionandhdrlen & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	service  . . . . . . . = 0x__%02.2X", il->service & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	tlen . . . . . . . . . = %6.6u", intswap(il->tlen));
	fmtplc(s,row++);

	sprintf(s,
	"	identity . . . . . . . = 0x%04.4X", intswap(il->identity));
	fmtplc(s,row++);

	sprintf(s,
	"	frags  . . . . . . . . = 0x%04.4X", intswap(il->frags));
	fmtplc(s,row++);

	sprintf(s,
	"	ttl  . . . . . . . . . = %6.6u", il->ttl & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	protocol . . . . . . . = 0x__%02.2X", il->protocol & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . = 0x%04.4X", intswap(il->check));
	fmtplc(s,row++);

	ea = &il->ipsource;
	row++;
	sprintf(s,
	"	ipsource = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);

	ea = &il->ipdest;
	row++;
	sprintf(s,
	"	ipdest   = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);
}

scrnR(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register TCPLAYER *tcl;
	int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #R)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	row = 2;
	sprintf(s,
	"TCPKT		tcpout	size = %4.4d bytes", sizeof(struct tcp));
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	size = %4.4d bytes", sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPLAYER	t	size = %4.4d bytes", sizeof(struct tcph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPKT	data	size = %4.4d bytes",
		sizeof(skt->tcpout.x.data));
	fmtplc(s,row++);

	tcl = &tl->t;
	row++;

	sprintf(s,
	"	TCPLAYER t");
	fmtplc(s,row++);

	sprintf(s,
	"	source . . . . . . . . =     %6u", intswap(tcl->source));
	fmtplc(s,row++);

	sprintf(s,
	"	dest . . . . . . . . . =     %6u", intswap(tcl->dest));
	fmtplc(s,row++);

	sprintf(s,
	"	seq  . . . . . . . . . = 0x%08.8lX", longswap(tcl->seq));
	fmtplc(s,row++);

	sprintf(s,
	"	ack  . . . . . . . . . = 0x%08.8lX", longswap(tcl->ack));
	fmtplc(s,row++);

	sprintf(s,
	"	hlen . . . . . . . . . =       %4.4d", tcl->hlen & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	flags  . . . . . . . . =     0x__%02.2X", tcl->flags & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	window . . . . . . . . =     %6u", intswap(tcl->window));
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . =     0x%04.4X", intswap(tcl->check));
	fmtplc(s,row++);

	sprintf(s,
	"	urgent . . . . . . . . =     0x%04.4X", intswap(tcl->urgent));
	fmtplc(s,row++);
}

scrnS(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register UDPKT *tl;
	register UDPLAYER *il;
	int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #S)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	sprintf(s,
	"UDPKT		udp	size = %4.4d bytes",
		sizeof(struct udp));
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	size = %4.4d bytes", sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    UDPLAYER	u	size = %4.4d bytes", sizeof(struct udph));
	fmtplc(s,row++);

	sprintf(s,
	"    UDPKT	data	size = %4.4d bytes", UMAXLEN);
	fmtplc(s,row++);

	il = &tl->u;
	row++;
	sprintf(s,
	"	UDPLAYER	u");
	fmtplc(s,row++);

	sprintf(s,
	"	source . . . . . . . . = %6.6u", intswap(il->source));
	fmtplc(s,row++);

	sprintf(s,
	"	dest   . . . . . . . . = %6.6u", intswap(il->dest));
	fmtplc(s,row++);

	sprintf(s,
	"	length . . . . . . . . = 0x%04.4X", intswap(il->length));
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . = 0x%04.4X", intswap(il->check));
	fmtplc(s,row++);
}

scrnT(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register ICMPKT *tl;
	register ICMPLAYER *il;
	int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #T)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	sprintf(s,
	"ICMPPKT		icmp	size = %4.4d", sizeof(struct icmp));
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	size = %4.4d bytes", sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    ICMPLAYER	c	size = %4.4d bytes", sizeof(struct icmph));
	fmtplc(s,row++);

	sprintf(s,
	"    ICMPKT	data	size = %4.4d bytes", ICMPMAX);
	fmtplc(s,row++);

	il = &tl->c;
	row++;
	sprintf(s,
	"	ICMPLAYER	c");
	fmtplc(s,row++);

	sprintf(s,
	"	type   . . . . . . . . = 0x__%02.2X", il->type & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	code   . . . . . . . . = 0x__%02.2X", il->code & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . = 0x%04.4X", intswap(il->check));
	fmtplc(s,row++);

	sprintf(s,
	"	part1  . . . . . . . . = 0x%04.4X", intswap(il->part1));
	fmtplc(s,row++);

	sprintf(s,
	"	part2  . . . . . . . . = 0x%04.4X", intswap(il->part2));
	fmtplc(s,row++);
}
                                                                                                                                                                                                                                                                                                                                                                                                        