/* access.c */

/*
 * System Access Utilities
 */

#include <stdio.h>
#include <string.h>

#include "access.h"
#include "usrblk.h"
#include "tsxutl.h"
#include "rtfile.h"

extern	struct	userblock user; /* username / password block */

#define	ac_dnest subdnest
#define	ac_dbase subdbase
static int ac_dlevl = 0;	/* subdirectory level */

static char ac_dev[6] = { 'd', 'k', ':', 0, 0, 0 };

static char phydev[6] = { 'd', 'k', ':', 0, 0, 0 };
static char ac_nam[8][8];
static char ac_ext[8][4];
static char ac_fil[16];
static char ac_slash = '\\';

static char			/* space for fully expanded user */
userpaths[DIRLSTSIZE+1][106];	/* directory / file specifications */

int	ac_priv;		/* current priveleges */

/*
 * faccess
 */
int faccess(pst,rights)
char *pst;
int rights;
{
	return(access(pst,rights,0));
}

/*
 * daccess
 */
int daccess(pst,rights)
char *pst;
int rights;
{
	return(access(pst,rights,1));
}

/*
 * access
 *
 * If the password requirement is set then set the path
 * and verify that the directory / file may be accessed as
 * defined in the users userblock structure.
 */
int access(pst,rights,df)
char *pst;
int rights,df;
{
	char path[200];

	/*
	 * Clear Privileges
	 */
	ac_priv = 0;

	/*
	 * Check for password bypass (implies full access)
	 */
	if(!pswdreqd) {
		ac_priv = ALL_PRIV;
		return(1);
	}

	/*
	 * Get the current path and parse it
	 */
	getpath(path);
	if(ac_lgcdsk(path,1))
		return(0);

	/*
	 * Now parse the incoming specification
	 */
	if(ac_lgcdsk(pst,df))
		return(0);

	/*
	 * Get the full path with file
	 */
	ac_path(path);

	/*
	 * Check User directories
	 */
	if(chkpath(path,rights)) {
		return(1);
	} else {
		sprintf(errstr,
			"Insufficient privilege for requested operation");
		return(0);
	}
}

/*
 * chkpath
 *
 * Compare the path to each of the userblock directory
 * entries beginning with the access directories and
 * ending with the default directory.
 *
 * If an entry matches the path then the entries access rights
 * are compared to the requested operation returning a (1)
 * if the operation is permitted or a (0) if not.
 *
 * If no matching entries are found and the DIRUNRESTRICTED flag
 * is set then the operation is permitted otherwise the operation
 * is not permitted.
 */
static int chkpath(path,rights)
char *path;
int rights;
{
	register int i;

	/*
	 * Check Directory entries
	 */
	for(i=0; i<DIRLSTSIZE; i++) {
		if(patheq(path,userpaths[i])) {
			ac_priv = user.dirlst[i].flags;
			return((ac_priv&rights)==rights ? 1 : 0);
		}
	}

	/*
	 * Check Default Directory
	 */
	if(patheq(path,userpaths[DIRLSTSIZ])) {
		ac_priv = user.defdir.flags;
		return((ac_priv&rights)==rights ? 1 : 0);
	}

	/*
	 * Check Unrestricted Access flag
	 */
	if(user.userflag[1]&DIRUNRESTRICTED) {
		ac_priv = user.defdir.flags;
		return(1);
	} else {
		return(0);
	}
}

/*
 * patheq
 *
 * Compare path with the userblock directory entry.
 * A match is returned if the userblock entry is
 * wholly contained in the path.
 */
static int patheq(s,t)
register char *s,*t;
{
	register char c;

	if(*t == '\0')
		return(0);

	while(*t != '\0') {
		if(*s != *t) {
			if(*s!='/' && *s!='\\')
				return(0);
			if(*t!='/' && *t!='\\')
				return(0);
		}
		s++;
		t++;
		/*
		 * After the device specification allow the
		 * directory specification	dev:\'file.ext'
		 * to match with the file	dev:'file.ext'
		 */
		if(*(t-1) == ':') {
			if(*s=='/' || *s=='\\')
				s++;
			if(*t=='/' || *t=='\\')
				t++;
		}
	}
	return(1);
}

/*
 * lduserpaths()
 *
 * Load the userblock specifications in fully
 * expanded form to allow quick checks.
 */
VOID lduserpaths()
{
	register int i;

	/*
	 * load Accessable Directory entries
	 */
	for(i=0; i<DIRLSTSIZE; i++) {
		if(user.dirlst[i].path[0]!=0) {
			ac_lgcdsk(&user.dirlst[i].path,0);
			ac_path(userpaths[i]);
		} else {
			userpaths[i][0] = '\0';
		}
	}

	/*
	 * load Default Directory
	 */
	ac_lgcdsk(&user.defdir.path,0);
	ac_path(userpaths[DIRLSTSIZE]);
}

/*
 * Logical Disk Directory Parser
 *
 * This routine attempts to parse the specified string into
 * a complete device / logical device specification without
 * doing any actual device or file access.
 */
static int ac_lgcdsk(str,flag)
register char *str;
int flag;
{
	register char *s,*t;
	char sl[2];
	char st[106];
	char tm1[20];
	char tm2[20];
	int i;

	errstr[0] = '\0';
	ac_fil[0] = '\0';
	*st = '\0';
	strcpy(sl,(strchr(str,'\\') != NULL) ? "\\" : "/");
	/*
	 * Check for device specification
	 */
	if((t = strchr(str,':')) == NULL) {
		t = str;
	} else {
		if((*str == '\\') || (*str == '/')) {
			strncat(st,str+1,++t - (str+1));
		} else {
			strncat(st,str,++t - str);
		}
	}
	/*
	 * Delimit any file specification
	 */
	if(*t && *t != '\\' && *t != '/' && *t != '.')
		strcat(st,sl);
	/*
	 * Copy remainder of string
	 */
	strncat(st,t,sizeof(st)-2 - (t - str));
	st[sizeof(st)-2] = '\0';
	/*
	 * Encapsulate with delimeter if this a directory spec
	 * and there are subdirectorys
	 */
	if(flag && (strchr(st,'\\') != NULL || strchr(st,'/') != NULL)) {
		strcat(st,sl);
	}
	/*
	 * Replace '/' with '\\'
	 * Convert to lower case
	 */
	for(t=st; *t!='\0'; t++) {
		if(*t == '/' || *t == '\\') {
			ac_slash = *t;
			*t = '\\';
		} else {
			*t = tolower(*t);
		}
	}
	/*
	 * cd .
	 */
	if(!strcmp(st,".")) {
		*st = '\0';
	}
	/*
	 * cd ..
	 */
	if(!strcmp(st,"..")) {
		if(ac_dlevl) {
			if(--ac_dlevl) {
				sprintf(ac_dev,"ld%1d:", ac_dlevl-1+ac_dbase);
			} else {
				strcpy(ac_dev,phydev);
			}
			return(0);
		} else {
			sprintf(errstr,
			/* */
			".. ignored, not in a subdirectory");
			/* */
			return(1);
		}
	}
	/*
	 * Scan for Physical Device delimeter
	 */
	if((t = strchr(st,':')) != NULL) {
		/*
		 * Test for a valid device
		 */
		if(ac_tstdev(st)) {
			sprintf(errstr,
			/* */
			"Invalid device specification");
			/* */
			return(1);
		}
		ac_dlevl = 0;
		t++;
	} else {
		t = st;
	}
	/*
	 * Extract each subdirectory
	 */
	while((t = strchr(s=t,'\\')) != NULL && strchr(s=++t,'\\') != NULL) {
		/*
		 * Extract subdirectory
		 */
		for(s=tm1,i=0; *t!='\0' && *t!='\\' && i<19; i++) {
			*s++ = *t++;
		}
		*s = '\0';
		/*
		 * A null entry terminates scan
		 */
		if(tm1[0] == '\0') {
			return(0);
		}
		/*
		 * An embedded device is not allowed
		 */
		if(strchr(tm1,':') != NULL) {
			sprintf(errstr,
			/* */
			"'dev:' not allowed in subdirectory");
			/* */
			return(1);
		}
		if(ac_dlevl >= ac_dnest) {
			sprintf(errstr,
			/* */
			"Subdirectory nesting may not exceed %d", ac_dnest);
			/* */
			return(1);
		}
		/*
		 * Generate a complete file spec
		 * from the two filespec strings.
		 */
		sprintf(tm2,"%s.dsk", ac_dev);
		rtparse(rtfile(tm1,tm2));
		/*
		 * Update directory tree
		 */
		sprintf(ac_dev,"ld%1d:", ac_dlevl+ac_dbase);
		strcpy(ac_nam[ac_dlevl],rtname());
		strcpy(ac_ext[ac_dlevl],rtext());
		/*
		 * Update subdirectory level
		 */
		ac_dlevl += 1;
	}
	/*
	 * Assume the trailing non bracketed
	 * string is a file name
	 */
	strncpy(ac_fil,s,16);
	ac_fil[15] = '\0';
	return(0);
}

/*
 * Test the Device Specification and Set the Default Directory
 */
static int ac_tstdev(st)
register char *st;
{
	char t[6];
	register char *q;
	register int i;

	for(i=0,q=t; *st && i<4; i++,q++,st++)
		*q = tolower(*st);
	*q = '\0';

	q = strchr(t,':');
	if(q==NULL || q==t || (q-t)>3) {
		return(1);
	}

	*(++q) = '\0';

	sprintf(ac_dev,"%s",t);
	sprintf(phydev,"%s",t);
	return(0);
}

/*
 * Expand full path with extensions
 */
static char *ac_path(st)
register char *st;
{
	char s[12];
	register int i;

	sprintf(st,"%s", phydev);
	for(i=0; i<ac_dlevl ;++i) {
		sprintf(s,"%c%s.%s", ac_slash,ac_nam[i],ac_ext[i]);
		strcat(st,s);
	}
	if(ac_fil[0] != '\0') {
		if(ac_dlevl) {
			sprintf(s,"%c%s", ac_slash,ac_fil);
			strcat(st,s);
		} else {
			strcat(st,ac_fil);
		}
	}
	return(st);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              