.comment;softin.tsx

.chapter;Software Installation

  The TCP/IP Package software components should be installed as
described in the following sections.  The ethernet device handler
specific to your particular hardware configuration must be copied
to the TSX-PLUS system device.  The logical name assignments
used by the package are:

.list
.list element;TCP:###Location of client/server programs
.br
#######and assorted configuration, message,
.br
#######and help files.
.list element;PAS:###Location of password files.
.list element;ENx:###Selected device driver units 0-3.
.end list

  The logical name assignments MAI:, location of mailboxes,
HTP:, location of HTTP home directory, and GPH:, location
of GOPHER files, may be used in various command files.

  The TCP/IP Package for TSX-Plus executables are found
on logical disks TSDSK1.DSK, TSDSK2.DSK, and TSDSK3.DSK.
The required device handlers are found on the logical
disk DVRDSK.DSK.

.header level 1;Installation Configurations

The TSX-Plus package may be installed in
one of the following three configurations:

.header level 2;Install All Files on System Device 

All command files and client/server programs
are copied directly to your system disk.  Assign SY: to
TCP:.  This configuration puts everything
in one place but installs about 90 files (and 2100 blocks)
on your system disk.

.header level 2;Install Only Command Files on System Device

Create a seperate logical disk (assigned as TCP:) for the
client/server programs and perhaps seperate logical disks
for the password files (assigned as PAS:) and mail boxes
(assigned as MAI:).  Copy the command files to the system
directory.  This will install about 50 files (and 50 blocks)
on your system device.

.header level 2;Install All Files on a Logical Disk

Create a seperate logical disk (assigned as TCP:) for the
package and perhaps seperate logical disks for the password
files (assigned as PAS:) and mail boxes (assigned as MAI:).
Copy all the files to the TCP: disk.  This configuration
requires the user to specify the TCP: logical when using
any TCP/IP command file or program but removes all files
from the system disk.  CCL commands may be defined to
obviate the need for using TCP:, see the file TSXUCL.INS
for a complete set of definitions.  Edit the file to
include only the CCL definitions you wish defined.

.header level 1;Software Components

The following annotated list summarizes the software components:

.lm 2
.list
.tp 5
.list element; TCP/IP Network Server
.list 0
.list element; DETACH.TSX	detached job startup command file
.list element; TCPIP.COM	TCPIP startup command file
.list element; TCPIP.SAV	TCPIP network server Program
.list element; TCPIP.CFG	TCPIP configuration file
.end list
.tp 3
.list element; Telnet Client
.list 0
.list element; TELNET.COM	TELNET startup command file
.list element; TELNET.SAV	TELNET client program
.end list
.tp 6
.list element; Remote TELNET Server
.list 0
.list element; RTELNT.SRV	TELNET server detached job startup
.list element; RTELNT.COM	TELNET server startup command file
.list element; RTELNT.SAV	TELNET server program
.list element; RTELNT.MSG	TELNET server message file
.list element; RTELNT.HLP	TELNET server help file
.end list
.tp 3
.list element; CNCT Client
.list 0
.list element; CNCT.COM		CNCT startup command file
.list element; CNCT.SAV		CNCT client program
.end list
.tp 6
.list element; Remote CNCT Server
.list 0
.list element; RCNCT.SRV	CNCT server detached job startup
.list element; RCNCT.COM	CNCT server startup command file
.list element; RCNCT.SAV	CNCT server program
.list element; RCNCT.MSG	CNCT server message file
.list element; RCNCT.HLP	CNCT server help file
.end list
.tp 4
.list element; FTP Client
.list 0
.list element; FTP.COM		FTP startup command file
.list element; FTP.SAV		FTP client program
.list element; FTPCMD.TXT	FTP command help text
.end list
.tp 3
.list element; FTPL Client
.list 0
.list element; FTPL.COM		FTPL startup command file
.list element; FTPL.SAV		FTPL client program
.end list
.tp 6
.list element; Remote FTP Server
.list 0
.list element; RFTP.SRV		FTP server detached job startup
.list element; RFTP.COM		FTP server startup command file
.list element; RFTP.SAV		FTP server program
.list element; RFTP.MSG		FTP server message file
.list element; RFTP.HLP		FTP server help file
.end list
.tp 4
.list element; MAIL Client
.list 0
.list element; MAIL.COM		MAIL startup command file
.list element; MAIL.SAV		MAIL client program
.list element; MAICMD.TXT	MAIL command help text
.end list
.tp 4
.list element; MMAIL Client
.list 0
.list element; MMAIL.COM	MMAIL startup command file
.list element; MMAIL.SAV	MMAIL client program
.list element; MMACMD.TXT	MMAIL command help text
.end list
.tp 4
.list element; POP3 Mail Server
.list 0
.list element; RPOP3.SRV	RPOP3 server detached job startup
.list element; RPOP3.COM	RPOP3 server startup command file
.list element; RPOP3.SAV	RPOP3 server program
.end list
.tp 4
.list element; MAILER Task
.list 0
.list element; MAILER.SRV	MAILER task detached job startup
.list element; MAILER.COM	MAILER task startup command file
.list element; MAILER.SAV	MAILER task program
.end list
.tp 5
.list element; Remote MAIL Server
.list 0
.list element; RSMTP.SRV	MAIL server detached job startup
.list element; RSMTP.COM	MAIL server startup command file
.list element; RSMTP.SAV	MAIL server program
.list element; RSMTP.HLP	MAIL server help file
.end list
.tp 6
.list element; Local Printer Utilities
.list 0
.list element; LLPC.COM		LLPC  local start printer queue
.list element; LLPQ.COM		LLPQ  local printer queue status
.list element; LLPR.COM		LLPR  local print command
.list element; LLPRM.COM	LLPRM local remove print job
.list element; LLPQRM.SAV	LLPxx local printer control program
.end list
.tp 4
.list element; Remote LPD Server
.list 0
.list element; RLPD.SRV		RLPD server detached job startup
.list element; RLDP.COM		RLPD server startup command file
.list element; RLPD.SAV		RLPD server program
.end list
.tp 5
.list element; Printer Daemon
.list 0
.list element; LPRINT.SRV	LPRINT task detached job startup
.list element; LPRINT.COM	LPRINT task startup command file
.list element; LPRINT.SAV	LPRINT task program
.list element; LPDQRM.CFG	LPRINT configuration file
.end list
.tp 6
.list element; Remote Printer Utilities
.list 0
.list element; LPC.COM		LPC  local start printer queue
.list element; LPQ.COM		LPQ  local printer queue status
.list element; LPR.COM		LPR  local print command
.list element; LPRM.COM		LPRM local remove print job
.list element; LPQRM.SAV	LPxx local printer control program
.end list
.tp 3
.list element; Remote Binary File Printing
.list 0
.list element; NTSND.COM	NTSND client startup command file
.list element; NTSND.SAV	NTSND client program
.end list
.tp 4
.list element; Remote HTTP Web Server
.list 0
.list element; RHTTP.SRV	RHTTP server detached job startup
.list element; RHTTP.COM	RHTTP server startup command file
.list element; RHTTP.SAV	RHTTP server program
.end list
.tp 4
.list element; Remote Gopher Server
.list 0
.list element; RGOPH.SRV	RGOPH server detached job startup
.list element; RGOPH.COM	RGOPH server startup command file
.list element; RGOPH.SAV	RGOPH server program
.list element; RGOPH.CFG	RGOPH server configuration list
.end list
.tp 4
.list element; Password and Authorization Files
.list 0
.list element; PASWRD.COM	Password startup command file
.list element; PASWRD.SAV	Password program
.list element; PASWRD.FIL	Password and authorization data file
.end list
.tp 3
.list element; Client/Server Monitor
.list 0
.list element; SKTMON.COM	Monitor startup command file
.list element; SKTMON.SAV	Monitor program
.end list
.tp 11
.list element; Subdirectory Utilities
.list 0
.list element; LCD.COM		Change directory command file
.list element; LDEL.COM		Delete file command file
.list element; LDIR.COM		List directory command file
.list element; LLS.COM		List directory command file
.list element; LMKDIR.COM	Make directory command file
.list element; LPRO.COM		Protect file command file
.list element; LRENAM.COM	Rename file command file
.list element; LRMDIR.COM	Delete Subdirectory command file
.list element; LUNP.COM		Unprotect file command file
.list element; UTIL.SAV		Utilities program
.end list
.tp 4
.list element; Subdirectory Summary Utility
.list 0
.list element; LDISKS.COM	Subdirectory summary command file
.list element; RFTHLP.COM	Generate RFTP.HLP command file
.list element; LDISKS.SAV	Subdirectory summary program file
.end list
.tp 4
.list element; Miscellaneous Files
.list 0
.list element; ABRTCP.SAV	Abort all Client/Server programs
.list element; ABRTJB.COM	Abort Client/Server Job command file
.list element; ABRTJB.SAV	Abort Client/Server Job program
.list element; KILLM.SAV	Kill all Client/Server Messages
.list element; REMOVE.COM	Remove all Client/Server global regions
.end list
.end list
.lm 8


.header level 1;Installation in Detail

  Complete the hardware installation as described in the
chapter titled Hardware Installation.

  Under TSX-Plus the most convenient installation is:
.list
.list element;Create TSXTCP.DSK[2400] as TCP:,
.br
a logical disk for the TCP/IP files
.list element;Create PASWRD.DSK[200] as PAS:,
.br
a logical disk for the password files
.list element;Optionally Create MAIL.DSK[nnn],
.br
a logical disk for the MAIL directory
.list element;Optionally Create HTTP.DSK[nnn],
.br
a logical disk for the HTTP home directory
.list element;Optionally Create GOPHER.DSK[nnn],
.br
a logical disk for the GOPHER directory

.note
The MAIL, HTTP, and GOPHER directories are needed only if you are going
to use the mail, http, or gopher servers.  The size of the MAI:, HTP:,
and GPH: logical disks are whatever is needed.
.end note

.list element;Copy the contents of the distribution disks
TSDSK1, TSDSK2, and TSDSK3 to TCP:.
.list element;Copy and rename (as EQ.TSX or EU.TSX) the
appropriate device handler from the logical disk DVRDSK.DSK
to SY:.  (See the chapter on device handlers for more information
on selecting the appropriate device handler.)
.list element;Edit the file TCP:TSXUCL.INS to include the CCL
commands you want.
.list element;Create a command file which will mount and assign
the logical disk for TCP: and add the line '@TCP:TSXUCL.INS' at
the end.  Include this file in the LINEx.TSX startup files.
.list element;Copy PASWRD.SAV and PASWRD.FIL to PAS:.
.list element;Edit the command file TCP:PASWRD.COM to mount and
assign the logical disk PAS:.
.list element; Update the password file.  The password
file contains an anonymous account which you will need to
update or delete. If you delete the anonymous account then add at
least one valid account for initial testing with remote FTP enabled.
.list element;Edit the file TCP:TCPIP.CFG for your configuration.
Your machine's name and IP address are required and the specification
of a name server and gateway may be required for your network.
.list element;Edit TCP:TCPIP.COM to mount TCP: and assign units
0-3 of the device handler to EN0-3.  Copy this file to SY:.
.list element;Edit or create the TSX detached job startup file
SY:DETACH.TSX to include the line 'detach#sy:tcpip.com'.
.list element;Edit the files TCP:*.SRV to mount and assign the
logical disks for TCP:, PAS:, MAI:, HTP:, and GPH: as required
by the particular service. (Since the servers are run as detached
jobs these need to be defined when the job starts.)
.list element;Update your TSX configuration by following the
section on TSX-Plus system generation.
.list element;Reboot your TSX-Plus system.  Verify that the job
TCPIP is running. (If the job did not start then check that
SY:TCPIP.COM has TCP: defined correctly, the configuration
file path is correct, the device assignments are correct, and
file TCPIP.CFG is correct.  Try starting
the TCPIP server from the console: ru/single TCP:TCPIP, enter the
command line arguments at the argv: prompt and see what errors
the program gives.)
.list element;Verify that another networked computer can communicate
with your machine by doing a 'ping'.  Don't know what a ping is?
Skip this step. (verifies that TCPIP is able to respond to data
sent over the Ethernet wire)
.list element;Attempt to Telnet or FTP to a local computer using
only the IP number of that computer. (verifies connections are
possible)
.list element;Attempt to Telnet or FTP to a local computer using
the computer's name.  The computer's name and IP address must not be
in the TCPIP.CFG file. (verifies that the name server entry is
correct)
.list element;Attempt to Telnet or FTP to a machine not on your
local network.  If you use the machine's name then the name server
must be working or the machine's name and IP number must be
in the configurataion file TCP:TCPIP.CFG.  (verifies that the
gateway entry is correct)
.list element;Attempt to FTP to your computer from some other
networked machine using your machine's IP address.  If your machine's
name has not been added to the name server you must use the IP number.
(verifies that the RFTP.SRV configuration
is correct and that password checking is working)
.end list


  Essentially your installation is now complete.  You only need
to update the password file to specify user/password information,
access rights, and default FTP and MAIL directories.  Individual
program configuration information is contained in the chapter
titled Program Options.

                                                                       