{$Y-,Z-}
program px;

{ This program will compile, link and run a
  normal NBS Pascal program.

	Author: Keith Buckley
	Date:   14-JAN-1984
        Revision : 19-JAN-1986}

const
  delimiter='\';
  Bcolon="B:";
  slash="/";
  period=".";
  strlen=80;
  nrterms = 14;

type
  relation = (lt,le,eq,ge,gt,ne);
  string=array[1..strlen] of char;
  sm1string = array [1..nrterms, 1..3] of char;
  fl = array [1..nrterms] of boolean;

const
  sl = sm1string ("/B", "/C", "/F", "/G", "/L", "/M", "/N", "/P", "/Q", "/X", "/Y", "/Z", "/J", "/A");

var
  nbsversion : @string;
  extralink, ext, badoption : string;
  flag : fl;
  i,j,k,stop,len:integer;
  ouf:text;

procedure uppercase(var ch : char); external;

function compare(s1:string; r:relation; s2:string):boolean; external;

function length(src:string):integer; external;

function stoi(s:string; b,st:integer; var stop:integer):integer; external;

procedure substring(src:string; var dst:string; index,size:integer); external;

procedure concat(src1,src2:string; maxlength:integer); external;

function position(src,pattern:string; index:integer):integer; external;

procedure delete(var dst:string; index,size:integer); external;

procedure rerun; external;

procedure setcmd(delimiter:char); external;

function version:@string; external;

procedure checkoption;
var
  j, k : integer;

begin
  for j := 1 to nrterms do begin
    k := position(argv[1]@, sl[j], 1);
    flag[j] := (k>0);       {set flag TRUE if present}
    if flag[j] then delete(argv[1]@, k, 2)
  end;

  j:=position(argv[1]@, slash, 1);  {remove extra /options}
  if j>0 then begin
    substring(argv[1]@, badoption, j, length(argv[1]@));
    writeln('?PX-W-Illegal switch(es) ', badoption);
    delete(argv[1]@, j, strlen);
  end;
end;

procedure pre(ext : string);
begin
  if flag[13] then begin   {/J present}
    writeln(ouf, "R PRE");
    write(ouf, "- ", argv[1]@);
    if compare(ext, ne, ".P") then begin   {file.P must be specified}
      writeln;
      writeln('?PX-E-No file ', argv[1]@, '.P');
      writeln(chr(7));
      rerun
    end;
    writeln(ouf, " ",argv[1]@, ".PAS")
  end;
end;

procedure p1(ext : string);
begin
  writeln(ouf, "R PASS1");
  write(ouf, "-");
  if flag[11] then write(ouf, "Y");
  if not(flag[12]) and not(flag[5]) and not(flag[9]) then write(ouf,"Z");
{not /Z (warning) and not /L (listing) and not /Q (quiet to NL:)}
  if flag[4] then write(ouf,"G");
  if not(flag[2]) then write(ouf, "LC");  {presume line count}
  write(ouf, " ", argv[1]@);
  if flag[13] then write(ouf, ".PAS")   {presume .PAS formed after PRE option}
    else write(ouf, ext);
  write(ouf, " ", "I00 D00 ");
  if flag[5] then
    writeln(ouf, argv[1]@, ".LST")  {/L listing}
  else if flag[9] then writeln(ouf, "NL:")  {/Q quiet}
  else writeln(ouf,"TT:");   {default to TT:}
end;

procedure p2;
begin
  writeln(ouf, "R PASS2");
  write(ouf, "-");
  if flag[3] then write(ouf, "F");
  if flag[7] then write(ouf, "N");
  if flag[8] then write(ouf, "P");
  write(ouf," ", "I00 D00 ", argv[1]@);
  if flag[8] then
    writeln(ouf, " ", argv[1]@, ".OLS")  {/P  procedure list}
  else writeln(ouf)
end;

procedure link(j:integer);
begin
  if not(flag[6]) then begin    {link if not /M}
    write(ouf,"LINK");
    if (flag[1]) and (j<>0) then
      write(ouf,"/BOTTOM:",j);    {/B}
    write(ouf," ",argv[1]@);
    if (flag[14]) and (length(extralink) <> 0) then   {/A}
      write(ouf, ',', extralink);
    writeln(ouf)
  end;
end;

procedure linkoptions;
begin
  i := position(argv[1]@, Bcolon, 1);
  if i>0 then begin
    j := stoi(argv[1]@, 10, i+2, stop);
    if stop = 0 then                       {if end of line}
      delete(argv[1]@, i+1, length(argv[1]@))
    else delete(argv[1]@, i+1, stop-i-1)
  end;
  i := position(argv[1]@, "/A", 1);
  if i <> 0 then begin
    k := position(argv[1]@, slash, i+1);    {find next option}
    if k = 0 then
      k := length(argv[1]@) + 1;
    substring(argv[1]@, extralink, i+3, k-i-3);
    delete(argv[1]@, i+2, k-i-2)
  end
end;

procedure run;
begin
  if not(flag[6]) and not(flag[10]) then    {not /M, not /X}
    writeln(ouf,"RUN ",argv[1]@);
end;

begin
  nbsversion := version;
  if argc<>2 then begin
    writeln('$program/options (for NBS ', nbsversion@, ' - PX1.3)');
    writeln;
    writeln('PRE preprocessor option:');
    writeln('            /J - invoke pre-processor (requires FILNAM.P) - OFF');
    writeln;
    writeln('PASS1 options: /C - toggle compiled line count display - OFF');
    writeln('            /G - allow line tracing for compiled program - OFF');
    writeln('            /L - listing output to file (FILNAM.LST) - default TT:');
    writeln('            /Q - no listing (output to NL:)');
    writeln('            /Y - suppress array bounds checking - OFF');
    writeln('            /Z - halt terminal output on error or warning - OFF');
    writeln;
    writeln('PASS2 options: /F - profile subroutines (use with PROFIL.SAV) - OFF');
    writeln('            /N - produce a command line request - default OFF');
    writeln('            /P - procedure name index to file (FILNAM.OLS) - OFF');
    writeln;
    writeln('LINK options: /B:nnnn - link to specified bottom');
    writeln('            /M - do not LINK file - OFF');
    writeln('            /A - link additional file (/A:extra)');
    writeln;
    writeln('Run-time:   /X - do not execute the file - OFF');
    writeln;
    rerun
  end
  else begin   (* main *)
    argv[0]@ := "";
    for j := 1 to nrterms do
      flag[j] := false;
    j := 0;
    for i := 1 to length(argv[1]@) do
      uppercase(argv[1]@[i]);
    linkoptions;
    i := position(argv[1]@, slash, 1);
    if i>0 then
      checkoption;
    i := position(argv[1]@, period, 1);
    if i>0 then begin
      substring(argv[1]@, ext, i, strlen);
      delete(argv[1]@, i, strlen)
    end;
    concat(argv[0]@, "@", strlen);
    concat(argv[0]@, argv[1]@, strlen);
    rewrite(ouf, argv[1]@, "COM", 2);
    pre(ext);
    p1(ext);
    p2;
    link(j);
    run;
    setcmd(delimiter)
  end
end.
                                                                                                                                                                                                                                                                                                                                                                                                                           