{$W-,Y-}
program nbs;
{	Author : Earl Chew
	Date   : 2-Mar-1984

Copyright (C)   C.E. Chew 1984

An NBS Pascal compiler command file generator }

const
  stringlength = 20;
  argcmax = 10;
  version = '1.6iec3';
  progid = "NBS";
  headings = 6;

type
  string = array [1..stringlength+1] of char;
  relation = (lt, le, eq, ge, gt, ne);


{OPTION DATA STRUCTURES}

type
  options = (first,
             com,p,pas,int,dat,lst,obj,ols,crf,sav,
             ep1,gp1,lp1,tp1,wp1,yp1,zp1,
             fp2,np2,op2,pp2,sp2,xp2,
	     passes,np3,rp3,sp3,xp3,
             bot,
             printer,ypre,npass1,npass2,ypasref,nlink,nrun,ninvoke,
             last);
  units = (pre,pass1,pass2,pasref,link,run);

  optiontablerec = record
         	     name,code : string;
		     defarg : integer;
		     radix : integer;
		     global : boolean
	    	   end;

  optiontablearray = array [succ(first)..pred(last)] of optiontablerec;

  displayrec = record
		 title : string;
		 low, high : options
	       end;

  displayarray = array [1..headings] of displayrec;

  switchoptstring = array [1..8] of options;

  switchoptarray = array [pre..run] of switchoptstring;

  fileoptstring = array [1..5] of options;

  fileoptarray = array [pre..run] of fileoptstring;

  defarray = array [1..6] of string;

const
  optiontable = optiontablearray(
		("COM",		"",	1, 0, false),
		("P",		"",	0, 0, false),
		("PAS",		"",	0, 0, false),
		("INT",		"",	2, 0, false),
		("DAT",		"",	3, 0, false),
		("LST",		"",	4, 0, false),
		("OBJ",		"",	0, 0, false),
		("OLS",		"",	5, 0, false),
		("CRF",		"",	6, 0, false),
		("SAV",		"",	0, 0, false),
		("SEParate",	"E",	-1,0, true),
		("TRAce",	"G",	-1,0, true),
		("NOLISt",	"L",	-1,0, true),
		("TABles",	"T",	-1,0, true),
		("NOWARnings",	"W",	-1,0, true),
		("NOARRaycheck","Y",	-1,0, true),
		("PAUse",	"Z",	-1,0, true),
		("PROfile",	"F",	-1,0, true),
		("NOCOMmandline","N",	-1,0, true),
		("CODelist",	"O",	-1,0, true),
		("PROcedureindex","P",	-1,0, true),
		("STACkdump",	"S",	-1,0, true),
		("EXTernal",	"X",	-1,0, true),
		("PASSes",	"",	-1,10, true),
		("NOUSErsymbols","N",	-1,0, true),
		("PASCalsymbols","P",	-1,0, true),
		("STANdardsymbols","S",	-1,0, true),
		("NOSOUrcelist","X",	-1,0, true),
		("BOTtom",	"/BOTTOM",-1,8,true),
		("PRInter",	"",	-1,0, true),
		("PRE",		"",	-1,0, true),
		("NOPASS1",	"",	-1,0, true),
		("NOPASS2",	"",	-1,0, true),
		("CROssreference","",	-1,0, true),
		("NOLINk",	"",	-1,0, true),
		("NORUN",	"",	-1,0, true),
		("NOINVoke",	"",	-1,0, true));

  displaytable = displayarray(
		 ("Parsing Modifiers",	printer,	ninvoke),
		 ("File Specifiers",	com,		sav),
		 ("PASS1",		ep1,		zp1),
		 ("PASS2",		fp2,		xp2),
		 ("Cross Referencer",	passes,		xp3),
		 ("Linker",		bot,		bot));

  switchstring = switchoptarray(
			(first,first,first,first,first,first,first,first),
			(ep1,gp1,lp1,tp1,wp1,yp1,zp1,first),
			(fp2,np2,op2,pp2,sp2,xp2,first,first),
			(np3,rp3,sp3,xp3,first,first,first,first),
			(bot,first,first,first,first,first,first,first),
			(first,first,first,first,first,first,first,first));

  filestring = fileoptarray(
			(p,pas,first,first,first),
			(pas,int,dat,lst,first),
			(int,dat,obj,ols,first),
			(pas,crf,first,first,first),
			(obj,first,first,first,first),
			(sav,first,first,first,first));

  default = defarray("NBS", "I00", "D00", "TT:", "TT:", "TT:");

{V A R I A B L E S}

type
  optionstaterec = record
			switch : boolean;
			arg : @string;
			value : integer
		   end;

  optionstatearray = array [succ(first)..pred(last)] of optionstaterec;

  defaultarray = array [1..6] of @string;

  argvcarray = array [1..argcmax] of integer;

var

  optionstate : optionstatearray;
  defaults : defaultarray;
  comfile : text;
  argvc : argvcarray;

procedure delete(var s:string; st, sp:integer); external;

function isuppercase(c:char):boolean; external;

function isdigit(i:char):boolean; external;

function length(s:string):integer; external;

function position(s1, s2:string; start:integer):integer; external;

procedure fatal(p, m:string); external;

procedure warn(p, m:string); external;

function stoi(s:string; b, st:integer; var so:integer):integer; external;

procedure itos(n:integer; var s:string; b:integer; si:boolean; m:integer); external;

procedure concatenate(var s1:string; s2:string; m:integer); external;

function compare(s1:string; r:relation; s2:string):boolean; external;

procedure setcmd(d:char); external;

procedure rerun; external;

procedure uppercase(var c:char); external;

function initialise : boolean;
var
  argk, i : integer;
  s : @string;
  opt : options;

begin
  initialise := true;
  for argk := 1 to argc-1 do
    argvc[argk] := 0;
  for i := 1 to 6 do begin
    new(s);
    s@ := default[i];
    defaults[i] := s
  end;
  for opt := succ(first) to pred(last) do begin
    with optionstate[opt] do begin
      switch := false;
      arg := nil;
      value := 0
    end
  end;
  if argc = 1 then
    initialise := false
end;

procedure summary;
var
  i : integer;
  opt : options;

begin
  repeat
    writeln;
    writeln('NBS	Version ', version);
    writeln;
    writeln('Command line format :');
    writeln('	$filename[/option...] [filename[/option...]]...');
    writeln;
    for i := 1 to headings do
      writeln(i:8, ' ':3, displaytable[i].title);
    writeln(9:8, '   Return to command line prompt');
    writeln;
    write('Help text required : ');
    readln(i);
    if (i >= 1) and (i <= headings) then begin
      writeln;
      with displaytable[i] do begin
	write(title, ' -');
	for opt := low to high do begin
	  if (ord(opt) - ord(low)) mod 4 = 0 then
	    writeln;
	  with optiontable[opt] do begin
	    if radix <> 0 then begin
	      write(name:13, ':');
	      if radix = 10 then
		write('<dec>')
	      else
		write('<oct>')
	    end
	    else
	      write(name:19)
	  end
	end;
	writeln
      end
    end
  until i=9
end;

procedure option;
var
  argk : integer;
  opt : options;
  val : integer;

procedure extractoption(var s:string; var option:options; var value:integer);
var
  t : string;
  slash : integer;

procedure extract(var s, t:string; start:integer);
var
  sinx, tinx : integer;
  ch : char;

begin
  sinx := start;
  tinx := 1;
  loop
    sinx := sinx+1;
    ch := s[sinx];
  exit if (ch = chr(0)) or not(isuppercase(ch) or isdigit(ch));
    t[tinx] := ch;
    tinx := tinx+1
  end;
  t[tinx] := chr(1);
  delete(s, start, tinx)
end;   {extract}


function index(var t:string; var option:options):boolean;
var
  cho, cht : char;
  tinx : integer;

function caselessmatch(cht, cho : char):boolean;

begin
  uppercase(cho);
  caselessmatch := cht=cho
end;   {caselessmatch}

begin   {index}
  option := first;
  loop
    option := succ(option);
    with optiontable[option] do begin
      tinx := 0;
      repeat
	tinx := tinx+1;
	cho := name[tinx];
	cht := t[tinx]
      until not caselessmatch(cht, cho)
    end;
  exit if not((cht<>chr(1)) or isuppercase(cho) or isdigit(cho)) then index := true;
  exit if option = pred(last) then index := false;
  end
end;   {index}

procedure worth(var t:string; radix, start:integer; var value:integer);
var
  stop : integer;

begin   {worth}
  if radix = 0 then begin
    if t[start] = ':' then 
      fatal(progid, "Value supplied for non-numeric option");
    value := 0
  end
  else begin
    if t[start] <> ':' then
      fatal(progid, "No value supplied for numeric option");
    value := stoi(t, radix, start+1, stop);
    if stop = start+1 then 
      fatal(progid, "Bad value supplied for numeric option");
    if stop = 0 then
      stop := length(t)+1;
    delete(t, start, stop-start)
  end
end;   {worth}

begin   {extractoption}
  slash := position(s, "/", 1);
  if slash = 0 then 
    option := first
  else begin
    extract(s, t, slash);
    if not index(t, option) then
      fatal(progid, "Unknown option");
    worth(s, optiontable[option].radix, slash, value)
  end
end;   {extractoption}

begin    {option}
  for argk := 1 to argc-1 do begin
    loop
      extractoption(argv[argk]@, opt,val);
    exit if opt = first;
      with optionstate[opt] do begin
	if switch then
	  warn(progid, "Option specified more than once - ignoring");
	switch := true;
	if optiontable[opt].global then
	  arg := nil
	else begin
	  arg :=argv[argk];
	  argvc[argk] := argvc[argk]+1
	end;
	value := val
      end
    end
  end
end;    {option}

procedure checkoption;
var
  opt : options;
  takedefault : boolean;
  argk : integer;

begin
  for opt := succ(first) to pred(last) do begin
    with optiontable[opt], optionstate[opt] do begin
      if not(global or switch) then begin
	if opt = p then
	  takedefault := optionstate[ypre].switch
	else if opt = pas then
	  takedefault := not optionstate[npass1].switch or
			 optionstate[ypre].switch or
			 optionstate[ypasref].switch
	else if opt = obj then
	  takedefault := not optionstate[nlink].switch or
			 not optionstate[npass2].switch
	else if opt = sav then
	  takedefault := not optionstate[nlink].switch
	else
	  takedefault := true;
	if takedefault then begin
	  switch := true;
	  value := 0;
	  if defarg = 0 then begin
	    arg := argv[1];
	    argvc[1] := argvc[1]+1
	  end
	  else
	    arg := defaults[defarg]
	end
      end
    end
  end;
  for argk := 1 to argc-1 do begin
    if argvc[argk] = 0 then
      warn(progid, "No use for specified filename");
    if argv[argk]@[1] = chr(0) then 
      fatal(progid, "No filename specified");
    if (argvc[argk]>1) and (position(argv[argk]@, ".", 1)>0) then
      fatal(progid, "Illegal use of file extension")
  end
end;    {checkoption}

procedure switches(u : units);
var
  opt : options;
  inx : integer;
  s : string;

begin
  inx := 0;
  loop
    inx := inx+1;
    opt := switchstring[u][inx];
  exit if opt = first;
    with optionstate[opt], optiontable[opt] do begin
      if switch then begin
	write(comfile, code);
	if radix>0 then begin
	  itos(value, s, radix, false, stringlength);
	  write(comfile, ':', s)
	end
      end
    end
  end
end;    {switches}

procedure files(u : units);
var
  opt : options;
  inx : integer;

begin
  inx := 0;
  loop
    inx := inx+1;
    opt := filestring[u][inx];
  exit if opt = first;
    write(comfile, ' ', optionstate[opt].arg@)
  end
end;    {files}

procedure normal(u : units; p : string);

begin
  writeln(comfile, 'R ', p);
  write(comfile, '-');
  switches(u);
  files(u)
end;    {normal}

procedure commandfile;
var
  i : integer;

begin
  rewrite(comfile, optionstate[com].arg@, "COM");
  if optionstate[printer].switch then begin
    for i := 4 to 6 do begin
      defaults[i]@[1] := 'L';
      defaults[i]@[2] := 'P'
    end
  end
end;     {commandfile}

procedure preprocessor;

begin
  if optionstate[ypre].switch then begin
    normal(pre, "PRE");
    writeln(comfile)
  end
end;    {preprocessor}

procedure p1;

begin
  if not optionstate[npass1].switch then begin
    optionstate[zp1].switch := optionstate[zp1].switch or
			       compare(optionstate[lst].arg@, eq, "TT:");
    normal(pass1, "PASS1");
    writeln(comfile)
  end
end;   {p1}

procedure p2;

begin
  if not optionstate[npass2].switch then begin
    normal(pass2, "PASS2");
    writeln(comfile)
  end
end;   {p2}

procedure crossref;

begin
  if optionstate[ypasref].switch then begin
    optionstate[xp3].switch := optionstate[xp3].switch or
	(not optionstate[npass1].switch and
	compare(optionstate[crf].arg@, eq, optionstate[lst].arg@) and
	(optionstate[crf].arg@[length(optionstate[crf].arg@)] = ':'));
    normal(pasref, "PASREF");
    if optionstate[passes].switch then
      write(comfile, ' ',  optionstate[passes].value);
    writeln(comfile)
  end
end;    {crossref}

procedure llink;

begin
  if not optionstate[nlink].switch then begin
    write(comfile, 'LINK/EXECUTE:', optionstate[sav].arg@);
    switches(link);
    files(link);
    writeln(comfile)
  end
end;    {llink}

procedure rrun;

begin
  if not optionstate[nrun].switch then begin
    write(comfile, 'RUN');
    switches(run);
    files(run);
    writeln(comfile)
  end
end;    {rrun}

procedure invoke;

begin
  if not optionstate[ninvoke].switch then begin
    concatenate(argv[0]@, "@", stringlength);
    concatenate(argv[0]@, optionstate[com].arg@, stringlength);
    setcmd(chr(0))
  end
end;    {invoke}

begin   {NBS}
  if not initialise then begin
    summary;
    rerun
  end
  else begin
    option;
    checkoption;
    commandfile;
    preprocessor;
    p1;
    p2;
    crossref;
    llink;
    rrun;
    invoke
  end
end.
                                                                                                                                                                                                                                                                         