
C
      BYTE FUNCTION HEXBIN ( HEX, BINARY )
C
C###############################################################################
C	Converts the ascii hex character string stored in HEX to an integer
Cbinary value BINARY. HEX can be at most 4 bytes long. If it is less than 4,
Cthen the string must be terminated by a null byte. Upper and lower case
Cletters are handled identically by the routine.
C	If the conversion was succesful, then HEXBIN returns true, else it
Creturns false.
C###############################################################################
      INTEGER BINARY
      BYTE HEX ( 4 ), NIBBLE
      NS = 0
      BINARY = 0
       LEN = 0
20000 IF (.NOT.( LEN .LT. 4 .AND. HEX ( LEN + 1 ) .NE. 0)) GOTO 20002
20001 LEN = LEN + 1 
      GOTO 20000
20002 CONTINUE
       I = LEN
20003 IF (.NOT.( I .GE. 1)) GOTO 20005
      NIBBLE = HEX ( I )
      IF (.NOT.( NIBBLE .GE. '0' .AND. NIBBLE .LE. '9' )) GOTO 20006
      NIBVAL = NIBBLE - '0'
      GOTO 20007
20006 CONTINUE
      IF (.NOT.( NIBBLE .GE. 'A' .AND. NIBBLE .LE. 'F' )) GOTO 20008
      NIBVAL = NIBBLE - 'A' + 10
      GOTO 20009
20008 CONTINUE
      IF (.NOT.( NIBBLE .GE. 'a' .AND. NIBBLE .LE. 'f' )) GOTO 20010
      NIBVAL = NIBBLE - 'a' + 10
      GOTO 20011
20010 CONTINUE
      hexbin = ( . FALSE . )
      RETURN
20011 CONTINUE
20009 CONTINUE
20007 CONTINUE
      BINARY = ISHFT ( NIBVAL, NS ) + BINARY
      NS = NS + 4
20004 I = I - 1 
      GOTO 20003
20005 CONTINUE
      hexbin = ( . TRUE . )
      RETURN
      END

C
      SUBROUTINE BINHEX ( BINARY, HEX )
C
C###############################################################################
C	Converts the integer binary value BINARY to a 4 byte string of ascii
Chex characters.
C###############################################################################
      BYTE HEX ( 4 ), HEXTBL ( 16 )
      INTEGER BINARY, BINTMP
      DATA HEXTBL / '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 
     $'A', 'B', 'C', 'D', 'E', 'F' /
      BINTMP = BINARY
       I = 4
20012 IF (.NOT.( I .GE. 1)) GOTO 20014
      HEX ( I ) = HEXTBL ( IAND ( BINTMP, 15 ) + 1 )
      BINTMP = ISHFT ( BINTMP, - 4 )
20013 I = I - 1 
      GOTO 20012
20014 CONTINUE
      RETURN
      END

C
      SUBROUTINE PADHEX ( HEX, HEX4 )
C
C###############################################################################
C	Converts the arbitrary length ASCII hex character string in HEX to a
C4 character byte string and stores the result in HEX4. HEX may be up to
Cfour characters in length and if less than 4, the string must be terminated by
Ca null byte.
C###############################################################################
      BYTE HEX ( 4 ), HEX4 ( 4 )
      INTEGER SHIFT
       LEN = 0
20015 IF (.NOT.( LEN .LT. 4 .AND. HEX ( LEN + 1 ) .NE. 0)) GOTO 20017
20016 LEN = LEN + 1 
      GOTO 20015
20017 CONTINUE
      NPAD = 4 - LEN
       I = 1
20018 IF (.NOT.( I .LE. 4)) GOTO 20020
      IF (.NOT.( I .LE. NPAD )) GOTO 20021
      HEX4 ( I ) = '0'
      GOTO 20022
20021 CONTINUE
      HEX4 ( I ) = HEX ( I - NPAD )
20022 CONTINUE
20019 I = I + 1 
      GOTO 20018
20020 CONTINUE
      RETURN
      END

C
      BYTE FUNCTION HEXSUB ( MIN, SUB, DIFF )
C
C###############################################################################
C	Function performs a 16 bit subtraction of two ascii hex values. The hex
CSUBtrahend is subtracted from the hex MINuend and returned in the hex
CDIFFerence. MIN and SUB must be ASCII hex values up to four characters in
Clength and if less 4 characters the strings MUST be terminated with a null
Cbyte. DIFFerence is always returned as a 4 character string.
C
C	The function returns false if a negative value results from the
Csubtraction (there are no negative hex values allowed), or if either the
CMIN or the SUB are illegal hex values.
C
C	The function splits the minuend and the subtrahend into high
Cand low bytes, subtracts each independently, checks for a borrow condition,
Cconverts the high and low order results into hex, and then concatenates the
Ctwo strings to form the ASCII hex difference.
C###############################################################################
      BYTE MIN ( 4 ), SUB ( 4 ), DIFF ( 4 ), HMIN ( 4 ), HSUB ( 4 )
      BYTE HEXBIN, MIN4 ( 4 ), SUB4 ( 4 )
      INTEGER BORROW
      CALL PADHEX ( MIN, MIN4 )
      CALL PADHEX ( SUB, SUB4 )
      CALL COPY ( MIN4 ( 3 ), HMIN ( 1 ), 3 )
      CALL COPY ( SUB4 ( 3 ), HSUB ( 1 ), 3 )
      IF (.NOT.( .NOT. HEXBIN ( HMIN, IHMIN ) .OR. .NOT. HEXBIN ( HSUB,
     $ IHSUB ) )) GOTO 20023
      hexsub = ( . FALSE . )
      RETURN
20023 CONTINUE
      ILDIFF = IHMIN - IHSUB
      IF (.NOT.( ILDIFF .LT. 0 )) GOTO 20025
      ILDIFF = ILDIFF + 256
      BORROW = 1
      GOTO 20026
20025 CONTINUE
      BORROW = 0
20026 CONTINUE
      CALL COPY ( MIN4 ( 1 ), HMIN ( 1 ), 3 )
      CALL COPY ( SUB4 ( 1 ), HSUB ( 1 ), 3 )
      IF (.NOT.( .NOT. HEXBIN ( HMIN, IHMIN ) .OR. .NOT. HEXBIN ( HSUB,
     $ IHSUB ) )) GOTO 20027
      hexsub = ( . FALSE . )
      RETURN
20027 CONTINUE
      IHDIFF = IHMIN - IHSUB - BORROW
      IF (.NOT.( IHDIFF .LT. 0 )) GOTO 20029
      hexsub = ( . FALSE . )
      RETURN
20029 CONTINUE
      CALL BINHEX ( ILDIFF, HMIN )
      CALL BINHEX ( IHDIFF, HSUB )
      DIFF ( 1 ) = HSUB ( 3 )
      DIFF ( 2 ) = HSUB ( 4 )
      DIFF ( 3 ) = HMIN ( 3 )
      DIFF ( 4 ) = HMIN ( 4 )
      hexsub = ( . TRUE . )
      RETURN
      END

C
      BYTE FUNCTION HEXADD ( ADD, AUG, SUM )
C
C###############################################################################
C	Function performs a 16 bit addition of two ascii hex values. The hex
CAUGend is added to the hex ADDend and returned in the hex SUM.
CADD and AUG must be ASCII hex values up to four characters in length and
Cif less 4 characters the strings MUST be terminated with a null byte. SUM
Cis always returned as a 4 character string.
C
C	The function returns false if an overflow results from the addition,
Cor if either  ADD or AUG are illegal hex values.
C
C	The function splits the ADDend and the AUGend into high and low bytes,
Cadds each individually, checks for a carry condition, converts the high and
Clow order results into hex, and then concatenates the two strings to form
Cthe ASCII hex SUM.
C###############################################################################
      BYTE ADD ( 4 ), AUG ( 4 ), SUM ( 4 ), HADD ( 4 ), HAUG ( 4 )
      BYTE HEXBIN, ADD4 ( 4 ), AUG4 ( 4 )
      INTEGER CARRY
      CALL PADHEX ( ADD, ADD4 )
      CALL PADHEX ( AUG, AUG4 )
      CALL COPY ( ADD4 ( 3 ), HADD ( 1 ), 3 )
      CALL COPY ( AUG4 ( 3 ), HAUG ( 1 ), 3 )
      IF (.NOT.( .NOT. HEXBIN ( HADD, IHADD ) .OR. .NOT. HEXBIN ( HAUG,
     $ IHAUG ) )) GOTO 20031
      hexadd = ( . FALSE . )
      RETURN
20031 CONTINUE
      ILSUM = IHADD + IHAUG
      IF (.NOT.( ILSUM .GE. 256 )) GOTO 20033
      ILSUM = ILSUM - 256
      CARRY = 1
      GOTO 20034
20033 CONTINUE
      CARRY = 0
20034 CONTINUE
      CALL COPY ( ADD4 ( 1 ), HADD ( 1 ), 3 )
      CALL COPY ( AUG4 ( 1 ), HAUG ( 1 ), 3 )
      IF (.NOT.( .NOT. HEXBIN ( HADD, IHADD ) .OR. .NOT. HEXBIN ( HAUG,
     $ IHAUG ) )) GOTO 20035
      hexadd = ( . FALSE . )
      RETURN
20035 CONTINUE
      IHSUM = IHADD + IHAUG + CARRY
      IF (.NOT.( IHSUM .GE. 256 )) GOTO 20037
      hexadd = ( . FALSE . )
      RETURN
20037 CONTINUE
      CALL BINHEX ( ILSUM, HADD )
      CALL BINHEX ( IHSUM, HAUG )
      SUM ( 1 ) = HAUG ( 3 )
      SUM ( 2 ) = HAUG ( 4 )
      SUM ( 3 ) = HADD ( 3 )
      SUM ( 4 ) = HADD ( 4 )
      hexadd = ( . TRUE . )
      RETURN
      END

                                                                                                                                                                                                                                                                                                                                                                                                    