/* shost1.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "mapskt.h"
#include "bytprc.h"
#include "confgs.h"


/*
 *  Shostlook
 *
 *  The straightforward list searcher.  Looks for either the
 *  session name matching or the host name matching.  NULL if neither.
 */
struct machinfo *Shostlook(sknum,hname)
int sknum;
register char *hname;
{
	register struct machinfo *m;
	register struct socket *skt;

	/*
	 * Check socket machine record
	 */
	if(sknum>=0) {
		skt = (struct socket *) mapskt(sknum);
		m = skt->mpp;
		if(m) {
			if(m->sname && !ncstrcmp(hname,m->sname))
				return(m);
			if(m->hname && !ncstrcmp(hname,m->hname))
				return(m);
		}
	}
	/*
	 * Check Internal machine list
	 */
	m = Smachlist;
	while(m!=NULL) {
		if(m->sname && !ncstrcmp(hname,m->sname))
			return(m);
		if(m->hname && !ncstrcmp(hname,m->hname))
			return(m);
		m = m->next;
	}
	return(NULL);
}

/*
 *  Snewns
 *
 *  Rotate to the next nameserver
 *  Chooses the next highest number from the nameserv field
 */
int Snewns()
{
	register struct machinfo *m,*low;
	register int i;

	/*
	 * safety, should never happen
	 */
	if(!Sns)
		Sns = Smachlist;
	low = Sns;
	/*
	 * what is value now?
	 */
	i = Sns->nameserv;
	m = Smachlist;
	while(m) {
		if(m->nameserv==(char)i+1) {
			Sns = m;
			return(0);
		}
		if((m->nameserv>0) && (m->nameserv<low->nameserv))
			low = m;
		m = m->next;
	}
	if(Sns==low)
		/*
		 * no alternate
		 */
		return(1);
	else
		Sns = low;
	return(0);
}

/*
 *  Ssetgates
 *
 *  set up the gateway machines and the subnet mask
 */
VOID Ssetgates()
{
	register struct machinfo *m;
	register int level,again;

	/*
	 * leave default unless specified
	 */
	if(Scon.havemask) {
		ntstmask(Scon.netmask);
	}
	/*
	 *  Search the list of machines for gateway flags.
	 *  Invoke ntstgate in increasing order of gateway level #s.
	 *  Terminates when it gets through list without
	 *  finding next higher number.
	 */
	level = 0;
	do {
		level++;
		again = 0;
		m = Smachlist;
		while(m!=NULL) {
			if(m->gateway ==
				(char)level && m->mstat>=HAVEIP) {
				ntstgate(m->hostip);
			}
			if(m->gateway==(char)level+1)
				again = 1;
			m = m->next;
		}
	} while(again);
}

/*
 *  ntstmask
 *
 *  Set the network mask.
 */
VOID ntstmask(st)
register char *st;
{
	movebytes(nnmask,st,4);
}

/*
 *  ncstrcmp
 *
 *  No case string compare.
 *  Only returns 0=match, 1=no match, does not compare greater or less
 *  There is a tiny bit of overlap with the | 32 trick, but shouldn't be
 *  a problem.  It causes some different symbols to match.
 */
int ncstrcmp(sa,sb)
register char *sa,*sb;
{
	/*
	 * don't compare leading spaces
	 */
	while(*sa && *sa<33)
		sa++;
	while(*sb && *sb<33)
		sb++;
	while(*sa && *sb) {
		if((*sa!=*sb) && ((*sa | 32)!=(*sb | 32)))
			return(1);
		sa++;
		sb++;
	}
	/*
	 * if both at end of string
	 */
	if(!*sa && !*sb)
		return(0);
	else
		return(1);
}
                                                                                                                                                                                                                                                                                                                                                                                                                  