/* rpop3.c */

#define	RPOP3MASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vrpop3.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "cticks.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "datime.h"
#include "inicli.h"
#include "suspnd.h"
#include "usrblk.h"
#include "rcdlck.h"
#include "mailbx.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();		/* (txt) print text */
extern	int	dosess();		/* session loop */
extern	int	setrp3();		/* setup POP3 session */
extern	VOID	rp3resp();		/* (s) response to client */
extern	VOID	lsterr();		/* error lister */
extern	int	response();		/* dumby routine for TSXUTL.C */
extern	int	rpop3cmnds();		/* (s) return command index */
extern	int	rp3equal();		/* (s,t) compare strings */
extern	VOID	rp3d();			/* (code) process POP3 commands */
extern	int	getword();		/* (string,word) extract a word */
extern	VOID	strlwr();		/* (st) convert to lower case */
extern	int	checkpass();		/* (us,ps) verify user/password */
extern	int	Scompass();		/* (ps) compare password */
extern	VOID	mailstat();		/* check for unread mail */
extern	VOID	mesgstat();		/* recalculate the mail statistics */
extern	VOID	toplines();		/* send header plus lines to NET */
extern	int	openmail();		/* open mail file for pop3 XTND */
#endif

extern	char	*stptok();		/* (p,t,l,d) stop on token */
extern	char	*stpblk();		/* (ch) stop on block */
extern	char	*checkuser();		/* (us) check if this is a user */

/*
 * List of POP3 commands
 */
#define R_DELE	0
#define	R_LAST	1
#define	R_LIST	2
#define	R_NOOP	3
#define R_PASS	4
#define R_QUIT	5
#define	R_RETR	6
#define	R_RSET	7
#define R_STAT	8
#define	R_TOP	9
#define	R_USER	10
#define	R_XTND	11
#define R_NULL	12	/* NO MATCH */

char *rp3_clist[] = {
	"DELE",	"LAST", "LIST", "NOOP",	"PASS",
	"QUIT",	"RETR",	"RSET",	"STAT",	"TOP",
	"USER", "XTND"
};

/*
 *  If MSG_FAST is defined:
 *	message size given as 512 times number of blocks in file
 *  
 *  If MSG_FAST is not defined:
 *	message size is found by scanning file for exact length
 */

#define	MSG_FAST	1

#define	MSG_DELE	0x0001
#define	MSG_RETR	0x0002

/*
 *	Defines
 */

#define BUFFERS		(128)
#define	COMMAND		(128)
#define	RSPSTRING	(128)
#define GENBUFR		(128)

#define	INFO_LEN	(80)
#define	HDR_R		(0x0001)
#define	HDR_D		(0x0002)
#define	HDR_F		(0x0004)
#define	HDR_M		(0x0008)
#define	HDR_T		(0x0010)
#define	HDR_S		(0x0020)

#define	MAXMSG	15		/* report only MAXMSG messages at a time */

/*
 *	Global Variables For RPOP3 Control Channel
 */

static int
	aflag = 0,		/* Attach to Service Flag */
	rflag = 0,		/* rpop3 restart flag */
	rp3cskt = -1,		/* socket for incoming pop3 */
	mflag = 0,		/* monitor processing */
	waitpos = 0,		/* marker for gathering strings from net */
	rfstate = 0,		/* state of the control channel */
	retstate = 0,		/* to emulate a subroutine call */
	rcnt = 0;		/* number of characters from control */

int	yflag = 0,		/* login timeout flag */
	zflag = 0;		/* inactivity timeout flag */

long	lzaptime = 0L,		/* login zap time in ticks */
	izaptime = 0L;		/* inactivity zap time in ticks */

/*
 *	Global Buffers / Pointers
 */

static char
	command[COMMAND],		/* command string */
	rsp[RSPSTRING],			/* response string */
	scratch[GENBUFR],		/* scratch string */
	pathname[DIRPATHLEN+2],		/* space to keep path name */
	username[USERPASSLEN+2],	/* current username */
	password[USERPASSLEN+2];	/* current pasword */

static struct userblock
	user;			/* usernames / passwords / mailboxes */

char	xs[2];			/* dumby buffer for TSXUTL.C */

static	int
	mailer = 0;		/* mail delivery agent task number */
static char *
	mailfl = "ml____.___";	/* mailer file */
static char
	emailfl[GENBUFR];	/* expanded mailer file */
static FILE *
	mailfh = NULL;		/* mailer file handle */


static char *			/* password file */
	passfl = "PAS:paswrd.fil";
static FILE *
	passfh = NULL;


static	int
	msgcnt = 0,		/* number of messages for current user */
	msgdel = 0,		/* deleted messages */
	msglast = 0,		/* last message read */
	msgindex[MAXMSG],	/* message indexes */
	msgflag[MAXMSG];	/* message flags */

static	long
	msgspc = 0,		/* total size of all messages */
	msglength[MAXMSG];	/* message lengths */

/*
 * Debugging options
 *
 *	bit 0	(0x01)	event printing
 *	bit 1	(0x02)	dosess() events
 *	bit 2	(0x04)	rp3d()
 *	bit 3	(0x08)	checkuser()/checkpass()
 *	bit 4	(0x10)	toplines()
 */

#if ts$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  RPOP3 [?] [-d level] [-p filespec] [-t n] [-y s] [-z s] [-aerv]",
       "	?               List the Help Text and Exit RPOP3",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() event printing",
       "		4 -	enable RPOP3() printing",
       "	        8 -	enable checkuser() / checkpass() printing",
       "	       16 -	enable topline() printing",
#else
       "  RPOP3 [?] [-p filespec] [-t n] [-y s] [-z s] [-aerv]",
       "	?               List the Help Text and Exit RPOP3",
#endif
       "	a		Attach to Service",
       "	e		Enable Monitoring of RPOP3 Transactions",
       "	p  filespec	Specify the Password Filespec",
       "	r		Restart RPOP3 after Disconnect",
       "	t  n		TCPIP Task Number for Mail Delivery Agent",
       "	v		Verbose Mode",
       "	y  s		Login Timeout in seconds",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

#if rt$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  RPOP3 [?] [-d level] [-p filespec] [-y s] [-z s] [-erv]",
       "	?               List the Help Text and Exit RPOP3",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() event printing",
       "		4 -	enable RPOP3() printing",
       "	        8 -	enable checkuser() / checkpass() printing",
       "	       16 -	enable topline() printing",
#else
       "  RPOP3 [?] [-p filespec] [-y s] [-z s] [-erv]",
       "	?               List the Help Text and Exit RPOP3",
#endif
       "	e		Enable Monitoring of RPOP3 Transactions",
       "	p  filespec	Specify the Password Filespec",
       "	r		Restart RPOP3 after Disconnect",
       "	v		Verbose Mode",
       "	y  s		Login Timeout in seconds",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}


main(argc,argv)
int argc;
char *argv[];
{
	int ev,i,j,k;
	register char c;
	register struct socket *skt;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	kb_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    kb_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#if ts$sys
			case 'a':	/* attach to service */
				aflag = 1;
				break;
#endif
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'e':	/* enable RPOP3 monitoring */
				mflag = 1;
				break;

			case 'p':	/* password file */
				passfl = argv[++i];
				break;

			case 'r':	/* enable RPOP3 restarting */
				rflag = 1;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
#if ts$sys
			case 't':	/* task number */
				if(sscanf(argv[++i],"%d",&mailer) <= 0)
					mailer = 0;
				break;
#endif
			case 'v':	/* verbose mode on */
				kb_prnt = 1;
				break;

			case 'y':	/* login timeout flag */
				sscanf(argv[++i],"%d",&yflag);
				lzaptime = 60L * yflag;
				break;

			case 'z':	/* inactivity timeout flag */
				sscanf(argv[++i],"%d",&zflag);
				izaptime = 60L * zflag;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	if (debug)
		kb_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 *  Start listening to the POP3 port
	 */
	while(((rp3cskt = setrp3()) < 0) && !fndbrk) {
		/*
		 * Could not get a socket, wait 5 seconds
		 */
		suspnd(300);
	}

	while(!fndbrk && ev != -1) {
		ev = dosess();
		if(ev==0)
			suspnd(0);
	}

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");


	skclose(rp3cskt);
	skrelease(rp3cskt,1);

	suspnd(0);
	errhandle();

	cd("dk:");

	kb_puts("\r\nEscaping from RPOP3\r\n");
	exit(0);
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving message events
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("dosess(): cl = %d, ev = %d, dat = %u\r\n", cl,ev,dat);
}
#endif

	  switch(cl) {
	    case CONCLASS:
	      /*
	       * RPOP3 Connection socket
	       */
	      rp3d(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  /*
		   * disable automatic restart
		   */
		  rflag = 0;
		  kb_puts("\r\nRPOP3 session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    return(-1);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  rp3d(0);
	}

	return(ev);
}

/*
 *	set up to receive a connection for POP3 commands
 */
int setrp3()
{
	int sknum;

	rfstate = 0;		/* state of the control channel */
	retstate = 0;		/* to emulate a subroutine call */
	rcnt = 0;		/* number of characters from control */
	waitpos = 0;		/* character position */

	/*
	 * Set the default directory
	 */
	cd("dk:");

	/*
	 * Initialize various things
	 */
	Snetinit();

	/*
	 * aflag = 1	indicates attach mode
	 * aflag = 0	indicates listen mode
	 */
	if(aflag) {
		/*
		 * Attach job to connection opened by TCPIP
		 */
		sknum = attach(0,HPOP3);
		if(sknum==-1) {
			fndbrk++;
			return(-1);
		} else {
			Stmrset(ABORTCLASS,CLIENT,sknum,CONNWAITTIME);
		}
	} else {
		/*
		 * Create socket for control connection
		 */
		sknum = socket(0);
		if(sknum==-1)
			return(-1);
		/*
		 * default port
		 */
		listen(sknum,HPOP3);
	}
	return(sknum);

}

/*
 * Dump response to client
 */
VOID rp3resp(s)
register char *s;
{
	skwrite(rp3cskt, s, strlen(s));
	skwrite(rp3cskt, "\r\n", 2);
	skenque(rp3cskt, 1);
	if(mflag) {
		kb_puts(s);
		kbprintf("  {%d}\r\n", strlen(s)+2);
	}
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * This routine is a dumby routine for TSXUTL.C
 * It should never be called, but returns a 1 [ABORT]
 */
int rtresp()
{
	kb_puts("rtresp: This dumby routine should never be called");
	return(1);
}

/*
 * Scan command list for a match
 */
int rpop3cmnd(s)
char *s;
{
	register int i;

	for (i=0; i<R_NULL; i++) {
		if (rp3equal(s,rp3_clist[i])) {
			return(i);
		}
	}
	return(R_NULL);
}

/*
 * POP3 command test
 */
int rp3equal(s,t)
register char *s,*t;
{
	register int i,l;

	l = strlen(t);
	for(i=0; i<l; s++,t++,i++) {
		if(toupper(*s) != *t) {
			return(0);
		}
	}
	return(1);
}

/*
 *	Remote POP3 Server
 */
VOID rp3d(code)
int code;
{
	register struct socket *skt;
	register char *p;
	char word[80];
	int i,icnt,j,rp3cmnd;
	FILE *inp;

	if(rp3cskt < 0)
		return;

	skt = (struct socket *) mapskt(rp3cskt);

	switch(rfstate) {
	case 0:

/*S*/	switch(code) {
	case CONOPEN:
		Stmrunset(ABORTCLASS,CLIENT,rp3cskt);

		/*
		 * Enable Timeout
		 */
		cticks(&skquetime);

		p = skt->tcpout.i.ipsource;

		sprintf(rsp,
	/*Net*/
	"+OK Server %s%s, %s [%d.%d.%d.%d]",
		vrstxt[1]+1, vrstxt[2],
		skt->hostname,
		*(p+0)&0xFF, *(p+1)&0xFF, *(p+2)&0xFF, *(p+3)&0xFF
	/*Net*/
		);
		rp3resp(rsp);

		retstate = 1;
		rfstate = 50;
		waitpos = 0; 
		break;

	case CONCLOSE:
		kb_puts("Connection Closed by Remote Client\r\n");
		rcnt = -1;
		break;

	case CONFAIL:
		kb_puts("Connection Failed\r\n");
		rcnt = -1;
		break;

	default:
		break;
/*S*/	}
		break;

	case 1:
		/*
		 * check for username/password
		 */
		retstate = 1;
		rfstate = 50;  
		waitpos = 0;  
		if(getword(command,word) == FALSE)
			break;

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rp3d(%d): %s %s\r\n", code,word,command);
}
#endif

		strlwr(command);
		rp3cmnd = rpop3cmnd(word);
		switch(rp3cmnd) {
		case R_USER:
			/*
			 * keep user name
			 */
			username[0] = '\0';
			strncat(username,command,USERPASSLEN);
			username[USERPASSLEN] = '\0';
			strlwr(username);
			if((p = checkuser(username)) != NULL) {
				sprintf(rsp,
	/*Net*/
	"+OK User %s valid", username
	/*Net*/
				);
			} else {
				sprintf(rsp,
	/*Net*/
	"-ERR User %s unknown", username
	/*Net*/
				);
			}
			rp3resp(rsp);
			break;

		case R_PASS:
			/*
			 * keep password
			 */
			password[0] = '\0';
			strncat(password,command,USERPASSLEN);
			password[USERPASSLEN] = '\0';
			strlwr(password);
			if (!checkpass(username,password)) {
				sprintf(rsp,
	/*Net*/
	"-ERR User %s password invalid", username
	/*Net*/
				);
				rp3resp(rsp);
				break;
			}

			/*
			 * Log Session
			 */
			sprintf(scratch,
	/*Log*/
	"RPOP3: %s", username
	/*Log*/
				);
			logsession(rp3cskt,scratch);

			/*
			 * Report number of messages
			 * waiting to be read
			 */
			msgcnt = 0;
			msgdel = 0;
			sprintf(scratch,"%-.6s.idx", username);
			if((inp=rtopen(scratch,"rn",0,0)) == NULL) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rp3d(%d): Index file %s not found\r\n", code, scratch);
}
#endif
				/*
				 * Create index file if not opened
				 */
				if(!makidx(username)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rp3d(%d): Index file %s not created\r\n", code, scratch);
}
#endif
					rp3resp(
	/*Net*/
	"-ERR Failed to create index file"
	/*Net*/
					);
					break;
				}
				inp = rtopen(scratch,"rn",0,0);
			}
			if (inp != NULL) {
				fread(&mailidx,sizeof(mailidx),1,inp);
				rtclose(inp);
				mailstat();
				retstate = 2;
				sprintf(rsp,
	/*Net*/
	"+OK User %s has %d message%s",
		username, msgcnt-msgdel, ((msgcnt-msgdel)==1) ? "" : "s"
	/*Net*/
				);
			} else {
				sprintf(rsp,
	/*Net*/
	"-ERR Unable to read mail index file"
	/*Net*/
				);
			}
			rp3resp(rsp);
			break;

		case R_QUIT:
			sprintf(rsp,
	/*Net*/
	"+OK %s RPOP3 Server Closing", skt->hostname
	/*Net*/
			);
			rp3resp(rsp);
			rcnt = -1;
			break;

		default:
			rp3resp(
	/*Net*/
	"-ERR USER and PASS required to activate me"
	/*Net*/
			);
			break;
		}
		break;				
				
	case 2:
		/*
		 * Transaction State
		 */
		retstate = 2;
		rfstate = 50;  
		waitpos = 0;  
		if(getword(command,word) == FALSE)
			break;

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rp3d(%d): %s %s\r\n", code,word,command);
}
#endif

		mesgstat();
		strlwr(command);
		rp3cmnd = rpop3cmnd(word);
		switch(rp3cmnd) {

		case R_STAT:
			sprintf(rsp,
	/*Net*/
	"+OK %d %ld", msgcnt-msgdel, msgspc
	/*Net*/
			);
			rp3resp(rsp);
			break;


		case R_LIST:
			if (command[0] != '\0') {
				sscanf(command,"%d",&i);
				if ((i > 0) && (i <= msgcnt)) {
					if (msgflag[i-1]) {
						sprintf(rsp,
	/*Net*/
	"-ERR Message %d is Marked for Deletion", i
	/*Net*/
						);
					} else {
						sprintf(rsp,
	/*Net*/
	"+OK %d %ld", i, msglength[i-1]
	/*Net*/
						);
					}
				} else {
					sprintf(rsp,
	/*Net*/
	"-ERR Invalid Message Number, %d", i
	/*Net*/
					);
				}
				rp3resp(rsp);
			} else {
				sprintf(rsp,
	/*Net*/
	"+OK %d message%s (%ld octets)",
		msgcnt-msgdel, ((msgcnt-msgdel)==1) ? "" : "s", msgspc
	/*Net*/
				);
				rp3resp(rsp);

				for(i=0; i<msgcnt; i++) {
					if (!msgflag[i]) {
						sprintf(rsp,
	/*Net*/
	"%d  %ld", i+1, msglength[i]
	/*Net*/
						);
						rp3resp(rsp);
					}
				}

				if(msgcnt-msgdel)
					rp3resp(
	/*Net*/
	"."
	/*Net*/
					);
			}
			break;


		case R_DELE:
			if (command[0] != '\0') {
				sscanf(command,"%d",&i);
				if ((i > 0) && (i <= msgcnt)) {
					if (msgflag[i-1] & MSG_DELE) {
						sprintf(rsp,
	/*Net*/
	"-ERR Message %d is Marked for Deletion", i
	/*Net*/
						);
					} else {
						msgflag[i-1] |= MSG_DELE;
						sprintf(rsp,
	/*Net*/
	"+OK Message %d is Marked for Deletion", i
	/*Net*/
						);
						if (i > msglast)
							msglast = i;
					}
				} else {
					sprintf(rsp,
	/*Net*/
	"-ERR Invalid Message Number, %d", i
	/*Net*/
					);
				}
			} else {
				sprintf(rsp,
	/*Net*/
	"-ERR DELE without message number"
	/*Net*/
				);
			}
			rp3resp(rsp);
			break;


		case R_NOOP:
			rp3resp(
	/*Net*/
	"+OK NOOP"
	/*Net*/
			);
			break;


		case R_LAST:
			sprintf(rsp,
	/*Net*/
	"+OK %d  Last message accessed", msglast
	/*Net*/
			);
			rp3resp(rsp);
			break;


		case R_RSET:
			msgcnt = 0;
			msgdel = 0;
			sprintf(scratch,"%-.6s.idx", username);
			if((inp = rtopen(scratch,"rn",0,0)) != NULL) {
				fread(&mailidx,sizeof(mailidx),1,inp);
				rtclose(inp);
				mailstat();
				sprintf(rsp,
	/*Net*/
	"+OK %d message%s (%ld octets)",
		msgcnt-msgdel, ((msgcnt-msgdel)==1) ? "" : "s", msgspc
	/*Net*/
				);
			} else {
				sprintf(rsp,
	/*Net*/
	"-ERR Unable to read mail index file"
	/*Net*/
				);
			}
			rp3resp(rsp);
			break;


		case R_TOP:
			if (getword(command,word)) {
				sscanf(word,"%d",&i);
				if ((i>0) && (i<=msgcnt) && !msgflag[i-1]) {
					if (getword(command,word)) {
						sscanf(word,"%d",&j);
					} else {
						j = 10;
					}
					sprintf(rsp,
	/*Net*/
	"+OK Header followed by %d TOP line%s", j, (j==1) ? "" : "s"
	/*Net*/
					);
					rp3resp(rsp);
					toplines(i,j);
				} else {
					sprintf(rsp,
	/*Net*/
	"-ERR Invalid Message Number, %d", i
	/*Net*/
					);
				}
			} else {
				rp3resp(
	/*Net*/
	"-ERR TOP without message number"
	/*Net*/
				);
			}
			break;


		case R_RETR:
			if (getword(command,word)) {
				sscanf(word,"%d",&i);
				if ((i > 0) && (i <= msgcnt)) {
					if (msgflag[i-1] & MSG_DELE) {
						sprintf(rsp,
	/*Net*/
	"-ERR Message %d Flagged for Deletion", i
	/*Net*/
						);
						rp3resp(rsp);
					} else {
						sprintf(rsp,
	/*Net*/
	"+OK %ld octets", msglength[i-1]
	/*Net*/
						);
						rp3resp(rsp);
						toplines(i,32767);
						msgflag[i-1] |= MSG_RETR;
					}
				} else {
					sprintf(rsp,
	/*Net*/
	"-ERR Invalid Message Number, %d", i
	/*Net*/
					);
					rp3resp(rsp);
				}
			} else {
				rp3resp(
	/*Net*/
	"-ERR RETR without message number"
	/*Net*/
				);
			}
			break;


		case R_XTND:
			if(getword(command,word) == FALSE) {
				rp3resp(
	/*Net*/
	"-ERR XTND Without Option"
	/*Net*/
				);
				break;
			}

			if (streq(word,"xmit")) {
				/*
				 * Open mail file
				 */
				if (!mailfile()) {
					rp3resp(
	/*Net*/
	rsp
	/*Net*/
					);
				} else {
					rp3resp(
	/*Net*/
	"+OK"
	/*Net*/
					);
					fprintf(mailfh,
	/*File*/
	"Received: by %s  (%s%s)\r\n", skt->hostname, vrstxt[1]+1, vrstxt[2]
	/*File*/
					);
					fprintf(mailfh,
	/*File*/
	"Date: %s\r\n", datime()
	/*File*/
					);
					fprintf(mailfh,
	/*File*/
	"Message-Id: %s @%s\r\n", emailfl, skt->hostname
	/*File*/
					);
					retstate = 2;
					rfstate = 60;
					waitpos = 0;
				}
				break;
			}

			sprintf(rsp,
	/*Net*/
	"-ERR XTND With Unknown Option '%s'", word
	/*Net*/
			);
			rp3resp(rsp);
			break;


		case R_QUIT:
			for(i=0; i<msgcnt; i++) {
				if (msgflag[i] & MSG_DELE) {
					sprintf(scratch,"%-.6s.%03d",
						username,msgindex[i]);
					delete(lclfile(scratch));
					modidx(username,msgindex[i],
						CLR_RCVD|CLR_READ);
				}
			}
			sprintf(rsp,
	/*Net*/
	"+OK %s RPOP3 Server Closing (%d message%s left)",
		skt->hostname, msgcnt-msgdel, ((msgcnt-msgdel)==1) ? "" : "s"
	/*Net*/
			);
			rp3resp(rsp);
			rcnt = -1;
			break;

		default:
			sprintf(rsp,
	/*Net*/
	"-ERR Unknown command %s", word
	/*Net*/
			);
			rp3resp(rsp);
			break;
		}
		break;

	case 50:
		/*
		 * subroutine to wait for end of line
		 */
		icnt = 0;
		while(	0 < (rcnt = skread(rp3cskt,&command[waitpos],1))) {
			icnt = 1;
			if(command[waitpos] == '\n') {
				/*
				 * find end of string
				 */
				while (	(command[waitpos] < 33) &&
					(waitpos >= 0) )
					waitpos--;
				/*
				 * put in terminator
				 */
				command[++waitpos] = '\0';
				rfstate = retstate;
				break;
			} else {
				if(waitpos < COMMAND-1)
					waitpos += rcnt;
			}
		}
		if (icnt) {
			skdeque(rp3cskt);
			suspnd(-1);
		}
		break;

	case 60:
		/*
		 * subroutine to write out mail data
		 */
		icnt = 0;
		while(	0 < (rcnt = skread(rp3cskt,&command[waitpos],1))) {
			icnt = 1;
			if(command[waitpos] == '\n') {
				if(waitpos==2 && strneq(command,".\r\n",3)) {
					if( (mailfh != NULL) &&
					    !rtclose(mailfh) ) {
						rp3resp(
	/*Net*/
	"+OK Message Saved"
	/*Net*/
						);
						if (mailer) {
							cl_xmit(TASKCLASS,
								STARTJOB,
								mailer);
						}
					} else {
						rp3resp(
	/*Net*/
	"-ERR Disk write error, probably disk full."
	/*Net*/
						);
					}
					mailfh = NULL;
					rfstate = retstate;
					command[0] = '\0';
					waitpos = 0;
					break;
				}
				/*
				 * skip . if two .'s
				 * at beginning of line
				 */
				if(strneq(command,"..",2)) {
					p = command+1;
					i = waitpos;
				} else {
					p = command;
					i = waitpos+1;
				}

				/*
				 * write mail data to file
				 */
				if(mailfh != NULL && !fwrite(p,1,i,mailfh)) {
					/*
					 * disk full err
					 */
					rtclose(mailfh);
					mailfh = NULL;
				}
				waitpos = 0;
				break;
			} else {
				if(waitpos < COMMAND-1)
					waitpos += rcnt;
			}
		}
		if (icnt) {
			skdeque(rp3cskt);
			suspnd(-1);
		}
		break;


	default:
		break;
	}

	if(retstate == 1) {
		/*
		 * Process Login Timeout
		 */
		if((yflag != 0) &&
		   (skquetime != 0L) &&
		   (elapsed(skquetime) > lzaptime)) {
			rp3resp(
	/*Net*/
	"-ERR Login Timeout"
	/*Net*/
				);
			rcnt = -1;
		}
	}
	if(retstate >= 2) {
		/*
		 * Process Inactivity Timeout
		 */
		if((zflag != 0) &&
		   (skquetime != 0L) &&
		   (elapsed(skquetime) > izaptime)) {
			rp3resp(
	/*Net*/
	"-ERR Inactivity Timeout"
	/*Net*/
				);
			rcnt = -1;
		}
	}

	if(rcnt < 0) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rp3d(%d): rfstate = %d, rcnt = %d\r\n",
		code,rfstate,rcnt);
}
#endif
		rcnt = 0;
		if(rp3cskt >= 0) {
			sksendwait(rp3cskt,(long) SENDWAIT);
			skclose(rp3cskt);
			rp3cskt = skrelease(rp3cskt,1);
		}
		if(rflag && !aflag) {
			/*
			 *  Start listening to the POP3 port
			 */
			while((rp3cskt = setrp3()) < 0 && !fndbrk) {
				/*
				 * Could not get a socket, wait 5 seconds
				 */
				suspnd(300);
			}
		} else {
			fndbrk = 1;
		}
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 79
		 */
		q = stptok(p, word, 79, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  checkuser (us)
 *
 *  Check the password file for the users' name.
 *  An inaccessable password file results in an invalid return.
 *
 *  If the user is found then
 *	(1)	the mailbox path is set, else
 *	(2)	the default path is set, else
 *	(3)	invalid return
 *
 *  An invalid return occurrs if the user is not found or the
 *  directory path is invalid.
 *
 *  Returns valid(char*)/invalid(NULL)
 */
char *checkuser(us)
char *us;
{
	if(NULL==(passfh = rtopen(passfl,"rn",0,0))) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkuser(): no passfl: %s\r\n", passfl);
}
#endif
		return(NULL);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,passfh)) {
		/*
		 * does user exist ?
		 */
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkuser(): us = '%s', user = '%s'\r\n", us,user.username);
}
#endif
		if(!strncmp(us,&user.username,USERPASSLEN)) {
			/*
			 * User found
			 */
			rtclose(passfh);
			getpath(pathname);
			/*
			 * Set Users Mailbox Directory
			 */
			if(user.mailbox.path[0]!='\0' &&
				!cd(&user.mailbox.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkuser(): mailbox directory: %s\r\n", user.mailbox.path);
}
#endif
				return(user.mailbox.path);
			} else
			/*
			 * Set Users default directory
			 */
			if(user.defdir.path[0]!='\0' &&
				!cd(&user.defdir.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkuser(): default directory: %s\r\n", user.defdir.path);
}
#endif
				return(user.defdir.path);
			}
			cd(pathname);
			return(NULL);
		}
	}
	rtclose(passfh);
	return(NULL);
}

/*
 *  checkpass ( us, ps )
 *
 *  If the user/password are validated then
 *  returns valid(1) else invalid(0).
 */
int checkpass(us,ps)
char *us,*ps;
{
	/*
	 * does password check ?
	 */
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("checkpass(): us = '%s', pass = '%s'\r\n", us,ps);
}
#endif
	if(!strncmp(us,&user.username,USERPASSLEN) &&
		(PASSNOTREQUIRED & user.userflag[0]  ||
			Scompass(ps,&user.password))) {
		return(1);
	}
	return(0);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
char *ps,*en;
{
	int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

/*
 *  Mailstat()
 *
 *  Find first MAXMSG files.
 *  Read first MAXMSG files to determine lengths.
 */
VOID
mailstat()
{
	int	i,j,k,l;
	long	len;
	FILE *	inp;

	msgcnt = 0;

	for(i=0; i<1000; i++) {
		k = i >> 3;
		l = 1 << (i & 0x0007);
		if(mailidx.rcvd[k] & l) {
			msgindex[msgcnt] = i;
			msglength[msgcnt] = 0L;
			msgflag[msgcnt] = 0;
			msgcnt += 1;
		}
		if (msgcnt == MAXMSG)
			break;
	}

	/*
	 * Read selected mail files
	 */
	for(i=0; i<msgcnt; i++) {
		sprintf(scratch,"%-.6s.%03d", username,msgindex[i]);
		if((inp = rtopen(scratch,"r",0,0)) == NULL) {
			modidx(username,msgindex[i],CLR_RCVD|CLR_READ);
			for(j=i; j<msgcnt-1; j++) {
				msgindex[j] = msgindex[j+1];
			}
			msgcnt -= 1;
		} else {
#ifdef	MSG_FAST
			len = inp->io_size * 512L;
			msglength[i] = msglength[i] + len;
#else
			while(fgetss(scratch,sizeof(scratch)-1,inp) != NULL) {
			    msglength[i] = msglength[i] + strlen(scratch) + 2;
			}
#endif
			rtclose(inp);
		}
	}

	/*
	 * Find total space used by messages
	 */
	msgspc = 0L;

	for(i=0; i<msgcnt; i++) {
		msgspc = msgspc + msglength[i];
	}

	/*
	 * No deleted messages
	 */
	msgdel = 0;

	/*
	 * Last message accessed
	 */
	msglast = 0;
}

/*
 *  mesgstat()
 *
 *  Find current message status
 */
VOID
mesgstat()
{
	int	i;

	msgdel = 0;
	msgspc = 0L;

	for(i=0; i<msgcnt; i++) {
		if(msgflag[i] & MSG_DELE) {
			msgdel += 1;
		} else {
			msgspc = msgspc + msglength[i];
		}
	}
}

/*
 *  toplines()
 *
 *  Send the mesg file header followed by n lines of text.
 */
int
toplines(i,n)
int	i,n;
{
	FILE *	inp;
	int finished,hdrdone;

	sprintf(scratch,"%-.6s.%03d", username,msgindex[i-1]);
	if((inp = rtopen(scratch,"r",0,0)) == NULL) {
#ifdef	DEBUGOPTION
if(debug&0x10) {
	printf("toplines(): Unable to open message file %s\r\n", scratch);
}
#endif
		/*
		 * End of Message
		 */
		rp3resp(".");
		return;
	}

	/*
	 * Transfer Message File
	 */
	finished = FALSE;
	hdrdone = FALSE;
	rsp[0] = '\.';
	do {
		if(skroom(rp3cskt) > LOWWATER) {
			if(fgetss(rsp+1,RSPSTRING-2,inp) != NULL) {
				if(rsp[1] != '\.') {
					rp3resp(rsp+1);
				} else {
					rp3resp(rsp);
				}
				if (rsp[1] == '\0') {
					hdrdone = TRUE;
				}
				if (hdrdone == TRUE) {
					if (n) {
						n -= 1;
					} else {
						finished = TRUE;
					}
				}
			} else {
				finished = TRUE;
			}
		} else {
			suspnd(6);
		}
	} while(finished != TRUE && !sktest(rp3cskt));
	rtclose(inp);
	/*
	 * End Message
	 */
	rp3resp(".");
}

/*
 * Open a unique mail file in the users mail directory
 */
int
mailfile()
{
	int idx;

	/*
	 * The mailidx file must be locked to ensure
	 * no other process has simultaneous access to
	 * the file while the index is being updated.
	 * If TSX+ is not sysgened for shared-file
	 * record locking then record locking does not occur.
	 */
	idx = modidx(username,0,INC_MLTMP);
	if(!idx) {
		/*
		 * Create index file if not opened
		 */
		if(!makidx(username)) {
			sprintf(rsp,"-ERR Failed to create index file");
			return(0);
		} else {
			idx = modidx(username,1,SET_MLTMP);
			if(!idx) {
			    sprintf(rsp,"-ERR Failed to update index file");
			    return(0);
			}
		}
	}

	/*
	 * Create a unique file name for mail data
	 */
	sprintf(mailfl,"ml%-.4s.%03d",username,idx);
	sprintf(scratch,"%sml%-.4s.%03d", getdef(), username, idx);
	expand(emailfl,scratch);

	/*
	 * Open mail file
	 */
	if((mailfh = rtopen(mailfl,"wn",0,0)) == NULL) {
		sprintf(rsp,"-ERR Failed to open file");
		return(0);
	}

	return(1);
}
                                                                                                 