/* mailc.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "os.h"
#include "vmail.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "mailpi.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "inicli.h"
#include "suspnd.h"
#include "usrblk.h"
#include "rcdlck.h"
#include "mailbx.h"
#include "datime.h"
#include "cticks.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();
extern	int	finduniq();
extern	int	toggle();
extern	VOID	prnthelp();
extern	int	mailpi();
extern	VOID	more();
extern	VOID	mailexit();
extern	int	question();
extern	int	rtresp();
extern	int	tstbrk();
extern	int	loadpath();
extern	VOID	lcd();
extern	VOID	ldelete();
extern	VOID	ldelfil();
extern	VOID	lls();
extern	VOID	lmkdir();
extern	VOID	lprotect();
extern	VOID	setfilp();
extern	VOID	lrename();
extern	VOID	newname();
extern	VOID	lrmdir();
extern	VOID	rmdir();
extern	VOID	lunprotect();
extern	VOID	clrfilp();
extern	VOID	lsterr();
extern	int	mailgets();
extern	int	getword();
extern	int	checkusps();
extern	int	Scompass();
extern	VOID	strlwr();
extern	int	strmatch();
extern	VOID	getinfo();
extern	int	wrtmsg();
extern	VOID	sendmail();
extern	int	send();
extern	VOID	lsendmail();
extern	int	lsend();
extern	VOID	scrnview();
extern	VOID	mailrsp();
extern	int	mailopen();
extern	int	mailreplies();
extern	int	rgetline();
extern	int	checkevent();
#endif

extern	char	*stptok();
extern	char	*stpblk();

/*
 *	Defines
 */

#define FALSE		 0
#define TRUE		 1
#define SUCCESS		 2
#define HAVEDATA	 4
#define ERROR	   	-1
#define NONE	   	-2
#define ABORT	   	-3
#define INCOMPLETE	-4
#define AMBIGUOUS	-5

#define BUFFERS		1024
#define	RSPSTRING	200
#define GENBUFR		200

/*
 *	Global Variables For MAIL Control Channel
 */

extern
int	pswdreqd;		/* password required */

extern
int	fromtty;		/* tty / file input flag */

extern
int	hash,			/* hash mark flag */
	verbose,		/* print mail transactions */
	prompt,			/* prompt for answer */
	wild,			/* wild cards enabled */
	uflag,			/* username / password flag */
	lflag,			/* local mail flag */
	msgcnt,			/* number of unread mail messages */
	msgflag,		/* created message flag */
	mailcskt;		/* socket for outgoing mail */

extern
int	zflag;			/* connection timeout flag */

extern
long	izaptime;		/* connection zap time in ticks */

/*
 *	Global Buffers / Pointers
 */

#define	INFO_LEN	(80)
#define	HDR_R		(0x0001)
#define	HDR_D		(0x0002)
#define	HDR_F		(0x0004)
#define	HDR_M		(0x0008)
#define	HDR_T		(0x0010)
#define	HDR_S		(0x0020)

extern
struct mesginfo {
	char	rcvd[INFO_LEN];
	char	date[INFO_LEN];
	char	from[INFO_LEN];
	char	mesgid[INFO_LEN];
	char	to[INFO_LEN];
	char	to_dest[INFO_LEN];
	char	to_user[INFO_LEN];
	char	to_mach[INFO_LEN];
	char	to_host[INFO_LEN];
	char	subject[INFO_LEN];
	char	filename[INFO_LEN];
	char	expanded[INFO_LEN];
};

extern
struct mesginfo
	header;			/* message header information */

extern
struct userblock
	user;			/* usernames / passwords / mailboxes */

extern
char	xs[BUFFERS];		/* buffer space for incoming data */
				/* and TSXUTL.C command files */

extern
char	ml_cmnd[GENBUFR],		/* command string */
	scratch[GENBUFR],		/* scratch string */
	rsp[RSPSTRING],			/* response string */
	filespec[GENBUFR],		/* current file filespec */
	mailspec[GENBUFR],		/* mailbox file filespec */
	hostname[INFO_LEN],		/* local host name */
	username[USERPASSLEN+2],	/* username */
	password[USERPASSLEN+2],	/* password */
	mailpath[DIRPATHLEN+2],		/* mailbox path */
	lclmpath[DIRPATHLEN+2],		/* local mail path */
	uspspath[DIRPATHLEN+2],		/* path returned by checkusps */
	defpath[GENBUFR],		/* default path */
	pathname[GENBUFR];		/* space to keep path name */

extern
char *	ipadd;				/* intermediate IP Address */

extern
char *	pass;				/* password file */

extern
char	fromfile[20];			/* command file */

extern
FILE	*fromfp;			/* command file */


/*
 *  checkusps ( us, ps, pflag )
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password are validated then
 *  the mail directory is accessed else the
 *  default directory is accessed. An inaccessable
 *  mail and default directory results in an invalid return.
 *
 *  Returns valid(1)/invalid(0)
 */
int checkusps(us,ps,pflag)
char *us,*ps;
int pflag;
{
	FILE *fp;
	
	if(NULL==(fp = rtopen(pass,"rn",0,0))) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): password file not found: %s\r\n", pass);
}
#endif
		return(0);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does username / password check ?
		 */
		if(!strncmp(us,&user.username,USERPASSLEN) &&
				(!pflag ||
				user.userflag[0]&PASSNOTREQUIRED ||
				Scompass(ps,&user.password))
			) {
			rtclose(fp);
			/*
			 * User found
			 */
			getpath(pathname);
			/*
			 * Set Users Mailbox Directory
			 */
			if(user.mailbox.path[0]!='\0' &&
				!cd(&user.mailbox.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): mailbox directory: %s\r\n", user.mailbox.path);
}
#endif
				getpath(uspspath);
				cd(pathname);
				return(1);
			} else
			/*
			 * Set Users default directory
			 */
			if(user.defdir.path[0]!='\0' &&
				!cd(&user.defdir.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): default directory: %s\r\n", user.defdir.path);
}
#endif
				getpath(uspspath);
				cd(pathname);
				return(1);
			}
			cd(pathname);
			return(0);
		}
	}
	rtclose(fp);
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): Username not found.\r\n");
}
#endif
	return(0);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
register char *ps,*en;
{
	register int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

int strmatch(s,t)
char *s,*t;
{
	register int i,j;

	j = strlen(s);
	for(i=0; i<j; i++) {
		if(tolower(*s++) != tolower(*t++))
			return(0);
	}
	return(1);
}
                                                                                                                                                                                                                                                                                