/* mailbx.c */

#include <stdio.h>

#include "tsxutl.h"
#include "rcdlck.h"
#include "mailbx.h"

struct mailrecord
	mailidx;		/* users' mailbox index file */

/*
 * modidx
 *
 * Set / Clear the bits in the index file
 * Update the index counter in the index file
 *
 * Return the current mailid index for the file or 0
 * if the file could not be opened.
 *
 * Return the current mailex index for the file or 0
 * if the file could not be opened.
 */
int modidx(usrnam,idx,op)
char *usrnam;
register int idx,op;
{
	FILE *fp;
	char str[12];
	register int i,j;

	/*
	 * The mailidx file must be locked to ensure
	 * no other process has simultaneous access to
	 * the file while the file is being updated.
	 * If TSX+ is not sysgened for shared-file
	 * record locking then record locking does not occur.
	 */
	sprintf(str,"%-.6s.idx", usrnam);
	if((fp = rtopen(str,"rn",0,0)) != NULL) {
		frcdlock(0,fp);
		frcdread(&mailidx,0,fp);
		if(op&SET_MLID) {
			mailidx.mailid = idx;
		}
		if(op&INC_MLID) {
			idx = mailidx.mailid += 1;
			if(idx > 999)
				idx = mailidx.mailid = 1;
		}
		if(op&SET_MLTMP) {
			mailidx.mailtmp = idx;
		}
		if(op&INC_MLTMP) {
			idx = mailidx.mailtmp += 1;
			if(idx > 999)
				idx = mailidx.mailtmp = 1;
		}
		i = idx >> 3;
		j = 1 << (idx & 0x0007);
		if(op&SET_RCVD) {
			mailidx.rcvd[i] |= j;
		}
		if(op&CLR_RCVD) {
			mailidx.rcvd[i] &= ~j;
		}
		if(op&SET_READ) {
			mailidx.read[i] |= j;
		}
		if(op&CLR_READ) {
			mailidx.read[i] &= ~j;
		}
		frcdwrite(&mailidx,0,fp);
		frcdunlock(0,fp);
		rtclose(fp);
	} else {
		return(0);
	}
	if(op & (SET_MLTMP | INC_MLTMP)) {
		return(mailidx.mailtmp);
	} else {
		return(mailidx.mailid);
	}
}

/*
 * makidx
 *
 * Return 1 if index file created, else 0.
 */
int makidx(usrnam)
char *usrnam;
{
	FILE *fp;
	char *p,str[12];
	register int i;

	sprintf(str,"%-.6s.idx", usrnam);
	if((fp = rtopen(str,"wn",0,0)) == NULL) {
		return(0);
	} else {
		p = &mailidx;
		for(i=0; i<sizeof(mailidx); i++) {
			*p++ = '\0';
		}
		i  = !fwrite(&mailidx,sizeof(mailidx),1,fp);
		i |= rtclose(fp);
		return(i ? 0 : 1);
	}
}

/*
 * clridx
 *
 * Clear the index file records
 */
int clridx(usrnam,op)
char *usrnam;
register int op;
{
	FILE *fp;
	char str[12];
	register int i;

	/*
	 * The mailidx file must be locked to ensure
	 * no other process has simultaneous access to
	 * the file while the file is being updated.
	 * If TSX+ is not sysgened for shared-file
	 * record locking then record locking does not occur.
	 */
	sprintf(str,"%-.6s.idx", usrnam);
	if((fp = rtopen(str,"rn",0,0)) != NULL) {
		frcdlock(0,fp);
		frcdread(&mailidx,0,fp);
		if(op&CLR_MLID) {
			mailidx.mailid = 0;
		}
		if(op&CLR_MLTMP) {
			mailidx.mailtmp = 0;
		}
		if(op&CLR_RCVD) {
			for (i=0; i<sizeof(mailidx.rcvd); i++) {
				mailidx.rcvd[i] = 0;
			}
		}
		if(op&CLR_READ) {
			for (i=0; i<sizeof(mailidx.read); i++) {
				mailidx.read[i] = 0;
			}
		}
		frcdwrite(&mailidx,0,fp);
		frcdunlock(0,fp);
		rtclose(fp);
		return(1);
	} else {
		return(0);
	}
}

                                                                                                                                                                                                                                                                                                                                                                                                                                     