/* ldisks.c */

#define	DISKMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vldisk.h"
#include "ldisks.h"
#include "tsxutl.h"
#include "rtfile.h"
#include "kbdutl.h"


static char *usetxt[] = {
       "",
       "   LDISKS [?] [-f filename] [dev1] [dev2] ...",
       "	?		List this Help Text and Exit LDISKS",
       "	f  filename	Output File Name",
       "",
	0
	};


#define	ABORT	(-1)

int	tljobn;				/* unused / required by TSXUTL */
char	xs[1];				/* unused / required by TSXUTL */

struct directory {
	struct directory *nxtdir;
	struct directory *subdir;
	char dirname[100];
	int size;
};

struct directory *dirp = NULL;

static char disksfile[80] = { '\0' };
static FILE *disksfp = NULL;


/*
 * main - main procedure.  Displays opening message,
 *	  parses arguments, reads user commands
 *	  executes them, and cleans up.
 */

main(argc,argv)
int argc;
char *argv[];
{
	int c;
	register int i,j,k;
	struct directory *p;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(vrstxt);
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;

			case 'f':	/* output filename */
				strcpy(disksfile,argv[++i]);
				/*
				 * open output file
				 */
				if(*disksfile != '\0') {
					disksfp = fopen(disksfile,"w");
				}
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		} else {
			/*
			 * Create device list
			 */
			devlist(argv[i]);
		}
	}
	if(disksfp == NULL)
		disksfp = stdout;

	/*
	 * Scan specified device/directories
	 */
	dirscan();

	/*
	 * Output header
	 */
	if(dirp != NULL) {
		fprintf(disksfp,"Logical Subdirectories for");
		p = dirp;
		while(p != NULL) {
			if(p->nxtdir != NULL) {
				fprintf(disksfp," %s,", p->dirname);
			} else {
			    if(p == dirp) {
				fprintf(disksfp," %s\r\n", p->dirname);
			    } else {
				fprintf(disksfp," and %s\r\n", p->dirname);
			    }
			}
			p = p->nxtdir;
		}
		/*
		 * Print Devices with subdirectories
		 */
		dprint();
	}

	/*
	 * exit ldisks
	 */
	fclose(disksfp);

	cd("dk:");
	exit(0);
}

/*
 *	Error list routine required by TSXUTL
 */

VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 *	Dumby routine required by TSXUTL
 */
int rtresp()
{
	return(1);
}

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}

/*
 * Create the structure and initialize
 */
struct directory *createstruct()
{
	register struct directory *p;

	p = (struct directory *) malloc(sizeof(struct directory));
	p->nxtdir = NULL;
	p->subdir = NULL;
	p->dirname[0] = '\0';
	return(p);
}

/*
 * Add a device to the list
 */
VOID devlist(s)
char *s;
{
	register struct directory *p,*q;

	/*
	 * Create the structure and initialize
	 */
	p = createstruct();
	strncpy(p->dirname,s,100);
	p->dirname[99] = '\0';

	/*
	 * Find end of list and append new device
	 */
	if(dirp == NULL) {
		dirp = p;
	} else {
		q = dirp;
		while(q->nxtdir != NULL) {
			q = q->nxtdir;
		}
		q->nxtdir = p;
	}
}

/*
 * Scan for directories
 */
VOID dirscan()
{
	register struct directory *p;

	p = dirp;
	while(p != NULL) {
		if(cd(p->dirname)) {
			lsterr();
		} else {
			rcsearch(p);
		}
		cd("dk:");
		p = p->nxtdir;
	}
}

VOID rcsearch(x)
struct directory *x;
{
	register struct directory *p,*q;
	char path[106],npath[106];

	/*
	 * Find all subdirectories in this directory
	 */
	p = x;
	q = fnddir();
	p->subdir = q;
	/*
	 * Find all directories in the subdirectories
	 */
	getpath(path);
	while(q != NULL) {
		sprintf(npath,"/%s", q->dirname);
		if(cd(npath)) {
			lsterr();
			cd(path);
		} else {
			rcsearch(q);
			cd("..");
		}
		q = q->nxtdir;
	}
	lsterr();
}

/*
 * Find directories
 */
struct directory *fnddir()
{
	register struct directory *p,*q,*r;
	char fillst[16];
	char dblk[8];
	char *fl;
	int  i,ldunit;
	
	if(subdlevl >= subdnest) {
		return(NULL);
	}

	/*
	 * no directories yet
	 */
	p = NULL;

	/*
	 * no names expanded yet
	 */
	fl = NULL;

	do {

	/*
	 * get matching file
	 */
	if((fl = filnam("*.dsk",fl,1)) == NULL) {
		errstr[0] = '\0';
		continue;
	}
	strcpy(fillst,fl);

	/*
	 * verify a directory
	 */
	r50blk(dblk,fillst,getdef());
	ldunit = subdlevl + subdbase;
	dlogcl(ldunit);
	if(!(i = mlogcl(ldunit,dblk,0))) {
		i = vlogcl(ldunit);
		dlogcl(ldunit);
	}
	if(i)
		continue;

	/*
	 * process file
	 */
	q = createstruct();
	rtparse(fillst);
	sprintf(q->dirname,"%s", rtname());
	q->size = filsiz();

	/*
	 * Find end of list and append new directory
	 */
	if(p == NULL) {
		p = q;
	} else {
		r = p;
		while(r->nxtdir != NULL) {
			r = r->nxtdir;
		}
		r->nxtdir = q;
	}

	} while(fl != NULL);

	if(fl != NULL)
		lastname();

	return(p);
}

struct directory *next[8];
int level = 0;

VOID dprint()
{
	register struct directory *p;

	p = dirp;
	while(p != NULL) {
		fprintf(disksfp,"\r\n      %s\r\n", p->dirname);
		rcprint(p->subdir);
		p = p->nxtdir;
	}
	fprintf(disksfp,"\r\n");
}


VOID rcprint(x)
struct directory *x;
{
	register int i,j;
	char st[100];

	while(x != NULL) {

		next[level] = x->nxtdir;

		*st = '\0';
		for(i=0; i<=level; i++) {
			j = next[i] != NULL;
			if(i==level) {
				strcat(st,"        `-");
			} else {
				if(j) {
					strcat(st,"        | ");
				} else {
					strcat(st,"          ");
				}
			}
		}
		fprintf(disksfp,"%s-> %6.6s[%5u]\r\n", st,x->dirname,x->size);

		if(x->subdir != NULL) {
			level++;
			rcprint(x->subdir);
			level--;
		}
		x = x->nxtdir;
	}
}
                                                                                                                                                                                                             