/* abrtjb.c */

/*
 *  Includes
 */
#include <stdio.h>
#include "os.h"
#include "evtdef.h"
#include "cldrvr.h"
#include "suspnd.h"
#include "termio.h"

static int jobnum = 0;		/* default to no job */

static char *usetxt[] = {
       "",
       "  ABRTJB [?] jobnum, ...",
       "	?               List the Help Text and Exit ABRTJB",
       "	jobnum		TCP/IP related job(s) to abort",
       0
       };

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		kb_puts(*dp);
		kb_nline();
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	register int i,j,k;
	char c;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			printf("Unrecognized option -%c ignored\r\n", c);
			k++;
		    }
		} else {
			if(sscanf(argv[i],"%d",&jobnum) <= 0) {
				/*
				 * Request for complete abort not allowed
				 */
				printtxt(usetxt);
				exit(0);
			} else {
				/*
				 * Request TCPIP to abort selected client
				 */
#if rt$sys
				++jobnum;
#endif
				cl_xmit(ABORTCLASS,CLIENT,jobnum);
			}
		}
	}
}
                                                                                                                                                                                                                                               