{$I+,Y-}
program word_break;


{
  Computer Detection of Typographical Errors
	Word Break-Out

  		Author : C. E. Chew
  		Date   : April 1985

 Link with base of 1000 octal.
}

const
  stringlength = 20;

  version = 'WBREAK  1.0  May 1985';
  wbreak = "WBREAK";

  debug = false;

  space = ' ';
  apostrophe = '''';
  semicolon = ';';
  nul = chr(0);
  lf = chr(10);

  inpx = 2;
  outx = 3;

type
  relation = (lt, le, eq, ge, gt, ne);
  string = array [1..stringlength+1] of char;

var
  inp, out : text;
  firstonline : boolean;
  word : string;



procedure rerun; external;



function initialise:boolean;

begin
  initialise := false;
  if argc = 4 then begin
    reset(inp, argv[inpx]@, "TXT");
    rewrite(out, argv[outx]@, "WRD");
    firstonline := true;
    initialise := true
  end
end;



function getword(var w : string):boolean;

var
  i : integer;
  ch : char;

procedure getchar(var ch : char);

begin
  if eof(inp) then
    ch := nul
  else begin
    if firstonline then begin
      while inp@ = semicolon do
	readln(inp);
      firstonline := false
    end;
    if eoln(inp) then
      firstonline := true;
    read(inp, ch);
    if (ch >= 'A') and (ch <= 'Z') then
      ch := chr(ord(ch) + (ord('a') - ord('A')))
    else if ch < space then
      ch := space
  end
end;

begin
  getword := false;
  getchar(ch);
  while (ch <> nul) and ((ch < 'a') or (ch > 'z')) do
    getchar(ch);
  if ch <> nul then begin
    i := 0;
    while (((ch >= 'a') and (ch <= 'z')) or (ch = apostrophe))
	  and (i < stringlength) do begin
      if ch = apostrophe then
	ch := '{';
      i := i + 1;
      w[i] := ch;
      getchar(ch)
    end;
    w[i+1] := nul;
    getword := true;
    if debug then
      writeln('Word : ', w)
  end
end;



procedure putword(var w : string);

begin
  writeln(out, w)
end;


begin
  if not initialise then begin
    writeln(version);
    writeln;
    writeln('$options input output');
    writeln;
    writeln;
    rerun
  end
  else begin
    while getword(word) do
      putword(word)
  end
end.
                                                                                                                                                                                                                                                                                                                                                                                                      