program maze;
{ NBS PASCAL Version  1.6e

      Version 7a
      Earl Chew

      Original algorithm from 'BYTE' May 1982
           T.E. Neldner
}

Const
  frontier=chr(0);
  open=chr(1);
  open_down=chr(2);
  open_right=chr(3);
  closed=chr(4);

  maze_sign='o';

  base_level=8;
  cell_type=3;

  untraversed=chr(0*base_level);
  traversing=chr(1*base_level);
  traversed=chr(2*base_level);
  over_step=chr(3*base_level);

  up_bias=1;
  down_bias=1;
  left_bias=2;
  right_bias=2;

  bias_count=up_bias+down_bias+left_bias+right_bias
	     -min(up_bias,min(down_bias,min(left_bias,right_bias)));

  printer_width=132;
  printer_height=66;
  first_page_height=61;

  block_width=(printer_width-1) div 3;
  form_feed=chr(12);

  version='7a';

Type
  maze_cell=char;
  bias_counter=1..bias_count;
  direction_offset=-1..1;
  maze_offset=0..maxint;
  corridor=record
             maze:array [maze_offset] of maze_cell
           end;
  compass=(upwards,downwards,port,starboard,nowhere);
  direction_probe=upwards..starboard;
  vector_array=array [direction_probe] of compass;
  offset_array=array [direction_probe] of direction_offset;
  direction_array=array [compass] of compass;
  bias_array=array [direction_probe] of integer;
  paper_orientation=(top,bottom);
  cell_status=(blocked,back_track,traversable,found_exit);
  maze_design_array=array [0..cell_type] of array [1..2] of char;

Var
  printer:text;
  grid:@corridor;
  seed:integer;
  breadth,depth:integer;
  width,height:integer;
  error:boolean;
  start,stop:integer;
  right_hand_margin:integer;
  reference:boolean;
  copies,number_of_mazes,number_of_solutions,maze_count:integer;

Const
  vertical_offset=offset_array(-1,1,0,0);
  horizontal_offset=offset_array(0,0,-1,1);
  opposite_direction=direction_array(downwards,upwards,starboard,port,nowhere);
  maze_design=maze_design_array('  ',(maze_sign,maze_sign),'  ',(maze_sign,maze_sign));
  bias=bias_array(up_bias,down_bias,left_bias,right_bias);


Procedure mark_cell(h:maze_offset; mark:maze_cell);
begin
  grid@.maze[h]:=chr(ord(grid@.maze[h]) mod base_level+ord(mark));
end;


Function reconnoitre(i,j:maze_offset; Var heading:compass; previous_heading:compass):cell_status;
Const
  vertical_test_offset=offset_array(-1,0,0,0);
  horizontal_test_offset=offset_array(0,0,-1,0);
Var
  status:cell_status;
  k:direction_probe;
  test_cell,c1,t1:maze_cell;
  go_back:compass;
  h_cell,h_test:maze_offset;
  over_step_table:array [1..3] of maze_offset;
  over_step_count:0..3;
begin
  status:=blocked;

  if (i=height) and (j=stop) then
    status:=found_exit
  else begin
    over_step_count:=0;
    go_back:=opposite_direction[previous_heading];

    for k:=upwards to starboard do begin
      test_cell:=chr(ord(k) div 2 + ord(open_down));
      h_cell:=(i+vertical_offset[k])*breadth+j+horizontal_offset[k];
      h_test:=(i+vertical_test_offset[k])*breadth+j+horizontal_test_offset[k];
      t1:=chr(ord(grid@.maze[h_test]) mod base_level);
      c1:=chr(ord(grid@.maze[h_cell]) div base_level * base_level);

      if (t1=test_cell) or (t1=open) then begin
	if c1=untraversed then begin
	  if status<>traversable then begin
	    status:=traversable;
	    heading:=k
	  end
	end
	else begin
	  if c1=traversing then begin
	    if go_back<>nowhere then begin
	      if go_back<>k then begin
		mark_cell(h_cell,over_step);
		over_step_count:=over_step_count+1;
		over_step_table[over_step_count]:=h_cell
	      end
	      else begin
		if status=blocked then begin
		  status:=back_track;
		  heading:=go_back
		end
	      end
	    end
	    else begin
	      if status=blocked then begin
		status:=back_track;
		heading:=k
	      end
	    end
	  end
	  else begin
	    if c1=over_step then begin
	      over_step_count:=over_step_count+1;
	      over_step_table[over_step_count]:=h_cell
	    end
	  end
	end
      end
    end;

    if status=back_track then begin
      while over_step_count>0 do begin
	mark_cell(over_step_table[over_step_count],traversing);
	over_step_count:=over_step_count-1
      end
    end
  end;

  reconnoitre:=status
end;


Procedure go_that_way(Var i,j:maze_offset; heading:compass);
begin
  case heading of
    upwards:
      i:=i-1;

    downwards:
      i:=i+1;

    port:
      j:=j-1;

    starboard:
      j:=j+1

  end
end;


Function solve_maze:boolean;
Var
  i,j:maze_offset;
  path_status:cell_status;
  path,previous_path:compass;
  look_around,done:boolean;
begin
  i:=1;
  j:=start;
  look_around:=true;
  done:=false;
  previous_path:=nowhere;
  mark_cell(i*breadth+j,traversing);

  repeat
    if look_around then
      path_status:=reconnoitre(i,j,path,previous_path)
    else
      look_around:=true;

    case path_status of

      traversable:begin
	previous_path:=path;
	go_that_way(i,j,path);
	mark_cell(i*breadth+j,traversing)
      end;

      back_track:begin
	look_around:=false;
	previous_path:=nowhere;
	repeat
	  mark_cell(i*breadth+j,traversed);
	  go_that_way(i,j,path);
	  path_status:=reconnoitre(i,j,path,previous_path)
	until path_status<>back_track
      end;

      blocked:begin
	done:=true;
	solve_maze:=false
      end;

      found_exit:begin
	done:=true;
	solve_maze:=true
      end

    end
  until done
end;


Procedure write_bar(left_margin,right_margin,spot:maze_offset; edge:paper_orientation);
Var
  k:maze_offset;
  doorway:boolean;
begin
  doorway:=(left_margin<=spot) and (spot<=right_margin);
  if edge=top then
    if doorway then
      writeln(printer,' ':(spot-left_margin)*3,' IN')
    else
      writeln(printer);

  if left_margin=1 then
    write(printer,'+')
  else
    write(printer,' ');

  for k:=left_margin to right_margin do
    if k=spot then
      write(printer,'  +')
    else
      write(printer,'--+');
  writeln(printer);

  if edge=bottom then
    if doorway then
      writeln(printer,' ':(spot-left_margin)*3,'OUT')
    else
      writeln(printer)
end;


Procedure get_seed;
Const
  RMON_base=22;
  RMON_size=1800;
Type
  core=array [0..maxint] of integer;
Var
  memory:@core;
  location,limit:integer;
begin
  memory:=nil;
  limit:=memory@[RMON_base] div 2;
  if limit<0 then
    limit:=limit+32768;
  for location:=0 to limit+RMON_size do
    seed:=seed+memory@[location];
  if seed<0 then
    seed:=seed+32768;
  if not odd(seed) then
    seed:=seed+1
end;


Procedure argn(Var result,pointer:integer; m:integer);
begin
  result:=0;
  pointer:=0;
  while (argv[m]@[pointer]>='0') and (argv[m]@[pointer]<='9') do begin
    result:=result*10+ord(argv[m]@[pointer])-ord('0');
    pointer:=pointer+1
  end
end;


Function rnd(interval:integer):integer;
Var
  t:integer;
begin
  t:=259*seed;
  if t<0 then
    t:=t+32768;
  seed:=t;
  rnd:=trunc((float(t)*3.05175781e-5)*float(interval))+1
end;


Procedure heading(copy_of_maze:integer; low_range,high_range:maze_offset);
begin
  writeln(printer,'Maze : ',maze_count);
  writeln(printer,'Copy : ',copy_of_maze);
  writeln(printer,'Columns : ',low_range,' to ',high_range);
  write(printer,form_feed)
end;


Procedure draw_maze_line(left_margin,right_margin,row:integer);
Var
  h,k:maze_offset;
  t:integer;
begin
  with grid@ do begin
    h:=row*breadth;

    if left_margin=1 then
      write(printer,'|')
    else
      write(printer,' ');

    for k:=left_margin to right_margin do begin
      t:=ord(maze[h+k]);
      write(printer,maze_design[t div base_level]);
      case chr(t mod base_level) of
	open_down,closed:
	  write(printer,'|');

	open_right,open: begin
	  if (chr(t div base_level*base_level)=traversing) and
	     (chr(ord(maze[h+k+1]) div base_level*base_level)=traversing) then
	    write(printer,maze_sign)
	  else
	    write(printer,' ')
	end

      end
    end;

    writeln(printer);

    if row<height then begin
      if left_margin=1 then
	write(printer,'+')
      else
	write(printer,' ');
      for k:=left_margin to right_margin do
	case chr(ord(maze[h+k]) mod base_level) of
	  open_right,closed:
	    write(printer,'--+');

	  open_down,open: begin
	    if (chr(ord(maze[h+k]) div base_level*base_level)=traversing) and
	       (chr(ord(maze[h+breadth+k]) div base_level*base_level)=traversing) then
	      write(printer,maze_design[1])
	    else
	      write(printer,'  ');
	    write(printer,'+');
	  end

	end;
      writeln(printer)
    end

  end
end;


Procedure cut_path(i2,j2:maze_offset; which_way:compass);
Var
  i,j:maze_offset;
  arrow:0..bias_count;
  k:direction_probe;
  needle:compass;
  c:1..maxint;
  direction:array [bias_counter] of compass;
begin
  i:=i2;
  j:=j2;
  needle:=which_way;

  with grid@ do begin
    repeat
      case needle of
	upwards: begin
	  i:=i-1;
	  maze[i*breadth+j]:=open_down
	end;

	downwards: begin
	  maze[i*breadth+j]:=pred(pred(maze[i*breadth+j]));
	  i:=i+1;
	  maze[i*breadth+j]:=closed
	end;

	port: begin
	  j:=j-1;
	  maze[i*breadth+j]:=open_right
	end;

	starboard: begin
	  maze[i*breadth+j]:=pred(maze[i*breadth+j]);
	  j:=j+1;
	  maze[i*breadth+j]:=closed
	end
      end;

      arrow:=0;

      for k:=upwards to starboard do begin
	if maze[(i+vertical_offset[k])*breadth+j+horizontal_offset[k]]=frontier then begin
	  for c:=1 to bias[k] do begin
	    arrow:=arrow+1;
	    direction[arrow]:=k
	  end
	end
      end;

      if arrow>0 then begin
	needle:=direction[rnd(arrow)]
      end

    until arrow=0
  end
end;


Procedure set_up_boundaries;
Var
  i,j:maze_offset;
begin
  with grid@ do begin

    i:=height+1;
    for j:=0 to width+1 do begin
      maze[j]:=closed;
      maze[i*breadth+j]:=closed
    end;

    j:=width+1;
    for i:=1 to height do begin
      maze[i*breadth]:=closed;
      maze[i*breadth+j]:=closed
    end

  end
end;


Procedure make_maze;
Var
  h,i,j:maze_offset;
  k:compass;
begin
  with grid@ do begin

    if maze_count>1 then
      for i:=1 to height do begin
        h:=i*breadth;
        for j:=h+1 to h+width do
	  maze[j]:=frontier
      end;

    i:=1;
    j:=1;
    maze[breadth+1]:=closed;

    start:=rnd(width);
    if copies>0 then
      write_bar(1,right_hand_margin,start,top);

    repeat
      for k:=upwards to starboard do begin
	if maze[(i+vertical_offset[k])*breadth+j+horizontal_offset[k]]=frontier then begin
	  cut_path(i,j,k)
	end
      end;

      j:=j+1;
      if j>width then begin
	if copies>0 then
	  draw_maze_line(1,right_hand_margin,i);
	j:=1;
	i:=i+1
      end
    until i>height;

    stop:=rnd(width);
    if copies>0 then
      write_bar(1,right_hand_margin,stop,bottom)
  end
end;


Procedure print_maze(kopies:integer; left_margin,right_margin:maze_offset);
Var
  copy_count:integer;
  left,right,row:maze_offset;
begin
  for copy_count:=1 to kopies do begin
    if copy_count=1 then begin
      left:=left_margin;
      right:=right_margin
    end
    else begin
      left:=1;
      right:=min(block_width,width)
    end;

    while left<=right do begin
      write(printer,form_feed);
      if reference then
	heading(copy_count,left,right);

      write_bar(left,right,start,top);

      row:=1;
      repeat
	draw_maze_line(left,right,row);
	row:=row+1
      until row>height;

      write_bar(left,right,stop,bottom);

      left:=right+1;
      right:=min(right+block_width,width)
    end

  end
end;


Function options:boolean;
Var
  k:0..80;
begin
  k:=0;
  options:=false;
  reference:=false;
  while argv[1]@[k]<>chr(0) do begin
    if argv[1]@[k]='R' then
      reference:=true
    else
      options:=(argv[1]@[k]<>'-');
    k:=k+1
  end
end;


Procedure initialise;
Var
  point:integer;
begin
  writeln('MAZE      Version ',version);
  writeln;
  break(output);
  if (argc>=5) and (argc<=8) then begin
    rewrite(printer,argv[2]@);

    argn(height,point,3);
    if argv[3]@[point]='P' then
      height:=((height-1)*printer_height+first_page_height-3) div 2;

    argn(width,point,4);
    if argv[4]@[point]='P' then
      width:=width*block_width;

    right_hand_margin:=min(block_width,width);
    breadth:=width+2;
    depth:=height+2;

    if argc>=6 then
      argn(number_of_mazes,point,5)
    else
      number_of_mazes:=1;

    if argc>=7 then
      argn(copies,point,6)
    else
      copies:=1;

    if argc>=8 then
      argn(number_of_solutions,point,7)
    else
      number_of_solutions:=0
  end;

  error:=options or ((argc<5) and (argc>8))
	 or (height<1) or (width<1) or (number_of_mazes<1)
end;


begin {main}

  initialise;

  if not error then begin
    get_seed;
    new(grid,breadth*depth);

    set_up_boundaries;

    for maze_count:=1 to number_of_mazes do begin
      if reference and (copies>0) then
	heading(1,1,right_hand_margin);
      make_maze;
      print_maze(copies,block_width+1,min(2*block_width,width));
      if number_of_solutions>0 then begin
	if not solve_maze then begin
	  writeln('?MAZE-W-Maze ',maze_count,' has no solution');
	  writeln;
	  break(output)
	end;
	print_maze(number_of_solutions,1,min(block_width,width))
      end;
      if maze_count<number_of_mazes then
	write(printer,form_feed)
    end

  end
  else begin
    writeln('?MAZE-F-Illegal parameters. Usage is as follows:');
    writeln('-[R]  outfile  height[P]  width[P]  [number]  [copies]  [solutions]')
  end
end.
                                                                                               