/*
 *				t a n h . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION
title	tanh	hyperbolic tanh function
index	hyperbolic tanh function
usage
	.s
	double x, f, tanh();
	.br
	f = tanh(x);
	.s
description
	.s
	Returns hyperbolic tanh of argument.
	.s
diagnostics
	.s
	None
	.s
internal
	.s
	Algorithm from pp. 239-255 of Cody and Waite.
author
	.s
	Hamish Ross.
	.s
date
	.s
	30-Jan-85
#endif

#include <math.h>

#define XBIG 20.1		/* limit for tanh(x) = 1 for x > XBIG	*/
#define LOG3BY2 0.549306144334054846	/* log(3) / 2			*/

static double p0 = -0.161341190239962281e4;
static double p1 = -0.992259296722360833e2;
static double p2 = -0.964374927772254698e0;
static double q0 =  0.484023570719886887e4;
static double q1 =  0.223377207189623129e4;
static double q2 =  0.112744743805349493e3;
double tanh(x)
double x;
{
    double f, g, p, q, exp();

    f = x < 0 ? -x : x;
    if (f > XBIG)
	f = 1.0;
    else if (f > LOG3BY2) {
	f = 0.5 - 1.0 / (exp(f + f) + 1.0);
	f += f;
    }
    else if (f > ROOT_EPS) {
	g = f * f;
	p = ((p2 * g + p1) * g + p0) * g;
	q = ((g + q2) * g + q1) * g + q0;
	g = p / q;
	f = f + f * g;
    }
    return(x < 0.0 ? -f : f);
}
                                                                                                                                                                                                                                                                                                                            