c-----------------------------------------------------------------------
c
c	Mischy month making subroutine
c
c	part of Mitch Wyle's DTC program
c
c	Inputs: 
c		ib	-	begining day of the week
c		il	-	length of month in days
c		xoff	-	offset for x coordinate
c		xspa	-	number of spaces to skip between numbers
c		yspa	-	number of lines to skip between lines
c
c	Output:
c		display screen (see below)
c
c-----------------------------------------------------------------------
c

	SUBROUTINE mischy(ib,il,xoff,xspa,YOFF,yspa)

c
c	Declarations:
c

	integer	ib		!	begining day of the week
	integer il		!	length of month in days
	integer ix		!	x coordinate of where to put day
	integer iy		!	y coordinate of where to put day
	integer ip		!	the day of the week for date in hand
	integer xoff		!	x offset
	INTEGER YOFF
	integer xspa		!	number of spaces between numbers
	integer yspa		!	number of lines to skip between lines
c
c	Initialize:
c

	iterm = 6		!	Output terminal unit number
	iy = 4 + YOFF
	ip = ib - 1
C	If (yspa .ne. 0) iy = 12
c
c	Now write month out to screen, one day at a time:
c

	Do 5 i=1,il

	    ip = ip + 1			!	increment day number
	    If ( ip .gt. 7 ) then	!	is it Sunday again?
		ip = 1			!	reset day to Sunday.
		iy = iy + 1 + yspa	!	move down one line
	    End If
	    ix = (3+xspa) * ip - 2 + xoff
	    call dtcat(ix,iy)		!	position cursor
	    write(iterm,1) i		!	write day number to screen
1	    format('+',i2)

5	Continue
	
	return
	end
               