	SUBROUTINE GRDOC
C
C	this really isn't a subroutine, but a device for putting comments
C	in the beginning of the file.
C
C	SUBROUTINE			FUNCTION
C	----------                      --------
C
C	GRINIT		INITIALIZE THE INFORMATION BUFFER FOR THE
C			GRAPHICS ROUTINES
C			CALLING SEQUENCE: CALL GRINIT(IBUF)
C	GRREGN		SPECIFY THE REGION THAT A GRAPH WILL
C			BE PLOTTED IN
C	GRSCAL		ENTER SCALING FACTORS FOR USE BY PLOTTING
C			ROUTINES WHEN AUTOSCALE IS NOT USED,  MANDITORY
C			FOR POINT MODE PLOTTING
C	GRHLIN		PUT A HORIZONTAL LINE AT A PARTICULAR VERTICAL
C			COORDINATE (SPECIFIED IN USER VALUES).
C	GRVIEW		TURN ONE OF THE GRAPHS ON OR OFF DEPENDING ON
C			THE VALUE OF THE ARGUMENT
C
	RETURN
	END
	SUBROUTINE GRINIT(IBUF)
C
C	PURPOSE INITIALIZE THE INFORMATION BUFFER (30 WORDS)
C
	DIMENSION IBUF(1)
	IBUF(1)=0	!IF 0 SHOWS THAT THE SCREEN HAS NOT BEEN
C			!CLEANED; OTHERWISE BIT PATTERN WILL SHOW
C			!WHICH REGIONS HAVE BEEN CLEANED
	IBUF(2)=0	!0=GRAPH 0 NOT SCALED  1=SCALED
	IBUF(3)=0	!0= "    1  "    "       "
	IBUF(4)="40	!FIRST CHARACTER FOR REGISTER 0
	IBUF(5)="40	!SECOND CHARACTER FOR REGISTER 0
	IBUF(6)="40	!FIRST CHARACTER FOR REGISTER 1
	IBUF(7)="41	!SECOND CHARACTER FOR REGISTER 1
	IBUF(8)=3	!REGION TO BE USED FOR GRAPH 0 (DEFAULT IS 3)
C			! =1 SIGNIFIES UPPER REGION
C			! =2 SIGNIFIES LOWER REGION
C			! =3 SIGNIFIES FULL DISPLAY
C			! =-1 IF NOT ASSIGNED
	IBUF(9)=-1	!REGION TO BE USED FOR GRAPH 1
C
C	10	RESERVED FOR FUTURE USE (left over from coding change)
C	11-26	STORAGE OF SCALING FACTORS FOR GRAPHS 0 AND 1
C
	DO 10 I=10,26
10	IBUF(I)=0
	IBUF(27)="52525	!PATTERN TO SHOW THAT GRINIT HAS  BEEN RUN
	IBUF(28)=1	!BY DEFAULT THE FULL REGION IS IN USE, 0 OTHERWISE
	IBUF(29)=0	!FLAG FOR MOVE MODE IN GRPNTM, IF >0 THEN COUNTER
	IBUF(30)=-1	!COUNTER USED BY GRPNTM
	RETURN
	END
	SUBROUTINE GRREGN(IBUF,IGRAPH,IRGN)
C
C	THERE ARE NO DEFAULTS FOR THIS SUBROUTINE!!!
C
C	GIVEN THE GRAPH NUMBER (IGRAPH) AND THE REGION CODE (IRGN),
C	THIS SUBROUTINE WILL MODIFY THE DATA TABLES SO THAT THE
C	GRAPH APPEARS IN THE APPROPRIATE AREA.
C
C	THE VALUES FOR IGRAPH ARE 0 AND 1
C
C	THE VALUES FOR IRGN ARE:
C	1 FOR THE UPPER DISPLAY AREA
C	2 FOR THE LOWER DISPLAY AREA
C	3 FOR THE FULL DISPLAY AREA
C
	DIMENSION IBUF(1)
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1
	CALL ERRMSG('?GRREGN - invalid graph number (0/1 required)')
	CALL EXIT
	RETURN
1	IF((IRGN.GE.1).AND.(IRGN.LE.3))GOTO 2
	CALL ERRMSG('?GRREGN - invalid region designation')
	CALL EXIT
	RETURN
2	IBUF(8+IGRAPH)=IRGN
	RETURN
	END
	SUBROUTINE GRSCAL(IBUF,XMIN,XMAX,YMIN,YMAX,IGRAPH)
C
C	GRSCAL IS USED TO ENTER SCALING FACTORS INTO THE IBUF ARRAY
C
C	NOTE: IF AUTOSCALING IS USED AFTER THIS SUBROUTINE FOR THE
C	SAME GRAPH, THIS DATA WILL BE LOST
C
	DIMENSION IBUF(1),TEMP(4),ITEMP(8)
	EQUIVALENCE (TEMP(1),ITEMP(1))
	IF(IBUF(27).NE."52525)CALL GRINIT(IBUF)
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 10
	CALL ERRMSG('?GRSCAL - invalid graph number')
	CALL EXIT
	RETURN
10	TEMP(1)=XMIN
	TEMP(2)=XMAX
	TEMP(3)=YMIN
	TEMP(4)=YMAX
	IBASE=10
	IF(IGRAPH.EQ.1)IBASE=18
	DO 20 I=1,8
20	IBUF(IBASE+I)=ITEMP(I)
	IBUF(2+IGRAPH)=1	!SHOW THAT THE GRAPH HAS BEEN SCALED
	RETURN
	END
	SUBROUTINE GRHLIN(IBUF,USER,IGR)
C
C	THIS SUBROUTINE WILL PUT A HORIZONTAL LINE AT A PARTICULAR
C	LOCATION ON THE VERTICAL AXIS.  THE POSITION IS SPECIFIED
C	IN USER COORDINATES.  IN ORDER FOR THIS ROUTINE TO FUNCTION
C	THE GRAPH MUST HAVE BEEN SCALED, EITHER THORUGH A PREVIOUS
C	GRAPH CALL, RO THROUGH THE USE OF GRSCAL.
C
C	ARGUMENTS:
C
C	IBUF	IS THE INFORMATION BUFFER DESCRIBED ELSEWHERE
C
C	USER	IS THE LINES POSITION IN USER VALUES (AS OPPOSED TO
C		ABSOLUTE VT105 VERTICAL DOT POSITIONS)
C
C	IGR	IS THE GRAPH NUMBER (0 OR 1), THE DEFAULT IS 0.
C
C
C	J. LISCOUSKI  DIGITAL EQUIPMENT CORPORATION
C	NOV. 21, 1979
C
C	NOTE: ALL ARGUMENTS ARE NEEDED, EITHER BY DEFAULT OR BY USER
C	      DEFINITION.  IF ANY ARE MISSING, A TRAP TO 4 MAY RESULT.
C
	DIMENSION IBUF(1),TEMP(2),ITEMP(3),IRB(2,3)
	BYTE CMD(11),ENTRGR(3),EXITGR(3)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),YMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),YMAX)	!FROM IBUF INTO THE APPROPRIATE
C					!REAL VARIABLES
	DATA IRB/239,150,129,50,239,50/ !REGION BOUNDS
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. SUBROUTINE
C
C	BEGINNING OF EXECUTABLE CODE
C
	IFLAG=0	!SHOW THAT WE (EXPECTED) ENTERED IN ALPHANUMERIC MODE
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRHLIN - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).EQ."52525)GOTO 4 !GRINIT CALLED?
	CALL ERRMSG('?GRHLIN - GRINIT not called')
	CALL EXIT
	RETURN
4	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 3	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRHLIN - graph not assigned to region')
	CALL EXIT
	RETURN
C
C	GET SCALING VALUES FOR  Y AXIS
C
3	IBASE=14
	IF(IGRAPH.EQ.1)IBASE=22
10	IF(IBUF(2+IGRAPH).NE.0)GOTO 12	!HAVE SCALED VALUES BEEN ENTERED?
	CALL ERRMSG('?GRHLIN - scaling has not been provided for graph')
	CALL EXIT
	RETURN
12	DO 15 I=1,4
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
C	HAVE HORIZONTAL LINES BEEN ENABLED?
C
	IF((IBUF(6).AND.1).NE.0)GOTO 17
	IBUF(6)=IBUF(6).OR.1	!SET BIT
	CMD(1)='I'
	CMD(2)=IBUF(6)
	CMD(3)=IBUF(7)
	CALL OUTSTR(ENTRGR)
	CALL OUTSTR(CMD,3)
	IFLAG=1			!SHOW THAT WE ARE IN GRAPHICS MODE
C
C	DISPLAY ENABLED?
C
17	IF(((IBUF(4).AND.1).NE.0).AND.(IFLAG.EQ.0))GOTO 20
	IF(((IBUF(4).AND.1).NE.0).AND.(IFLAG.EQ.1))GOTO 22
	IF(IFLAG.EQ.0)CALL OUTSTR(ENTRGR) !ENTER GRAPH MODE
	IBUF(4)=IBUF(4).OR.1 !SET BIT
	CMD(1)='A'
	CMD(2)=IBUF(4)
	CMD(3)=IBUF(5)
	CALL OUTSTR(CMD,3)
	GOTO 22
20	CALL OUTSTR(ENTRGR)
22	RANGE=IRB(1,IRGN)-IRB(2,IRGN) !# OF DOTS ON Y-AXIS
	CMD(1)='D'
	IY=INT(F(USER,YMAX,YMIN)*RANGE)+IRB(2,IRGN)
C
C	CHECK FOR OUT OF REGION CONDITION
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(2)=32+("37 .AND. IY)
	CMD(3)=48+(("340 .AND. IY)/32)
	CALL OUTSTR(CMD,3)
	CALL OUTSTR(EXITGR)	!EXIT GRAPHICS MODE
	RETURN
	END
	SUBROUTINE GRVIEW(IBUF,IARG,IGRAPH)
C
C	GRVIEW IS USED TO TURN A PARTICULAR GRAPH ON OR OFF.
C	IT IS USEFUL WHEN TWO GRAPHS OCCUPY THE SAME PLOTTING REGION
C	AND THE USER WANTS TO SEE THEM INDIVUALLY.
C
C	NO DEFAULTS FOR THIS SUBROUITINE
C
C	IGRAPH MAY TAKE ON VALUES OF 0 OR 1 DEPENDING ON THE
C	       GRAPH INVOLVED
C
C	IARG   IF =0 WILL TURN THE SELECTED GRAPH OFF
C	       IF =1 WILL TURN THE SELECTED GRAPH ON
C
C
	DIMENSION IBUF(1),ION(2),IOFF(2)
	BYTE MSG(8)
	DATA IOFF/"75,"73/
	DATA ION/2,4/
	DATA MSG /"33,'1','A',0,0,"33,'2',0/
C
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 10
	CALL ERRMSG('?GRVIEW - invalid graph number, should be 0 or 1')
	CALL EXIT
	RETURN
10	IF(IARG.EQ.0)GOTO 100
	IF(IARG.EQ.1)GOTO 200
	CALL ERRMSG('?GRVIEW - invalid value for argument')
	CALL EXIT
	RETURN
100	IBUF(4)=IBUF(4).AND.IOFF(IGRAPH+1)
	IBUF(5)=IBUF(5).AND.IOFF(IGRAPH+1)
	GOTO 300
200	IBUF(4)=IBUF(4).OR.ION(IGRAPH+1)
	IBUF(5)=IBUF(5).OR.ION(IGRAPH+1)
300	MSG(4)=IBUF(4)
	MSG(5)=IBUF(5)
	CALL OUTSTR(MSG)
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                          