	SUBROUTINE GRCLN(IBUF,IGRAPH)
C
C	CRCLN IS USER TO CLEAR THE SCREEN OF DATA PRIOR TO 
C	USING ANY OF THE GRAPHICS FUNCTIONS.
C	FOR IGRAPH::
C	A VALUE OF 0 WILL CLEAN THE SECTION BEING USED
C	FOR GRAPH 0
C	A VALUE OF 1 WILL CLEAN THE AREA FOR GRAPH 1
C
C	IF GRINIT HAS NOT BEEN CALLED PRIOR TO THIS SUBROUTINE
C	IT WILL BE INVOKED
C
	DIMENSION IBUF(1),IRB(2,3),LTXT(2,2)
	BYTE CURMRK(2),ENTRGR(3),EXITGR(3),CMD(10),INIT(31),IG(2)
	BYTE START(3,3)
	DATA START/"66,"44,0,"62,"41,0,"62,"41,0/ !CODED DOT POSITIONS
	DATA IG/'B','J'/ !PICK GRAPH 0 OR 1
	DATA ENTRGR/"33,"61,0/	!ENTER GRAPHICS MODE
	DATA EXITGR/"33,"62,0/	!EXIT GRAPHICS MODE
	DATA IRB/239,150,129,50,239,50/ !REGION BOUNDS
	DATA CURMRK/'C','K'/	!SELECT CURSOR FOR GRAPH
	DATA LTXT/2,10,12,20/
C
C THE FOLLOWING DATA STREAM WILL SET THE ROLL AREA TO (21,24)
C                                MOVE THE CURSOR TO (20,80)
C                                AND ERASE FROM THE BEGINNING OF THE
C                                SCREEN TO THE CURSOR POSITION.  IT WILL
C                                ALSO CLEAR THE GRAPHICS REGISTERS AND
C                                MEMORY.
C
C THE EQUIVALENT CHARACTER STREAM IS $[21;24r$[20;80H$[1J$1A  I0!$2
C
	DATA INIT/"33,91,50,49,59,50,52,114,"33,91,50,48,59,56,48,72,
     1	          "33,91,49,74,"33,'1','A',32,32,'I','0',33,"33,'2',0/
C
C	HAS GRINIT BEEN CALLED
C
	IF (IBUF(27).EQ."52525)GOTO 10
	CALL ERRMSG('?GRCLN - GRINIT has not been called prior to GRCLN')
	CALL EXIT
	RETURN
10	IF ((IGRAPH.GE.0) .AND. (IGRAPH.LE.1))GOTO 20	!IGRAPH VALID?
	CALL ERRMSG('?GRCLN - invalid argument -- IGRAPH')
	CALL EXIT
	RETURN
20	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 60
	CALL ERRMSG('?GRCLN - graph not assigned to region')
	CALL EXIT
	RETURN
60	IF(IBUF(1).EQ.0)GOTO 200	!HAS THE SCREEN BEEN CLEANED BEFORE?
C
C	THE FOLLOWING THREE LINES OF CODE PERMIT THE PLOTTING OF TWO GRAPHS IN
C	THE SAME DISPLAY REGION WITHOUT CLEANING THE SECTION OF SCREEN A
C	SECOND TIME. THE  EXPRESSION 2**IBUF(8) IS SIMPLY A MEANS OF 
C	MAPPING THE VALUES 1, 2, AND 3 INTO UNIQUE BIT POSITIONS IN AN
C 	INTEGER
C
C	SHOULD THE USER WANT TO CLEAN A SECTION OF GRAPH AFTER BOTH GRAPHS
C	HAVE BEEN ASSIGNED TO THE SAME REGION HE CAN:
C		1)REASSIGN ONE OF THE GRAPHS TO A DIFFERENT REGION
C		2)USE THE VTCLR SUBROUTINE WHICH CLEANS EVERYTHING
C
	IF(IBUF(8).NE.IBUF(9))GOTO 70 !PLOTTING IN THE SAME REGION?
	IF(((2**IBUF(8)).AND.IBUF(1)).NE.0)GOTO 300 !REGION ALREADY CLEANED
	IBUF(1)=IBUF(1).OR.(2**IBUF(8)) !SET APPROPRIATE BIT
70	GOTO (100,100,200),IGRAPH+1
C
C	SET UP INDICIES FOR ERASING TEXT LINES
C
C
C	IF THE PREVIOUS GRAPH (IF ANY) USED THE FULL DISPLAY AREA, AND
C	THE CURRENT USE WILL BE USING EITHER THE UPPER OR LOWER
C	REGIONS, CLEAN THE ENTIRE SCREEN
C
C	NOTE: (IRGN.NE.3), IN OTHER WORDS IF IRGN (WHICH INDICATE THE REGION
C			 1=UPPER, 2=LOWER, 3=FULL) IS A 1 OR A 2, AND
C			 THE FULL DISPLAY WAS USED, GOTO 200
C
100	IF((IBUF(28).EQ.1).AND.(IRGN.NE.3))GOTO 200
	IF (IRGN.EQ.3)GOTO 200 !IF FULL REGION CLEAN ALL
110	DO 112 J=LTXT(1,IRGN),LTXT(2,IRGN)
	J1=J	!NEEDED TO ALLOW COMPILER OPTIMIZATIONS, WITHOUT IT A
C		!COMPILE TIME WARNING RESULTS
112	CALL VTELIN(2,J1)	!ERASE APPROPRIATE LINES
C
C   ******** NOW CLEAN UP GRAPHICS *************
C
C	BEGIN BY ELIMINATING THE HORIZONTAL LINES
C
	CALL OUTSTR(ENTRGR)	!ENTER GRAPHICS MODE
	IF((IBUF(6).AND.1).EQ.0)GOTO 120 !HAVE H-LINES BEEN ENABLED?
	CMD(1)='D'	!REFERENCE HORIZONTAL LINES
	DO 113 J=IRB(2,IRGN),IRB(1,IRGN) !WORK WITHIN REGION BOUNDS
	CMD(2)=32+("37 .AND. J)	!FIRST CHARACTER
	CMD(3)=32+(("340 .AND. J)/32)	!SECOND CHARACTER
	CALL OUTSTR(CMD,3)
113	CONTINUE
C
C	ERASE GRAPHIC DATA
C
120	MASK="165	!USED TO MASK THE FIRST CHAR. OF "A" COMMAND
	IF(IGRAPH.EQ.1)MASK="153
	IBUF(4)=IBUF(4).AND.MASK	!RESET STATUS REGISTER 0
	MASK="175	!USED TO MASK THE SEC. CHAR. OF "A" COMMAND
	IF(IGRAPH.EQ.1)MASK="173
	IBUF(5)=IBUF(5).AND.MASK
	MASK="173	!USED TO MASK THE FIRST CHARACTER OF "I" COMMAND
	IF(IGRAPH.EQ.1)MASK="167
	IBUF(6)=IBUF(6).AND.MASK
	CMD(1)='A'
	CMD(2)=IBUF(4)
	CMD(3)=IBUF(5)
	CMD(4)='I'
	CMD(6)=IBUF(6)
	CMD(7)=IBUF(7)
	CALL OUTSTR(CMD,7)	!RESET DISPLAY
	CMD(1)=CURMRK(IGRAPH+1)
	DO 130 I=1,512
	J=I-1
	CMD(2)=32+(J.AND."37)
	CMD(3)=32+((J.AND."740)/32)
	CALL OUTSTR(CMD,3)	!CLEAR EXISTING MARKERS
130	CONTINUE	
	GOTO 310
C	(200) SINCE THE FULL DISPLAY WILL BE USED, REINITIALIZE THE ENTIRE
C	DATA AREA
C
200	CALL OUTSTR(INIT)
	IBUF(4)="40	!MAKE SURE THAT THE DATA IN IBUF
	IBUF(5)="40	!AGREES WITH THE RESULTS OF THE
	IBUF(6)="40	!SCREEN INITIALIZATION
	IBUF(7)="41
	IBUF(1)=IBUF(1).OR.(2**IBUF(8+IGRAPH)) !SHOW WHICH REGION
C
C	(300) RESET THE POSITION OF THE DOTS USED TO MAKE UP A GRAPH
C
300	CALL OUTSTR(ENTRGR)	!ENTER GRAPHICS
310	CALL OUTSTR('H  ')	!STARTING X=0
	CALL OUTSTR(IG(IGRAPH+1),1) !SELECT PROPER GRAPH
	DO 325 I=1,512
325	CALL OUTSTR(START(1,IRGN)) !POSITON DOTS USING CODED VALUES
	CALL OUTSTR(EXITGR)	 !EXIT GRAPHICS MODE
	RETURN
	END
                                                                 