	SUBROUTINE GRAPH(MODE,X,Y,NPTS)
C
C	MODE IS THE TYPE OF DISPLAY::
C	X IS THE REAL ARRAY FOR THE X AXIS (OPTIONAL)
C	Y IS THE REAL ARRAY FOR THE Y AXIS (REQUIRED)
C	NPTS IS THE NUMBER OF POINTS IN EACH ARRAY
C
	DIMENSION X(1),Y(1)
	BYTE ENTRGR(3),EXITGR(3),CMD(10),INIT(21)
	DATA ENTRGR/"33,"61,0/	!ENTER GRAPHICS MODE
	DATA EXITGR/"33,"62,0/	!EXIT GRAPHICS MODE
C
C THE FOLLOWING DATA STREAM WILL SET THE ROLL AREA TO (21,24)
C                                MOVE THE CURSOR TO (20,80)
C                                AND ERASE FROM THE BEGINNING OF THE
C                                SCREEN TO THE CURSOR POSITION.
C
C THE EQUIVALENT CHARACTER STREAM IS $[21;24r$[20;80H$[1J
C
	DATA INIT/"33,91,50,49,59,50,52,114,"33,91,50,48,59,56,48,72,
     1	          "33,91,49,74,0/
C
C	NOW BEGIN PREPROCESSING DATA
C
	IF(IADDR(X(1)).EQ.-1)GOTO 10	!HAS X ARRAY BEEN DEFAULTED?
	CALL BOUNDS(1,X,XMAX,XMIN,NPTS)	!GET MAX AND MIN FOR X ARRAY
	IFLAG=1	!SHOW NO DEFAULT
	GOTO 20
10	XMIN=1.		!USE NUMBER OF POINTS FOR X BOUNDS
	XMAX=NPTS
	IFLAG=0	!SHOW FLAG SET TO DEFAULT
20	CALL BOUNDS(1,Y,YMAX,YMIN,NPTS)	!GET MAX AND MIN FOR Y ARRAY
C
C	INITITALIZE SCREEN
C
	CALL OUTSTR(INIT)
	CALL OUTSTR(ENTRGR)	!ENTER GRAPHICS MODE
C
C	THE NEXT SECTION OF CODE SETS UP THE FRAME FOR THE DATA USING
C	A PAIR OF HORIZONTAL LINES AND THE FIRST AND LAST X DATA POINT
C	FOR THE VERTICLE PORTION OF THE FRAME
C
C	FIRST, THE HORIZONTAL LINES (ONE EACH AT POINTS 52 AND 239)
C
	CALL OUTSTR('I1!A" D41D/7')
C
C	NOW MOVE ALL POINTS TO DOT POSITION 52
	CALL OUTSTR('H  B')	!SET X=0 LOAD Y
	DO 5 I=1,512
5	CALL OUTSTR('41')	!510 DOTS AT LINE 52
C
C	SET UP SCALING FOR X AND Y AXIS
C	X=0 TO 511        Y=0 TO 187 (WE ARE NOT USING THE FULL DISPLAY AREA
C	                              SINCE IT WOULD OVERLAY THE ROLL AREA)
C
C
C
C	LOAD REGISTER 0
C
	CALL OUTSTR('A# ') !USE GRAPH 0 IN POINT MODE
C
C	LOAD REGISTER 1
C
	CALL OUTSTR('I%!') !NO MARKERS OR LINE, SQUARE FORMAT
C
C	NOW BEGIN SENDING DATA
C
	DO 100 I=1,NPTS
	X1=I
	IF(IFLAG.EQ.1)X1=X(I)	!USE ACTUAL X VALUES IF NO DEFAULT
	Y1=Y(I)
	IX=INT(((X1-XMIN)/(XMAX-XMIN))*511.)
	CMD(1)='H'
	CMD(2)=32+("37 .AND. IX)
	CMD(3)=32+(("740 .AND. IX)/32)
	IY=INT(((Y1-YMIN)/(YMAX-YMIN))*187.)+53	!THE 53 IS TO MOVE THE
C						 DISPLAY OUT OF	ROLL AREA
	CMD(4)='B'
	CMD(5)=32+("37 .AND. IY)
	CMD(6)=32+(("340 .AND. IY)/32)
	CMD(7)=0
	CALL OUTSTR(CMD)
100	CONTINUE
	CALL OUTSTR(EXITGR)	!EXIT GRAPHICS MODE
	RETURN
	END
                                             